/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Random;
import weka.classifiers.rules.Rule;
import weka.core.Attribute;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RuleStats
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -5708153367675298624L;
    private Instances m_Data = null;
    private FastVector m_Ruleset = null;
    private FastVector m_SimpleStats = null;
    private FastVector m_Filtered = null;
    private double m_Total = -1.0;
    private static double REDUNDANCY_FACTOR = 0.5;
    private double MDL_THEORY_WEIGHT = 1.0;
    private FastVector m_Distributions = null;

    public RuleStats() {
    }

    public RuleStats(Instances data, FastVector rules) {
        this();
        this.m_Data = data;
        this.m_Ruleset = rules;
    }

    public void cleanUp() {
        this.m_Data = null;
        this.m_Filtered = null;
    }

    public void setNumAllConds(double total) {
        this.m_Total = total < 0.0 ? RuleStats.numAllConditions(this.m_Data) : total;
    }

    public void setData(Instances data) {
        this.m_Data = data;
    }

    public Instances getData() {
        return this.m_Data;
    }

    public void setRuleset(FastVector rules) {
        this.m_Ruleset = rules;
    }

    public FastVector getRuleset() {
        return this.m_Ruleset;
    }

    public int getRulesetSize() {
        return this.m_Ruleset.size();
    }

    public double[] getSimpleStats(int index) {
        if (this.m_SimpleStats != null && index < this.m_SimpleStats.size()) {
            return (double[])this.m_SimpleStats.elementAt(index);
        }
        return null;
    }

    public Instances[] getFiltered(int index) {
        if (this.m_Filtered != null && index < this.m_Filtered.size()) {
            return (Instances[])this.m_Filtered.elementAt(index);
        }
        return null;
    }

    public double[] getDistributions(int index) {
        if (this.m_Distributions != null && index < this.m_Distributions.size()) {
            return (double[])this.m_Distributions.elementAt(index);
        }
        return null;
    }

    public void setMDLTheoryWeight(double weight) {
        this.MDL_THEORY_WEIGHT = weight;
    }

    public static double numAllConditions(Instances data) {
        double total = 0.0;
        Enumeration attEnum = data.enumerateAttributes();
        while (attEnum.hasMoreElements()) {
            Attribute att = (Attribute)attEnum.nextElement();
            if (att.isNominal()) {
                total += (double)att.numValues();
                continue;
            }
            total += 2.0 * (double)data.numDistinctValues(att);
        }
        return total;
    }

    public void countData() {
        if (this.m_Filtered != null || this.m_Ruleset == null || this.m_Data == null) {
            return;
        }
        int size = this.m_Ruleset.size();
        this.m_Filtered = new FastVector(size);
        this.m_SimpleStats = new FastVector(size);
        this.m_Distributions = new FastVector(size);
        Instances data = new Instances(this.m_Data);
        int i = 0;
        while (i < size) {
            double[] stats = new double[6];
            double[] classCounts = new double[this.m_Data.classAttribute().numValues()];
            Instances[] filtered = this.computeSimpleStats(i, data, stats, classCounts);
            this.m_Filtered.addElement(filtered);
            this.m_SimpleStats.addElement(stats);
            this.m_Distributions.addElement(classCounts);
            data = filtered[1];
            ++i;
        }
    }

    public void countData(int index, Instances uncovered, double[][] prevRuleStats) {
        if (this.m_Filtered != null || this.m_Ruleset == null) {
            return;
        }
        int size = this.m_Ruleset.size();
        this.m_Filtered = new FastVector(size);
        this.m_SimpleStats = new FastVector(size);
        Instances[] data = new Instances[2];
        data[1] = uncovered;
        int i = 0;
        while (i < index) {
            this.m_SimpleStats.addElement(prevRuleStats[i]);
            if (i + 1 == index) {
                this.m_Filtered.addElement(data);
            } else {
                this.m_Filtered.addElement(new Object());
            }
            ++i;
        }
        int j = index;
        while (j < size) {
            double[] stats = new double[6];
            Instances[] filtered = this.computeSimpleStats(j, data[1], stats, null);
            this.m_Filtered.addElement(filtered);
            this.m_SimpleStats.addElement(stats);
            data = filtered;
            ++j;
        }
    }

    private Instances[] computeSimpleStats(int index, Instances insts, double[] stats, double[] dist) {
        Rule rule = (Rule)this.m_Ruleset.elementAt(index);
        Instances[] data = new Instances[]{new Instances(insts, insts.numInstances()), new Instances(insts, insts.numInstances())};
        int i = 0;
        while (i < insts.numInstances()) {
            Instance datum = insts.instance(i);
            double weight = datum.weight();
            if (rule.covers(datum)) {
                data[0].add(datum);
                stats[0] = stats[0] + weight;
                if ((int)datum.classValue() == (int)rule.getConsequent()) {
                    stats[2] = stats[2] + weight;
                } else {
                    stats[4] = stats[4] + weight;
                }
                if (dist != null) {
                    int n = (int)datum.classValue();
                    dist[n] = dist[n] + weight;
                }
            } else {
                data[1].add(datum);
                stats[1] = stats[1] + weight;
                if ((int)datum.classValue() != (int)rule.getConsequent()) {
                    stats[3] = stats[3] + weight;
                } else {
                    stats[5] = stats[5] + weight;
                }
            }
            ++i;
        }
        return data;
    }

    public void addAndUpdate(Rule lastRule) {
        if (this.m_Ruleset == null) {
            this.m_Ruleset = new FastVector();
        }
        this.m_Ruleset.addElement(lastRule);
        Instances data = this.m_Filtered == null ? this.m_Data : ((Instances[])this.m_Filtered.lastElement())[1];
        double[] stats = new double[6];
        double[] classCounts = new double[this.m_Data.classAttribute().numValues()];
        Instances[] filtered = this.computeSimpleStats(this.m_Ruleset.size() - 1, data, stats, classCounts);
        if (this.m_Filtered == null) {
            this.m_Filtered = new FastVector();
        }
        this.m_Filtered.addElement(filtered);
        if (this.m_SimpleStats == null) {
            this.m_SimpleStats = new FastVector();
        }
        this.m_SimpleStats.addElement(stats);
        if (this.m_Distributions == null) {
            this.m_Distributions = new FastVector();
        }
        this.m_Distributions.addElement(classCounts);
    }

    public static double subsetDL(double t, double k, double p) {
        double rt = Utils.gr(p, 0.0) ? -k * Utils.log2(p) : 0.0;
        return rt -= (t - k) * Utils.log2(1.0 - p);
    }

    public double theoryDL(int index) {
        double k = ((Rule)this.m_Ruleset.elementAt(index)).size();
        if (k == 0.0) {
            return 0.0;
        }
        double tdl = Utils.log2(k);
        if (k > 1.0) {
            tdl += 2.0 * Utils.log2(tdl);
        }
        return this.MDL_THEORY_WEIGHT * REDUNDANCY_FACTOR * (tdl += RuleStats.subsetDL(this.m_Total, k, k / this.m_Total));
    }

    public static double dataDL(double expFPOverErr, double cover, double uncover, double fp, double fn) {
        double uncoverBits;
        double coverBits;
        double totalBits = Utils.log2(cover + uncover + 1.0);
        if (Utils.gr(cover, uncover)) {
            double expErr = expFPOverErr * (fp + fn);
            coverBits = RuleStats.subsetDL(cover, fp, expErr / cover);
            uncoverBits = Utils.gr(uncover, 0.0) ? RuleStats.subsetDL(uncover, fn, fn / uncover) : 0.0;
        } else {
            double expErr = (1.0 - expFPOverErr) * (fp + fn);
            coverBits = Utils.gr(cover, 0.0) ? RuleStats.subsetDL(cover, fp, fp / cover) : 0.0;
            uncoverBits = RuleStats.subsetDL(uncover, fn, expErr / uncover);
        }
        return totalBits + coverBits + uncoverBits;
    }

    public double potential(int index, double expFPOverErr, double[] rulesetStat, double[] ruleStat, boolean checkErr) {
        double pcov = rulesetStat[0] - ruleStat[0];
        double puncov = rulesetStat[1] + ruleStat[0];
        double pfp = rulesetStat[4] - ruleStat[4];
        double pfn = rulesetStat[5] + ruleStat[2];
        double dataDLWith = RuleStats.dataDL(expFPOverErr, rulesetStat[0], rulesetStat[1], rulesetStat[4], rulesetStat[5]);
        double theoryDLWith = this.theoryDL(index);
        double dataDLWithout = RuleStats.dataDL(expFPOverErr, pcov, puncov, pfp, pfn);
        double potential = dataDLWith + theoryDLWith - dataDLWithout;
        double err = ruleStat[4] / ruleStat[0];
        boolean overErr = Utils.grOrEq(err, 0.5);
        if (!checkErr) {
            overErr = false;
        }
        if (Utils.grOrEq(potential, 0.0) || overErr) {
            rulesetStat[0] = pcov;
            rulesetStat[1] = puncov;
            rulesetStat[4] = pfp;
            rulesetStat[5] = pfn;
            return potential;
        }
        return Double.NaN;
    }

    public double minDataDLIfDeleted(int index, double expFPRate, boolean checkErr) {
        double[] rulesetStat = new double[6];
        int more = this.m_Ruleset.size() - 1 - index;
        FastVector<double[]> indexPlus = new FastVector<double[]>(more);
        int j = 0;
        while (j < index) {
            rulesetStat[0] = rulesetStat[0] + ((double[])this.m_SimpleStats.elementAt(j))[0];
            rulesetStat[2] = rulesetStat[2] + ((double[])this.m_SimpleStats.elementAt(j))[2];
            rulesetStat[4] = rulesetStat[4] + ((double[])this.m_SimpleStats.elementAt(j))[4];
            ++j;
        }
        Instances data = index == 0 ? this.m_Data : ((Instances[])this.m_Filtered.elementAt(index - 1))[1];
        int j2 = index + 1;
        while (j2 < this.m_Ruleset.size()) {
            double[] stats = new double[6];
            Instances[] split = this.computeSimpleStats(j2, data, stats, null);
            indexPlus.addElement(stats);
            rulesetStat[0] = rulesetStat[0] + stats[0];
            rulesetStat[2] = rulesetStat[2] + stats[2];
            rulesetStat[4] = rulesetStat[4] + stats[4];
            data = split[1];
            ++j2;
        }
        if (more > 0) {
            rulesetStat[1] = ((double[])indexPlus.lastElement())[1];
            rulesetStat[3] = ((double[])indexPlus.lastElement())[3];
            rulesetStat[5] = ((double[])indexPlus.lastElement())[5];
        } else if (index > 0) {
            rulesetStat[1] = ((double[])this.m_SimpleStats.elementAt(index - 1))[1];
            rulesetStat[3] = ((double[])this.m_SimpleStats.elementAt(index - 1))[3];
            rulesetStat[5] = ((double[])this.m_SimpleStats.elementAt(index - 1))[5];
        } else {
            rulesetStat[1] = ((double[])this.m_SimpleStats.elementAt(0))[0] + ((double[])this.m_SimpleStats.elementAt(0))[1];
            rulesetStat[3] = ((double[])this.m_SimpleStats.elementAt(0))[3] + ((double[])this.m_SimpleStats.elementAt(0))[4];
            rulesetStat[5] = ((double[])this.m_SimpleStats.elementAt(0))[2] + ((double[])this.m_SimpleStats.elementAt(0))[5];
        }
        double potential = 0.0;
        int k = index + 1;
        while (k < this.m_Ruleset.size()) {
            double[] ruleStat = (double[])indexPlus.elementAt(k - index - 1);
            double ifDeleted = this.potential(k, expFPRate, rulesetStat, ruleStat, checkErr);
            if (!Double.isNaN(ifDeleted)) {
                potential += ifDeleted;
            }
            ++k;
        }
        double dataDLWithout = RuleStats.dataDL(expFPRate, rulesetStat[0], rulesetStat[1], rulesetStat[4], rulesetStat[5]);
        return dataDLWithout - potential;
    }

    public double minDataDLIfExists(int index, double expFPRate, boolean checkErr) {
        double[] rulesetStat = new double[6];
        int j = 0;
        while (j < this.m_SimpleStats.size()) {
            rulesetStat[0] = rulesetStat[0] + ((double[])this.m_SimpleStats.elementAt(j))[0];
            rulesetStat[2] = rulesetStat[2] + ((double[])this.m_SimpleStats.elementAt(j))[2];
            rulesetStat[4] = rulesetStat[4] + ((double[])this.m_SimpleStats.elementAt(j))[4];
            if (j == this.m_SimpleStats.size() - 1) {
                rulesetStat[1] = ((double[])this.m_SimpleStats.elementAt(j))[1];
                rulesetStat[3] = ((double[])this.m_SimpleStats.elementAt(j))[3];
                rulesetStat[5] = ((double[])this.m_SimpleStats.elementAt(j))[5];
            }
            ++j;
        }
        double potential = 0.0;
        int k = index + 1;
        while (k < this.m_SimpleStats.size()) {
            double[] ruleStat = this.getSimpleStats(k);
            double ifDeleted = this.potential(k, expFPRate, rulesetStat, ruleStat, checkErr);
            if (!Double.isNaN(ifDeleted)) {
                potential += ifDeleted;
            }
            ++k;
        }
        double dataDLWith = RuleStats.dataDL(expFPRate, rulesetStat[0], rulesetStat[1], rulesetStat[4], rulesetStat[5]);
        return dataDLWith - potential;
    }

    public double relativeDL(int index, double expFPRate, boolean checkErr) {
        return this.minDataDLIfExists(index, expFPRate, checkErr) + this.theoryDL(index) - this.minDataDLIfDeleted(index, expFPRate, checkErr);
    }

    public void reduceDL(double expFPRate, boolean checkErr) {
        boolean needUpdate = false;
        double[] rulesetStat = new double[6];
        int j = 0;
        while (j < this.m_SimpleStats.size()) {
            rulesetStat[0] = rulesetStat[0] + ((double[])this.m_SimpleStats.elementAt(j))[0];
            rulesetStat[2] = rulesetStat[2] + ((double[])this.m_SimpleStats.elementAt(j))[2];
            rulesetStat[4] = rulesetStat[4] + ((double[])this.m_SimpleStats.elementAt(j))[4];
            if (j == this.m_SimpleStats.size() - 1) {
                rulesetStat[1] = ((double[])this.m_SimpleStats.elementAt(j))[1];
                rulesetStat[3] = ((double[])this.m_SimpleStats.elementAt(j))[3];
                rulesetStat[5] = ((double[])this.m_SimpleStats.elementAt(j))[5];
            }
            ++j;
        }
        int k = this.m_SimpleStats.size() - 1;
        while (k >= 0) {
            double[] ruleStat = (double[])this.m_SimpleStats.elementAt(k);
            double ifDeleted = this.potential(k, expFPRate, rulesetStat, ruleStat, checkErr);
            if (!Double.isNaN(ifDeleted)) {
                if (k == this.m_SimpleStats.size() - 1) {
                    this.removeLast();
                } else {
                    this.m_Ruleset.removeElementAt(k);
                    needUpdate = true;
                }
            }
            --k;
        }
        if (needUpdate) {
            this.m_Filtered = null;
            this.m_SimpleStats = null;
            this.countData();
        }
    }

    public void removeLast() {
        int last = this.m_Ruleset.size() - 1;
        this.m_Ruleset.removeElementAt(last);
        this.m_Filtered.removeElementAt(last);
        this.m_SimpleStats.removeElementAt(last);
        if (this.m_Distributions != null) {
            this.m_Distributions.removeElementAt(last);
        }
    }

    public static Instances rmCoveredBySuccessives(Instances data, FastVector rules, int index) {
        Instances rt = new Instances(data, 0);
        int i = 0;
        while (i < data.numInstances()) {
            Instance datum = data.instance(i);
            boolean covered = false;
            int j = index + 1;
            while (j < rules.size()) {
                Rule rule = (Rule)rules.elementAt(j);
                if (rule.covers(datum)) {
                    covered = true;
                    break;
                }
                ++j;
            }
            if (!covered) {
                rt.add(datum);
            }
            ++i;
        }
        return rt;
    }

    public static final Instances stratify(Instances data, int folds, Random rand) {
        if (!data.classAttribute().isNominal()) {
            return data;
        }
        Instances result = new Instances(data, 0);
        Instances[] bagsByClasses = new Instances[data.numClasses()];
        int i = 0;
        while (i < bagsByClasses.length) {
            bagsByClasses[i] = new Instances(data, 0);
            ++i;
        }
        int j = 0;
        while (j < data.numInstances()) {
            Instance datum = data.instance(j);
            bagsByClasses[(int)datum.classValue()].add(datum);
            ++j;
        }
        j = 0;
        while (j < bagsByClasses.length) {
            bagsByClasses[j].randomize(rand);
            ++j;
        }
        int k = 0;
        while (k < folds) {
            int offset = k;
            int bag = 0;
            while (true) {
                if (offset >= bagsByClasses[bag].numInstances()) {
                    offset -= bagsByClasses[bag].numInstances();
                    if (++bag >= bagsByClasses.length) break;
                    continue;
                }
                result.add(bagsByClasses[bag].instance(offset));
                offset += folds;
            }
            ++k;
        }
        return result;
    }

    public double combinedDL(double expFPRate, double predicted) {
        double rt = 0.0;
        if (this.getRulesetSize() > 0) {
            double[] stats = (double[])this.m_SimpleStats.lastElement();
            int j = this.getRulesetSize() - 2;
            while (j >= 0) {
                stats[0] = stats[0] + this.getSimpleStats(j)[0];
                stats[2] = stats[2] + this.getSimpleStats(j)[2];
                stats[4] = stats[4] + this.getSimpleStats(j)[4];
                --j;
            }
            rt += RuleStats.dataDL(expFPRate, stats[0], stats[1], stats[4], stats[5]);
        } else {
            double fn = 0.0;
            int j = 0;
            while (j < this.m_Data.numInstances()) {
                if ((int)this.m_Data.instance(j).classValue() == (int)predicted) {
                    fn += this.m_Data.instance(j).weight();
                }
                ++j;
            }
            rt += RuleStats.dataDL(expFPRate, 0.0, this.m_Data.sumOfWeights(), 0.0, fn);
        }
        int i = 0;
        while (i < this.getRulesetSize()) {
            rt += this.theoryDL(i);
            ++i;
        }
        return rt;
    }

    public static final Instances[] partition(Instances data, int numFolds) {
        Instances[] rt = new Instances[2];
        int splits = data.numInstances() * (numFolds - 1) / numFolds;
        rt[0] = new Instances(data, 0, splits);
        rt[1] = new Instances(data, splits, data.numInstances() - splits);
        return rt;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 4608 $");
    }
}

