/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.ArrayList;
import java.util.Collections;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.GraftSplit;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.j48.Stats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class C45PruneableClassifierTreeG
extends ClassifierTree {
    static final long serialVersionUID = 66981207374331964L;
    boolean m_pruneTheTree = false;
    float m_CF = 0.25f;
    boolean m_subtreeRaising = true;
    boolean m_cleanup = true;
    boolean m_relabel = false;
    double m_BiProbCrit = 1.64;
    boolean m_Debug = false;

    public C45PruneableClassifierTreeG(ModelSelection toSelectLocModel, boolean pruneTree, float cf, boolean raiseTree, boolean relabel, boolean cleanup) throws Exception {
        super(toSelectLocModel);
        this.m_pruneTheTree = pruneTree;
        this.m_CF = cf;
        this.m_subtreeRaising = raiseTree;
        this.m_cleanup = cleanup;
        this.m_relabel = relabel;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    public C45PruneableClassifierTreeG(ModelSelection toSelectLocModel, Instances data, ClassifierSplitModel gs, boolean prune, float cf, boolean raise, boolean isLeaf, boolean relabel, boolean cleanup) {
        super(toSelectLocModel);
        this.m_relabel = relabel;
        this.m_cleanup = cleanup;
        this.m_localModel = gs;
        this.m_train = data;
        this.m_test = null;
        this.m_isLeaf = isLeaf;
        this.m_isEmpty = !(gs.distribution().total() > 0.0);
        this.m_pruneTheTree = prune;
        this.m_CF = cf;
        this.m_subtreeRaising = raise;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.buildTree(data, this.m_subtreeRaising);
        this.collapse();
        if (this.m_pruneTheTree) {
            this.prune();
        }
        this.doGrafting(data);
        if (this.m_cleanup) {
            this.cleanup(new Instances(data, 0));
        }
    }

    public final void collapse() {
        if (!this.m_isLeaf) {
            double errorsOfTree;
            double errorsOfSubtree = this.getTrainingErrors();
            if (errorsOfSubtree >= (errorsOfTree = this.localModel().distribution().numIncorrect()) - 0.001) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
            } else {
                int i = 0;
                while (i < this.m_sons.length) {
                    this.son(i).collapse();
                    ++i;
                }
            }
        }
    }

    public void prune() throws Exception {
        if (!this.m_isLeaf) {
            double errorsTree;
            int i = 0;
            while (i < this.m_sons.length) {
                this.son(i).prune();
                ++i;
            }
            int indexOfLargestBranch = this.localModel().distribution().maxBag();
            double errorsLargestBranch = this.m_subtreeRaising ? this.son(indexOfLargestBranch).getEstimatedErrorsForBranch(this.m_train) : Double.MAX_VALUE;
            double errorsLeaf = this.getEstimatedErrorsForDistribution(this.localModel().distribution());
            if (Utils.smOrEq(errorsLeaf, (errorsTree = this.getEstimatedErrors()) + 0.1) && Utils.smOrEq(errorsLeaf, errorsLargestBranch + 0.1)) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
                return;
            }
            if (Utils.smOrEq(errorsLargestBranch, errorsTree + 0.1)) {
                C45PruneableClassifierTreeG largestBranch = this.son(indexOfLargestBranch);
                this.m_sons = largestBranch.m_sons;
                this.m_localModel = largestBranch.localModel();
                this.m_isLeaf = largestBranch.m_isLeaf;
                this.newDistribution(this.m_train);
                this.prune();
            }
        }
    }

    @Override
    protected ClassifierTree getNewTree(Instances data) throws Exception {
        C45PruneableClassifierTreeG newTree = new C45PruneableClassifierTreeG(this.m_toSelectModel, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, this.m_relabel, this.m_cleanup);
        newTree.buildTree(data, this.m_subtreeRaising);
        return newTree;
    }

    private double getEstimatedErrors() {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.localModel().distribution());
        }
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.son(i).getEstimatedErrors();
            ++i;
        }
        return errors;
    }

    private double getEstimatedErrorsForBranch(Instances data) throws Exception {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(data));
        }
        Distribution savedDist = this.localModel().m_distribution;
        this.localModel().resetDistribution(data);
        Instances[] localInstances = this.localModel().split(data);
        this.localModel().m_distribution = savedDist;
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.son(i).getEstimatedErrorsForBranch(localInstances[i]);
            ++i;
        }
        return errors;
    }

    private double getEstimatedErrorsForDistribution(Distribution theDistribution) {
        if (Utils.eq(theDistribution.total(), 0.0)) {
            return 0.0;
        }
        return theDistribution.numIncorrect() + Stats.addErrs(theDistribution.total(), theDistribution.numIncorrect(), this.m_CF);
    }

    private double getTrainingErrors() {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.localModel().distribution().numIncorrect();
        }
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.son(i).getTrainingErrors();
            ++i;
        }
        return errors;
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private void newDistribution(Instances data) throws Exception {
        this.localModel().resetDistribution(data);
        this.m_train = data;
        if (!this.m_isLeaf) {
            Instances[] localInstances = this.localModel().split(data);
            int i = 0;
            while (i < this.m_sons.length) {
                this.son(i).newDistribution(localInstances[i]);
                ++i;
            }
        } else if (!Utils.eq(data.sumOfWeights(), 0.0)) {
            this.m_isEmpty = false;
        }
    }

    private C45PruneableClassifierTreeG son(int index) {
        return (C45PruneableClassifierTreeG)this.m_sons[index];
    }

    public void doGrafting(Instances data) throws Exception {
        double[][] limits = new double[data.numAttributes()][2];
        int i = 0;
        while (i < data.numAttributes()) {
            limits[i][0] = Double.NEGATIVE_INFINITY;
            limits[i][1] = Double.POSITIVE_INFINITY;
            ++i;
        }
        double[][] instanceIndex = new double[2][data.numInstances()];
        int x = 0;
        while (x < data.numInstances()) {
            instanceIndex[0][x] = 1.0;
            instanceIndex[1][x] = 1.0;
            ++x;
        }
        this.traverseTree(data, instanceIndex, limits, this, 0.0, -1);
    }

    private void traverseTree(Instances fulldata, double[][] iindex, double[][] limits, C45PruneableClassifierTreeG parent, double pL, int nodeClass) throws Exception {
        if (this.m_isLeaf) {
            this.findGraft(fulldata, iindex, limits, parent, pL, nodeClass);
        } else {
            int i = 0;
            while (i < this.localModel().numSubsets()) {
                double[][] newiindex = new double[2][fulldata.numInstances()];
                int x = 0;
                while (x < 2) {
                    System.arraycopy(iindex[x], 0, newiindex[x], 0, iindex[x].length);
                    ++x;
                }
                this.sortInstances(fulldata, newiindex, limits, i);
                ++i;
            }
        }
    }

    private void sortInstances(Instances fulldata, double[][] iindex, double[][] limits, int subset) throws Exception {
        C45Split test = (C45Split)this.localModel();
        double knownCases = 0.0;
        double thisSubsetCount = 0.0;
        int x = 0;
        while (x < iindex[0].length) {
            if (!(iindex[0][x] == 0.0 && iindex[1][x] == 0.0 || fulldata.instance(x).isMissing(test.attIndex()))) {
                knownCases += iindex[0][x];
                if (test.whichSubset(fulldata.instance(x)) != subset) {
                    if (iindex[0][x] > 0.0) {
                        iindex[1][x] = iindex[0][x];
                        iindex[0][x] = 0.0;
                    } else if (iindex[1][x] > 0.0) {
                        iindex[1][x] = 0.0;
                    }
                } else {
                    thisSubsetCount += iindex[0][x];
                }
            }
            ++x;
        }
        double lprop = knownCases == 0.0 ? 1.0 / (double)test.numSubsets() : thisSubsetCount / knownCases;
        int x2 = 0;
        while (x2 < iindex[0].length) {
            if ((iindex[0][x2] != 0.0 || iindex[1][x2] != 0.0) && fulldata.instance(x2).isMissing(test.attIndex())) {
                double[] dArray = iindex[1];
                int n = x2;
                dArray[n] = dArray[n] - (iindex[1][x2] - iindex[0][x2]) * (1.0 - lprop);
                double[] dArray2 = iindex[0];
                int n2 = x2;
                dArray2[n2] = dArray2[n2] * lprop;
            }
            ++x2;
        }
        int nodeClass = this.localModel().distribution().maxClass(subset);
        double pL = (this.localModel().distribution().perClass(nodeClass) + 1.0) / (this.localModel().distribution().total() + 2.0);
        this.son(subset).traverseTree(fulldata, iindex, test.minsAndMaxs(fulldata, limits, subset), this, pL, nodeClass);
    }

    private void findGraft(Instances fulldata, double[][] iindex, double[][] limits, ClassifierTree parent, double pLaplace, int pLeafClass) throws Exception {
        GraftSplit gs;
        int leafClass = this.m_isEmpty ? pLeafClass : this.localModel().distribution().maxClass();
        double leafLaplace = this.m_isEmpty ? pLaplace : this.laplaceLeaf(leafClass);
        Instances l = new Instances(fulldata, fulldata.numInstances());
        Instances n = new Instances(fulldata, fulldata.numInstances());
        int lcount = 0;
        int acount = 0;
        int x = 0;
        while (x < fulldata.numInstances()) {
            if (!(iindex[0][x] <= 0.0) || !(iindex[1][x] <= 0.0)) {
                if (iindex[0][x] != 0.0) {
                    l.add(fulldata.instance(x));
                    l.instance(lcount).setWeight(iindex[0][x]);
                    iindex[0][lcount++] = iindex[0][x];
                }
                if (iindex[1][x] > 0.0) {
                    n.add(fulldata.instance(x));
                    n.instance(acount).setWeight(iindex[1][x]);
                    iindex[1][acount++] = iindex[1][x];
                }
            }
            ++x;
        }
        boolean graftPossible = false;
        double[] classDist = new double[n.numClasses()];
        int x2 = 0;
        while (x2 < n.numInstances()) {
            if (iindex[1][x2] > 0.0 && !n.instance(x2).classIsMissing()) {
                int n2 = (int)n.instance(x2).classValue();
                classDist[n2] = classDist[n2] + iindex[1][x2];
            }
            ++x2;
        }
        int cVal = 0;
        while (cVal < n.numClasses()) {
            double theLaplace = (classDist[cVal] + 1.0) / (classDist[cVal] + 2.0);
            if (cVal != leafClass && theLaplace > leafLaplace && this.biprob(classDist[cVal], classDist[cVal], leafLaplace) > this.m_BiProbCrit) {
                graftPossible = true;
                break;
            }
            ++cVal;
        }
        if (!graftPossible) {
            return;
        }
        ArrayList<GraftSplit> t = new ArrayList<GraftSplit>();
        int a = 0;
        while (a < n.numAttributes()) {
            block62: {
                int[] sorted;
                block63: {
                    if (a == n.classIndex()) break block62;
                    sorted = this.sortByAttribute(n, a);
                    if (!n.attribute(a).isNumeric()) break block63;
                    boolean prohibited = false;
                    double minLeaf = Double.POSITIVE_INFINITY;
                    double maxLeaf = Double.NEGATIVE_INFINITY;
                    int i = 0;
                    while (i < l.numInstances()) {
                        if (l.instance(i).isMissing(a) && l.instance(i).classValue() == (double)leafClass) {
                            prohibited = true;
                            break;
                        }
                        double value = l.instance(i).value(a);
                        if (!this.m_relabel || l.instance(i).classValue() == (double)leafClass) {
                            if (value < minLeaf) {
                                minLeaf = value;
                            }
                            if (value > maxLeaf) {
                                maxLeaf = value;
                            }
                        }
                        ++i;
                    }
                    if (prohibited) break block62;
                    double minBestClass = Double.NaN;
                    double minBestLaplace = leafLaplace;
                    double minBestVal = Double.NaN;
                    double minBestPos = Double.NaN;
                    double minBestTotal = Double.NaN;
                    double[][] minBestCounts = null;
                    double[][] counts = new double[2][n.numClasses()];
                    int x3 = 0;
                    while (x3 < n.numInstances()) {
                        if (n.instance(sorted[x3]).isMissing(a)) break;
                        double theval = n.instance(sorted[x3]).value(a);
                        if (this.m_Debug) {
                            System.out.println("\t " + theval);
                        }
                        if (theval <= limits[a][0]) {
                            if (this.m_Debug) {
                                System.out.println("\t  <= lowerlim: continuing...");
                            }
                        } else {
                            if (theval >= minLeaf) {
                                if (!this.m_Debug) break;
                                System.out.println("\t  >= minLeaf; breaking...");
                                break;
                            }
                            double[] dArray = counts[0];
                            int n3 = (int)n.instance(sorted[x3]).classValue();
                            dArray[n3] = dArray[n3] + iindex[1][sorted[x3]];
                            if (x3 != n.numInstances() - 1) {
                                int z = x3 + 1;
                                while (z < n.numInstances() && n.instance(sorted[z]).value(a) == theval) {
                                    ++z;
                                    double[] dArray2 = counts[0];
                                    int n4 = (int)n.instance(sorted[++x3]).classValue();
                                    dArray2[n4] = dArray2[n4] + iindex[1][sorted[x3]];
                                }
                            }
                            double total = Utils.sum(counts[0]);
                            int c = 0;
                            while (c < n.numClasses()) {
                                double temp = (counts[0][c] + 1.0) / (total + 2.0);
                                if (temp > minBestLaplace) {
                                    minBestPos = counts[0][c];
                                    minBestTotal = total;
                                    minBestLaplace = temp;
                                    minBestClass = c;
                                    minBestCounts = this.copyCounts(counts);
                                    minBestVal = x3 == n.numInstances() - 1 ? theval : (theval + n.instance(sorted[x3 + 1]).value(a)) / 2.0;
                                }
                                ++c;
                            }
                        }
                        ++x3;
                    }
                    if (!Double.isNaN(minBestVal) && this.biprob(minBestPos, minBestTotal, leafLaplace) > this.m_BiProbCrit) {
                        GraftSplit gsplit = null;
                        try {
                            gsplit = new GraftSplit(a, minBestVal, 0, (double)leafClass, minBestCounts);
                        }
                        catch (Exception e) {
                            System.err.println("graftsplit error: " + e.getMessage());
                            System.exit(1);
                        }
                        t.add(gsplit);
                    }
                    minBestCounts = null;
                    double maxBestClass = -1.0;
                    double maxBestLaplace = leafLaplace;
                    double maxBestVal = Double.NaN;
                    double maxBestPos = Double.NaN;
                    double maxBestTotal = Double.NaN;
                    double[][] maxBestCounts = null;
                    int c = 0;
                    while (c < n.numClasses()) {
                        counts[0][c] = 0.0;
                        counts[1][c] = 0.0;
                        ++c;
                    }
                    if (n.numInstances() < 1 || !(n.instance(sorted[0]).value(a) < limits[a][1])) break block62;
                    int x4 = n.numInstances() - 1;
                    while (x4 >= 0) {
                        if (!n.instance(sorted[x4]).isMissing(a)) {
                            double theval = n.instance(sorted[x4]).value(a);
                            if (this.m_Debug) {
                                System.out.println("\t " + theval);
                            }
                            if (theval > limits[a][1]) {
                                if (this.m_Debug) {
                                    System.out.println("\t  >= upperlim; continuing...");
                                }
                            } else {
                                if (theval <= maxLeaf) {
                                    if (!this.m_Debug) break;
                                    System.out.println("\t  < maxLeaf; breaking...");
                                    break;
                                }
                                double[] dArray = counts[1];
                                int n5 = (int)n.instance(sorted[x4]).classValue();
                                dArray[n5] = dArray[n5] + iindex[1][sorted[x4]];
                                if (x4 != 0 && !n.instance(sorted[x4 - 1]).isMissing(a)) {
                                    int z = x4 - 1;
                                    while (z >= 0 && n.instance(sorted[z]).value(a) == theval) {
                                        --z;
                                        double[] dArray3 = counts[1];
                                        int n6 = (int)n.instance(sorted[--x4]).classValue();
                                        dArray3[n6] = dArray3[n6] + iindex[1][sorted[x4]];
                                    }
                                }
                                double total = Utils.sum(counts[1]);
                                int c2 = 0;
                                while (c2 < n.numClasses()) {
                                    double temp = (counts[1][c2] + 1.0) / (total + 2.0);
                                    if (temp > maxBestLaplace) {
                                        maxBestPos = counts[1][c2];
                                        maxBestTotal = total;
                                        maxBestLaplace = temp;
                                        maxBestClass = c2;
                                        maxBestCounts = this.copyCounts(counts);
                                        maxBestVal = x4 == 0 ? theval : (theval + n.instance(sorted[x4 - 1]).value(a)) / 2.0;
                                    }
                                    ++c2;
                                }
                            }
                        }
                        --x4;
                    }
                    if (Double.isNaN(maxBestVal) || !(this.biprob(maxBestPos, maxBestTotal, leafLaplace) > this.m_BiProbCrit)) break block62;
                    GraftSplit gsplit = null;
                    try {
                        gsplit = new GraftSplit(a, maxBestVal, 1, (double)leafClass, maxBestCounts);
                    }
                    catch (Exception e) {
                        System.err.println("graftsplit error:" + e.getMessage());
                        System.exit(1);
                    }
                    t.add(gsplit);
                    break block62;
                }
                if (limits[a][1] != 1.0) {
                    boolean[] prohibit = new boolean[l.attribute(a).numValues()];
                    int aval = 0;
                    while (aval < n.attribute(a).numValues()) {
                        int x5 = 0;
                        while (x5 < l.numInstances()) {
                            if (!(!l.instance(x5).isMissing(a) && l.instance(x5).value(a) != (double)aval || this.m_relabel && l.instance(x5).classValue() != (double)leafClass)) {
                                prohibit[aval] = true;
                                break;
                            }
                            ++x5;
                        }
                        ++aval;
                    }
                    double bestVal = Double.NaN;
                    double bestClass = Double.NaN;
                    double bestLaplace = leafLaplace;
                    double[][] bestCounts = null;
                    double[][] counts = new double[2][n.numClasses()];
                    int x6 = 0;
                    while (x6 < n.numInstances()) {
                        if (!n.instance(sorted[x6]).isMissing(a)) {
                            int c = 0;
                            while (c < n.numClasses()) {
                                counts[0][c] = 0.0;
                                ++c;
                            }
                            double theval = n.instance(sorted[x6]).value(a);
                            double[] dArray = counts[0];
                            int n7 = (int)n.instance(sorted[x6]).classValue();
                            dArray[n7] = dArray[n7] + iindex[1][sorted[x6]];
                            if (x6 != n.numInstances() - 1) {
                                int z = x6 + 1;
                                while (z < n.numInstances() && n.instance(sorted[z]).value(a) == theval) {
                                    ++z;
                                    double[] dArray4 = counts[0];
                                    int n8 = (int)n.instance(sorted[++x6]).classValue();
                                    dArray4[n8] = dArray4[n8] + iindex[1][sorted[x6]];
                                }
                            }
                            if (!prohibit[(int)theval]) {
                                double total = Utils.sum(counts[0]);
                                bestLaplace = leafLaplace;
                                bestClass = Double.NaN;
                                int c3 = 0;
                                while (c3 < n.numClasses()) {
                                    double temp = (counts[0][c3] + 1.0) / (total + 2.0);
                                    if (temp > bestLaplace && this.biprob(counts[0][c3], total, leafLaplace) > this.m_BiProbCrit) {
                                        bestLaplace = temp;
                                        bestClass = c3;
                                        bestVal = theval;
                                        bestCounts = this.copyCounts(counts);
                                    }
                                    ++c3;
                                }
                                if (!Double.isNaN(bestClass)) {
                                    GraftSplit gsplit = null;
                                    try {
                                        gsplit = new GraftSplit(a, bestVal, 2, (double)leafClass, bestCounts);
                                    }
                                    catch (Exception e) {
                                        System.err.println("graftsplit error: " + e.getMessage());
                                        System.exit(1);
                                    }
                                    t.add(gsplit);
                                }
                            }
                        }
                        ++x6;
                    }
                }
            }
            ++a;
        }
        Collections.sort(t);
        int x7 = 0;
        while (x7 < t.size()) {
            gs = (GraftSplit)t.get(x7);
            if (gs.maxClassForSubsetOfInterest() != leafClass) break;
            t.remove(x7);
            --x7;
            ++x7;
        }
        if (t.size() < 1) {
            return;
        }
        x7 = t.size() - 1;
        while (x7 >= 0) {
            gs = (GraftSplit)t.get(x7);
            try {
                gs.buildClassifier(l);
                gs.deleteGraftedCases(l);
            }
            catch (Exception e) {
                System.err.println("graftsplit build error: " + e.getMessage());
            }
            --x7;
        }
        ((C45PruneableClassifierTreeG)parent).setDescendents(t, this);
    }

    private int[] sortByAttribute(Instances data, int a) {
        double[] attList = data.attributeToDoubleArray(a);
        int[] temp = Utils.sort(attList);
        return temp;
    }

    private double[][] copyCounts(double[][] src) {
        double[][] newArr = new double[src.length][0];
        int x = 0;
        while (x < src.length) {
            newArr[x] = new double[src[x].length];
            int y = 0;
            while (y < src[x].length) {
                newArr[x][y] = src[x][y];
                ++y;
            }
            ++x;
        }
        return newArr;
    }

    private double getProbsLaplace(int classIndex, Instance instance, double weight) throws Exception {
        double prob = 0.0;
        if (this.m_isLeaf) {
            return weight * this.localModel().classProbLaplace(classIndex, instance, -1);
        }
        int treeIndex = this.localModel().whichSubset(instance);
        if (treeIndex == -1) {
            double[] weights = this.localModel().weights(instance);
            int i = 0;
            while (i < this.m_sons.length) {
                if (!this.son((int)i).m_isEmpty) {
                    prob = !this.son((int)i).m_isLeaf ? (prob += this.son(i).getProbsLaplace(classIndex, instance, weights[i] * weight)) : (prob += weight * weights[i] * this.localModel().classProbLaplace(classIndex, instance, i));
                }
                ++i;
            }
            return prob;
        }
        if (this.son((int)treeIndex).m_isLeaf) {
            return weight * this.localModel().classProbLaplace(classIndex, instance, treeIndex);
        }
        return this.son(treeIndex).getProbsLaplace(classIndex, instance, weight);
    }

    private double getProbs(int classIndex, Instance instance, double weight) throws Exception {
        double prob = 0.0;
        if (this.m_isLeaf) {
            return weight * this.localModel().classProb(classIndex, instance, -1);
        }
        int treeIndex = this.localModel().whichSubset(instance);
        if (treeIndex == -1) {
            double[] weights = this.localModel().weights(instance);
            int i = 0;
            while (i < this.m_sons.length) {
                if (!this.son((int)i).m_isEmpty) {
                    prob += this.son(i).getProbs(classIndex, instance, weights[i] * weight);
                }
                ++i;
            }
            return prob;
        }
        if (this.son((int)treeIndex).m_isEmpty) {
            return weight * this.localModel().classProb(classIndex, instance, treeIndex);
        }
        return this.son(treeIndex).getProbs(classIndex, instance, weight);
    }

    public void setDescendents(ArrayList t, C45PruneableClassifierTreeG originalLeaf) {
        NoSplit kLeaf;
        C45PruneableClassifierTreeG newNode;
        Instances headerInfo = new Instances(this.m_train, 0);
        boolean end = false;
        ClassifierSplitModel splitmod = null;
        if (t.size() > 0) {
            splitmod = (ClassifierSplitModel)t.remove(t.size() - 1);
            newNode = new C45PruneableClassifierTreeG(this.m_toSelectModel, headerInfo, splitmod, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, false, this.m_relabel, this.m_cleanup);
        } else {
            kLeaf = ((GraftSplit)this.localModel()).getOtherLeaf();
            newNode = new C45PruneableClassifierTreeG(this.m_toSelectModel, headerInfo, kLeaf, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, true, this.m_relabel, this.m_cleanup);
            end = true;
        }
        if (this.m_sons != null) {
            int x = 0;
            while (x < this.m_sons.length) {
                if (this.son(x).equals(originalLeaf)) {
                    this.m_sons[x] = newNode;
                }
                ++x;
            }
        } else {
            this.m_sons = new C45PruneableClassifierTreeG[this.localModel().numSubsets()];
            kLeaf = ((GraftSplit)this.localModel()).getLeaf();
            C45PruneableClassifierTreeG kNode = new C45PruneableClassifierTreeG(this.m_toSelectModel, headerInfo, kLeaf, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, true, this.m_relabel, this.m_cleanup);
            if (((GraftSplit)this.localModel()).subsetOfInterest() == 0) {
                this.m_sons[0] = kNode;
                this.m_sons[1] = newNode;
            } else {
                this.m_sons[0] = newNode;
                this.m_sons[1] = kNode;
            }
        }
        if (!end) {
            newNode.setDescendents(t, originalLeaf);
        }
    }

    private double laplaceLeaf(double classIndex) {
        double l = (this.localModel().distribution().perClass((int)classIndex) + 1.0) / (this.localModel().distribution().total() + 2.0);
        return l;
    }

    public double biprob(double x, double n, double r) throws Exception {
        return (x - 0.5 - n * r) / Math.sqrt(n * r * (1.0 - r));
    }

    @Override
    public String toString() {
        try {
            StringBuffer text = new StringBuffer();
            if (this.m_isLeaf) {
                text.append(": ");
                if (this.m_localModel instanceof GraftSplit) {
                    text.append(((GraftSplit)this.m_localModel).dumpLabelG(0, this.m_train));
                } else {
                    text.append(this.m_localModel.dumpLabel(0, this.m_train));
                }
            } else {
                this.dumpTree(0, text);
            }
            text.append("\n\nNumber of Leaves  : \t" + this.numLeaves() + "\n");
            text.append("\nSize of the tree : \t" + this.numNodes() + "\n");
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print classification tree.";
        }
    }

    protected void dumpTree(int depth, StringBuffer text) throws Exception {
        int i = 0;
        while (i < this.m_sons.length) {
            text.append("\n");
            int j = 0;
            while (j < depth) {
                text.append("|   ");
                ++j;
            }
            text.append(this.m_localModel.leftSide(this.m_train));
            text.append(this.m_localModel.rightSide(i, this.m_train));
            if (this.m_sons[i].m_isLeaf) {
                text.append(": ");
                if (this.m_localModel instanceof GraftSplit) {
                    text.append(((GraftSplit)this.m_localModel).dumpLabelG(i, this.m_train));
                } else {
                    text.append(this.m_localModel.dumpLabel(i, this.m_train));
                }
            } else {
                ((C45PruneableClassifierTreeG)this.m_sons[i]).dumpTree(depth + 1, text);
            }
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5532 $");
    }
}

