/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.util.Random;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class AlgVector
implements Cloneable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -4023736016850256591L;
    protected double[] m_Elements;

    public AlgVector(int n) {
        this.m_Elements = new double[n];
        this.initialize();
    }

    public AlgVector(double[] array) {
        this.m_Elements = new double[array.length];
        int i = 0;
        while (i < array.length) {
            this.m_Elements[i] = array[i];
            ++i;
        }
    }

    public AlgVector(Instances format, Random random) throws Exception {
        int len = format.numAttributes();
        int i = 0;
        while (i < format.numAttributes()) {
            if (!format.attribute(i).isNumeric()) {
                --len;
            }
            ++i;
        }
        if (len > 0) {
            this.m_Elements = new double[len];
            this.initialize(random);
        }
    }

    public AlgVector(Instance instance) throws Exception {
        int len = instance.numAttributes();
        int i = 0;
        while (i < instance.numAttributes()) {
            if (!instance.attribute(i).isNumeric()) {
                --len;
            }
            ++i;
        }
        if (len > 0) {
            this.m_Elements = new double[len];
            int n = 0;
            int i2 = 0;
            while (i2 < instance.numAttributes()) {
                if (instance.attribute(i2).isNumeric()) {
                    this.m_Elements[n] = instance.value(i2);
                    ++n;
                }
                ++i2;
            }
        } else {
            throw new IllegalArgumentException("No numeric attributes in data!");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AlgVector v = (AlgVector)super.clone();
        v.m_Elements = new double[this.numElements()];
        int i = 0;
        while (i < this.numElements()) {
            v.m_Elements[i] = this.m_Elements[i];
            ++i;
        }
        return v;
    }

    protected void initialize() {
        int i = 0;
        while (i < this.m_Elements.length) {
            this.m_Elements[i] = 0.0;
            ++i;
        }
    }

    protected void initialize(Random random) {
        int i = 0;
        while (i < this.m_Elements.length) {
            this.m_Elements[i] = random.nextDouble();
            ++i;
        }
    }

    public final double getElement(int index) {
        return this.m_Elements[index];
    }

    public final int numElements() {
        return this.m_Elements.length;
    }

    public final void setElement(int index, double value) {
        this.m_Elements[index] = value;
    }

    public final void setElements(double[] elements) {
        int i = 0;
        while (i < elements.length) {
            this.m_Elements[i] = elements[i];
            ++i;
        }
    }

    public double[] getElements() {
        double[] elements = new double[this.numElements()];
        int i = 0;
        while (i < elements.length) {
            elements[i] = this.m_Elements[i];
            ++i;
        }
        return elements;
    }

    public Instance getAsInstance(Instances model, Random random) throws Exception {
        DenseInstance newInst = null;
        if (this.m_Elements != null) {
            newInst = new DenseInstance(model.numAttributes());
            newInst.setDataset(model);
            int i = 0;
            int j = 0;
            while (i < model.numAttributes()) {
                if (model.attribute(i).isNumeric()) {
                    if (j >= this.m_Elements.length) {
                        throw new Exception("Datatypes are not compatible.");
                    }
                    newInst.setValue(i, this.m_Elements[j++]);
                }
                if (model.attribute(i).isNominal()) {
                    int newVal = (int)(random.nextDouble() * (double)model.attribute(i).numValues());
                    if (newVal == model.attribute(i).numValues()) {
                        --newVal;
                    }
                    newInst.setValue(i, (double)newVal);
                }
                ++i;
            }
        }
        return newInst;
    }

    public final AlgVector add(AlgVector other) {
        AlgVector b = null;
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            try {
                b = (AlgVector)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                b = new AlgVector(n);
            }
            int i = 0;
            while (i < n) {
                b.m_Elements[i] = this.m_Elements[i] + other.m_Elements[i];
                ++i;
            }
        }
        return b;
    }

    public final AlgVector substract(AlgVector other) {
        AlgVector b;
        int n = this.m_Elements.length;
        try {
            b = (AlgVector)this.clone();
        }
        catch (CloneNotSupportedException ex) {
            b = new AlgVector(n);
        }
        int i = 0;
        while (i < n) {
            b.m_Elements[i] = this.m_Elements[i] - other.m_Elements[i];
            ++i;
        }
        return b;
    }

    public final double dotMultiply(AlgVector b) {
        double sum = 0.0;
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            int i = 0;
            while (i < n) {
                sum += this.m_Elements[i] * b.m_Elements[i];
                ++i;
            }
        }
        return sum;
    }

    public final void scalarMultiply(double s) {
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            int i = 0;
            while (i < n) {
                this.m_Elements[i] = s * this.m_Elements[i];
                ++i;
            }
        }
    }

    public void changeLength(double len) {
        double factor = this.norm();
        factor = len / factor;
        this.scalarMultiply(factor);
    }

    public double norm() {
        if (this.m_Elements != null) {
            int n = this.m_Elements.length;
            double sum = 0.0;
            int i = 0;
            while (i < n) {
                sum += this.m_Elements[i] * this.m_Elements[i];
                ++i;
            }
            return Math.pow(sum, 0.5);
        }
        return 0.0;
    }

    public final void normVector() {
        double len = this.norm();
        this.scalarMultiply(1.0 / len);
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.m_Elements.length) {
            if (i > 0) {
                text.append(",");
            }
            text.append(Utils.doubleToString(this.m_Elements[i], 6));
            ++i;
        }
        text.append("\n");
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) throws Exception {
        double[] first = new double[]{2.3, 1.2, 5.0};
        try {
            AlgVector test = new AlgVector(first);
            System.out.println("test:\n " + test);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

