/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Trie
implements Serializable,
Cloneable,
Collection<String>,
RevisionHandler {
    private static final long serialVersionUID = -5897980928817779048L;
    protected TrieNode m_Root = new TrieNode(null);
    protected int m_HashCode;
    protected boolean m_RecalcHashCode = true;

    @Override
    public boolean add(String o) {
        return this.m_Root.add(String.valueOf(o) + TrieNode.STOP);
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        boolean result = false;
        Iterator<? extends String> iter = c.iterator();
        while (iter.hasNext()) {
            boolean bl = result = this.add(iter.next()) || result;
        }
        return result;
    }

    @Override
    public void clear() {
        this.m_Root.removeAllChildren();
        this.m_RecalcHashCode = true;
    }

    public Object clone() {
        Trie result = new Trie();
        result.m_Root = (TrieNode)this.m_Root.clone();
        return result;
    }

    @Override
    public boolean contains(Object o) {
        return this.m_Root.contains(String.valueOf((String)o) + TrieNode.STOP);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean result = true;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            if (this.contains(iter.next())) continue;
            result = false;
            break;
        }
        return result;
    }

    public boolean containsPrefix(String prefix) {
        return this.m_Root.contains(prefix);
    }

    @Override
    public boolean equals(Object o) {
        return this.m_Root.equals(((Trie)o).getRoot());
    }

    public String getCommonPrefix() {
        return this.m_Root.getCommonPrefix();
    }

    public TrieNode getRoot() {
        return this.m_Root;
    }

    public Vector<String> getWithPrefix(String prefix) {
        Vector<String> result = new Vector<String>();
        if (this.containsPrefix(prefix)) {
            TrieNode node = this.m_Root.find(prefix);
            TrieIterator iter = new TrieIterator(node);
            while (iter.hasNext()) {
                result.add(iter.next());
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        if (this.m_RecalcHashCode) {
            this.m_HashCode = this.toString().hashCode();
            this.m_RecalcHashCode = false;
        }
        return this.m_HashCode;
    }

    @Override
    public boolean isEmpty() {
        return this.m_Root.getChildCount() == 0;
    }

    @Override
    public Iterator<String> iterator() {
        return new TrieIterator(this.m_Root);
    }

    @Override
    public boolean remove(Object o) {
        boolean result;
        this.m_RecalcHashCode = result = this.m_Root.remove(String.valueOf((String)o) + TrieNode.STOP);
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        Iterator<?> iter = c.iterator();
        while (iter.hasNext()) {
            boolean bl = result = this.remove(iter.next()) || result;
        }
        this.m_RecalcHashCode = result;
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (String o : this) {
            if (c.contains(o)) continue;
            boolean bl = result = this.remove(o) || result;
        }
        this.m_RecalcHashCode = result;
        return result;
    }

    @Override
    public int size() {
        return this.m_Root.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new String[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Vector list = new Vector();
        Iterator iter = (Iterator)Utils.cast(this.iterator());
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        Object[] result = Array.getLength(a) != list.size() ? (Object[])Utils.cast(Array.newInstance(a.getClass().getComponentType(), list.size())) : a;
        int i = 0;
        while (i < list.size()) {
            result[i] = list.get(i);
            ++i;
        }
        return result;
    }

    protected String toString(TrieNode node) {
        StringBuffer result = new StringBuffer();
        StringBuffer indentation = new StringBuffer();
        int i = 0;
        while (i < node.getLevel()) {
            indentation.append(" | ");
            ++i;
        }
        result.append(indentation.toString());
        if (node.getChar() == null) {
            result.append("<root>");
        } else if (node.getChar() == TrieNode.STOP) {
            result.append("STOP");
        } else {
            result.append("'" + node.getChar() + "'");
        }
        result.append("\n");
        i = 0;
        while (i < node.getChildCount()) {
            result.append(this.toString((TrieNode)node.getChildAt(i)));
            ++i;
        }
        return result.toString();
    }

    public String toString() {
        return this.toString(this.m_Root);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] args) {
        String[] data = args.length == 0 ? new String[]{"this is a test", "this is another test", "and something else"} : (String[])args.clone();
        Trie t = new Trie();
        int i = 0;
        while (i < data.length) {
            t.add(data[i]);
            ++i;
        }
        System.out.println(t);
    }

    public static class TrieIterator
    implements Iterator<String>,
    RevisionHandler {
        protected TrieNode m_Root;
        protected TrieNode m_LastLeaf;
        protected TrieNode m_CurrentLeaf;

        public TrieIterator(TrieNode node) {
            this.m_Root = node;
            this.m_CurrentLeaf = (TrieNode)this.m_Root.getFirstLeaf();
            this.m_LastLeaf = (TrieNode)this.m_Root.getLastLeaf();
        }

        @Override
        public boolean hasNext() {
            return this.m_CurrentLeaf != null;
        }

        @Override
        public String next() {
            String result = this.m_CurrentLeaf.getString();
            result = result.substring(0, result.length() - 1);
            this.m_CurrentLeaf = this.m_CurrentLeaf != this.m_LastLeaf ? (TrieNode)this.m_CurrentLeaf.getNextLeaf() : null;
            return result;
        }

        @Override
        public void remove() {
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }

    public static class TrieNode
    extends DefaultMutableTreeNode
    implements RevisionHandler {
        private static final long serialVersionUID = -2252907099391881148L;
        public static final Character STOP = Character.valueOf('\u0000');
        protected Hashtable<Character, TrieNode> m_Children = new Hashtable(100);

        public TrieNode(char c) {
            this(new Character(c));
        }

        public TrieNode(Character c) {
            super(c);
        }

        public Character getChar() {
            return (Character)this.getUserObject();
        }

        public void setChar(Character value) {
            this.setUserObject(value);
        }

        public boolean add(String suffix) {
            boolean result = false;
            Character c = Character.valueOf(suffix.charAt(0));
            String newSuffix = suffix.substring(1);
            TrieNode child = this.m_Children.get(c);
            if (child == null) {
                result = true;
                child = this.add(c);
            }
            if (newSuffix.length() > 0) {
                result = child.add(newSuffix) || result;
            }
            return result;
        }

        protected TrieNode add(Character c) {
            TrieNode child = new TrieNode(c);
            this.add(child);
            this.m_Children.put(c, child);
            return child;
        }

        protected void remove(Character c) {
            TrieNode child = this.m_Children.get(c);
            this.remove(child);
            this.m_Children.remove(c);
        }

        public boolean remove(String suffix) {
            boolean result;
            Character c = Character.valueOf(suffix.charAt(0));
            String newSuffix = suffix.substring(1);
            TrieNode child = this.m_Children.get(c);
            if (child == null) {
                result = false;
            } else if (newSuffix.length() == 0) {
                this.remove(c);
                result = true;
            } else {
                result = child.remove(newSuffix);
                if (child.getChildCount() == 0) {
                    this.remove(child.getChar());
                }
            }
            return result;
        }

        public boolean contains(String suffix) {
            Character c = Character.valueOf(suffix.charAt(0));
            String newSuffix = suffix.substring(1);
            TrieNode child = this.m_Children.get(c);
            boolean result = child == null ? false : (newSuffix.length() == 0 ? true : child.contains(newSuffix));
            return result;
        }

        @Override
        public Object clone() {
            TrieNode result = new TrieNode(this.getChar());
            Enumeration<Character> keys = this.m_Children.keys();
            while (keys.hasMoreElements()) {
                Character key = keys.nextElement();
                TrieNode child = (TrieNode)this.m_Children.get(key).clone();
                result.add(child);
                result.m_Children.put(key, child);
            }
            return result;
        }

        public boolean equals(Object obj) {
            TrieNode node = (TrieNode)obj;
            boolean result = this.getChar() == null ? node.getChar() == null : this.getChar().equals(node.getChar());
            if (result) {
                Enumeration<Character> keys = this.m_Children.keys();
                while (keys.hasMoreElements()) {
                    Character key = keys.nextElement();
                    result = this.m_Children.get(key).equals(node.m_Children.get(key));
                    if (!result) break;
                }
            }
            return result;
        }

        public TrieNode find(String suffix) {
            Character c = Character.valueOf(suffix.charAt(0));
            String newSuffix = suffix.substring(1);
            TrieNode child = this.m_Children.get(c);
            TrieNode result = child == null ? null : (newSuffix.length() == 0 ? child : child.find(newSuffix));
            return result;
        }

        public String getCommonPrefix() {
            return this.getCommonPrefix("");
        }

        public String getCommonPrefix(String startPrefix) {
            TrieNode startNode = startPrefix.length() == 0 ? this : this.find(startPrefix);
            String result = startNode == null ? null : String.valueOf(startPrefix) + startNode.determineCommonPrefix("");
            return result;
        }

        protected String determineCommonPrefix(String currentPrefix) {
            String newPrefix = !this.isRoot() && this.getChar() != STOP ? String.valueOf(currentPrefix) + this.getChar() : currentPrefix;
            String result = this.m_Children.size() == 1 ? ((TrieNode)this.getChildAt(0)).determineCommonPrefix(newPrefix) : newPrefix;
            return result;
        }

        public int size() {
            int result = 0;
            TrieNode leaf = (TrieNode)this.getFirstLeaf();
            while (leaf != null) {
                if (leaf != this.getRoot()) {
                    ++result;
                }
                leaf = (TrieNode)leaf.getNextLeaf();
            }
            return result;
        }

        public String getString() {
            char[] result = new char[this.getLevel()];
            TrieNode node = this;
            while (node.getParent() != null) {
                if (node.isRoot()) break;
                result[node.getLevel() - 1] = node.getChar().charValue();
                node = (TrieNode)node.getParent();
            }
            return new String(result);
        }

        @Override
        public String toString() {
            return "" + this.getChar();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }
}

