/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.converters.AbstractFileLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.URLSourcedLoader;

public class LibSVMLoader
extends AbstractFileLoader
implements BatchConverter,
URLSourcedLoader {
    private static final long serialVersionUID = 4988360125354664417L;
    public static String FILE_EXTENSION = ".libsvm";
    protected String m_URL = "http://";
    protected transient Reader m_sourceReader = null;
    protected Vector<double[]> m_Buffer = null;

    public String globalInfo() {
        return "Reads a source that is in libsvm format.\n\nFor more information about libsvm see:\n\nhttp://www.csie.ntu.edu.tw/~cjlin/libsvm/";
    }

    @Override
    public String getFileExtension() {
        return FILE_EXTENSION;
    }

    @Override
    public String[] getFileExtensions() {
        return new String[]{this.getFileExtension()};
    }

    @Override
    public String getFileDescription() {
        return "libsvm data files";
    }

    @Override
    public void reset() throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        if (this.m_File != null && new File(this.m_File).isFile()) {
            this.setFile(new File(this.m_File));
        } else if (this.m_URL != null && !this.m_URL.equals("http://")) {
            this.setURL(this.m_URL);
        }
    }

    public void setSource(URL url) throws IOException {
        this.m_structure = null;
        this.m_Buffer = null;
        this.setRetrieval(0);
        this.setSource(url.openStream());
        this.m_URL = url.toString();
    }

    @Override
    public void setURL(String url) throws IOException {
        this.m_URL = url;
        this.setSource(new URL(url));
    }

    @Override
    public String retrieveURL() {
        return this.m_URL;
    }

    @Override
    public void setSource(InputStream in) throws IOException {
        this.m_File = new File(System.getProperty("user.dir")).getAbsolutePath();
        this.m_URL = "http://";
        this.m_sourceReader = new BufferedReader(new InputStreamReader(in));
    }

    protected double[] libsvmToArray(String row) {
        int index;
        String col;
        int max = 0;
        StringTokenizer tok = new StringTokenizer(row, " \t");
        tok.nextToken();
        while (tok.hasMoreTokens()) {
            col = tok.nextToken();
            index = Integer.parseInt(col.substring(0, col.indexOf(":")));
            if (index <= max) continue;
            max = index;
        }
        tok = new StringTokenizer(row, " \t");
        double[] result = new double[max + 1];
        result[result.length - 1] = Double.parseDouble(tok.nextToken());
        while (tok.hasMoreTokens()) {
            double value;
            col = tok.nextToken();
            index = Integer.parseInt(col.substring(0, col.indexOf(":")));
            result[index - 1] = value = Double.parseDouble(col.substring(col.indexOf(":") + 1));
        }
        return result;
    }

    protected int determineNumAttributes(String row, int num) {
        int result = num;
        int count = this.libsvmToArray(row).length;
        if (count > result) {
            result = count;
        }
        return result;
    }

    @Override
    public Instances getStructure() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.m_structure == null) {
            this.m_Buffer = new Vector();
            try {
                int cInt;
                int numAtt = 0;
                StringBuffer line = new StringBuffer();
                while ((cInt = this.m_sourceReader.read()) != -1) {
                    char c = (char)cInt;
                    if (c == '\n' || c == '\r') {
                        if (line.length() > 0) {
                            this.m_Buffer.add(this.libsvmToArray(line.toString()));
                            numAtt = this.determineNumAttributes(line.toString(), numAtt);
                        }
                        line = new StringBuffer();
                        continue;
                    }
                    line.append(c);
                }
                if (line.length() != 0) {
                    this.m_Buffer.add(this.libsvmToArray(line.toString()));
                    numAtt = this.determineNumAttributes(line.toString(), numAtt);
                }
                ArrayList<Attribute> atts = new ArrayList<Attribute>(numAtt);
                int i = 0;
                while (i < numAtt - 1) {
                    atts.add(new Attribute("att_" + (i + 1)));
                    ++i;
                }
                atts.add(new Attribute("class"));
                String relName = !this.m_URL.equals("http://") ? this.m_URL : this.m_File;
                this.m_structure = new Instances(relName, atts, 0);
                this.m_structure.setClassIndex(this.m_structure.numAttributes() - 1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException("Unable to determine structure as libsvm: " + ex);
            }
        }
        return new Instances(this.m_structure, 0);
    }

    @Override
    public Instances getDataSet() throws IOException {
        if (this.m_sourceReader == null) {
            throw new IOException("No source has been specified");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Cannot mix getting Instances in both incremental and batch modes");
        }
        this.setRetrieval(1);
        if (this.m_structure == null) {
            this.getStructure();
        }
        Instances result = new Instances(this.m_structure, 0);
        int i = 0;
        while (i < this.m_Buffer.size()) {
            double[] data;
            double[] sparse = this.m_Buffer.get(i);
            if (sparse.length != this.m_structure.numAttributes()) {
                data = new double[this.m_structure.numAttributes()];
                System.arraycopy(sparse, 0, data, 0, sparse.length - 1);
                data[data.length - 1] = sparse[sparse.length - 1];
            } else {
                data = sparse;
            }
            result.add(new SparseInstance(1.0, data));
            ++i;
        }
        try {
            this.m_sourceReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Instance getNextInstance(Instances structure) throws IOException {
        throw new IOException("LibSVMLoader can't read data sets incrementally.");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] args) {
        LibSVMLoader.runFileLoader(new LibSVMLoader(), args);
    }
}

