/*
 * Decompiled with CFR 0.152.
 */
package weka.core.matrix;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public class LinearRegression
implements RevisionHandler {
    protected double[] m_Coefficients = null;

    public LinearRegression(Matrix a, Matrix y, double ridge) {
        this.calculate(a, y, ridge);
    }

    public LinearRegression(Matrix a, Matrix y, double[] w, double ridge) {
        if (w.length != a.getRowDimension()) {
            throw new IllegalArgumentException("Incorrect number of weights provided");
        }
        Matrix weightedThis = new Matrix(a.getRowDimension(), a.getColumnDimension());
        Matrix weightedDep = new Matrix(a.getRowDimension(), 1);
        int i = 0;
        while (i < w.length) {
            double sqrt_weight = Math.sqrt(w[i]);
            int j = 0;
            while (j < a.getColumnDimension()) {
                weightedThis.set(i, j, a.get(i, j) * sqrt_weight);
                ++j;
            }
            weightedDep.set(i, 0, y.get(i, 0) * sqrt_weight);
            ++i;
        }
        this.calculate(weightedThis, weightedDep, ridge);
    }

    protected void calculate(Matrix a, Matrix y, double ridge) {
        if (y.getColumnDimension() > 1) {
            throw new IllegalArgumentException("Only one dependent variable allowed");
        }
        int nc = a.getColumnDimension();
        this.m_Coefficients = new double[nc];
        Matrix xt = a.transpose();
        boolean success = true;
        do {
            Matrix ss = xt.times(a);
            int i = 0;
            while (i < nc) {
                ss.set(i, i, ss.get(i, i) + ridge);
                ++i;
            }
            Matrix bb = xt.times(y);
            int i2 = 0;
            while (i2 < nc) {
                this.m_Coefficients[i2] = bb.get(i2, 0);
                ++i2;
            }
            try {
                Matrix solution = ss.solve(new Matrix(this.m_Coefficients, this.m_Coefficients.length));
                i2 = 0;
                while (i2 < nc) {
                    this.m_Coefficients[i2] = solution.get(i2, 0);
                    ++i2;
                }
                success = true;
            }
            catch (Exception ex) {
                ridge *= 10.0;
                success = false;
            }
        } while (!success);
    }

    public final double[] getCoefficients() {
        return this.m_Coefficients;
    }

    public String toString() {
        return Utils.arrayToString(this.getCoefficients());
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

