/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.io.Serializable;
import weka.core.DenseInstance;
import weka.core.DistanceFunction;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class BallNode
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8289151861759883510L;
    public int m_Start;
    public int m_End;
    public int m_NumInstances;
    public int m_NodeNumber;
    public int m_SplitAttrib = -1;
    public double m_SplitVal = -1.0;
    public BallNode m_Left = null;
    public BallNode m_Right = null;
    protected Instance m_Pivot;
    protected double m_Radius;

    public BallNode(int nodeNumber) {
        this.m_NodeNumber = nodeNumber;
    }

    public BallNode(int start, int end, int nodeNumber) {
        this.m_Start = start;
        this.m_End = end;
        this.m_NodeNumber = nodeNumber;
        this.m_NumInstances = end - start + 1;
    }

    public BallNode(int start, int end, int nodeNumber, Instance pivot, double radius) {
        this.m_Start = start;
        this.m_End = end;
        this.m_NodeNumber = nodeNumber;
        this.m_Pivot = pivot;
        this.m_Radius = radius;
        this.m_NumInstances = end - start + 1;
    }

    public boolean isALeaf() {
        return this.m_Left == null && this.m_Right == null;
    }

    public void setStartEndIndices(int start, int end) {
        this.m_Start = start;
        this.m_End = end;
        this.m_NumInstances = end - start + 1;
    }

    public void setPivot(Instance pivot) {
        this.m_Pivot = pivot;
    }

    public Instance getPivot() {
        return this.m_Pivot;
    }

    public void setRadius(double radius) {
        this.m_Radius = radius;
    }

    public double getRadius() {
        return this.m_Radius;
    }

    public int numInstances() {
        return this.m_End - this.m_Start + 1;
    }

    public static Instance calcCentroidPivot(int[] instList, Instances insts) {
        Instance temp;
        double[] attrVals = new double[insts.numAttributes()];
        int i = 0;
        while (i < instList.length) {
            temp = insts.instance(instList[i]);
            int j = 0;
            while (j < temp.numValues()) {
                int n = j;
                attrVals[n] = attrVals[n] + temp.valueSparse(j);
                ++j;
            }
            ++i;
        }
        int j = 0;
        int numInsts = instList.length;
        while (j < attrVals.length) {
            int n = j++;
            attrVals[n] = attrVals[n] / (double)numInsts;
        }
        temp = new DenseInstance(1.0, attrVals);
        return temp;
    }

    public static Instance calcCentroidPivot(int start, int end, int[] instList, Instances insts) {
        Instance temp;
        double[] attrVals = new double[insts.numAttributes()];
        int i = start;
        while (i <= end) {
            temp = insts.instance(instList[i]);
            int j = 0;
            while (j < temp.numValues()) {
                int n = j;
                attrVals[n] = attrVals[n] + temp.valueSparse(j);
                ++j;
            }
            ++i;
        }
        int j = 0;
        int numInsts = end - start + 1;
        while (j < attrVals.length) {
            int n = j++;
            attrVals[n] = attrVals[n] / (double)numInsts;
        }
        temp = new DenseInstance(1.0, attrVals);
        return temp;
    }

    public static double calcRadius(int[] instList, Instances insts, Instance pivot, DistanceFunction distanceFunction) throws Exception {
        return BallNode.calcRadius(0, instList.length - 1, instList, insts, pivot, distanceFunction);
    }

    public static double calcRadius(int start, int end, int[] instList, Instances insts, Instance pivot, DistanceFunction distanceFunction) throws Exception {
        double radius = Double.NEGATIVE_INFINITY;
        int i = start;
        while (i <= end) {
            double dist = distanceFunction.distance(pivot, insts.instance(instList[i]), Double.POSITIVE_INFINITY);
            if (dist > radius) {
                radius = dist;
            }
            ++i;
        }
        return Math.sqrt(radius);
    }

    public static Instance calcPivot(BallNode child1, BallNode child2, Instances insts) throws Exception {
        Instance p1 = child1.getPivot();
        Instance p2 = child2.getPivot();
        double[] attrVals = new double[p1.numAttributes()];
        int j = 0;
        while (j < attrVals.length) {
            int n = j;
            attrVals[n] = attrVals[n] + p1.value(j);
            int n2 = j;
            attrVals[n2] = attrVals[n2] + p2.value(j);
            int n3 = j++;
            attrVals[n3] = attrVals[n3] / 2.0;
        }
        p1 = new DenseInstance(1.0, attrVals);
        return p1;
    }

    public static double calcRadius(BallNode child1, BallNode child2, Instance pivot, DistanceFunction distanceFunction) throws Exception {
        Instance p1 = child1.getPivot();
        Instance p2 = child2.getPivot();
        double radius = child1.getRadius() + distanceFunction.distance(p1, p2) + child2.getRadius();
        return radius / 2.0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }
}

