/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.regression;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.datagenerators.classifiers.regression.MexicanHat;
import weka.filters.unsupervised.attribute.AddExpression;

public class Expression
extends MexicanHat {
    static final long serialVersionUID = -4237047357682277211L;
    protected String m_Expression;
    protected AddExpression m_Filter;
    protected Instances m_RawData;

    public Expression() {
        this.setExpression(this.defaultExpression());
    }

    @Override
    public String globalInfo() {
        return "A data generator for generating y according to a given expression out of randomly generated x.\nE.g., the mexican hat can be generated like this:\n   sin(abs(a1)) / abs(a1)\nIn addition to this function, the amplitude can be changed and gaussian noise can be added.";
    }

    @Override
    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.addElement(new Option("\tThe expression to use for generating y out of x \n\t(default " + this.defaultExpression() + ").", "E", 1, "-E <expression>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('E', options);
        if (tmpStr.length() != 0) {
            this.setExpression(tmpStr);
        } else {
            this.setExpression(this.defaultExpression());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-E");
        result.add(this.getExpression());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String amplitudeTipText() {
        return "The amplitude to multiply the y value with.";
    }

    protected String defaultExpression() {
        return "sin(abs(a1)) / abs(a1)";
    }

    public String getExpression() {
        return this.m_Expression;
    }

    public void setExpression(String value) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("An expression has to be provided!");
        }
        this.m_Expression = value;
    }

    public String expressionTipText() {
        return "The expression for generating y out of x.";
    }

    @Override
    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        FastVector<Attribute> atts = new FastVector<Attribute>();
        atts.addElement(new Attribute("x"));
        this.m_RawData = new Instances(this.getRelationNameToUse(), atts, 0);
        this.m_Filter = new AddExpression();
        this.m_Filter.setName("y");
        this.m_Filter.setExpression(this.getExpression());
        this.m_Filter.setInputFormat(this.m_RawData);
        return super.defineDataFormat();
    }

    @Override
    public Instance generateExample() throws Exception {
        DenseInstance result = null;
        Random rand = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double x = rand.nextDouble();
        x = x * (this.getMaxRange() - this.getMinRange()) + this.getMinRange();
        double[] atts = new double[]{x};
        Instance inst = new DenseInstance(1.0, atts);
        this.m_Filter.input(inst);
        this.m_Filter.batchFinished();
        inst = this.m_Filter.output();
        double y = inst.value(1) + this.getAmplitude() * this.m_NoiseRandom.nextGaussian() * this.getNoiseRate() * this.getNoiseVariance();
        atts = new double[this.m_DatasetFormat.numAttributes()];
        atts[0] = x;
        atts[1] = y;
        result = new DenseInstance(1.0, atts);
        result.setDataset(this.m_DatasetFormat);
        return result;
    }

    @Override
    public Instances generateExamples() throws Exception {
        Instances result = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        int i = 0;
        while (i < this.getNumExamplesAct()) {
            result.add(this.generateExample());
            ++i;
        }
        return result;
    }

    @Override
    public String generateStart() {
        return "";
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        Expression.runDataGenerator(new Expression(), args);
    }
}

