/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.experiment.DatabaseUtils;

public class InstanceQuery
extends DatabaseUtils
implements OptionHandler {
    static final long serialVersionUID = 718158370917782584L;
    boolean m_CreateSparseData = false;
    String m_Query = "SELECT * from ?";

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSQL query to execute.", "Q", 1, "-Q <query>"));
        result.addElement(new Option("\tReturn sparse rather than normal instances.", "S", 0, "-S"));
        result.addElement(new Option("\tThe username to use for connecting.", "U", 1, "-U <username>"));
        result.addElement(new Option("\tThe password to use for connecting.", "P", 1, "-P <password>"));
        result.addElement(new Option("\tEnables debug output.", "D", 0, "-D"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setSparseData(Utils.getFlag('S', options));
        String tmpStr = Utils.getOption('Q', options);
        if (tmpStr.length() != 0) {
            this.setQuery(tmpStr);
        }
        if ((tmpStr = Utils.getOption('U', options)).length() != 0) {
            this.setUsername(tmpStr);
        }
        if ((tmpStr = Utils.getOption('P', options)).length() != 0) {
            this.setPassword(tmpStr);
        }
        this.setDebug(Utils.getFlag('D', options));
    }

    public String queryTipText() {
        return "The SQL query to execute against the database.";
    }

    public void setQuery(String q) {
        this.m_Query = q;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public String sparseDataTipText() {
        return "Encode data as sparse instances.";
    }

    public void setSparseData(boolean s) {
        this.m_CreateSparseData = s;
    }

    public boolean getSparseData() {
        return this.m_CreateSparseData;
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-Q");
        options.add(this.getQuery());
        if (this.getSparseData()) {
            options.add("-S");
        }
        if (!this.getUsername().equals("")) {
            options.add("-U");
            options.add(this.getUsername());
        }
        if (!this.getPassword().equals("")) {
            options.add("-P");
            options.add(this.getPassword());
        }
        if (this.getDebug()) {
            options.add("-D");
        }
        return options.toArray(new String[options.size()]);
    }

    public Instances retrieveInstances() throws Exception {
        return this.retrieveInstances(this.m_Query);
    }

    public Instances retrieveInstances(String query) throws Exception {
        if (this.m_Debug) {
            System.err.println("Executing query: " + query);
        }
        this.connectToDatabase();
        if (!this.execute(query)) {
            if (this.m_PreparedStatement.getUpdateCount() == -1) {
                throw new Exception("Query didn't produce results");
            }
            if (this.m_Debug) {
                System.err.println(String.valueOf(this.m_PreparedStatement.getUpdateCount()) + " rows affected.");
            }
            this.close();
            return null;
        }
        ResultSet rs = this.getResultSet();
        if (this.m_Debug) {
            System.err.println("Getting metadata...");
        }
        ResultSetMetaData md = rs.getMetaData();
        if (this.m_Debug) {
            System.err.println("Completed getting metadata...");
        }
        int numAttributes = md.getColumnCount();
        int[] attributeTypes = new int[numAttributes];
        Hashtable[] nominalIndexes = new Hashtable[numAttributes];
        FastVector[] nominalStrings = new FastVector[numAttributes];
        int i = 1;
        while (i <= numAttributes) {
            switch (this.translateDBColumnType(md.getColumnTypeName(i))) {
                case 0: {
                    attributeTypes[i - 1] = 1;
                    nominalIndexes[i - 1] = new Hashtable();
                    nominalStrings[i - 1] = new FastVector();
                    break;
                }
                case 9: {
                    attributeTypes[i - 1] = 2;
                    nominalIndexes[i - 1] = new Hashtable();
                    nominalStrings[i - 1] = new FastVector();
                    break;
                }
                case 1: {
                    attributeTypes[i - 1] = 1;
                    nominalIndexes[i - 1] = new Hashtable();
                    nominalIndexes[i - 1].put("false", new Double(0.0));
                    nominalIndexes[i - 1].put("true", new Double(1.0));
                    nominalStrings[i - 1] = new FastVector();
                    nominalStrings[i - 1].addElement("false");
                    nominalStrings[i - 1].addElement("true");
                    break;
                }
                case 2: {
                    attributeTypes[i - 1] = 0;
                    break;
                }
                case 3: {
                    attributeTypes[i - 1] = 0;
                    break;
                }
                case 4: {
                    attributeTypes[i - 1] = 0;
                    break;
                }
                case 5: {
                    attributeTypes[i - 1] = 0;
                    break;
                }
                case 6: {
                    attributeTypes[i - 1] = 0;
                    break;
                }
                case 7: {
                    attributeTypes[i - 1] = 0;
                    break;
                }
                case 8: {
                    attributeTypes[i - 1] = 3;
                    break;
                }
                case 10: {
                    attributeTypes[i - 1] = 3;
                    break;
                }
                default: {
                    attributeTypes[i - 1] = 2;
                }
            }
            ++i;
        }
        Vector<String> columnNames = new Vector<String>();
        int i2 = 0;
        while (i2 < numAttributes) {
            columnNames.add(md.getColumnName(i2 + 1));
            ++i2;
        }
        if (this.m_Debug) {
            System.err.println("Creating instances...");
        }
        FastVector<SparseInstance> instances = new FastVector<SparseInstance>();
        int rowCount = 0;
        while (rs.next()) {
            if (rowCount % 100 == 0 && this.m_Debug) {
                System.err.print("read " + rowCount + " instances \r");
                System.err.flush();
            }
            double[] vals = new double[numAttributes];
            int i3 = 1;
            while (i3 <= numAttributes) {
                switch (this.translateDBColumnType(md.getColumnTypeName(i3))) {
                    case 0: {
                        String str = rs.getString(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        Double index = (Double)nominalIndexes[i3 - 1].get(str);
                        if (index == null) {
                            index = new Double(nominalStrings[i3 - 1].size());
                            nominalIndexes[i3 - 1].put(str, index);
                            nominalStrings[i3 - 1].addElement(str);
                        }
                        vals[i3 - 1] = index;
                        break;
                    }
                    case 9: {
                        String txt = rs.getString(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        Double index = (Double)nominalIndexes[i3 - 1].get(txt);
                        if (index == null) {
                            index = new Double(nominalStrings[i3 - 1].size());
                            nominalIndexes[i3 - 1].put(txt, index);
                            nominalStrings[i3 - 1].addElement(txt);
                        }
                        vals[i3 - 1] = index;
                        break;
                    }
                    case 1: {
                        boolean boo = rs.getBoolean(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = boo ? 1.0 : 0.0;
                        break;
                    }
                    case 2: {
                        double dd = rs.getDouble(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = dd;
                        break;
                    }
                    case 3: {
                        byte by = rs.getByte(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = by;
                        break;
                    }
                    case 4: {
                        short sh = rs.getShort(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = sh;
                        break;
                    }
                    case 5: {
                        int in = rs.getInt(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = in;
                        break;
                    }
                    case 6: {
                        long lo = rs.getLong(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = lo;
                        break;
                    }
                    case 7: {
                        float fl = rs.getFloat(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = fl;
                        break;
                    }
                    case 8: {
                        Date date = rs.getDate(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = date.getTime();
                        break;
                    }
                    case 10: {
                        Time time = rs.getTime(i3);
                        if (rs.wasNull()) {
                            vals[i3 - 1] = Utils.missingValue();
                            break;
                        }
                        vals[i3 - 1] = time.getTime();
                        break;
                    }
                    default: {
                        vals[i3 - 1] = Utils.missingValue();
                    }
                }
                ++i3;
            }
            AbstractInstance newInst = this.m_CreateSparseData ? new SparseInstance(1.0, vals) : new DenseInstance(1.0, vals);
            instances.addElement((SparseInstance)newInst);
            ++rowCount;
        }
        if (this.m_Debug) {
            System.err.println("Creating header...");
        }
        FastVector<Attribute> attribInfo = new FastVector<Attribute>();
        int i4 = 0;
        while (i4 < numAttributes) {
            String attribName = this.attributeCaseFix((String)columnNames.get(i4));
            switch (attributeTypes[i4]) {
                case 1: {
                    attribInfo.addElement(new Attribute(attribName, nominalStrings[i4]));
                    break;
                }
                case 0: {
                    attribInfo.addElement(new Attribute(attribName));
                    break;
                }
                case 2: {
                    Attribute att = new Attribute(attribName, null);
                    attribInfo.addElement(att);
                    int n = 0;
                    while (n < nominalStrings[i4].size()) {
                        att.addStringValue((String)nominalStrings[i4].elementAt(n));
                        ++n;
                    }
                    break;
                }
                case 3: {
                    attribInfo.addElement(new Attribute(attribName, null));
                    break;
                }
                default: {
                    throw new Exception("Unknown attribute type");
                }
            }
            ++i4;
        }
        Instances result = new Instances("QueryResult", attribInfo, instances.size());
        int i5 = 0;
        while (i5 < instances.size()) {
            result.add((Instance)instances.elementAt(i5));
            ++i5;
        }
        this.close(rs);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) {
        try {
            block9: {
                iq = new InstanceQuery();
                query = Utils.getOption('Q', args);
                if (query.length() == 0) {
                    iq.setQuery("select * from Experiment_index");
                } else {
                    iq.setQuery(query);
                }
                iq.setOptions(args);
                try {
                    Utils.checkForRemainingOptions(args);
                    break block9;
                }
                catch (Exception e) {
                    System.err.println("Options for weka.experiment.InstanceQuery:\n");
                    en = iq.listOptions();
                    ** while (en.hasMoreElements())
                }
lbl-1000:
                // 1 sources

                {
                    o = (Option)en.nextElement();
                    System.err.println(String.valueOf(o.synopsis()) + "\n" + o.description());
                    continue;
                }
lbl19:
                // 1 sources

                System.exit(1);
            }
            aha = iq.retrieveInstances();
            iq.disconnectFromDatabase();
            if (aha == null) {
                return;
            }
            System.out.println(new Instances(aha, 0));
            i = 0;
            while (i < aha.numInstances()) {
                System.out.println(aha.instance(i));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }
}

