/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.supervised.instance;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.SupervisedFilter;

public class Resample
extends Filter
implements SupervisedFilter,
OptionHandler {
    static final long serialVersionUID = 7079064953548300681L;
    protected double m_SampleSizePercent = 100.0;
    protected int m_RandomSeed = 1;
    protected double m_BiasToUniformClass = 0.0;
    protected boolean m_NoReplacement = false;
    protected boolean m_InvertSelection = false;

    public String globalInfo() {
        return "Produces a random subsample of a dataset using either sampling with replacement or without replacement.\nThe original dataset must fit entirely in memory. The number of instances in the generated dataset may be specified. The dataset must have a nominal class attribute. If not, use the unsupervised version. The filter can be made to maintain the class distribution in the subsample, or to bias the class distribution toward a uniform distribution. When used in batch mode (i.e. in the FilteredClassifier), subsequent batches are NOT resampled.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSpecify the random number seed (default 1)", "S", 1, "-S <num>"));
        result.addElement(new Option("\tThe size of the output dataset, as a percentage of\n\tthe input dataset (default 100)", "Z", 1, "-Z <num>"));
        result.addElement(new Option("\tBias factor towards uniform class distribution.\n\t0 = distribution in input data -- 1 = uniform distribution.\n\t(default 0)", "B", 1, "-B <num>"));
        result.addElement(new Option("\tDisables replacement of instances\n\t(default: with replacement)", "no-replacement", 0, "-no-replacement"));
        result.addElement(new Option("\tInverts the selection - only available with '-no-replacement'.", "V", 0, "-V"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() != 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(1);
        }
        tmpStr = Utils.getOption('B', options);
        if (tmpStr.length() != 0) {
            this.setBiasToUniformClass(Double.parseDouble(tmpStr));
        } else {
            this.setBiasToUniformClass(0.0);
        }
        tmpStr = Utils.getOption('Z', options);
        if (tmpStr.length() != 0) {
            this.setSampleSizePercent(Double.parseDouble(tmpStr));
        } else {
            this.setSampleSizePercent(100.0);
        }
        this.setNoReplacement(Utils.getFlag("no-replacement", options));
        if (this.getNoReplacement()) {
            this.setInvertSelection(Utils.getFlag('V', options));
        }
        if (this.getInputFormat() != null) {
            this.setInputFormat(this.getInputFormat());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-B");
        result.add("" + this.getBiasToUniformClass());
        result.add("-S");
        result.add("" + this.getRandomSeed());
        result.add("-Z");
        result.add("" + this.getSampleSizePercent());
        if (this.getNoReplacement()) {
            result.add("-no-replacement");
            if (this.getInvertSelection()) {
                result.add("-V");
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String biasToUniformClassTipText() {
        return "Whether to use bias towards a uniform class. A value of 0 leaves the class distribution as-is, a value of 1 ensures the class distribution is uniform in the output data.";
    }

    public double getBiasToUniformClass() {
        return this.m_BiasToUniformClass;
    }

    public void setBiasToUniformClass(double newBiasToUniformClass) {
        this.m_BiasToUniformClass = newBiasToUniformClass;
    }

    public String randomSeedTipText() {
        return "Sets the random number seed for subsampling.";
    }

    public int getRandomSeed() {
        return this.m_RandomSeed;
    }

    public void setRandomSeed(int newSeed) {
        this.m_RandomSeed = newSeed;
    }

    public String sampleSizePercentTipText() {
        return "The subsample size as a percentage of the original set.";
    }

    public double getSampleSizePercent() {
        return this.m_SampleSizePercent;
    }

    public void setSampleSizePercent(double newSampleSizePercent) {
        this.m_SampleSizePercent = newSampleSizePercent;
    }

    public String noReplacementTipText() {
        return "Disables the replacement of instances.";
    }

    public boolean getNoReplacement() {
        return this.m_NoReplacement;
    }

    public void setNoReplacement(boolean value) {
        this.m_NoReplacement = value;
    }

    public String invertSelectionTipText() {
        return "Inverts the selection (only if instances are drawn WITHOUT replacement).";
    }

    public boolean getInvertSelection() {
        return this.m_InvertSelection;
    }

    public void setInvertSelection(boolean value) {
        this.m_InvertSelection = value;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public boolean setInputFormat(Instances instanceInfo) throws Exception {
        super.setInputFormat(instanceInfo);
        this.setOutputFormat(instanceInfo);
        return true;
    }

    @Override
    public boolean input(Instance instance) {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.isFirstBatchDone()) {
            this.push(instance);
            return true;
        }
        this.bufferInput(instance);
        return false;
    }

    @Override
    public boolean batchFinished() {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (!this.isFirstBatchDone()) {
            this.createSubsample();
        }
        this.flushInput();
        this.m_NewBatch = true;
        this.m_FirstBatchDone = true;
        return this.numPendingOutput() != 0;
    }

    public void createSubsampleWithReplacement(Random random, int origSize, int sampleSize, int actualClasses, int[] classIndices) {
        int i = 0;
        while (i < sampleSize) {
            int index = 0;
            if (random.nextDouble() < this.m_BiasToUniformClass) {
                int cIndex = random.nextInt(actualClasses);
                int j = 0;
                int k = 0;
                while (j < classIndices.length - 1) {
                    if (classIndices[j] != classIndices[j + 1] && k++ >= cIndex) {
                        index = classIndices[j] + random.nextInt(classIndices[j + 1] - classIndices[j]);
                        break;
                    }
                    ++j;
                }
            } else {
                index = random.nextInt(origSize);
            }
            this.push((Instance)this.getInputFormat().instance(index).copy());
            ++i;
        }
    }

    public void createSubsampleWithoutReplacement(Random random, int origSize, int sampleSize, int actualClasses, int[] classIndices) {
        if (sampleSize > origSize) {
            sampleSize = origSize;
            System.err.println("Resampling without replacement can only use percentage <=100% - Using full dataset!");
        }
        Vector[] indices = new Vector[classIndices.length - 1];
        Vector[] indicesNew = new Vector[classIndices.length - 1];
        int i = 0;
        while (i < classIndices.length - 1) {
            indices[i] = new Vector(classIndices[i + 1] - classIndices[i]);
            indicesNew[i] = new Vector(indices[i].capacity());
            int n = classIndices[i];
            while (n < classIndices[i + 1]) {
                indices[i].add(n);
                ++n;
            }
            ++i;
        }
        int currentSize = origSize;
        int i2 = 0;
        while (i2 < sampleSize) {
            int index = 0;
            if (random.nextDouble() < this.m_BiasToUniformClass) {
                int cIndex = random.nextInt(actualClasses);
                int j = 0;
                int k = 0;
                while (j < classIndices.length - 1) {
                    if (classIndices[j] != classIndices[j + 1] && k++ >= cIndex) {
                        if (indices[j].size() == 0) {
                            --i2;
                        } else {
                            index = random.nextInt(indices[j].size());
                            indicesNew[j].add((Integer)indices[j].get(index));
                            indices[j].remove(index);
                        }
                        break;
                    }
                    ++j;
                }
            } else {
                index = random.nextInt(currentSize);
                int n = 0;
                while (n < actualClasses) {
                    if (index < indices[n].size()) {
                        indicesNew[n].add((Integer)indices[n].get(index));
                        indices[n].remove(index);
                        break;
                    }
                    index -= indices[n].size();
                    ++n;
                }
                --currentSize;
            }
            ++i2;
        }
        if (this.getInvertSelection()) {
            indicesNew = indices;
        } else {
            i2 = 0;
            while (i2 < indicesNew.length) {
                Collections.sort(indicesNew[i2]);
                ++i2;
            }
        }
        i2 = 0;
        while (i2 < indicesNew.length) {
            int n = 0;
            while (n < indicesNew[i2].size()) {
                this.push((Instance)this.getInputFormat().instance((Integer)indicesNew[i2].get(n)).copy());
                ++n;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < indices.length) {
            indices[i2].clear();
            indicesNew[i2].clear();
            ++i2;
        }
        indices = null;
        indicesNew = null;
    }

    protected void createSubsample() {
        int origSize = this.getInputFormat().numInstances();
        int sampleSize = (int)((double)origSize * this.m_SampleSizePercent / 100.0);
        this.getInputFormat().sort(this.getInputFormat().classIndex());
        int[] classIndices = new int[this.getInputFormat().numClasses() + 1];
        int currentClass = 0;
        classIndices[currentClass] = 0;
        int i = 0;
        while (i < this.getInputFormat().numInstances()) {
            int j;
            Instance current = this.getInputFormat().instance(i);
            if (current.classIsMissing()) {
                j = currentClass + 1;
                while (j < classIndices.length) {
                    classIndices[j] = i;
                    ++j;
                }
                break;
            }
            if (current.classValue() != (double)currentClass) {
                j = currentClass + 1;
                while ((double)j <= current.classValue()) {
                    classIndices[j] = i;
                    ++j;
                }
                currentClass = (int)current.classValue();
            }
            ++i;
        }
        if (currentClass <= this.getInputFormat().numClasses()) {
            int j = currentClass + 1;
            while (j < classIndices.length) {
                classIndices[j] = this.getInputFormat().numInstances();
                ++j;
            }
        }
        int actualClasses = 0;
        int i2 = 0;
        while (i2 < classIndices.length - 1) {
            if (classIndices[i2] != classIndices[i2 + 1]) {
                ++actualClasses;
            }
            ++i2;
        }
        Random random = new Random(this.m_RandomSeed);
        if (this.getNoReplacement()) {
            this.createSubsampleWithoutReplacement(random, origSize, sampleSize, actualClasses, classIndices);
        } else {
            this.createSubsampleWithReplacement(random, origSize, sampleSize, actualClasses, classIndices);
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5492 $");
    }

    public static void main(String[] argv) {
        Resample.runFilter(new Resample(), argv);
    }
}

