/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditor;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;

public class PropertyDialog
extends JDialog {
    private static final long serialVersionUID = -2314850859392433539L;
    private PropertyEditor m_Editor;
    private Component m_EditorComponent;

    public PropertyDialog(PropertyEditor pe, int x, int y) {
        this((Frame)null, pe, x, y);
        this.setVisible(true);
    }

    public PropertyDialog(Dialog owner, PropertyEditor pe) {
        this(owner, pe, -1, -1);
    }

    public PropertyDialog(Dialog owner, PropertyEditor pe, int x, int y) {
        super(owner, pe.getClass().getName(), true);
        this.initialize(pe, x, y);
    }

    public PropertyDialog(Frame owner, PropertyEditor pe) {
        this(owner, pe, -1, -1);
    }

    public PropertyDialog(Frame owner, PropertyEditor pe, int x, int y) {
        super(owner, pe.getClass().getName(), true);
        this.initialize(pe, x, y);
    }

    protected void initialize(PropertyEditor pe, int x, int y) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                e.getWindow().dispose();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.m_Editor = pe;
        this.m_EditorComponent = pe.getCustomEditor();
        this.getContentPane().add(this.m_EditorComponent, "Center");
        this.pack();
        int screenWidth = this.getGraphicsConfiguration().getBounds().width;
        int screenHeight = this.getGraphicsConfiguration().getBounds().height;
        if ((double)this.getHeight() > (double)screenHeight * 0.95) {
            this.setSize(this.getWidth(), (int)((double)screenHeight * 0.95));
        }
        if (x == -1 && y == -1) {
            this.setLocationRelativeTo(null);
        } else {
            if (x + this.getWidth() > screenWidth) {
                x = screenWidth - this.getWidth();
            }
            if (y + this.getHeight() > screenHeight) {
                y = screenHeight - this.getHeight();
            }
            this.setLocation(x, y);
        }
    }

    public PropertyEditor getEditor() {
        return this.m_Editor;
    }

    public static Frame getParentFrame(Container c) {
        Frame result = null;
        Container parent = c;
        while (parent != null) {
            if (parent instanceof Frame) {
                result = (Frame)parent;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }

    public static JInternalFrame getParentInternalFrame(Container c) {
        JInternalFrame result = null;
        Container parent = c;
        while (parent != null) {
            if (parent instanceof JInternalFrame) {
                result = (JInternalFrame)parent;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }

    public static Dialog getParentDialog(Container c) {
        Dialog result = null;
        Container parent = c;
        while (parent != null) {
            if (parent instanceof Dialog) {
                result = (Dialog)parent;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }
}

