/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.EventSetDescriptor;
import java.beans.beancontext.BeanContext;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.converters.ArffLoader;
import weka.core.converters.BatchConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.core.converters.IncrementalConverter;
import weka.gui.Logger;
import weka.gui.beans.AbstractDataSource;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSource;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.InstanceEvent;
import weka.gui.beans.InstanceListener;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Startable;
import weka.gui.beans.Visible;
import weka.gui.beans.WekaWrapper;

public class Loader
extends AbstractDataSource
implements Startable,
WekaWrapper,
EventConstraints,
BeanCommon,
EnvironmentHandler {
    private static final long serialVersionUID = 1993738191961163027L;
    private transient Instances m_dataSet;
    private transient Instances m_dataFormat;
    protected String m_globalInfo;
    private LoadThread m_ioThread;
    private static int IDLE = 0;
    private static int BATCH_LOADING = 1;
    private static int INCREMENTAL_LOADING = 2;
    private int m_state = IDLE;
    private weka.core.converters.Loader m_Loader = new ArffLoader();
    private InstanceEvent m_ie = new InstanceEvent(this);
    private int m_instanceEventTargets = 0;
    private int m_dataSetEventTargets = 0;
    private boolean m_dbSet = false;
    protected transient Logger m_log;
    protected transient Environment m_env;
    protected boolean m_stopped = false;

    public String globalInfo() {
        return this.m_globalInfo;
    }

    public Loader() {
        this.setLoader(this.m_Loader);
        this.appearanceFinal();
    }

    public void setDB(boolean flag) {
        this.m_dbSet = flag;
    }

    protected void appearanceFinal() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        JButton goButton = new JButton("Start...");
        this.add((Component)goButton, "Center");
        goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Loader.this.startLoading();
            }
        });
    }

    protected void appearanceDesign() {
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setBeanContext(BeanContext bc) {
        super.setBeanContext(bc);
        if (this.m_design) {
            this.appearanceDesign();
        } else {
            this.appearanceFinal();
        }
    }

    public void setLoader(weka.core.converters.Loader loader) {
        boolean loadImages = true;
        if (loader.getClass().getName().compareTo(this.m_Loader.getClass().getName()) == 0) {
            loadImages = false;
        }
        this.m_Loader = loader;
        String loaderName = loader.getClass().toString();
        loaderName = loaderName.substring(loaderName.lastIndexOf(46) + 1, loaderName.length());
        if (loadImages) {
            if (this.m_Loader instanceof Visible) {
                this.m_visual = ((Visible)((Object)this.m_Loader)).getVisual();
            } else if (!this.m_visual.loadIcons("weka/gui/beans/icons/" + loaderName + ".gif", "weka/gui/beans/icons/" + loaderName + "_animated.gif")) {
                this.useDefaultVisual();
            }
        }
        this.m_visual.setText(loaderName);
        this.m_globalInfo = KnowledgeFlowApp.getGlobalInfo(this.m_Loader);
    }

    protected void newFileSelected() {
        if (!(this.m_Loader instanceof DatabaseLoader)) {
            try {
                if (this.m_Loader instanceof EnvironmentHandler && this.m_env != null) {
                    ((EnvironmentHandler)((Object)this.m_Loader)).setEnvironment(this.m_env);
                }
                this.m_dataFormat = this.m_Loader.getStructure();
                System.out.println("[Loader] Notifying listeners of instance structure avail.");
                this.notifyStructureAvailable(this.m_dataFormat);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public weka.core.converters.Loader getLoader() {
        return this.m_Loader;
    }

    @Override
    public void setWrappedAlgorithm(Object algorithm) {
        if (!(algorithm instanceof weka.core.converters.Loader)) {
            throw new IllegalArgumentException(algorithm.getClass() + " : incorrect " + "type of algorithm (Loader)");
        }
        this.setLoader((weka.core.converters.Loader)algorithm);
    }

    @Override
    public Object getWrappedAlgorithm() {
        return this.getLoader();
    }

    protected void notifyStructureAvailable(Instances structure) {
        if (this.m_dataSetEventTargets > 0 && structure != null) {
            DataSetEvent dse = new DataSetEvent(this, structure);
            this.notifyDataSetLoaded(dse);
        } else if (this.m_instanceEventTargets > 0 && structure != null) {
            this.m_ie.setStructure(structure);
            this.notifyInstanceLoaded(this.m_ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataSetLoaded(DataSetEvent e) {
        Vector l;
        Loader loader = this;
        synchronized (loader) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(e);
                ++i;
            }
            this.m_dataSet = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyInstanceLoaded(InstanceEvent e) {
        Vector l;
        Loader loader = this;
        synchronized (loader) {
            l = (Vector)this.m_listeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                ((InstanceListener)l.elementAt(i)).acceptInstance(e);
                ++i;
            }
            this.m_dataSet = null;
        }
    }

    public void startLoading() {
        if (this.m_ioThread == null) {
            this.m_state = BATCH_LOADING;
            this.m_ioThread = new LoadThread(this);
            this.m_ioThread.setPriority(1);
            this.m_ioThread.start();
        } else {
            this.m_ioThread = null;
            this.m_state = IDLE;
        }
    }

    @Override
    public void start() throws Exception {
        this.startLoading();
        this.block(true);
    }

    @Override
    public String getStartMessage() {
        boolean ok = true;
        String entry = "Start loading";
        if (this.m_ioThread == null) {
            if (this.m_Loader instanceof FileSourcedConverter) {
                String temp = ((FileSourcedConverter)((Object)this.m_Loader)).retrieveFile().getPath();
                Environment env = this.m_env == null ? Environment.getSystemWide() : this.m_env;
                try {
                    temp = env.substitute(temp);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                File tempF = new File(temp);
                if (!tempF.isFile()) {
                    ok = false;
                }
            }
            if (!ok) {
                entry = "$" + entry;
            }
        }
        return entry;
    }

    private synchronized void block(boolean tf) {
        if (tf) {
            try {
                if (this.m_ioThread.isAlive() && this.m_state != IDLE) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
        } else {
            this.notifyAll();
        }
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (eventName.compareTo("instance") == 0) {
            if (!(this.m_Loader instanceof IncrementalConverter)) {
                return false;
            }
            if (this.m_dataSetEventTargets > 0) {
                return false;
            }
        }
        if (eventName.compareTo("dataSet") == 0) {
            if (!(this.m_Loader instanceof BatchConverter)) {
                return false;
            }
            if (this.m_instanceEventTargets > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized void addDataSourceListener(DataSourceListener dsl) {
        super.addDataSourceListener(dsl);
        ++this.m_dataSetEventTargets;
        try {
            if (this.m_Loader instanceof DatabaseLoader && this.m_dbSet && this.m_dataFormat == null || !(this.m_Loader instanceof DatabaseLoader) && this.m_dataFormat == null) {
                this.m_dataFormat = this.m_Loader.getStructure();
                this.m_dbSet = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyStructureAvailable(this.m_dataFormat);
    }

    @Override
    public synchronized void removeDataSourceListener(DataSourceListener dsl) {
        super.removeDataSourceListener(dsl);
        --this.m_dataSetEventTargets;
    }

    @Override
    public synchronized void addInstanceListener(InstanceListener dsl) {
        super.addInstanceListener(dsl);
        ++this.m_instanceEventTargets;
        try {
            if (this.m_Loader instanceof DatabaseLoader && this.m_dbSet && this.m_dataFormat == null || !(this.m_Loader instanceof DatabaseLoader) && this.m_dataFormat == null) {
                this.m_dataFormat = this.m_Loader.getStructure();
                this.m_dbSet = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.notifyStructureAvailable(this.m_dataFormat);
    }

    @Override
    public synchronized void removeInstanceListener(InstanceListener dsl) {
        super.removeInstanceListener(dsl);
        --this.m_instanceEventTargets;
    }

    public static void main(String[] args) {
        try {
            final JFrame jf = new JFrame();
            jf.getContentPane().setLayout(new BorderLayout());
            Loader tv = new Loader();
            jf.getContentPane().add((Component)tv, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.setSize(800, 600);
            jf.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.m_Loader != null) {
            try {
                this.m_Loader.reset();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void setLog(Logger logger) {
        this.m_log = logger;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return false;
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return false;
    }

    @Override
    public void connectionNotification(String eventName, Object source) {
    }

    @Override
    public void disconnectionNotification(String eventName, Object source) {
    }

    @Override
    public void stop() {
        this.m_stopped = true;
    }

    @Override
    public boolean isBusy() {
        return this.m_ioThread != null;
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|" + (this.m_Loader instanceof OptionHandler ? String.valueOf(Utils.joinOptions(((OptionHandler)((Object)this.m_Loader)).getOptions())) + "|" : "");
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    private class LoadThread
    extends Thread {
        private DataSource m_DP;

        public LoadThread(DataSource dp) {
            this.m_DP = dp;
        }

        @Override
        public void run() {
            block23: {
                try {
                    try {
                        Loader.this.m_visual.setAnimated();
                        boolean instanceGeneration = true;
                        if (Loader.this.m_dataSetEventTargets > 0) {
                            instanceGeneration = false;
                            Loader.this.m_state = BATCH_LOADING;
                        }
                        if (Loader.this.m_Loader instanceof EnvironmentHandler && Loader.this.m_env != null) {
                            ((EnvironmentHandler)((Object)Loader.this.m_Loader)).setEnvironment(Loader.this.m_env);
                        }
                        String msg = Loader.this.statusMessagePrefix();
                        msg = Loader.this.m_Loader instanceof FileSourcedConverter ? String.valueOf(msg) + "Loading " + ((FileSourcedConverter)((Object)Loader.this.m_Loader)).retrieveFile().getName() : String.valueOf(msg) + "Loading...";
                        if (Loader.this.m_log != null) {
                            Loader.this.m_log.statusMessage(msg);
                        }
                        if (instanceGeneration) {
                            Loader.this.m_state = INCREMENTAL_LOADING;
                            Instance nextInstance = null;
                            Instances structure = null;
                            try {
                                Loader.this.m_Loader.reset();
                                structure = Loader.this.m_Loader.getStructure();
                                Loader.this.notifyStructureAvailable(structure);
                            }
                            catch (IOException e) {
                                if (Loader.this.m_log != null) {
                                    Loader.this.m_log.statusMessage(String.valueOf(Loader.this.statusMessagePrefix()) + "ERROR (See log for details");
                                    Loader.this.m_log.logMessage("[Loader] " + Loader.this.statusMessagePrefix() + " " + e.getMessage());
                                }
                                e.printStackTrace();
                            }
                            try {
                                nextInstance = Loader.this.m_Loader.getNextInstance(structure);
                            }
                            catch (IOException e) {
                                if (Loader.this.m_log != null) {
                                    Loader.this.m_log.statusMessage(String.valueOf(Loader.this.statusMessagePrefix()) + "ERROR (See log for details");
                                    Loader.this.m_log.logMessage("[Loader] " + Loader.this.statusMessagePrefix() + " " + e.getMessage());
                                }
                                e.printStackTrace();
                            }
                            int z = 0;
                            while (nextInstance != null) {
                                if (Loader.this.m_stopped) break;
                                nextInstance.setDataset(structure);
                                Loader.this.m_ie.setStatus(1);
                                Loader.this.m_ie.setInstance(nextInstance);
                                nextInstance = Loader.this.m_Loader.getNextInstance(structure);
                                if (nextInstance == null) {
                                    Loader.this.m_ie.setStatus(2);
                                }
                                Loader.this.notifyInstanceLoaded(Loader.this.m_ie);
                                if (++z % 10000 != 0 || Loader.this.m_log == null) continue;
                                Loader.this.m_log.statusMessage(String.valueOf(Loader.this.statusMessagePrefix()) + "Loaded " + z + " instances");
                            }
                            Loader.this.m_visual.setStatic();
                            break block23;
                        }
                        Loader.this.m_Loader.reset();
                        Loader.this.m_dataSet = Loader.this.m_Loader.getDataSet();
                        Loader.this.m_visual.setStatic();
                        if (Loader.this.m_log != null) {
                            Loader.this.m_log.logMessage("[Loader] " + Loader.this.statusMessagePrefix() + " loaded " + Loader.this.m_dataSet.relationName());
                        }
                        Loader.this.notifyDataSetLoaded(new DataSetEvent(this.m_DP, Loader.this.m_dataSet));
                    }
                    catch (Exception ex) {
                        if (Loader.this.m_log != null) {
                            Loader.this.m_log.statusMessage(String.valueOf(Loader.this.statusMessagePrefix()) + "ERROR (See log for details");
                            Loader.this.m_log.logMessage("[Loader] " + Loader.this.statusMessagePrefix() + " " + ex.getMessage());
                        }
                        ex.printStackTrace();
                        if (Thread.currentThread().isInterrupted() && Loader.this.m_log != null) {
                            Loader.this.m_log.logMessage("[Loader] " + Loader.this.statusMessagePrefix() + " loading interrupted!");
                        }
                        Loader.this.m_ioThread = null;
                        Loader.this.m_visual.setStatic();
                        Loader.this.m_state = IDLE;
                        Loader.this.m_stopped = false;
                        if (Loader.this.m_log != null) {
                            Loader.this.m_log.statusMessage(String.valueOf(Loader.this.statusMessagePrefix()) + "Finished.");
                        }
                        Loader.this.block(false);
                    }
                }
                finally {
                    if (Thread.currentThread().isInterrupted() && Loader.this.m_log != null) {
                        Loader.this.m_log.logMessage("[Loader] " + Loader.this.statusMessagePrefix() + " loading interrupted!");
                    }
                    Loader.this.m_ioThread = null;
                    Loader.this.m_visual.setStatic();
                    Loader.this.m_state = IDLE;
                    Loader.this.m_stopped = false;
                    if (Loader.this.m_log != null) {
                        Loader.this.m_log.statusMessage(String.valueOf(Loader.this.statusMessagePrefix()) + "Finished.");
                    }
                    Loader.this.block(false);
                }
            }
        }
    }
}

