/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.converters.DatabaseConverter;
import weka.core.converters.DatabaseLoader;
import weka.core.converters.FileSourcedConverter;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.EnvironmentField;
import weka.gui.beans.Loader;

public class LoaderCustomizer
extends JPanel
implements Customizer,
CustomizerCloseRequester,
EnvironmentHandler {
    private static final long serialVersionUID = 6990446313118930298L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Loader m_dsLoader;
    private PropertySheetPanel m_LoaderEditor = new PropertySheetPanel();
    private JFileChooser m_fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
    private JFrame m_parentFrame;
    private JFrame m_fileChooserFrame;
    private EnvironmentField m_dbaseURLText;
    private EnvironmentField m_userNameText;
    private EnvironmentField m_queryText;
    private EnvironmentField m_keyText;
    private JPasswordField m_passwordText;
    private JCheckBox m_relativeFilePath;
    private EnvironmentField m_fileText;
    private Environment m_env = Environment.getSystemWide();

    static {
        GenericObjectEditor.registerEditors();
    }

    public LoaderCustomizer() {
        try {
            this.m_LoaderEditor.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    LoaderCustomizer.this.repaint();
                    if (LoaderCustomizer.this.m_dsLoader != null) {
                        System.err.println("Property change!!");
                        LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_dsLoader.getLoader());
                    }
                }
            });
            this.repaint();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setLayout(new BorderLayout());
        this.m_fileChooser.setDialogType(0);
        this.m_fileChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ApproveSelection")) {
                    try {
                        File selectedFile = LoaderCustomizer.this.m_fileChooser.getSelectedFile();
                        LoaderCustomizer.this.m_fileText.setText(selectedFile.toString());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                if (LoaderCustomizer.this.m_fileChooserFrame != null) {
                    LoaderCustomizer.this.m_fileChooserFrame.dispose();
                }
            }
        });
    }

    @Override
    public void setParentFrame(JFrame parent) {
        this.m_parentFrame = parent;
    }

    private void setUpOther() {
        this.removeAll();
        this.add((Component)this.m_LoaderEditor, "Center");
        this.validate();
        this.repaint();
    }

    private void setUpDatabase() {
        this.removeAll();
        JPanel db = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        db.setLayout(gbLayout);
        JLabel urlLab = new JLabel("Database URL", 4);
        urlLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(urlLab, gbConstraints);
        db.add(urlLab);
        this.m_dbaseURLText = new EnvironmentField();
        this.m_dbaseURLText.setEnvironment(this.m_env);
        this.m_dbaseURLText.setText(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUrl());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 5.0;
        gbLayout.setConstraints(this.m_dbaseURLText, gbConstraints);
        db.add(this.m_dbaseURLText);
        JLabel userLab = new JLabel("Username", 4);
        userLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(userLab, gbConstraints);
        db.add(userLab);
        this.m_userNameText = new EnvironmentField();
        this.m_userNameText.setEnvironment(this.m_env);
        this.m_userNameText.setText(((DatabaseConverter)((Object)this.m_dsLoader.getLoader())).getUser());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_userNameText, gbConstraints);
        db.add(this.m_userNameText);
        JLabel passwordLab = new JLabel("Password ", 4);
        passwordLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(passwordLab, gbConstraints);
        db.add(passwordLab);
        this.m_passwordText = new JPasswordField();
        JPanel passwordHolder = new JPanel();
        passwordHolder.setLayout(new BorderLayout());
        passwordHolder.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        passwordHolder.add((Component)this.m_passwordText, "Center");
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 2;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(passwordHolder, gbConstraints);
        db.add(passwordHolder);
        JLabel queryLab = new JLabel("Query", 4);
        queryLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(queryLab, gbConstraints);
        db.add(queryLab);
        this.m_queryText = new EnvironmentField();
        this.m_queryText.setEnvironment(this.m_env);
        this.m_queryText.setText(((DatabaseLoader)this.m_dsLoader.getLoader()).getQuery());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_queryText, gbConstraints);
        db.add(this.m_queryText);
        JLabel keyLab = new JLabel("Key columns", 4);
        keyLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(keyLab, gbConstraints);
        db.add(keyLab);
        this.m_keyText = new EnvironmentField();
        this.m_keyText.setEnvironment(this.m_env);
        this.m_keyText.setText(((DatabaseLoader)this.m_dsLoader.getLoader()).getKeys());
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_keyText, gbConstraints);
        db.add(this.m_keyText);
        JPanel buttonsP = new JPanel();
        buttonsP.setLayout(new FlowLayout());
        JButton ok = new JButton("OK");
        buttonsP.add(ok);
        JButton cancel = new JButton("Cancel");
        buttonsP.add(cancel);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).resetStructure();
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUrl(LoaderCustomizer.this.m_dbaseURLText.getText());
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUser(LoaderCustomizer.this.m_userNameText.getText());
                ((DatabaseConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setPassword(new String(LoaderCustomizer.this.m_passwordText.getPassword()));
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setQuery(LoaderCustomizer.this.m_queryText.getText());
                ((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).setKeys(LoaderCustomizer.this.m_keyText.getText());
                try {
                    LoaderCustomizer.this.m_dsLoader.notifyStructureAvailable(((DatabaseLoader)LoaderCustomizer.this.m_dsLoader.getLoader()).getStructure());
                    LoaderCustomizer.this.m_dsLoader.setDB(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LoaderCustomizer.this.m_parentFrame != null) {
                    LoaderCustomizer.this.m_parentFrame.dispose();
                }
            }
        });
        JPanel holderP = new JPanel();
        holderP.setLayout(new BorderLayout());
        holderP.add((Component)db, "North");
        holderP.add((Component)buttonsP, "South");
        JPanel about = this.m_LoaderEditor.getAboutPanel();
        if (about != null) {
            this.add((Component)about, "North");
        }
        this.add((Component)holderP, "South");
    }

    public void setUpFile() {
        File tmp2;
        this.removeAll();
        boolean currentFileIsDir = false;
        File tmp = ((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).retrieveFile();
        String tmpString = tmp.toString();
        if (Environment.containsEnvVariables(tmpString)) {
            try {
                tmpString = this.m_env.substitute(tmpString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((tmp2 = new File(new File(tmpString).getAbsolutePath())).isDirectory()) {
            this.m_fileChooser.setCurrentDirectory(tmp2);
            currentFileIsDir = true;
        } else {
            this.m_fileChooser.setSelectedFile(tmp2);
        }
        FileSourcedConverter loader = (FileSourcedConverter)((Object)this.m_dsLoader.getLoader());
        String[] ext = loader.getFileExtensions();
        ExtensionFileFilter firstFilter = null;
        int i = 0;
        while (i < ext.length) {
            ExtensionFileFilter ff = new ExtensionFileFilter(ext[i], String.valueOf(loader.getFileDescription()) + " (*" + ext[i] + ")");
            if (i == 0) {
                firstFilter = ff;
            }
            this.m_fileChooser.addChoosableFileFilter(ff);
            ++i;
        }
        if (firstFilter != null) {
            this.m_fileChooser.setFileFilter(firstFilter);
        }
        JPanel about = this.m_LoaderEditor.getAboutPanel();
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BorderLayout());
        if (about != null) {
            northPanel.add((Component)about, "North");
        }
        this.add((Component)northPanel, "North");
        final EnvironmentField ef = new EnvironmentField();
        JPanel efHolder = new JPanel();
        efHolder.setLayout(new BorderLayout());
        ef.setEnvironment(this.m_env);
        this.m_fileText = ef;
        if (!currentFileIsDir) {
            ef.setText(tmp.toString());
        }
        efHolder.add((Component)ef, "Center");
        JButton browseBut = new JButton("Browse...");
        browseBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JFrame jf = new JFrame("Choose file");
                    jf.getContentPane().setLayout(new BorderLayout());
                    jf.getContentPane().add((Component)LoaderCustomizer.this.m_fileChooser, "Center");
                    jf.pack();
                    jf.setVisible(true);
                    LoaderCustomizer.this.m_fileChooserFrame = jf;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel bP = new JPanel();
        bP.setLayout(new BorderLayout());
        bP.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        bP.add((Component)browseBut, "Center");
        efHolder.add((Component)bP, "East");
        JPanel alignedP = new JPanel();
        GridBagLayout gbLayout = new GridBagLayout();
        alignedP.setLayout(gbLayout);
        JLabel efLab = new JLabel("Filename", 4);
        efLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(efLab, gbConstraints);
        alignedP.add(efLab);
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 0;
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 5.0;
        gbLayout.setConstraints(efHolder, gbConstraints);
        alignedP.add(efHolder);
        northPanel.add((Component)alignedP, "South");
        this.m_relativeFilePath = new JCheckBox();
        this.m_relativeFilePath.setSelected(((FileSourcedConverter)((Object)this.m_dsLoader.getLoader())).getUseRelativePath());
        this.m_relativeFilePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FileSourcedConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setUseRelativePath(LoaderCustomizer.this.m_relativeFilePath.isSelected());
            }
        });
        JLabel relativeLab = new JLabel("Use relative file paths", 4);
        relativeLab.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 0;
        gbLayout.setConstraints(relativeLab, gbConstraints);
        alignedP.add(relativeLab);
        gbConstraints = new GridBagConstraints();
        gbConstraints.anchor = 13;
        gbConstraints.fill = 2;
        gbConstraints.gridy = 1;
        gbConstraints.gridx = 1;
        gbLayout.setConstraints(this.m_relativeFilePath, gbConstraints);
        alignedP.add(this.m_relativeFilePath);
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new FlowLayout());
        JButton OKBut = new JButton("OK");
        OKBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ((FileSourcedConverter)((Object)LoaderCustomizer.this.m_dsLoader.getLoader())).setFile(new File(ef.getText()));
                    LoaderCustomizer.this.m_dsLoader.setLoader(LoaderCustomizer.this.m_dsLoader.getLoader());
                    LoaderCustomizer.this.m_dsLoader.newFileSelected();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                LoaderCustomizer.this.m_parentFrame.dispose();
            }
        });
        JButton CancelBut = new JButton("Cancel");
        CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoaderCustomizer.this.m_parentFrame.dispose();
            }
        });
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        this.add((Component)butHolder, "South");
    }

    @Override
    public void setObject(Object object) {
        this.m_dsLoader = (Loader)object;
        this.m_LoaderEditor.setTarget(this.m_dsLoader.getLoader());
        if (this.m_dsLoader.getLoader() instanceof FileSourcedConverter) {
            this.setUpFile();
        } else if (this.m_dsLoader.getLoader() instanceof DatabaseConverter) {
            this.setUpDatabase();
        } else {
            this.setUpOther();
        }
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }
}

