/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.Utils;

public abstract class CachedKernel
extends Kernel {
    private static final long serialVersionUID = 702810182699015136L;
    protected int m_kernelEvals;
    protected int m_cacheHits;
    protected int m_cacheSize = 250007;
    protected double[] m_storage;
    protected long[] m_keys;
    protected double[][] m_kernelMatrix;
    protected int m_numInsts;
    protected int m_cacheSlots = 4;

    public CachedKernel() {
    }

    protected CachedKernel(Instances data, int cacheSize) throws Exception {
        this.setCacheSize(cacheSize);
        this.buildKernel(data);
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tThe size of the cache (a prime number), 0 for full cache and \n\t-1 to turn it off.\n\t(default: 250007)", "C", 1, "-C <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setCacheSize(Integer.parseInt(tmpStr));
        } else {
            this.setCacheSize(250007);
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-C");
        result.add("" + this.getCacheSize());
        return result.toArray(new String[result.size()]);
    }

    protected abstract double evaluate(int var1, int var2, Instance var3) throws Exception;

    @Override
    public double eval(int id1, int id2, Instance inst1) throws Exception {
        double result = 0.0;
        long key = -1L;
        int location = -1;
        if (id1 >= 0 && this.m_cacheSize != -1) {
            if (this.m_cacheSize == 0) {
                if (this.m_kernelMatrix == null) {
                    this.m_kernelMatrix = new double[this.m_data.numInstances()][];
                    int i = 0;
                    while (i < this.m_data.numInstances()) {
                        this.m_kernelMatrix[i] = new double[i + 1];
                        int j = 0;
                        while (j <= i) {
                            ++this.m_kernelEvals;
                            this.m_kernelMatrix[i][j] = this.evaluate(i, j, this.m_data.instance(i));
                            ++j;
                        }
                        ++i;
                    }
                }
                ++this.m_cacheHits;
                result = id1 > id2 ? this.m_kernelMatrix[id1][id2] : this.m_kernelMatrix[id2][id1];
                return result;
            }
            key = id1 > id2 ? (long)id1 + (long)id2 * (long)this.m_numInsts : (long)id2 + (long)id1 * (long)this.m_numInsts;
            int loc = location = (int)(key % (long)this.m_cacheSize) * this.m_cacheSlots;
            int i = 0;
            while (i < this.m_cacheSlots) {
                long thiskey = this.m_keys[loc];
                if (thiskey == 0L) break;
                if (thiskey == key + 1L) {
                    ++this.m_cacheHits;
                    if (i > 0) {
                        double tmps = this.m_storage[loc];
                        this.m_storage[loc] = this.m_storage[location];
                        this.m_keys[loc] = this.m_keys[location];
                        this.m_storage[location] = tmps;
                        this.m_keys[location] = thiskey;
                        return tmps;
                    }
                    return this.m_storage[loc];
                }
                ++loc;
                ++i;
            }
        }
        result = this.evaluate(id1, id2, inst1);
        ++this.m_kernelEvals;
        if (key != -1L && this.m_cacheSize != -1) {
            System.arraycopy(this.m_keys, location, this.m_keys, location + 1, this.m_cacheSlots - 1);
            System.arraycopy(this.m_storage, location, this.m_storage, location + 1, this.m_cacheSlots - 1);
            this.m_storage[location] = result;
            this.m_keys[location] = key + 1L;
        }
        return result;
    }

    @Override
    public int numEvals() {
        return this.m_kernelEvals;
    }

    @Override
    public int numCacheHits() {
        return this.m_cacheHits;
    }

    @Override
    public void clean() {
        this.m_storage = null;
        this.m_keys = null;
        this.m_kernelMatrix = null;
    }

    protected final double dotProd(Instance inst1, Instance inst2) throws Exception {
        double result = 0.0;
        int n1 = inst1.numValues();
        int n2 = inst2.numValues();
        int classIndex = this.m_data.classIndex();
        int p1 = 0;
        int p2 = 0;
        while (p1 < n1 && p2 < n2) {
            int ind2;
            int ind1 = inst1.index(p1);
            if (ind1 == (ind2 = inst2.index(p2))) {
                if (ind1 != classIndex) {
                    result += inst1.valueSparse(p1) * inst2.valueSparse(p2);
                }
                ++p1;
                ++p2;
                continue;
            }
            if (ind1 > ind2) {
                ++p2;
                continue;
            }
            ++p1;
        }
        return result;
    }

    public void setCacheSize(int value) {
        if (value >= -1) {
            this.m_cacheSize = value;
            this.clean();
        } else {
            System.out.println("Cache size cannot be smaller than -1 (provided: " + value + ")!");
        }
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public String cacheSizeTipText() {
        return "The size of the cache (a prime number), 0 for full cache and -1 to turn it off.";
    }

    @Override
    protected void initVars(Instances data) {
        super.initVars(data);
        this.m_kernelEvals = 0;
        this.m_cacheHits = 0;
        this.m_numInsts = this.m_data.numInstances();
        if (this.getCacheSize() > 0) {
            this.m_storage = new double[this.m_cacheSize * this.m_cacheSlots];
            this.m_keys = new long[this.m_cacheSize * this.m_cacheSlots];
        } else {
            this.m_storage = null;
            this.m_keys = null;
            this.m_kernelMatrix = null;
        }
    }

    @Override
    public void buildKernel(Instances data) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(data);
        }
        this.initVars(data);
    }
}

