/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;

public class ArffSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    static final long serialVersionUID = 2223634248900042228L;

    public ArffSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in arff (attribute relation file format) format. ";
    }

    @Override
    public String getFileDescription() {
        return "Arff data files";
    }

    @Override
    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(".arff");
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.enableAllAttributes();
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    @Override
    public void writeIncremental(Instance inst) throws IOException {
        int writeMode = this.getWriteMode();
        Instances structure = this.getInstances();
        PrintWriter outW = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            outW = new PrintWriter(this.getWriter());
        }
        if (writeMode == 1) {
            if (structure == null) {
                this.setWriteMode(2);
                if (inst != null) {
                    System.err.println("Structure(Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 2) {
            if (outW != null) {
                outW.close();
            }
            this.cancel();
        }
        if (writeMode == 3) {
            this.setWriteMode(0);
            Instances header = new Instances(structure, 0);
            if (this.retrieveFile() == null || outW == null) {
                System.out.println(header.toString());
            } else {
                outW.print(header.toString());
                outW.print("\n");
                outW.flush();
            }
            writeMode = this.getWriteMode();
        }
        if (writeMode == 0) {
            if (structure == null) {
                throw new IOException("No instances information available.");
            }
            if (inst != null) {
                if (this.retrieveFile() == null || outW == null) {
                    System.out.println(inst);
                } else {
                    outW.println(inst);
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        outW.flush();
                    }
                }
            } else {
                if (outW != null) {
                    outW.flush();
                    outW.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                outW = null;
                this.resetWriter();
            }
        }
    }

    @Override
    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            System.out.println(this.getInstances().toString());
            this.setWriteMode(1);
            return;
        }
        PrintWriter outW = new PrintWriter(this.getWriter());
        Instances data = this.getInstances();
        Instances header = new Instances(data, 0);
        outW.print(header.toString());
        int i = 0;
        while (i < data.numInstances()) {
            if (i % 1000 == 0) {
                outW.flush();
            }
            outW.println(data.instance(i));
            ++i;
        }
        outW.flush();
        outW.close();
        this.setWriteMode(1);
        outW = null;
        this.resetWriter();
        this.setWriteMode(2);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7118 $");
    }

    public static void main(String[] args) {
        ArffSaver.runFileSaver(new ArffSaver(), args);
    }
}

