/*
 * Decompiled with CFR 0.152.
 */
package weka.core.json;

import java.util.ArrayList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.core.json.JSONNode;

public class JSONInstances {
    public static final String HEADER = "header";
    public static final String DATA = "data";
    public static final String RELATION = "relation";
    public static final String ATTRIBUTES = "attributes";
    public static final String NAME = "name";
    public static final String TYPE = "type";
    public static final String CLASS = "class";
    public static final String LABELS = "labels";
    public static final String WEIGHT = "weight";
    public static final String DATEFORMAT = "dateformat";
    public static final String SPARSE = "sparse";
    public static final String VALUES = "values";
    public static final String SPARSE_SEPARATOR = ":";

    protected static Attribute toAttribute(JSONNode att, boolean[] classAtt) {
        Attribute result;
        String name = (String)att.getChild(NAME).getValue("noname");
        String type = (String)att.getChild(TYPE).getValue("");
        double weight = (Double)att.getChild(WEIGHT).getValue(new Double(1.0));
        if (type.equals(Attribute.typeToString(0))) {
            result = new Attribute(name);
        } else if (type.equals(Attribute.typeToString(1))) {
            JSONNode labels = att.getChild(LABELS);
            ArrayList<String> values = new ArrayList<String>();
            int i = 0;
            while (i < labels.getChildCount()) {
                values.add((String)((JSONNode)labels.getChildAt(i)).getValue());
                ++i;
            }
            result = new Attribute(name, values);
        } else if (type.equals(Attribute.typeToString(3))) {
            String dateformat = (String)att.getChild(TYPE).getValue("yyyy-MM-dd'T'HH:mm:ss");
            result = new Attribute(name, dateformat);
        } else if (type.equals(Attribute.typeToString(2))) {
            result = new Attribute(name, null);
        } else {
            System.err.println("Unhandled attribute type '" + type + "'!");
            return null;
        }
        result.setWeight(weight);
        return result;
    }

    protected static Instance toInstance(JSONNode inst, Instances data) {
        boolean sparse = (Boolean)inst.getChild(SPARSE).getValue(new Boolean(false));
        double weight = (Double)inst.getChild(WEIGHT).getValue(new Double(1.0));
        JSONNode values = inst.getChild(VALUES);
        double[] vals = new double[data.numAttributes()];
        int i = 0;
        while (i < values.getChildCount()) {
            block11: {
                int index;
                String value;
                block12: {
                    if (sparse) {
                        value = "" + ((JSONNode)values.getChildAt(i)).getValue();
                        int pos = value.indexOf(SPARSE_SEPARATOR);
                        index = Integer.parseInt(value.substring(0, pos));
                        value = value.substring(pos + 1);
                    } else {
                        index = i;
                        value = "" + ((JSONNode)values.getChildAt(i)).getValue();
                    }
                    try {
                        if (data.attribute(index).isNumeric()) {
                            vals[index] = Double.parseDouble(value);
                            break block11;
                        }
                        if (!data.attribute(index).isNominal()) break block12;
                        vals[index] = data.attribute(index).indexOfValue(value);
                        if (vals[index] == -1.0 && value.startsWith("'") && value.endsWith("'")) {
                            vals[index] = data.attribute(index).indexOfValue(Utils.unquote(value));
                        }
                        if (vals[index] == -1.0) {
                            System.err.println("Unknown label '" + value + "' for attribute #" + (index + 1) + "!");
                            return null;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("Error parsing value #" + (index + 1) + ": " + e.toString());
                        return null;
                    }
                }
                if (data.attribute(index).isDate()) {
                    vals[index] = data.attribute(index).parseDate(value);
                    break block11;
                }
                if (data.attribute(index).isString()) {
                    vals[index] = data.attribute(index).addStringValue(value);
                    break block11;
                }
                System.err.println("Unhandled attribute type '" + Attribute.typeToString(data.attribute(index).type()) + "'!");
                return null;
            }
            ++i;
        }
        DenseInstance result = new DenseInstance(weight, vals);
        result.setDataset(data);
        return result;
    }

    protected static Instances toInstances(JSONNode json, boolean onlyHeader) {
        JSONNode header = json.getChild(HEADER);
        if (header == null) {
            System.err.println("No 'header' section!");
            return null;
        }
        JSONNode data = json.getChild(DATA);
        if (data == null) {
            System.err.println("No 'data' section!");
            return null;
        }
        JSONNode attributes = header.getChild(ATTRIBUTES);
        if (attributes == null) {
            System.err.println("No 'attributes' array!");
            return null;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        boolean[] classAtt = new boolean[1];
        int classIndex = -1;
        int i = 0;
        while (i < attributes.getChildCount()) {
            Attribute att = JSONInstances.toAttribute((JSONNode)attributes.getChildAt(i), classAtt);
            if (att == null) {
                System.err.println("Could not convert attribute #" + (i + 1) + "!");
                return null;
            }
            if (classAtt[0]) {
                classIndex = i;
            }
            atts.add(att);
            ++i;
        }
        Instances result = new Instances(header.getChild(RELATION).getValue("unknown").toString(), atts, onlyHeader ? 0 : data.getChildCount());
        result.setClassIndex(classIndex);
        if (!onlyHeader) {
            i = 0;
            while (i < data.getChildCount()) {
                Instance inst = JSONInstances.toInstance((JSONNode)data.getChildAt(i), result);
                if (inst == null) {
                    System.err.println("Could not convert instance #" + (i + 1) + "!");
                    return null;
                }
                result.add(inst);
                ++i;
            }
        }
        return result;
    }

    public static Instances toInstances(JSONNode json) {
        return JSONInstances.toInstances(json, false);
    }

    public static Instances toHeader(JSONNode json) {
        return JSONInstances.toInstances(json, true);
    }

    protected static JSONNode toJSON(Instances inst, Attribute att) {
        JSONNode result = new JSONNode();
        result.addPrimitive(NAME, att.name());
        result.addPrimitive(TYPE, Attribute.typeToString(att));
        result.addPrimitive(CLASS, att.index() == inst.classIndex());
        result.addPrimitive(WEIGHT, att.weight());
        if (att.isNominal()) {
            JSONNode labels = result.addArray(LABELS);
            int i = 0;
            while (i < att.numValues()) {
                labels.addArrayElement(att.value(i));
                ++i;
            }
        }
        if (att.isDate()) {
            result.addPrimitive(DATEFORMAT, att.getDateFormat());
        }
        return result;
    }

    protected static JSONNode toJSON(Instance inst) {
        JSONNode result = new JSONNode();
        boolean sparse = inst instanceof SparseInstance;
        result.addPrimitive(SPARSE, sparse);
        result.addPrimitive(WEIGHT, inst.weight());
        JSONNode values = result.addArray(VALUES);
        if (sparse) {
            int i = 0;
            while (i < inst.numValues()) {
                values.addArrayElement(String.valueOf(inst.index(i)) + SPARSE_SEPARATOR + inst.toString(inst.index(i)));
                ++i;
            }
        } else {
            int i = 0;
            while (i < inst.numAttributes()) {
                values.addArrayElement(inst.toString(i));
                ++i;
            }
        }
        return result;
    }

    public static JSONNode toJSON(Instances inst) {
        JSONNode result = new JSONNode();
        JSONNode header = result.addObject(HEADER);
        header.addPrimitive(RELATION, inst.relationName());
        JSONNode atts = header.addArray(ATTRIBUTES);
        int i = 0;
        while (i < inst.numAttributes()) {
            atts.add(JSONInstances.toJSON(inst, inst.attribute(i)));
            ++i;
        }
        JSONNode data = result.addArray(DATA);
        i = 0;
        while (i < inst.numInstances()) {
            data.add(JSONInstances.toJSON(inst.instance(i)));
            ++i;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("No dataset supplied!");
            System.exit(1);
        }
        Instances data = ConverterUtils.DataSource.read(args[0]);
        JSONNode json = JSONInstances.toJSON(data);
        StringBuffer buffer = new StringBuffer();
        json.toString(buffer);
        System.out.println(buffer.toString());
        Instances inst = JSONInstances.toInstances(json);
        System.out.println(inst);
    }
}

