/*
 * Decompiled with CFR 0.152.
 */
package weka.core.pmml;

import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.pmml.Expression;
import weka.core.pmml.FieldMetaInfo;
import weka.core.pmml.TransformationDictionary;

public class DerivedFieldMetaInfo
extends FieldMetaInfo
implements Serializable {
    protected String m_displayName = null;
    protected ArrayList<FieldMetaInfo.Value> m_values = new ArrayList();
    protected Expression m_expression;

    public DerivedFieldMetaInfo(Element derivedField, ArrayList<Attribute> fieldDefs, TransformationDictionary transDict) throws Exception {
        super(derivedField);
        NodeList valL;
        String displayName = derivedField.getAttribute("displayName");
        if (displayName != null && displayName.length() > 0) {
            this.m_displayName = displayName;
        }
        if ((valL = derivedField.getElementsByTagName("Value")).getLength() > 0) {
            int i = 0;
            while (i < valL.getLength()) {
                Node valueN = valL.item(i);
                if (valueN.getNodeType() == 1) {
                    FieldMetaInfo.Value v = new FieldMetaInfo.Value((Element)valueN);
                    this.m_values.add(v);
                }
                ++i;
            }
        }
        this.m_expression = Expression.getExpression(derivedField, this.m_optype, fieldDefs, transDict);
    }

    public void setFieldDefs(ArrayList<Attribute> fieldDefs) throws Exception {
        this.m_expression.setFieldDefs(fieldDefs);
    }

    public void setFieldDefs(Instances fields) throws Exception {
        ArrayList<Attribute> tempDefs = new ArrayList<Attribute>();
        int i = 0;
        while (i < fields.numAttributes()) {
            tempDefs.add(fields.attribute(i));
            ++i;
        }
        this.setFieldDefs(tempDefs);
    }

    @Override
    public Attribute getFieldAsAttribute() {
        return this.m_expression.getOutputDef().copy(this.m_fieldName);
    }

    public double getDerivedValue(double[] incoming) throws Exception {
        return this.m_expression.getResult(incoming);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getFieldAsAttribute() + "\nexpression:\n");
        buff.append(this.m_expression + "\n");
        return buff.toString();
    }
}

