/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators.classifiers.classification;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.datagenerators.ClassificationGenerator;

public class Agrawal
extends ClassificationGenerator
implements TechnicalInformationHandler {
    static final long serialVersionUID = 2254651939636143025L;
    protected static ClassFunction[] builtInFunctions = new ClassFunction[]{new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40 || 60 <= age) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                if (50000.0 <= salary && salary <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (age < 60) {
                if (75000.0 <= salary && salary <= 125000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= salary && salary <= 75000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                if (elevel == 0 || elevel == 1) {
                    return 0L;
                }
                return 1L;
            }
            if (age < 60) {
                if (elevel == 1 || elevel == 2 || elevel == 3) {
                    return 0L;
                }
                return 1L;
            }
            if (elevel == 2 || elevel == 3 || elevel == 4) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                if (elevel == 0 || elevel == 1) {
                    if (25000.0 <= salary && salary <= 75000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (50000.0 <= salary && salary <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (age < 60) {
                if (elevel == 1 || elevel == 2 || elevel == 3) {
                    if (50000.0 <= salary && salary <= 100000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (75000.0 <= salary && salary <= 125000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (elevel == 2 || elevel == 3 || elevel == 4) {
                if (50000.0 <= salary && salary <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= salary && salary <= 75000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            if (age < 40) {
                if (50000.0 <= salary && salary <= 100000.0) {
                    if (100000.0 <= loan && loan <= 300000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (200000.0 <= loan && loan <= 400000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (age < 60) {
                if (75000.0 <= salary && salary <= 125000.0) {
                    if (200000.0 <= loan && loan <= 400000.0) {
                        return 0L;
                    }
                    return 1L;
                }
                if (300000.0 <= loan && loan <= 500000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= salary && salary <= 75000.0) {
                if (300000.0 <= loan && loan <= 500000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (100000.0 <= loan && loan <= 300000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double totalSalary = salary + commission;
            if (age < 40) {
                if (50000.0 <= totalSalary && totalSalary <= 100000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (age < 60) {
                if (75000.0 <= totalSalary && totalSalary <= 125000.0) {
                    return 0L;
                }
                return 1L;
            }
            if (25000.0 <= totalSalary && totalSalary <= 75000.0) {
                return 0L;
            }
            return 1L;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable = 2.0 * (salary + commission) / 3.0 - loan / 5.0 - 20000.0;
            return disposable > 0.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable = 2.0 * (salary + commission) / 3.0 - 5000.0 * (double)elevel - 20000.0;
            return disposable > 0.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable = 2.0 * (salary + commission) / 3.0 - 5000.0 * (double)elevel - loan / 5.0 - 10000.0;
            return disposable > 0.0 ? 0 : 1;
        }
    }, new ClassFunction(){

        @Override
        public long determineClass(double salary, double commission, int age, int elevel, int car, int zipcode, double hvalue, int hyears, double loan) {
            double disposable;
            double equity = 0.0;
            if (hyears >= 20) {
                equity = hvalue * ((double)hyears - 20.0) / 10.0;
            }
            return (disposable = 2.0 * (salary + commission) / 3.0 - 5000.0 * (double)elevel + equity / 5.0 - 10000.0) > 0.0 ? 0 : 1;
        }
    }};
    public static final int FUNCTION_1 = 1;
    public static final int FUNCTION_2 = 2;
    public static final int FUNCTION_3 = 3;
    public static final int FUNCTION_4 = 4;
    public static final int FUNCTION_5 = 5;
    public static final int FUNCTION_6 = 6;
    public static final int FUNCTION_7 = 7;
    public static final int FUNCTION_8 = 8;
    public static final int FUNCTION_9 = 9;
    public static final int FUNCTION_10 = 10;
    public static final Tag[] FUNCTION_TAGS = new Tag[]{new Tag(1, "Function 1"), new Tag(2, "Function 2"), new Tag(3, "Function 3"), new Tag(4, "Function 4"), new Tag(5, "Function 5"), new Tag(6, "Function 6"), new Tag(7, "Function 7"), new Tag(8, "Function 8"), new Tag(9, "Function 9"), new Tag(10, "Function 10")};
    protected int m_Function;
    protected boolean m_BalanceClass;
    protected double m_PerturbationFraction;
    protected boolean m_nextClassShouldBeZero;
    protected double m_lastLabel;

    public Agrawal() {
        this.setFunction(this.defaultFunction());
        this.setBalanceClass(this.defaultBalanceClass());
        this.setPerturbationFraction(this.defaultPerturbationFraction());
    }

    public String globalInfo() {
        return "Generates a people database and is based on the paper by Agrawal et al.:\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "R. Agrawal and T. Imielinski and A. Swami");
        result.setValue(TechnicalInformation.Field.YEAR, "1993");
        result.setValue(TechnicalInformation.Field.TITLE, "Database Mining: A Performance Perspective");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        result.setValue(TechnicalInformation.Field.VOLUME, "5");
        result.setValue(TechnicalInformation.Field.NUMBER, "6");
        result.setValue(TechnicalInformation.Field.PAGES, "914-925");
        result.setValue(TechnicalInformation.Field.NOTE, "Special issue on Learning and Discovery in Knowledge-Based Databases");
        result.setValue(TechnicalInformation.Field.URL, "http://www.almaden.ibm.com/software/quest/Publications/ByDate.html");
        result.setValue(TechnicalInformation.Field.PDF, "http://www.almaden.ibm.com/software/quest/Publications/papers/tkde93.pdf");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = this.enumToVector(super.listOptions());
        result.add(new Option("\tThe function to use for generating the data. (default " + this.defaultFunction().getSelectedTag().getID() + ")", "F", 1, "-F <num>"));
        result.add(new Option("\tWhether to balance the class.", "B", 0, "-B"));
        result.add(new Option("\tThe perturbation factor. (default " + this.defaultPerturbationFraction() + ")", "P", 1, "-P <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('F', options);
        if (tmpStr.length() != 0) {
            this.setFunction(new SelectedTag(Integer.parseInt(tmpStr), FUNCTION_TAGS));
        } else {
            this.setFunction(this.defaultFunction());
        }
        this.setBalanceClass(Utils.getFlag('B', options));
        tmpStr = Utils.getOption('P', options);
        if (tmpStr.length() != 0) {
            this.setPerturbationFraction(Double.parseDouble(tmpStr));
        } else {
            this.setPerturbationFraction(this.defaultPerturbationFraction());
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-F");
        result.add("" + this.m_Function);
        if (this.getBalanceClass()) {
            result.add("-B");
        }
        result.add("-P");
        result.add("" + this.getPerturbationFraction());
        return result.toArray(new String[result.size()]);
    }

    protected SelectedTag defaultFunction() {
        return new SelectedTag(1, FUNCTION_TAGS);
    }

    public SelectedTag getFunction() {
        return new SelectedTag(this.m_Function, FUNCTION_TAGS);
    }

    public void setFunction(SelectedTag value) {
        if (value.getTags() == FUNCTION_TAGS) {
            this.m_Function = value.getSelectedTag().getID();
        }
    }

    public String functionTipText() {
        return "The function to use for generating the data.";
    }

    protected boolean defaultBalanceClass() {
        return false;
    }

    public boolean getBalanceClass() {
        return this.m_BalanceClass;
    }

    public void setBalanceClass(boolean value) {
        this.m_BalanceClass = value;
    }

    public String balanceClassTipText() {
        return "Whether to balance the class.";
    }

    protected double defaultPerturbationFraction() {
        return 0.05;
    }

    public double getPerturbationFraction() {
        return this.m_PerturbationFraction;
    }

    public void setPerturbationFraction(double value) {
        if (!(value >= 0.0) || !(value <= 1.0)) {
            throw new IllegalArgumentException("Perturbation fraction must be in [0,1] (provided: " + value + ")!");
        }
        this.m_PerturbationFraction = value;
    }

    public String perturbationFractionTipText() {
        return "The perturbation fraction: 0 <= fraction <= 1.";
    }

    @Override
    public boolean getSingleModeFlag() throws Exception {
        return true;
    }

    @Override
    public Instances defineDataFormat() throws Exception {
        this.m_Random = new Random(this.getSeed());
        this.m_nextClassShouldBeZero = true;
        this.m_lastLabel = Double.NaN;
        this.setNumExamplesAct(this.getNumExamples());
        FastVector<Attribute> atts = new FastVector<Attribute>();
        atts.addElement(new Attribute("salary"));
        atts.addElement(new Attribute("commission"));
        FastVector<String> attValues = new FastVector<String>();
        atts.addElement(new Attribute("age"));
        attValues = new FastVector();
        int i = 0;
        while (i < 5) {
            attValues.addElement("" + i);
            ++i;
        }
        atts.addElement(new Attribute("elevel", attValues));
        attValues = new FastVector();
        i = 1;
        while (i <= 20) {
            attValues.addElement("" + i);
            ++i;
        }
        atts.addElement(new Attribute("car", attValues));
        attValues = new FastVector();
        i = 0;
        while (i < 9) {
            attValues.addElement("" + i);
            ++i;
        }
        atts.addElement(new Attribute("zipcode", attValues));
        atts.addElement(new Attribute("hvalue"));
        atts.addElement(new Attribute("hyears"));
        atts.addElement(new Attribute("loan"));
        attValues = new FastVector();
        i = 0;
        while (i < 2) {
            attValues.addElement("" + i);
            ++i;
        }
        atts.addElement(new Attribute("group", attValues));
        this.m_DatasetFormat = new Instances(this.getRelationNameToUse(), atts, 0);
        return this.m_DatasetFormat;
    }

    protected double perturbValue(double val, double min, double max) {
        return this.perturbValue(val, max - min, min, max);
    }

    protected double perturbValue(double val, double range, double min, double max) {
        if ((val += range * (2.0 * (this.getRandom().nextDouble() - 0.5)) * this.getPerturbationFraction()) < min) {
            val = min;
        } else if (val > max) {
            val = max;
        }
        return val;
    }

    @Override
    public Instance generateExample() throws Exception {
        DenseInstance result = null;
        Random random = this.getRandom();
        if (this.m_DatasetFormat == null) {
            throw new Exception("Dataset format not defined.");
        }
        double salary = 0.0;
        double commission = 0.0;
        double hvalue = 0.0;
        double loan = 0.0;
        int age = 0;
        int elevel = 0;
        int car = 0;
        int zipcode = 0;
        int hyears = 0;
        boolean desiredClassFound = false;
        ClassFunction classFunction = builtInFunctions[this.m_Function - 1];
        while (!desiredClassFound) {
            salary = 20000.0 + 130000.0 * random.nextDouble();
            commission = salary >= 75000.0 ? 0.0 : 10000.0 + 65000.0 * random.nextDouble();
            age = 20 + random.nextInt(61);
            elevel = random.nextInt(5);
            car = 1 + random.nextInt(20);
            zipcode = random.nextInt(9);
            hvalue = (9.0 - (double)zipcode) * 100000.0 * (0.5 + random.nextDouble());
            hyears = 1 + random.nextInt(30);
            loan = random.nextDouble() * 500000.0;
            this.m_lastLabel = classFunction.determineClass(salary, commission, age, elevel, car, zipcode, hvalue, hyears, loan);
            if (!this.getBalanceClass()) {
                desiredClassFound = true;
                continue;
            }
            if ((!this.m_nextClassShouldBeZero || this.m_lastLabel != 0.0) && (this.m_nextClassShouldBeZero || this.m_lastLabel != 1.0)) continue;
            desiredClassFound = true;
            boolean bl = this.m_nextClassShouldBeZero = !this.m_nextClassShouldBeZero;
        }
        if (this.getPerturbationFraction() > 0.0) {
            salary = this.perturbValue(salary, 20000.0, 150000.0);
            if (commission > 0.0) {
                commission = this.perturbValue(commission, 10000.0, 75000.0);
            }
            age = (int)Math.round(this.perturbValue(age, 20.0, 80.0));
            hvalue = this.perturbValue(hvalue, (9.0 - (double)zipcode) * 100000.0, 0.0, 135000.0);
            hyears = (int)Math.round(this.perturbValue(hyears, 1.0, 30.0));
            loan = this.perturbValue(loan, 0.0, 500000.0);
        }
        double[] atts = new double[this.m_DatasetFormat.numAttributes()];
        atts[0] = salary;
        atts[1] = commission;
        atts[2] = age;
        atts[3] = elevel;
        atts[4] = car - 1;
        atts[5] = zipcode;
        atts[6] = hvalue;
        atts[7] = hyears;
        atts[8] = loan;
        atts[9] = this.m_lastLabel;
        result = new DenseInstance(1.0, atts);
        result.setDataset(this.m_DatasetFormat);
        return result;
    }

    @Override
    public Instances generateExamples() throws Exception {
        Instances result = new Instances(this.m_DatasetFormat, 0);
        this.m_Random = new Random(this.getSeed());
        int i = 0;
        while (i < this.getNumExamplesAct()) {
            result.add(this.generateExample());
            ++i;
        }
        return result;
    }

    @Override
    public String generateStart() {
        return "";
    }

    @Override
    public String generateFinished() throws Exception {
        return "";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5987 $");
    }

    public static void main(String[] args) {
        Agrawal.runDataGenerator(new Agrawal(), args);
    }

    protected static interface ClassFunction {
        public long determineClass(double var1, double var3, int var5, int var6, int var7, int var8, double var9, int var11, double var12);
    }
}

