/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.gui.CustomPanelSupplier;
import weka.gui.PropertyDialog;

public class PropertyPanel
extends JPanel {
    static final long serialVersionUID = 5370025273466728904L;
    private PropertyEditor m_Editor;
    private PropertyDialog m_PD;
    private boolean m_HasCustomPanel = false;
    private JPanel m_CustomPanel;

    public PropertyPanel(PropertyEditor pe) {
        this(pe, false);
    }

    public PropertyPanel(PropertyEditor pe, boolean ignoreCustomPanel) {
        this.m_Editor = pe;
        if (!ignoreCustomPanel && this.m_Editor instanceof CustomPanelSupplier) {
            this.setLayout(new BorderLayout());
            this.m_CustomPanel = ((CustomPanelSupplier)((Object)this.m_Editor)).getCustomPanel();
            this.add((Component)this.m_CustomPanel, "Center");
            this.m_HasCustomPanel = true;
        } else {
            this.createDefaultPanel();
        }
    }

    protected void createDefaultPanel() {
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setToolTipText("Left-click to edit properties for this object, right-click/Alt+Shift+left-click for menu");
        this.setOpaque(true);
        final PropertyPanel comp = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 1) {
                    if (evt.getButton() == 1 && !evt.isAltDown() && !evt.isShiftDown()) {
                        PropertyPanel.this.showPropertyDialog();
                    } else if (evt.getButton() == 3 || evt.getButton() == 1 && evt.isAltDown() && evt.isShiftDown()) {
                        JMenuItem item;
                        JPopupMenu menu = new JPopupMenu();
                        if (PropertyPanel.this.m_Editor.getValue() != null) {
                            item = new JMenuItem("Show properties...");
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    PropertyPanel.this.showPropertyDialog();
                                }
                            });
                            menu.add(item);
                            item = new JMenuItem("Copy configuration to clipboard");
                            item.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    String str = PropertyPanel.this.m_Editor.getValue().getClass().getName();
                                    if (PropertyPanel.this.m_Editor.getValue() instanceof OptionHandler) {
                                        str = String.valueOf(str) + " " + Utils.joinOptions(((OptionHandler)PropertyPanel.this.m_Editor.getValue()).getOptions());
                                    }
                                    StringSelection selection = new StringSelection(str.trim());
                                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                                    clipboard.setContents(selection, selection);
                                }
                            });
                            menu.add(item);
                        }
                        item = new JMenuItem("Enter configuration...");
                        item.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String str = JOptionPane.showInputDialog(comp, (Object)"Configuration (<classname> [<options>])");
                                if (str != null) {
                                    try {
                                        String[] options = Utils.splitOptions(str);
                                        String classname = options[0];
                                        options[0] = "";
                                        PropertyPanel.this.m_Editor.setValue(Utils.forName(Object.class, classname, options));
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                        JOptionPane.showMessageDialog(comp, "Error parsing commandline:\n" + ex, "Error...", 0);
                                    }
                                }
                            }
                        });
                        menu.add(item);
                        menu.show(comp, evt.getX(), evt.getY());
                    }
                }
            }
        });
        Dimension newPref = this.getPreferredSize();
        newPref.height = this.getFontMetrics(this.getFont()).getHeight() * 5 / 4;
        newPref.width = newPref.height * 5;
        this.setPreferredSize(newPref);
        this.m_Editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PropertyPanel.this.repaint();
            }
        });
    }

    public void showPropertyDialog() {
        if (this.m_Editor.getValue() != null) {
            if (this.m_PD == null) {
                int x = this.getLocationOnScreen().x;
                int y = this.getLocationOnScreen().y;
                this.m_PD = PropertyDialog.getParentDialog(this) != null ? new PropertyDialog(PropertyDialog.getParentDialog(this), this.m_Editor, x, y) : new PropertyDialog(PropertyDialog.getParentFrame(this), this.m_Editor, x, y);
                this.m_PD.setVisible(true);
            } else {
                this.m_PD.setVisible(true);
            }
            this.m_Editor.setValue(this.m_Editor.getValue());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.m_PD != null) {
            this.m_PD.dispose();
            this.m_PD = null;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_HasCustomPanel) {
            this.m_CustomPanel.setEnabled(enabled);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.m_HasCustomPanel) {
            Insets i = this.getInsets();
            Rectangle box = new Rectangle(i.left, i.top, this.getSize().width - i.left - i.right - 1, this.getSize().height - i.top - i.bottom - 1);
            g.clearRect(i.left, i.top, this.getSize().width - i.right - i.left, this.getSize().height - i.bottom - i.top);
            this.m_Editor.paintValue(g, box);
        }
    }
}

