/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.SwapValues;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.DataFormatListener;
import weka.gui.beans.DataSetEvent;
import weka.gui.beans.DataSourceListener;
import weka.gui.beans.EventConstraints;
import weka.gui.beans.Visible;

public class ClassValuePicker
extends JPanel
implements Visible,
DataSourceListener,
BeanCommon,
EventConstraints,
Serializable {
    private static final long serialVersionUID = -1196143276710882989L;
    private int m_classValueIndex = 0;
    private Instances m_connectedFormat;
    private Object m_dataProvider;
    private Vector m_dataListeners = new Vector();
    private Vector m_dataFormatListeners = new Vector();
    protected transient Logger m_logger = null;
    protected BeanVisual m_visual = new BeanVisual("ClassValuePicker", "weka/gui/beans/icons/ClassValuePicker.gif", "weka/gui/beans/icons/ClassValuePicker_animated.gif");

    public String globalInfo() {
        return "Designate which class value is to be considered the \"positive\" class value (useful for ROC style curves).";
    }

    public ClassValuePicker() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    public Instances getConnectedFormat() {
        if (this.m_connectedFormat == null) {
            System.err.println("Is null!!!!!!");
        }
        return this.m_connectedFormat;
    }

    public void setClassValueIndex(int index) {
        this.m_classValueIndex = index;
        if (this.m_connectedFormat != null) {
            this.notifyDataFormatListeners();
        }
    }

    public int getClassValueIndex() {
        return this.m_classValueIndex;
    }

    @Override
    public void acceptDataSet(DataSetEvent e) {
        if (e.isStructureOnly() && (this.m_connectedFormat == null || !this.m_connectedFormat.equalHeaders(e.getDataSet()))) {
            this.m_connectedFormat = new Instances(e.getDataSet(), 0);
            this.notifyDataFormatListeners();
        }
        Instances dataSet = e.getDataSet();
        Instances newDataSet = this.assignClassValue(dataSet);
        e = new DataSetEvent(this, newDataSet);
        this.notifyDataListeners(e);
    }

    private Instances assignClassValue(Instances dataSet) {
        block8: {
            if (dataSet.classIndex() < 0) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " No class attribute defined in data set.");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: No class attribute defined in data set.");
                }
                return dataSet;
            }
            if (dataSet.classAttribute().isNumeric()) {
                if (this.m_logger != null) {
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Class attribute must be nominal (ClassValuePicker)");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "WARNING: Class attribute must be nominal.");
                }
                return dataSet;
            }
            if (this.m_logger != null) {
                this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "remove");
            }
            if (this.m_classValueIndex != 0) {
                try {
                    SwapValues sv = new SwapValues();
                    sv.setAttributeIndex("" + (dataSet.classIndex() + 1));
                    sv.setFirstValueIndex("first");
                    sv.setSecondValueIndex("" + (this.m_classValueIndex + 1));
                    sv.setInputFormat(dataSet);
                    Instances newDataSet = Filter.useFilter(dataSet, sv);
                    newDataSet.setRelationName(dataSet.relationName());
                    return newDataSet;
                }
                catch (Exception ex) {
                    if (this.m_logger == null) break block8;
                    this.m_logger.logMessage("[ClassValuePicker] " + this.statusMessagePrefix() + " Unable to swap class attibute values.");
                    this.m_logger.statusMessage(String.valueOf(this.statusMessagePrefix()) + "ERROR (See log for details)");
                }
            }
        }
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataListeners(DataSetEvent tse) {
        Vector l;
        ClassValuePicker classValuePicker = this;
        synchronized (classValuePicker) {
            l = (Vector)this.m_dataListeners.clone();
        }
        if (l.size() > 0) {
            int i = 0;
            while (i < l.size()) {
                System.err.println("Notifying data listeners (ClassValuePicker)");
                ((DataSourceListener)l.elementAt(i)).acceptDataSet(tse);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyDataFormatListeners() {
        Vector l;
        ClassValuePicker classValuePicker = this;
        synchronized (classValuePicker) {
            l = (Vector)this.m_dataFormatListeners.clone();
        }
        if (l.size() > 0) {
            DataSetEvent dse = new DataSetEvent(this, this.m_connectedFormat);
            int i = 0;
            while (i < l.size()) {
                ((DataFormatListener)l.elementAt(i)).newDataFormat(dse);
                ++i;
            }
        }
    }

    public synchronized void addDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.addElement(tsl);
    }

    public synchronized void removeDataSourceListener(DataSourceListener tsl) {
        this.m_dataListeners.removeElement(tsl);
    }

    public synchronized void addDataFormatListener(DataFormatListener dfl) {
        this.m_dataFormatListeners.addElement(dfl);
    }

    public synchronized void removeDataFormatListener(DataFormatListener dfl) {
        this.m_dataFormatListeners.removeElement(dfl);
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/ClassValuePicker.gif", "weka/gui/beans/icons/ClassValuePicker_animated.gif");
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return eventName.compareTo("dataSet") != 0 || this.m_dataProvider == null;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName) && eventName.compareTo("dataSet") == 0) {
            this.m_dataProvider = source;
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (eventName.compareTo("dataSet") == 0 && this.m_dataProvider == source) {
            this.m_dataProvider = null;
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    @Override
    public boolean eventGeneratable(String eventName) {
        if (eventName.compareTo("dataSet") != 0) {
            return false;
        }
        if (eventName.compareTo("dataSet") == 0) {
            if (this.m_dataProvider == null) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
            if (this.m_dataProvider instanceof EventConstraints && !((EventConstraints)this.m_dataProvider).eventGeneratable("dataSet")) {
                this.m_connectedFormat = null;
                this.notifyDataFormatListeners();
                return false;
            }
        }
        return true;
    }

    private String statusMessagePrefix() {
        return String.valueOf(this.getCustomName()) + "$" + this.hashCode() + "|";
    }
}

