/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.scripting;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ScriptUtils {
    protected static void copyOrMove(File sourceLocation, File targetLocation, boolean move) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            int i = 0;
            while (i < children.length) {
                ScriptUtils.copyOrMove(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), move);
                ++i;
            }
            if (move) {
                sourceLocation.delete();
            }
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = targetLocation.isDirectory() ? new FileOutputStream(String.valueOf(targetLocation.getAbsolutePath()) + File.separator + sourceLocation.getName()) : new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            if (move) {
                sourceLocation.delete();
            }
        }
    }

    public static void copy(File sourceLocation, File targetLocation) throws IOException {
        ScriptUtils.copyOrMove(sourceLocation, targetLocation, false);
    }

    public static void move(File sourceLocation, File targetLocation) throws IOException {
        ScriptUtils.copyOrMove(sourceLocation, targetLocation, true);
    }

    public static boolean save(File file, String content) {
        boolean result;
        block12: {
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(file));
                    writer.write(content);
                    writer.flush();
                    result = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = false;
                    if (writer == null) break block12;
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return result;
    }

    public static String load(File file) {
        StringBuffer result;
        block15: {
            result = new StringBuffer();
            String newLine = System.getProperty("line.separator");
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    reader = new BufferedReader(new FileReader(file));
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                        result.append(newLine);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    result = null;
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return result != null ? result.toString() : null;
    }
}

