/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.File;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Time;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import weka.core.AbstractInstance;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.experiment.DatabaseUtils;

public class InstanceQuery
extends DatabaseUtils
implements OptionHandler {
    static final long serialVersionUID = 718158370917782584L;
    protected boolean m_CreateSparseData = false;
    protected String m_Query = "SELECT * from ?";
    protected File m_CustomPropsFile = null;

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tSQL query to execute.", "Q", 1, "-Q <query>"));
        result.addElement(new Option("\tReturn sparse rather than normal instances.", "S", 0, "-S"));
        result.addElement(new Option("\tThe username to use for connecting.", "U", 1, "-U <username>"));
        result.addElement(new Option("\tThe password to use for connecting.", "P", 1, "-P <password>"));
        result.add(new Option("\tThe custom properties file to use instead of default ones,\n\tcontaining the database parameters.\n\t(default: none)", "custom-props", 1, "-custom-props <file>"));
        result.addElement(new Option("\tEnables debug output.", "D", 0, "-D"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.setSparseData(Utils.getFlag('S', options));
        String tmpStr = Utils.getOption('Q', options);
        if (tmpStr.length() != 0) {
            this.setQuery(tmpStr);
        }
        if ((tmpStr = Utils.getOption('U', options)).length() != 0) {
            this.setUsername(tmpStr);
        }
        if ((tmpStr = Utils.getOption('P', options)).length() != 0) {
            this.setPassword(tmpStr);
        }
        if ((tmpStr = Utils.getOption("custom-props", options)).length() == 0) {
            this.setCustomPropsFile(null);
        } else {
            this.setCustomPropsFile(new File(tmpStr));
        }
        this.setDebug(Utils.getFlag('D', options));
    }

    public String queryTipText() {
        return "The SQL query to execute against the database.";
    }

    public void setQuery(String q) {
        this.m_Query = q;
    }

    public String getQuery() {
        return this.m_Query;
    }

    public String sparseDataTipText() {
        return "Encode data as sparse instances.";
    }

    public void setSparseData(boolean s) {
        this.m_CreateSparseData = s;
    }

    public boolean getSparseData() {
        return this.m_CreateSparseData;
    }

    public void setCustomPropsFile(File value) {
        this.m_CustomPropsFile = value;
        this.initialize(this.m_CustomPropsFile);
    }

    public File getCustomPropsFile() {
        return this.m_CustomPropsFile;
    }

    public String customPropsFileTipText() {
        return "The custom properties that the user can use to override the default ones.";
    }

    @Override
    public String[] getOptions() {
        Vector<String> options = new Vector<String>();
        options.add("-Q");
        options.add(this.getQuery());
        if (this.getSparseData()) {
            options.add("-S");
        }
        if (!this.getUsername().equals("")) {
            options.add("-U");
            options.add(this.getUsername());
        }
        if (!this.getPassword().equals("")) {
            options.add("-P");
            options.add(this.getPassword());
        }
        if (this.m_CustomPropsFile != null && !this.m_CustomPropsFile.isDirectory()) {
            options.add("-custom-props");
            options.add(this.m_CustomPropsFile.toString());
        }
        if (this.getDebug()) {
            options.add("-D");
        }
        return options.toArray(new String[options.size()]);
    }

    public Instances retrieveInstances() throws Exception {
        return this.retrieveInstances(this.m_Query);
    }

    public Instances retrieveInstances(String query) throws Exception {
        if (this.m_Debug) {
            System.err.println("Executing query: " + query);
        }
        this.connectToDatabase();
        if (!this.execute(query)) {
            if (this.m_PreparedStatement.getUpdateCount() == -1) {
                throw new Exception("Query didn't produce results");
            }
            if (this.m_Debug) {
                System.err.println(this.m_PreparedStatement.getUpdateCount() + " rows affected.");
            }
            this.close();
            return null;
        }
        ResultSet rs = this.getResultSet();
        if (this.m_Debug) {
            System.err.println("Getting metadata...");
        }
        ResultSetMetaData md = rs.getMetaData();
        if (this.m_Debug) {
            System.err.println("Completed getting metadata...");
        }
        int numAttributes = md.getColumnCount();
        int[] attributeTypes = new int[numAttributes];
        Hashtable[] nominalIndexes = new Hashtable[numAttributes];
        FastVector[] nominalStrings = new FastVector[numAttributes];
        block32: for (int i = 1; i <= numAttributes; ++i) {
            switch (this.translateDBColumnType(md.getColumnTypeName(i))) {
                case 0: {
                    attributeTypes[i - 1] = 1;
                    nominalIndexes[i - 1] = new Hashtable();
                    nominalStrings[i - 1] = new FastVector();
                    continue block32;
                }
                case 9: {
                    attributeTypes[i - 1] = 2;
                    nominalIndexes[i - 1] = new Hashtable();
                    nominalStrings[i - 1] = new FastVector();
                    continue block32;
                }
                case 1: {
                    attributeTypes[i - 1] = 1;
                    nominalIndexes[i - 1] = new Hashtable();
                    nominalIndexes[i - 1].put("false", new Double(0.0));
                    nominalIndexes[i - 1].put("true", new Double(1.0));
                    nominalStrings[i - 1] = new FastVector();
                    nominalStrings[i - 1].addElement("false");
                    nominalStrings[i - 1].addElement("true");
                    continue block32;
                }
                case 2: {
                    attributeTypes[i - 1] = 0;
                    continue block32;
                }
                case 3: {
                    attributeTypes[i - 1] = 0;
                    continue block32;
                }
                case 4: {
                    attributeTypes[i - 1] = 0;
                    continue block32;
                }
                case 5: {
                    attributeTypes[i - 1] = 0;
                    continue block32;
                }
                case 6: {
                    attributeTypes[i - 1] = 0;
                    continue block32;
                }
                case 7: {
                    attributeTypes[i - 1] = 0;
                    continue block32;
                }
                case 8: {
                    attributeTypes[i - 1] = 3;
                    continue block32;
                }
                case 10: {
                    attributeTypes[i - 1] = 3;
                    continue block32;
                }
                default: {
                    attributeTypes[i - 1] = 2;
                }
            }
        }
        Vector<String> columnNames = new Vector<String>();
        for (int i = 0; i < numAttributes; ++i) {
            columnNames.add(md.getColumnLabel(i + 1));
        }
        if (this.m_Debug) {
            System.err.println("Creating instances...");
        }
        FastVector<SparseInstance> instances = new FastVector<SparseInstance>();
        int rowCount = 0;
        while (rs.next()) {
            if (rowCount % 100 == 0 && this.m_Debug) {
                System.err.print("read " + rowCount + " instances \r");
                System.err.flush();
            }
            double[] vals = new double[numAttributes];
            block35: for (int i = 1; i <= numAttributes; ++i) {
                switch (this.translateDBColumnType(md.getColumnTypeName(i))) {
                    case 0: {
                        String str = rs.getString(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        Double index = (Double)nominalIndexes[i - 1].get(str);
                        if (index == null) {
                            index = new Double(nominalStrings[i - 1].size());
                            nominalIndexes[i - 1].put(str, index);
                            nominalStrings[i - 1].addElement(str);
                        }
                        vals[i - 1] = index;
                        continue block35;
                    }
                    case 9: {
                        String txt = rs.getString(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        Double index = (Double)nominalIndexes[i - 1].get(txt);
                        if (index == null) {
                            index = new Double(nominalStrings[i - 1].size());
                            nominalIndexes[i - 1].put(txt, index);
                            nominalStrings[i - 1].addElement(txt);
                        }
                        vals[i - 1] = index;
                        continue block35;
                    }
                    case 1: {
                        boolean boo = rs.getBoolean(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = boo ? 1.0 : 0.0;
                        continue block35;
                    }
                    case 2: {
                        double dd = rs.getDouble(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = dd;
                        continue block35;
                    }
                    case 3: {
                        byte by = rs.getByte(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = by;
                        continue block35;
                    }
                    case 4: {
                        short sh = rs.getShort(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = sh;
                        continue block35;
                    }
                    case 5: {
                        int in = rs.getInt(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = in;
                        continue block35;
                    }
                    case 6: {
                        long lo = rs.getLong(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = lo;
                        continue block35;
                    }
                    case 7: {
                        float fl = rs.getFloat(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = fl;
                        continue block35;
                    }
                    case 8: {
                        Date date = rs.getDate(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = date.getTime();
                        continue block35;
                    }
                    case 10: {
                        Time time = rs.getTime(i);
                        if (rs.wasNull()) {
                            vals[i - 1] = Utils.missingValue();
                            continue block35;
                        }
                        vals[i - 1] = time.getTime();
                        continue block35;
                    }
                    default: {
                        vals[i - 1] = Utils.missingValue();
                    }
                }
            }
            AbstractInstance newInst = this.m_CreateSparseData ? new SparseInstance(1.0, vals) : new DenseInstance(1.0, vals);
            instances.addElement((SparseInstance)newInst);
            ++rowCount;
        }
        if (this.m_Debug) {
            System.err.println("Creating header...");
        }
        FastVector<Attribute> attribInfo = new FastVector<Attribute>();
        block36: for (int i = 0; i < numAttributes; ++i) {
            String attribName = this.attributeCaseFix((String)columnNames.get(i));
            switch (attributeTypes[i]) {
                case 1: {
                    attribInfo.addElement(new Attribute(attribName, nominalStrings[i]));
                    continue block36;
                }
                case 0: {
                    attribInfo.addElement(new Attribute(attribName));
                    continue block36;
                }
                case 2: {
                    Attribute att = new Attribute(attribName, (List<String>)null);
                    attribInfo.addElement(att);
                    for (int n = 0; n < nominalStrings[i].size(); ++n) {
                        att.addStringValue((String)nominalStrings[i].elementAt(n));
                    }
                    continue block36;
                }
                case 3: {
                    attribInfo.addElement(new Attribute(attribName, (String)null));
                    continue block36;
                }
                default: {
                    throw new Exception("Unknown attribute type");
                }
            }
        }
        Instances result = new Instances("QueryResult", attribInfo, instances.size());
        for (int i = 0; i < instances.size(); ++i) {
            result.add((Instance)instances.elementAt(i));
        }
        this.close(rs);
        return result;
    }

    public static void main(String[] args) {
        try {
            InstanceQuery iq = new InstanceQuery();
            String query = Utils.getOption('Q', args);
            if (query.length() == 0) {
                iq.setQuery("select * from Experiment_index");
            } else {
                iq.setQuery(query);
            }
            iq.setOptions(args);
            try {
                Utils.checkForRemainingOptions(args);
            }
            catch (Exception e) {
                System.err.println("Options for weka.experiment.InstanceQuery:\n");
                Enumeration en = iq.listOptions();
                while (en.hasMoreElements()) {
                    Option o = (Option)en.nextElement();
                    System.err.println(o.synopsis() + "\n" + o.description());
                }
                System.exit(1);
            }
            Instances aha = iq.retrieveInstances();
            iq.disconnectFromDatabase();
            if (aha == null) {
                return;
            }
            System.out.println(new Instances(aha, 0));
            for (int i = 0; i < aha.numInstances(); ++i) {
                System.out.println(aha.instance(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(e.getMessage());
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7485 $");
    }
}

