/*
 * Decompiled with CFR 0.152.
 */
package weka.attributeSelection;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.SubsetEvaluator;
import weka.core.Capabilities;
import weka.core.ContingencyTables;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.supervised.attribute.Discretize;

public class CfsSubsetEval
extends ASEvaluation
implements SubsetEvaluator,
OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = 747878400813276317L;
    private Instances m_trainInstances;
    private Discretize m_disTransform;
    private int m_classIndex;
    private boolean m_isNumeric;
    private int m_numAttribs;
    private int m_numInstances;
    private boolean m_missingSeparate;
    private boolean m_locallyPredictive;
    private float[][] m_corr_matrix;
    private double[] m_std_devs;
    private double m_c_Threshold;

    public String globalInfo() {
        return "CfsSubsetEval :\n\nEvaluates the worth of a subset of attributes by considering the individual predictive ability of each feature along with the degree of redundancy between them.\n\nSubsets of features that are highly correlated with the class while having low intercorrelation are preferred.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "M. A. Hall");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Correlation-based Feature Subset Selection for Machine Learning");
        result.setValue(TechnicalInformation.Field.SCHOOL, "University of Waikato");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return result;
    }

    public CfsSubsetEval() {
        this.resetOptions();
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tTreat missing values as a separate value.", "M", 0, "-M"));
        newVector.addElement(new Option("\tDon't include locally predictive attributes.", "L", 0, "-L"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        this.resetOptions();
        this.setMissingSeparate(Utils.getFlag('M', options));
        this.setLocallyPredictive(!Utils.getFlag('L', options));
    }

    public String locallyPredictiveTipText() {
        return "Identify locally predictive attributes. Iteratively adds attributes with the highest correlation with the class as long as there is not already an attribute in the subset that has a higher correlation with the attribute in question";
    }

    public void setLocallyPredictive(boolean b) {
        this.m_locallyPredictive = b;
    }

    public boolean getLocallyPredictive() {
        return this.m_locallyPredictive;
    }

    public String missingSeparateTipText() {
        return "Treat missing as a separate value. Otherwise, counts for missing values are distributed across other values in proportion to their frequency.";
    }

    public void setMissingSeparate(boolean b) {
        this.m_missingSeparate = b;
    }

    public boolean getMissingSeparate() {
        return this.m_missingSeparate;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[2];
        int current = 0;
        if (this.getMissingSeparate()) {
            options[current++] = "-M";
        }
        if (!this.getLocallyPredictive()) {
            options[current++] = "-L";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildEvaluator(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        this.m_trainInstances = new Instances(data);
        this.m_trainInstances.deleteWithMissingClass();
        this.m_classIndex = this.m_trainInstances.classIndex();
        this.m_numAttribs = this.m_trainInstances.numAttributes();
        this.m_numInstances = this.m_trainInstances.numInstances();
        this.m_isNumeric = this.m_trainInstances.attribute(this.m_classIndex).isNumeric();
        if (!this.m_isNumeric) {
            this.m_disTransform = new Discretize();
            this.m_disTransform.setUseBetterEncoding(true);
            this.m_disTransform.setInputFormat(this.m_trainInstances);
            this.m_trainInstances = Filter.useFilter(this.m_trainInstances, this.m_disTransform);
        }
        this.m_std_devs = new double[this.m_numAttribs];
        this.m_corr_matrix = new float[this.m_numAttribs][];
        int i = 0;
        while (i < this.m_numAttribs) {
            this.m_corr_matrix[i] = new float[i + 1];
            ++i;
        }
        i = 0;
        while (i < this.m_corr_matrix.length) {
            this.m_corr_matrix[i][i] = 1.0f;
            this.m_std_devs[i] = 1.0;
            ++i;
        }
        i = 0;
        while (i < this.m_numAttribs) {
            int j = 0;
            while (j < this.m_corr_matrix[i].length - 1) {
                this.m_corr_matrix[i][j] = -999.0f;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public double evaluateSubset(BitSet subset) throws Exception {
        float corr;
        double num = 0.0;
        double denom = 0.0;
        int i = 0;
        while (i < this.m_numAttribs) {
            if (i != this.m_classIndex && subset.get(i)) {
                int smaller;
                int larger;
                if (i > this.m_classIndex) {
                    larger = i;
                    smaller = this.m_classIndex;
                } else {
                    smaller = i;
                    larger = this.m_classIndex;
                }
                if (this.m_corr_matrix[larger][smaller] == -999.0f) {
                    this.m_corr_matrix[larger][smaller] = corr = this.correlate(i, this.m_classIndex);
                    num += this.m_std_devs[i] * (double)corr;
                } else {
                    num += this.m_std_devs[i] * (double)this.m_corr_matrix[larger][smaller];
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numAttribs) {
            if (i != this.m_classIndex && subset.get(i)) {
                denom += 1.0 * this.m_std_devs[i] * this.m_std_devs[i];
                int j = 0;
                while (j < this.m_corr_matrix[i].length - 1) {
                    if (subset.get(j)) {
                        if (this.m_corr_matrix[i][j] == -999.0f) {
                            this.m_corr_matrix[i][j] = corr = this.correlate(i, j);
                            denom += 2.0 * this.m_std_devs[i] * this.m_std_devs[j] * (double)corr;
                        } else {
                            denom += 2.0 * this.m_std_devs[i] * this.m_std_devs[j] * (double)this.m_corr_matrix[i][j];
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (denom < 0.0) {
            denom *= -1.0;
        }
        if (denom == 0.0) {
            return 0.0;
        }
        double merit = num / Math.sqrt(denom);
        if (merit < 0.0) {
            merit *= -1.0;
        }
        return merit;
    }

    private float correlate(int att1, int att2) {
        if (!this.m_isNumeric) {
            return (float)this.symmUncertCorr(att1, att2);
        }
        boolean att1_is_num = this.m_trainInstances.attribute(att1).isNumeric();
        boolean att2_is_num = this.m_trainInstances.attribute(att2).isNumeric();
        if (att1_is_num && att2_is_num) {
            return (float)this.num_num(att1, att2);
        }
        if (att2_is_num) {
            return (float)this.num_nom2(att1, att2);
        }
        if (att1_is_num) {
            return (float)this.num_nom2(att2, att1);
        }
        return (float)this.nom_nom(att1, att2);
    }

    private double symmUncertCorr(int att1, int att2) {
        double corr_measure;
        int j;
        double sum = 0.0;
        boolean flag = false;
        double temp = 0.0;
        if (att1 == this.m_classIndex || att2 == this.m_classIndex) {
            flag = true;
        }
        int ni = this.m_trainInstances.attribute(att1).numValues() + 1;
        int nj = this.m_trainInstances.attribute(att2).numValues() + 1;
        double[][] counts = new double[ni][nj];
        double[] sumi = new double[ni];
        double[] sumj = new double[nj];
        int i = 0;
        while (i < ni) {
            sumi[i] = 0.0;
            j = 0;
            while (j < nj) {
                sumj[j] = 0.0;
                counts[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numInstances) {
            Instance inst = this.m_trainInstances.instance(i);
            int ii = inst.isMissing(att1) ? ni - 1 : (int)inst.value(att1);
            int jj = inst.isMissing(att2) ? nj - 1 : (int)inst.value(att2);
            double[] dArray = counts[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
            ++i;
        }
        i = 0;
        while (i < ni) {
            sumi[i] = 0.0;
            j = 0;
            while (j < nj) {
                int n = i;
                sumi[n] = sumi[n] + counts[i][j];
                sum += counts[i][j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < nj) {
            sumj[j] = 0.0;
            i = 0;
            while (i < ni) {
                int n = j;
                sumj[n] = sumj[n] + counts[i][j];
                ++i;
            }
            ++j;
        }
        if (!this.m_missingSeparate && sumi[ni - 1] < (double)this.m_numInstances && sumj[nj - 1] < (double)this.m_numInstances) {
            double[] i_copy = new double[sumi.length];
            double[] j_copy = new double[sumj.length];
            double[][] counts_copy = new double[sumi.length][sumj.length];
            i = 0;
            while (i < ni) {
                System.arraycopy(counts[i], 0, counts_copy[i], 0, sumj.length);
                ++i;
            }
            System.arraycopy(sumi, 0, i_copy, 0, sumi.length);
            System.arraycopy(sumj, 0, j_copy, 0, sumj.length);
            double total_missing = sumi[ni - 1] + sumj[nj - 1] - counts[ni - 1][nj - 1];
            if (sumi[ni - 1] > 0.0) {
                j = 0;
                while (j < nj - 1) {
                    if (counts[ni - 1][j] > 0.0) {
                        i = 0;
                        while (i < ni - 1) {
                            temp = i_copy[i] / (sum - i_copy[ni - 1]) * counts[ni - 1][j];
                            double[] dArray = counts[i];
                            int n = j;
                            dArray[n] = dArray[n] + temp;
                            int n2 = i++;
                            sumi[n2] = sumi[n2] + temp;
                        }
                        counts[ni - 1][j] = 0.0;
                    }
                    ++j;
                }
            }
            sumi[ni - 1] = 0.0;
            if (sumj[nj - 1] > 0.0) {
                i = 0;
                while (i < ni - 1) {
                    if (counts[i][nj - 1] > 0.0) {
                        j = 0;
                        while (j < nj - 1) {
                            temp = j_copy[j] / (sum - j_copy[nj - 1]) * counts[i][nj - 1];
                            double[] dArray = counts[i];
                            int n = j;
                            dArray[n] = dArray[n] + temp;
                            int n3 = j++;
                            sumj[n3] = sumj[n3] + temp;
                        }
                        counts[i][nj - 1] = 0.0;
                    }
                    ++i;
                }
            }
            sumj[nj - 1] = 0.0;
            if (counts[ni - 1][nj - 1] > 0.0 && total_missing != sum) {
                i = 0;
                while (i < ni - 1) {
                    j = 0;
                    while (j < nj - 1) {
                        temp = counts_copy[i][j] / (sum - total_missing) * counts_copy[ni - 1][nj - 1];
                        double[] dArray = counts[i];
                        int n = j;
                        dArray[n] = dArray[n] + temp;
                        int n4 = i;
                        sumi[n4] = sumi[n4] + temp;
                        int n5 = j++;
                        sumj[n5] = sumj[n5] + temp;
                    }
                    ++i;
                }
                counts[ni - 1][nj - 1] = 0.0;
            }
        }
        if (Utils.eq(corr_measure = ContingencyTables.symmetricalUncertainty(counts), 0.0)) {
            if (flag) {
                return 0.0;
            }
            return 1.0;
        }
        return corr_measure;
    }

    private double num_num(int att1, int att2) {
        double num = 0.0;
        double sx = 0.0;
        double sy = 0.0;
        double mx = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att1));
        double my = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att2));
        int i = 0;
        while (i < this.m_numInstances) {
            Instance inst = this.m_trainInstances.instance(i);
            double diff1 = inst.isMissing(att1) ? 0.0 : inst.value(att1) - mx;
            double diff2 = inst.isMissing(att2) ? 0.0 : inst.value(att2) - my;
            num += diff1 * diff2;
            sx += diff1 * diff1;
            sy += diff2 * diff2;
            ++i;
        }
        if (sx != 0.0 && this.m_std_devs[att1] == 1.0) {
            this.m_std_devs[att1] = Math.sqrt(sx / (double)this.m_numInstances);
        }
        if (sy != 0.0 && this.m_std_devs[att2] == 1.0) {
            this.m_std_devs[att2] = Math.sqrt(sy / (double)this.m_numInstances);
        }
        if (sx * sy > 0.0) {
            double r = num / Math.sqrt(sx * sy);
            return r < 0.0 ? -r : r;
        }
        if (att1 != this.m_classIndex && att2 != this.m_classIndex) {
            return 1.0;
        }
        return 0.0;
    }

    private double num_nom2(int att1, int att2) {
        double temp;
        Instance inst;
        int mx = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att1));
        double my = this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att2));
        double stdv_num = 0.0;
        double r = 0.0;
        int nx = !this.m_missingSeparate ? this.m_trainInstances.attribute(att1).numValues() : this.m_trainInstances.attribute(att1).numValues() + 1;
        double[] prior_nom = new double[nx];
        double[] stdvs_nom = new double[nx];
        double[] covs = new double[nx];
        int i = 0;
        while (i < nx) {
            prior_nom[i] = 0.0;
            covs[i] = 0.0;
            stdvs_nom[i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < this.m_numInstances) {
            inst = this.m_trainInstances.instance(i);
            int ii = inst.isMissing(att1) ? (!this.m_missingSeparate ? mx : nx - 1) : (int)inst.value(att1);
            int n = ii;
            prior_nom[n] = prior_nom[n] + 1.0;
            ++i;
        }
        int k = 0;
        while (k < this.m_numInstances) {
            inst = this.m_trainInstances.instance(k);
            double diff2 = inst.isMissing(att2) ? 0.0 : inst.value(att2) - my;
            stdv_num += diff2 * diff2;
            i = 0;
            while (i < nx) {
                temp = inst.isMissing(att1) ? (!this.m_missingSeparate ? (i == mx ? 1.0 : 0.0) : (i == nx - 1 ? 1.0 : 0.0)) : ((double)i == inst.value(att1) ? 1.0 : 0.0);
                double diff1 = temp - prior_nom[i] / (double)this.m_numInstances;
                int n = i;
                stdvs_nom[n] = stdvs_nom[n] + diff1 * diff1;
                int n2 = i++;
                covs[n2] = covs[n2] + diff1 * diff2;
            }
            ++k;
        }
        i = 0;
        temp = 0.0;
        while (i < nx) {
            temp += prior_nom[i] / (double)this.m_numInstances * (stdvs_nom[i] / (double)this.m_numInstances);
            if (stdvs_nom[i] * stdv_num > 0.0) {
                double rr = covs[i] / Math.sqrt(stdvs_nom[i] * stdv_num);
                if (rr < 0.0) {
                    rr = -rr;
                }
                r += prior_nom[i] / (double)this.m_numInstances * rr;
            } else if (att1 != this.m_classIndex && att2 != this.m_classIndex) {
                r += prior_nom[i] / (double)this.m_numInstances * 1.0;
            }
            ++i;
        }
        if (temp != 0.0 && this.m_std_devs[att1] == 1.0) {
            this.m_std_devs[att1] = Math.sqrt(temp);
        }
        if (stdv_num != 0.0 && this.m_std_devs[att2] == 1.0) {
            this.m_std_devs[att2] = Math.sqrt(stdv_num / (double)this.m_numInstances);
        }
        if (r == 0.0 && att1 != this.m_classIndex && att2 != this.m_classIndex) {
            r = 1.0;
        }
        return r;
    }

    private double nom_nom(int att1, int att2) {
        double temp1;
        double temp2;
        Instance inst;
        int mx = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att1));
        int my = (int)this.m_trainInstances.meanOrMode(this.m_trainInstances.attribute(att2));
        double r = 0.0;
        int nx = !this.m_missingSeparate ? this.m_trainInstances.attribute(att1).numValues() : this.m_trainInstances.attribute(att1).numValues() + 1;
        int ny = !this.m_missingSeparate ? this.m_trainInstances.attribute(att2).numValues() : this.m_trainInstances.attribute(att2).numValues() + 1;
        double[][] prior_nom = new double[nx][ny];
        double[] sumx = new double[nx];
        double[] sumy = new double[ny];
        double[] stdvsx = new double[nx];
        double[] stdvsy = new double[ny];
        double[][] covs = new double[nx][ny];
        int i = 0;
        while (i < nx) {
            stdvsx[i] = 0.0;
            sumx[i] = 0.0;
            ++i;
        }
        int j = 0;
        while (j < ny) {
            stdvsy[j] = 0.0;
            sumy[j] = 0.0;
            ++j;
        }
        i = 0;
        while (i < nx) {
            j = 0;
            while (j < ny) {
                prior_nom[i][j] = 0.0;
                covs[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_numInstances) {
            inst = this.m_trainInstances.instance(i);
            int ii = inst.isMissing(att1) ? (!this.m_missingSeparate ? mx : nx - 1) : (int)inst.value(att1);
            int jj = inst.isMissing(att2) ? (!this.m_missingSeparate ? my : ny - 1) : (int)inst.value(att2);
            double[] dArray = prior_nom[ii];
            int n = jj;
            dArray[n] = dArray[n] + 1.0;
            int n2 = ii;
            sumx[n2] = sumx[n2] + 1.0;
            int n3 = jj;
            sumy[n3] = sumy[n3] + 1.0;
            ++i;
        }
        int z = 0;
        while (z < this.m_numInstances) {
            double diff2;
            inst = this.m_trainInstances.instance(z);
            j = 0;
            while (j < ny) {
                temp2 = inst.isMissing(att2) ? (!this.m_missingSeparate ? (j == my ? 1.0 : 0.0) : (j == ny - 1 ? 1.0 : 0.0)) : ((double)j == inst.value(att2) ? 1.0 : 0.0);
                diff2 = temp2 - sumy[j] / (double)this.m_numInstances;
                int n = j++;
                stdvsy[n] = stdvsy[n] + diff2 * diff2;
            }
            i = 0;
            while (i < nx) {
                temp1 = inst.isMissing(att1) ? (!this.m_missingSeparate ? (i == mx ? 1.0 : 0.0) : (i == nx - 1 ? 1.0 : 0.0)) : ((double)i == inst.value(att1) ? 1.0 : 0.0);
                double diff1 = temp1 - sumx[i] / (double)this.m_numInstances;
                int n = i;
                stdvsx[n] = stdvsx[n] + diff1 * diff1;
                j = 0;
                while (j < ny) {
                    temp2 = inst.isMissing(att2) ? (!this.m_missingSeparate ? (j == my ? 1.0 : 0.0) : (j == ny - 1 ? 1.0 : 0.0)) : ((double)j == inst.value(att2) ? 1.0 : 0.0);
                    diff2 = temp2 - sumy[j] / (double)this.m_numInstances;
                    double[] dArray = covs[i];
                    int n4 = j++;
                    dArray[n4] = dArray[n4] + diff1 * diff2;
                }
                ++i;
            }
            ++z;
        }
        i = 0;
        while (i < nx) {
            j = 0;
            while (j < ny) {
                if (stdvsx[i] * stdvsy[j] > 0.0) {
                    double rr = covs[i][j] / Math.sqrt(stdvsx[i] * stdvsy[j]);
                    if (rr < 0.0) {
                        rr = -rr;
                    }
                    r += prior_nom[i][j] / (double)this.m_numInstances * rr;
                } else if (att1 != this.m_classIndex && att2 != this.m_classIndex) {
                    r += prior_nom[i][j] / (double)this.m_numInstances * 1.0;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        temp1 = 0.0;
        while (i < nx) {
            temp1 += sumx[i] / (double)this.m_numInstances * (stdvsx[i] / (double)this.m_numInstances);
            ++i;
        }
        if (temp1 != 0.0 && this.m_std_devs[att1] == 1.0) {
            this.m_std_devs[att1] = Math.sqrt(temp1);
        }
        j = 0;
        temp2 = 0.0;
        while (j < ny) {
            temp2 += sumy[j] / (double)this.m_numInstances * (stdvsy[j] / (double)this.m_numInstances);
            ++j;
        }
        if (temp2 != 0.0 && this.m_std_devs[att2] == 1.0) {
            this.m_std_devs[att2] = Math.sqrt(temp2);
        }
        if (r == 0.0 && att1 != this.m_classIndex && att2 != this.m_classIndex) {
            r = 1.0;
        }
        return r;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_trainInstances == null) {
            text.append("CFS subset evaluator has not been built yet\n");
        } else {
            text.append("\tCFS Subset Evaluator\n");
            if (this.m_missingSeparate) {
                text.append("\tTreating missing values as a separate value\n");
            }
            if (this.m_locallyPredictive) {
                text.append("\tIncluding locally predictive attributes\n");
            }
        }
        return text.toString();
    }

    private void addLocallyPredictive(BitSet best_group) {
        boolean done = false;
        boolean ok = true;
        double temp_best = -1.0;
        int j = 0;
        BitSet temp_group = (BitSet)best_group.clone();
        while (!done) {
            float corr;
            int smaller;
            int larger;
            temp_best = -1.0;
            int i = 0;
            while (i < this.m_numAttribs) {
                if (i > this.m_classIndex) {
                    larger = i;
                    smaller = this.m_classIndex;
                } else {
                    smaller = i;
                    larger = this.m_classIndex;
                }
                if (!temp_group.get(i) && i != this.m_classIndex) {
                    if (this.m_corr_matrix[larger][smaller] == -999.0f) {
                        this.m_corr_matrix[larger][smaller] = corr = this.correlate(i, this.m_classIndex);
                    }
                    if ((double)this.m_corr_matrix[larger][smaller] > temp_best) {
                        temp_best = this.m_corr_matrix[larger][smaller];
                        j = i;
                    }
                }
                ++i;
            }
            if (temp_best == -1.0) {
                done = true;
                continue;
            }
            ok = true;
            temp_group.set(j);
            i = 0;
            while (i < this.m_numAttribs) {
                if (i > j) {
                    larger = i;
                    smaller = j;
                } else {
                    larger = j;
                    smaller = i;
                }
                if (best_group.get(i)) {
                    if (this.m_corr_matrix[larger][smaller] == -999.0f) {
                        this.m_corr_matrix[larger][smaller] = corr = this.correlate(i, j);
                    }
                    if ((double)this.m_corr_matrix[larger][smaller] > temp_best - this.m_c_Threshold) {
                        ok = false;
                        break;
                    }
                }
                ++i;
            }
            if (!ok) continue;
            best_group.set(j);
        }
    }

    @Override
    public int[] postProcess(int[] attributeSet) throws Exception {
        int j = 0;
        if (!this.m_locallyPredictive) {
            return attributeSet;
        }
        BitSet bestGroup = new BitSet(this.m_numAttribs);
        int i = 0;
        while (i < attributeSet.length) {
            bestGroup.set(attributeSet[i]);
            ++i;
        }
        this.addLocallyPredictive(bestGroup);
        i = 0;
        while (i < this.m_numAttribs) {
            if (bestGroup.get(i)) {
                ++j;
            }
            ++i;
        }
        int[] newSet = new int[j];
        j = 0;
        int i2 = 0;
        while (i2 < this.m_numAttribs) {
            if (bestGroup.get(i2)) {
                newSet[j++] = i2;
            }
            ++i2;
        }
        return newSet;
    }

    protected void resetOptions() {
        this.m_trainInstances = null;
        this.m_missingSeparate = false;
        this.m_locallyPredictive = true;
        this.m_c_Threshold = 0.0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6132 $");
    }

    public static void main(String[] args) {
        CfsSubsetEval.runEvaluator(new CfsSubsetEval(), args);
    }
}

