/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.io.LineNumberReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.Writer;
import java.util.Random;
import java.util.StringTokenizer;
import weka.core.AttributeExpression;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Matrix;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class CostMatrix
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -1973792250544554965L;
    private int m_size;
    protected Object[][] m_matrix;
    public static String FILE_EXTENSION = ".cost";

    public CostMatrix(int numOfClasses) {
        this.m_size = numOfClasses;
        this.initialize();
    }

    public CostMatrix(CostMatrix toCopy) {
        this(toCopy.size());
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                this.setCell(i, j, toCopy.getCell(i, j));
                ++j;
            }
            ++i;
        }
    }

    public void initialize() {
        this.m_matrix = new Object[this.m_size][this.m_size];
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                this.setCell(i, j, i == j ? new Double(0.0) : new Double(1.0));
                ++j;
            }
            ++i;
        }
    }

    public int size() {
        return this.m_size;
    }

    public int numColumns() {
        return this.size();
    }

    public int numRows() {
        return this.size();
    }

    private boolean replaceStrings() throws Exception {
        boolean nonDouble = false;
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                if (this.getCell(i, j) instanceof String) {
                    AttributeExpression temp = new AttributeExpression();
                    temp.convertInfixToPostfix((String)this.getCell(i, j));
                    this.setCell(i, j, temp);
                    nonDouble = true;
                } else if (this.getCell(i, j) instanceof AttributeExpression) {
                    nonDouble = true;
                }
                ++j;
            }
            ++i;
        }
        return nonDouble;
    }

    public Instances applyCostMatrix(Instances data, Random random) throws Exception {
        double sumOfWeightFactors = 0.0;
        if (data.classIndex() < 0) {
            throw new Exception("Class index is not set!");
        }
        if (this.size() != data.numClasses()) {
            throw new Exception("Misclassification cost matrix has wrong format!");
        }
        if (this.replaceStrings()) {
            if (data.classAttribute().numValues() > 2) {
                throw new Exception("Can't resample/reweight instances using non-fixed cost values when there are more than two classes!");
            }
            double[] weightOfInstances = new double[data.numInstances()];
            int i = 0;
            while (i < data.numInstances()) {
                Instance inst = data.instance(i);
                int classValIndex = (int)inst.classValue();
                double factor = 1.0;
                Object element = classValIndex == 0 ? this.getCell(classValIndex, 1) : this.getCell(classValIndex, 0);
                factor = element instanceof Double ? ((Double)element).doubleValue() : ((AttributeExpression)element).evaluateExpression(inst);
                weightOfInstances[i] = inst.weight() * factor;
                ++i;
            }
            if (random != null) {
                return data.resampleWithWeights(random, weightOfInstances);
            }
            Instances instances = new Instances(data);
            int i2 = 0;
            while (i2 < data.numInstances()) {
                instances.instance(i2).setWeight(weightOfInstances[i2]);
                ++i2;
            }
            return instances;
        }
        double[] weightFactor = new double[data.numClasses()];
        double[] weightOfInstancesInClass = new double[data.numClasses()];
        int j = 0;
        while (j < data.numInstances()) {
            int n = (int)data.instance(j).classValue();
            weightOfInstancesInClass[n] = weightOfInstancesInClass[n] + data.instance(j).weight();
            ++j;
        }
        double sumOfWeights = Utils.sum(weightOfInstancesInClass);
        int i = 0;
        while (i < this.m_size) {
            if (!Utils.eq((Double)this.getCell(i, i), 0.0)) {
                CostMatrix normMatrix = new CostMatrix(this);
                normMatrix.normalize();
                return normMatrix.applyCostMatrix(data, random);
            }
            ++i;
        }
        i = 0;
        while (i < data.numClasses()) {
            double sumOfMissClassWeights = 0.0;
            int j2 = 0;
            while (j2 < data.numClasses()) {
                if (Utils.sm((Double)this.getCell(i, j2), 0.0)) {
                    throw new Exception("Neg. weights in misclassification cost matrix!");
                }
                sumOfMissClassWeights += ((Double)this.getCell(i, j2)).doubleValue();
                ++j2;
            }
            weightFactor[i] = sumOfMissClassWeights * sumOfWeights;
            sumOfWeightFactors += sumOfMissClassWeights * weightOfInstancesInClass[i];
            ++i;
        }
        i = 0;
        while (i < data.numClasses()) {
            int n = i++;
            weightFactor[n] = weightFactor[n] / sumOfWeightFactors;
        }
        double[] weightOfInstances = new double[data.numInstances()];
        i = 0;
        while (i < data.numInstances()) {
            weightOfInstances[i] = data.instance(i).weight() * weightFactor[(int)data.instance(i).classValue()];
            ++i;
        }
        if (random != null) {
            return data.resampleWithWeights(random, weightOfInstances);
        }
        Instances instances = new Instances(data);
        int i3 = 0;
        while (i3 < data.numInstances()) {
            instances.instance(i3).setWeight(weightOfInstances[i3]);
            ++i3;
        }
        return instances;
    }

    public double[] expectedCosts(double[] classProbs) throws Exception {
        if (classProbs.length != this.m_size) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        double[] costs = new double[this.m_size];
        int x = 0;
        while (x < this.m_size) {
            int y = 0;
            while (y < this.m_size) {
                Object element = this.getCell(y, x);
                if (!(element instanceof Double)) {
                    throw new Exception("Can't use non-fixed costs in computing expected costs.");
                }
                int n = x;
                costs[n] = costs[n] + classProbs[y] * (Double)element;
                ++y;
            }
            ++x;
        }
        return costs;
    }

    public double[] expectedCosts(double[] classProbs, Instance inst) throws Exception {
        if (classProbs.length != this.m_size) {
            throw new Exception("Length of probability estimates don't match cost matrix");
        }
        if (!this.replaceStrings()) {
            return this.expectedCosts(classProbs);
        }
        double[] costs = new double[this.m_size];
        int x = 0;
        while (x < this.m_size) {
            int y = 0;
            while (y < this.m_size) {
                Object element = this.getCell(y, x);
                double costVal = !(element instanceof Double) ? ((AttributeExpression)element).evaluateExpression(inst) : ((Double)element).doubleValue();
                int n = x;
                costs[n] = costs[n] + classProbs[y] * costVal;
                ++y;
            }
            ++x;
        }
        return costs;
    }

    public double getMaxCost(int classVal) throws Exception {
        double maxCost = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.m_size) {
            Object element = this.getCell(classVal, i);
            if (!(element instanceof Double)) {
                throw new Exception("Can't use non-fixed costs when getting max cost.");
            }
            double cost = (Double)element;
            if (cost > maxCost) {
                maxCost = cost;
            }
            ++i;
        }
        return maxCost;
    }

    public double getMaxCost(int classVal, Instance inst) throws Exception {
        if (!this.replaceStrings()) {
            return this.getMaxCost(classVal);
        }
        double maxCost = Double.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.m_size) {
            Object element = this.getCell(classVal, i);
            double cost = !(element instanceof Double) ? ((AttributeExpression)element).evaluateExpression(inst) : ((Double)element).doubleValue();
            if (cost > maxCost) {
                maxCost = cost;
            }
            ++i;
        }
        return maxCost;
    }

    public void normalize() {
        int y = 0;
        while (y < this.m_size) {
            double diag = (Double)this.getCell(y, y);
            int x = 0;
            while (x < this.m_size) {
                this.setCell(x, y, new Double((Double)this.getCell(x, y) - diag));
                ++x;
            }
            ++y;
        }
    }

    public void readOldFormat(Reader reader) throws Exception {
        int currentToken;
        StreamTokenizer tokenizer = new StreamTokenizer(reader);
        this.initialize();
        tokenizer.commentChar(37);
        tokenizer.eolIsSignificant(true);
        while (-1 != (currentToken = tokenizer.nextToken())) {
            if (currentToken == 10) continue;
            if (currentToken != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double firstIndex = tokenizer.nval;
            if (!Utils.eq((int)firstIndex, firstIndex)) {
                throw new Exception("First number in line has to be index of a class!");
            }
            if ((int)firstIndex >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            currentToken = tokenizer.nextToken();
            if (-1 == currentToken) {
                throw new Exception("Premature end of file!");
            }
            if (currentToken == 10) {
                throw new Exception("Premature end of line!");
            }
            if (currentToken != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double secondIndex = tokenizer.nval;
            if (!Utils.eq((int)secondIndex, secondIndex)) {
                throw new Exception("Second number in line has to be index of a class!");
            }
            if ((int)secondIndex >= this.size()) {
                throw new Exception("Class index out of range!");
            }
            if ((int)secondIndex == (int)firstIndex) {
                throw new Exception("Diagonal of cost matrix non-zero!");
            }
            currentToken = tokenizer.nextToken();
            if (-1 == currentToken) {
                throw new Exception("Premature end of file!");
            }
            if (currentToken == 10) {
                throw new Exception("Premature end of line!");
            }
            if (currentToken != -2) {
                throw new Exception("Only numbers and comments allowed in cost file!");
            }
            double weight = tokenizer.nval;
            if (!Utils.gr(weight, 0.0)) {
                throw new Exception("Only positive weights allowed!");
            }
            this.setCell((int)firstIndex, (int)secondIndex, new Double(weight));
        }
    }

    public CostMatrix(Reader reader) throws Exception {
        String line;
        LineNumberReader lnr = new LineNumberReader(reader);
        int currentRow = -1;
        while ((line = lnr.readLine()) != null) {
            StringTokenizer st;
            if (line.startsWith("%") || !(st = new StringTokenizer(line)).hasMoreTokens()) continue;
            if (currentRow < 0) {
                int rows = Integer.parseInt(st.nextToken());
                if (!st.hasMoreTokens()) {
                    throw new Exception("Line " + lnr.getLineNumber() + ": expected number of columns");
                }
                int cols = Integer.parseInt(st.nextToken());
                if (rows != cols) {
                    throw new Exception("Trying to create a non-square cost matrix");
                }
                this.m_size = rows;
                this.initialize();
                ++currentRow;
                continue;
            }
            if (currentRow == this.m_size) {
                throw new Exception("Line " + lnr.getLineNumber() + ": too many rows provided");
            }
            int i = 0;
            while (i < this.m_size) {
                if (!st.hasMoreTokens()) {
                    throw new Exception("Line " + lnr.getLineNumber() + ": too few matrix elements provided");
                }
                String nextTok = st.nextToken();
                Double val = null;
                try {
                    val = new Double(nextTok);
                    double value = val;
                }
                catch (Exception ex) {
                    val = null;
                }
                if (val == null) {
                    this.setCell(currentRow, i, nextTok);
                } else {
                    this.setCell(currentRow, i, val);
                }
                ++i;
            }
            ++currentRow;
        }
        if (currentRow == -1) {
            throw new Exception("Line " + lnr.getLineNumber() + ": expected number of rows");
        }
        if (currentRow != this.m_size) {
            throw new Exception("Line " + lnr.getLineNumber() + ": too few rows provided");
        }
    }

    public void write(Writer w) throws Exception {
        w.write("% Rows\tColumns\n");
        w.write(this.m_size + "\t" + this.m_size + "\n");
        w.write("% Matrix elements\n");
        int i = 0;
        while (i < this.m_size) {
            int j = 0;
            while (j < this.m_size) {
                w.write(this.getCell(i, j) + "\t");
                ++j;
            }
            w.write("\n");
            ++i;
        }
        w.flush();
    }

    public String toMatlab() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        int i = 0;
        while (i < this.m_size) {
            if (i > 0) {
                result.append("; ");
            }
            int n = 0;
            while (n < this.m_size) {
                if (n > 0) {
                    result.append(" ");
                }
                result.append(this.getCell(i, n));
                ++n;
            }
            ++i;
        }
        result.append("]");
        return result.toString();
    }

    public final void setCell(int rowIndex, int columnIndex, Object value) {
        this.m_matrix[rowIndex][columnIndex] = value;
    }

    public final Object getCell(int rowIndex, int columnIndex) {
        return this.m_matrix[rowIndex][columnIndex];
    }

    public final double getElement(int rowIndex, int columnIndex) throws Exception {
        if (!(this.m_matrix[rowIndex][columnIndex] instanceof Double)) {
            throw new Exception("Cost matrix contains non-fixed costs!");
        }
        return (Double)this.m_matrix[rowIndex][columnIndex];
    }

    public final double getElement(int rowIndex, int columnIndex, Instance inst) throws Exception {
        if (this.m_matrix[rowIndex][columnIndex] instanceof Double) {
            return (Double)this.m_matrix[rowIndex][columnIndex];
        }
        if (this.m_matrix[rowIndex][columnIndex] instanceof String) {
            this.replaceStrings();
        }
        return ((AttributeExpression)this.m_matrix[rowIndex][columnIndex]).evaluateExpression(inst);
    }

    public final void setElement(int rowIndex, int columnIndex, double value) {
        this.m_matrix[rowIndex][columnIndex] = new Double(value);
    }

    public static Matrix parseMatlab(String matlab) throws Exception {
        return Matrix.parseMatlab(matlab);
    }

    public String toString() {
        double maxval = 0.0;
        boolean fractional = false;
        Object element = null;
        int widthNumber = 0;
        int widthExpression = 0;
        int i = 0;
        while (i < this.size()) {
            int j = 0;
            while (j < this.size()) {
                element = this.getCell(i, j);
                if (element instanceof Double) {
                    double current = (Double)element;
                    if (current < 0.0) {
                        current *= -11.0;
                    }
                    if (current > maxval) {
                        maxval = current;
                    }
                    double fract = Math.abs(current - Math.rint(current));
                    if (!fractional && Math.log(fract) / Math.log(10.0) >= -2.0) {
                        fractional = true;
                    }
                } else if (element.toString().length() > widthExpression) {
                    widthExpression = element.toString().length();
                }
                ++j;
            }
            ++i;
        }
        if (maxval > 0.0) {
            widthNumber = (int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 4 : 1));
        }
        int width = widthNumber > widthExpression ? widthNumber : widthExpression;
        StringBuffer text = new StringBuffer();
        int i2 = 0;
        while (i2 < this.size()) {
            int j = 0;
            while (j < this.size()) {
                element = this.getCell(i2, j);
                if (element instanceof Double) {
                    text.append(" ").append(Utils.doubleToString((Double)element, width, fractional ? 2 : 0));
                } else {
                    int diff = width - element.toString().length();
                    if (diff > 0) {
                        int left = diff % 2;
                        String temp = Utils.padLeft(element.toString(), element.toString().length() + (left += diff / 2));
                        temp = Utils.padRight(temp, width);
                        text.append(" ").append(temp);
                    } else {
                        text.append(" ").append(element.toString());
                    }
                }
                ++j;
            }
            text.append("\n");
            ++i2;
        }
        return text.toString();
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6041 $");
    }
}

