/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.ConditionalDensityEstimator;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.SelectedTag;
import weka.core.Statistics;
import weka.core.Tag;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.Normalize;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;
import weka.filters.unsupervised.attribute.Standardize;

public class GaussianProcesses
extends AbstractClassifier
implements OptionHandler,
IntervalEstimator,
ConditionalDensityEstimator,
TechnicalInformationHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -8620066949967678545L;
    protected NominalToBinary m_NominalToBinary;
    public static final int FILTER_NORMALIZE = 0;
    public static final int FILTER_STANDARDIZE = 1;
    public static final int FILTER_NONE = 2;
    public static final Tag[] TAGS_FILTER = new Tag[]{new Tag(0, "Normalize training data"), new Tag(1, "Standardize training data"), new Tag(2, "No normalization/standardization")};
    protected Filter m_Filter = null;
    protected int m_filterType = 0;
    protected ReplaceMissingValues m_Missing;
    protected boolean m_checksTurnedOff = false;
    protected double m_delta = 1.0;
    protected double m_Alin;
    protected double m_Blin;
    protected Kernel m_kernel = new PolyKernel();
    protected int m_NumTrain = 0;
    protected double m_avg_target;
    public double[][] m_L;
    protected Matrix m_t;

    public String globalInfo() {
        return " Implements Gaussian processes for regression without hyperparameter-tuning. To make choosing an appropriate noise level easier, this implementation applies normalization/standardization to the target attribute as well as the other attributes (if  normalization/standardizaton is turned on). Missing values are replaced by the global mean/mode. Nominal attributes are converted to binary ones. Note that kernel caching is turned off if the kernel used implements CachedKernel.";
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.MISC);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David J.C. Mackay");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.TITLE, "Introduction to Gaussian Processes");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Dept. of Physics, Cambridge University, UK");
        result.setValue(TechnicalInformation.Field.PS, "http://wol.ra.phy.cam.ac.uk/mackay/gpB.ps.gz");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getKernel().getCapabilities();
        result.setOwner(this);
        result.enableAllAttributeDependencies();
        if (result.handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        }
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.disableAllClasses();
        result.disableAllClassDependencies();
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances insts) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(insts);
            insts = new Instances(insts);
            insts.deleteWithMissingClass();
        }
        if (!this.m_checksTurnedOff) {
            this.m_Missing = new ReplaceMissingValues();
            this.m_Missing.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Missing);
        } else {
            this.m_Missing = null;
        }
        if (this.getCapabilities().handles(Capabilities.Capability.NUMERIC_ATTRIBUTES)) {
            boolean onlyNumeric = true;
            if (!this.m_checksTurnedOff) {
                int i = 0;
                while (i < insts.numAttributes()) {
                    if (i != insts.classIndex() && !insts.attribute(i).isNumeric()) {
                        onlyNumeric = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!onlyNumeric) {
                this.m_NominalToBinary = new NominalToBinary();
                this.m_NominalToBinary.setInputFormat(insts);
                insts = Filter.useFilter(insts, this.m_NominalToBinary);
            } else {
                this.m_NominalToBinary = null;
            }
        } else {
            this.m_NominalToBinary = null;
        }
        if (this.m_filterType == 1) {
            this.m_Filter = new Standardize();
            ((Standardize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Filter);
        } else if (this.m_filterType == 0) {
            this.m_Filter = new Normalize();
            ((Normalize)this.m_Filter).setIgnoreClass(true);
            this.m_Filter.setInputFormat(insts);
            insts = Filter.useFilter(insts, this.m_Filter);
        } else {
            this.m_Filter = null;
        }
        this.m_NumTrain = insts.numInstances();
        if (this.m_Filter != null) {
            Instance witness = (Instance)insts.instance(0).copy();
            witness.setValue(insts.classIndex(), 0.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            Instance res = this.m_Filter.output();
            this.m_Blin = res.value(insts.classIndex());
            witness.setValue(insts.classIndex(), 1.0);
            this.m_Filter.input(witness);
            this.m_Filter.batchFinished();
            res = this.m_Filter.output();
            this.m_Alin = res.value(insts.classIndex()) - this.m_Blin;
        } else {
            this.m_Alin = 1.0;
            this.m_Blin = 0.0;
        }
        try {
            CachedKernel cachedKernel = (CachedKernel)this.m_kernel;
            cachedKernel.setCacheSize(0);
        }
        catch (Exception cachedKernel) {
            // empty catch block
        }
        this.m_kernel.buildKernel(insts);
        double sum = 0.0;
        int i = 0;
        while (i < insts.numInstances()) {
            sum += insts.instance(i).classValue();
            ++i;
        }
        this.m_avg_target = sum / (double)insts.numInstances();
        int n = insts.numInstances();
        this.m_L = new double[n][];
        int i2 = 0;
        while (i2 < n) {
            this.m_L[i2] = new double[i2 + 1];
            ++i2;
        }
        double kv = 0.0;
        int i3 = 0;
        while (i3 < n) {
            int j = 0;
            while (j < i3) {
                this.m_L[i3][j] = kv = this.m_kernel.eval(i3, j, insts.instance(i3));
                ++j;
            }
            kv = this.m_kernel.eval(i3, i3, insts.instance(i3));
            this.m_L[i3][i3] = kv + this.m_delta * this.m_delta;
            ++i3;
        }
        double[] tmprow = new double[n];
        double tmp2 = 0.0;
        double tmp = 0.0;
        int i4 = 0;
        while (i4 < n) {
            tmp = -this.m_L[i4][i4];
            this.m_L[i4][i4] = 1.0 / tmp;
            int j = 0;
            while (j < n) {
                if (j != i4) {
                    if (j < i4) {
                        tmprow[j] = this.m_L[i4][j];
                        double[] dArray = this.m_L[i4];
                        int n2 = j;
                        dArray[n2] = dArray[n2] / tmp;
                        tmp2 = this.m_L[i4][j];
                        double[] dArray2 = this.m_L[j];
                        int n3 = j;
                        dArray2[n3] = dArray2[n3] + tmp2 * tmp2 * tmp;
                    } else if (j > i4) {
                        tmprow[j] = this.m_L[j][i4];
                        double[] dArray = this.m_L[j];
                        int n4 = i4;
                        dArray[n4] = dArray[n4] / tmp;
                        tmp2 = this.m_L[j][i4];
                        double[] dArray3 = this.m_L[j];
                        int n5 = j;
                        dArray3[n5] = dArray3[n5] + tmp2 * tmp2 * tmp;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < n) {
                if (j != i4) {
                    int k;
                    if (i4 < j) {
                        k = 0;
                        while (k < i4) {
                            double[] dArray = this.m_L[j];
                            int n6 = k;
                            dArray[n6] = dArray[n6] + tmprow[j] * this.m_L[i4][k];
                            ++k;
                        }
                    } else {
                        k = 0;
                        while (k < j) {
                            double[] dArray = this.m_L[j];
                            int n7 = k;
                            dArray[n7] = dArray[n7] + tmprow[j] * this.m_L[i4][k];
                            ++k;
                        }
                    }
                    k = i4 + 1;
                    while (k < j) {
                        double[] dArray = this.m_L[j];
                        int n8 = k;
                        dArray[n8] = dArray[n8] + tmprow[j] * this.m_L[k][i4];
                        ++k;
                    }
                }
                ++j;
            }
            ++i4;
        }
        this.m_t = new Matrix(insts.numInstances(), 1);
        double[] tt = new double[n];
        int i5 = 0;
        while (i5 < n) {
            tt[i5] = insts.instance(i5).classValue() - this.m_avg_target;
            ++i5;
        }
        i5 = 0;
        while (i5 < n) {
            double s = 0.0;
            int k = 0;
            while (k < i5) {
                s -= this.m_L[i5][k] * tt[k];
                ++k;
            }
            k = i5;
            while (k < n) {
                s -= this.m_L[k][i5] * tt[k];
                ++k;
            }
            this.m_t.set(i5, 0, s);
            ++i5;
        }
    }

    @Override
    public double classifyInstance(Instance inst) throws Exception {
        inst = this.filterInstance(inst);
        Matrix k = new Matrix(this.m_NumTrain, 1);
        int i = 0;
        while (i < this.m_NumTrain) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
            ++i;
        }
        double result = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        result = (result - this.m_Blin) / this.m_Alin;
        return result;
    }

    protected Instance filterInstance(Instance inst) throws Exception {
        if (!this.m_checksTurnedOff) {
            this.m_Missing.input(inst);
            this.m_Missing.batchFinished();
            inst = this.m_Missing.output();
        }
        if (this.m_NominalToBinary != null) {
            this.m_NominalToBinary.input(inst);
            this.m_NominalToBinary.batchFinished();
            inst = this.m_NominalToBinary.output();
        }
        if (this.m_Filter != null) {
            this.m_Filter.input(inst);
            this.m_Filter.batchFinished();
            inst = this.m_Filter.output();
        }
        return inst;
    }

    protected double computeStdDev(Instance inst, Matrix k) throws Exception {
        double kappa = this.m_kernel.eval(-1, -1, inst) + this.m_delta * this.m_delta;
        double s = 0.0;
        int n = this.m_L.length;
        int i = 0;
        while (i < n) {
            double t = 0.0;
            int j = 0;
            while (j < n) {
                t -= k.get(j, 0) * (i > j ? this.m_L[i][j] : this.m_L[j][i]);
                ++j;
            }
            s += t * k.get(i, 0);
            ++i;
        }
        double sigma = this.m_delta;
        if (kappa > s) {
            sigma = Math.sqrt(kappa - s);
        }
        return sigma;
    }

    @Override
    public double[][] predictIntervals(Instance inst, double confidenceLevel) throws Exception {
        inst = this.filterInstance(inst);
        Matrix k = new Matrix(this.m_NumTrain, 1);
        int i = 0;
        while (i < this.m_NumTrain) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
            ++i;
        }
        double estimate = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        double sigma = this.computeStdDev(inst, k);
        confidenceLevel = 1.0 - (1.0 - confidenceLevel) / 2.0;
        double z = Statistics.normalInverse(confidenceLevel);
        double[][] interval = new double[1][2];
        interval[0][0] = estimate - z * sigma;
        interval[0][1] = estimate + z * sigma;
        interval[0][0] = (interval[0][0] - this.m_Blin) / this.m_Alin;
        interval[0][1] = (interval[0][1] - this.m_Blin) / this.m_Alin;
        return interval;
    }

    public double getStandardDeviation(Instance inst) throws Exception {
        inst = this.filterInstance(inst);
        Matrix k = new Matrix(this.m_NumTrain, 1);
        int i = 0;
        while (i < this.m_NumTrain) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
            ++i;
        }
        return this.computeStdDev(inst, k) / this.m_Alin;
    }

    @Override
    public double logDensity(Instance inst, double value) throws Exception {
        inst = this.filterInstance(inst);
        Matrix k = new Matrix(this.m_NumTrain, 1);
        int i = 0;
        while (i < this.m_NumTrain) {
            k.set(i, 0, this.m_kernel.eval(-1, i, inst));
            ++i;
        }
        double estimate = k.transpose().times(this.m_t).get(0, 0) + this.m_avg_target;
        double sigma = this.computeStdDev(inst, k);
        value = value * this.m_Alin + this.m_Blin;
        double z = -Math.log(sigma * Math.sqrt(Math.PI * 2)) - (value -= estimate) * value / (2.0 * sigma * sigma);
        return z + Math.log(this.m_Alin);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        result.addElement(new Option("\tLevel of Gaussian Noise wrt transformed target. (default 1)", "L", 1, "-L <double>"));
        result.addElement(new Option("\tWhether to 0=normalize/1=standardize/2=neither. (default 0=normalize)", "N", 1, "-N"));
        result.addElement(new Option("\tThe Kernel to use.\n\t(default: weka.classifiers.functions.supportVector.PolyKernel)", "K", 1, "-K <classname and parameters>"));
        result.addElement(new Option("", "", 0, "\nOptions specific to kernel " + this.getKernel().getClass().getName() + ":"));
        enm = this.getKernel().listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('L', options);
        if (tmpStr.length() != 0) {
            this.setNoise(Double.parseDouble(tmpStr));
        } else {
            this.setNoise(1.0);
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setFilterType(new SelectedTag(Integer.parseInt(tmpStr), TAGS_FILTER));
        } else {
            this.setFilterType(new SelectedTag(0, TAGS_FILTER));
        }
        tmpStr = Utils.getOption('K', options);
        String[] tmpOptions = Utils.splitOptions(tmpStr);
        if (tmpOptions.length != 0) {
            tmpStr = tmpOptions[0];
            tmpOptions[0] = "";
            this.setKernel(Kernel.forName(tmpStr, tmpOptions));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.addElement(options[i]);
            ++i;
        }
        result.addElement("-L");
        result.addElement("" + this.getNoise());
        result.addElement("-N");
        result.addElement("" + this.m_filterType);
        result.addElement("-K");
        result.addElement(this.m_kernel.getClass().getName() + " " + Utils.joinOptions(this.m_kernel.getOptions()));
        return result.toArray(new String[result.size()]);
    }

    public String kernelTipText() {
        return "The kernel to use.";
    }

    public Kernel getKernel() {
        return this.m_kernel;
    }

    public void setKernel(Kernel value) {
        this.m_kernel = value;
    }

    public String filterTypeTipText() {
        return "Determines how/if the data will be transformed.";
    }

    public SelectedTag getFilterType() {
        return new SelectedTag(this.m_filterType, TAGS_FILTER);
    }

    public void setFilterType(SelectedTag newType) {
        if (newType.getTags() == TAGS_FILTER) {
            this.m_filterType = newType.getSelectedTag().getID();
        }
    }

    public String noiseTipText() {
        return "The level of Gaussian Noise (added to the diagonal of the Covariance Matrix), after the target has been normalized/standardized/left unchanged).";
    }

    public double getNoise() {
        return this.m_delta;
    }

    public void setNoise(double v) {
        this.m_delta = v;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.m_t == null) {
            return "Gaussian Processes: No model built yet.";
        }
        try {
            text.append("Gaussian Processes\n\n");
            text.append("Kernel used:\n  " + this.m_kernel.toString() + "\n\n");
            text.append("All values shown based on: " + TAGS_FILTER[this.m_filterType].getReadable() + "\n\n");
            text.append("Average Target Value : " + this.m_avg_target + "\n");
            text.append("Inverted Covariance Matrix:\n");
            double min = -this.m_L[0][0];
            double max = -this.m_L[0][0];
            int i = 0;
            while (i < this.m_NumTrain) {
                int j = 0;
                while (j <= i) {
                    if (-this.m_L[i][j] < min) {
                        min = -this.m_L[i][j];
                    } else if (-this.m_L[i][j] > max) {
                        max = -this.m_L[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n");
            text.append("Inverted Covariance Matrix * Target-value Vector:\n");
            min = this.m_t.get(0, 0);
            max = this.m_t.get(0, 0);
            i = 0;
            while (i < this.m_NumTrain) {
                if (this.m_t.get(i, 0) < min) {
                    min = this.m_t.get(i, 0);
                } else if (this.m_t.get(i, 0) > max) {
                    max = this.m_t.get(i, 0);
                }
                ++i;
            }
            text.append("    Lowest Value = " + min + "\n");
            text.append("    Highest Value = " + max + "\n \n");
        }
        catch (Exception e) {
            return "Can't print the classifier.";
        }
        return text.toString();
    }

    public static void main(String[] argv) {
        GaussianProcesses.runClassifier(new GaussianProcesses(), argv);
    }
}

