/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.rules.part.MakeDecList;
import weka.classifiers.trees.j48.BinC45ModelSelection;
import weka.classifiers.trees.j48.C45ModelSelection;
import weka.classifiers.trees.j48.ModelSelection;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class PART
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler,
Summarizable,
AdditionalMeasureProducer,
TechnicalInformationHandler {
    static final long serialVersionUID = 8121455039782598361L;
    private MakeDecList m_root;
    private float m_CF = 0.25f;
    private int m_minNumObj = 2;
    private boolean m_useMDLcorrection = true;
    private boolean m_reducedErrorPruning = false;
    private int m_numFolds = 3;
    private boolean m_binarySplits = false;
    private boolean m_unpruned = false;
    private int m_Seed = 1;

    public String globalInfo() {
        return "Class for generating a PART decision list. Uses separate-and-conquer. Builds a partial C4.5 decision tree in each iteration and makes the \"best\" leaf into a rule.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Eibe Frank and Ian H. Witten");
        result.setValue(TechnicalInformation.Field.TITLE, "Generating Accurate Rule Sets Without Global Optimization");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Fifteenth International Conference on Machine Learning");
        result.setValue(TechnicalInformation.Field.EDITOR, "J. Shavlik");
        result.setValue(TechnicalInformation.Field.YEAR, "1998");
        result.setValue(TechnicalInformation.Field.PAGES, "144-151");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Morgan Kaufmann");
        result.setValue(TechnicalInformation.Field.PS, "http://www.cs.waikato.ac.nz/~eibe/pubs/ML98-57.ps.gz");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.m_unpruned ? new MakeDecList(null, this.m_minNumObj).getCapabilities() : (this.m_reducedErrorPruning ? new MakeDecList(null, this.m_numFolds, this.m_minNumObj, this.m_Seed).getCapabilities() : new MakeDecList(null, this.m_CF, this.m_minNumObj).getCapabilities());
        return result;
    }

    @Override
    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        ModelSelection modSelection = this.m_binarySplits ? new BinC45ModelSelection(this.m_minNumObj, instances, this.m_useMDLcorrection) : new C45ModelSelection(this.m_minNumObj, instances, this.m_useMDLcorrection);
        this.m_root = this.m_unpruned ? new MakeDecList(modSelection, this.m_minNumObj) : (this.m_reducedErrorPruning ? new MakeDecList(modSelection, this.m_numFolds, this.m_minNumObj, this.m_Seed) : new MakeDecList(modSelection, this.m_CF, this.m_minNumObj));
        this.m_root.buildClassifier(instances);
        if (this.m_binarySplits) {
            ((BinC45ModelSelection)modSelection).cleanup();
        } else {
            ((C45ModelSelection)modSelection).cleanup();
        }
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        return this.m_root.classifyInstance(instance);
    }

    @Override
    public final double[] distributionForInstance(Instance instance) throws Exception {
        return this.m_root.distributionForInstance(instance);
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(8);
        newVector.addElement(new Option("\tSet confidence threshold for pruning.\n\t(default 0.25)", "C", 1, "-C <pruning confidence>"));
        newVector.addElement(new Option("\tSet minimum number of objects per leaf.\n\t(default 2)", "M", 1, "-M <minimum number of objects>"));
        newVector.addElement(new Option("\tUse reduced error pruning.", "R", 0, "-R"));
        newVector.addElement(new Option("\tSet number of folds for reduced error\n\tpruning. One fold is used as pruning set.\n\t(default 3)", "N", 1, "-N <number of folds>"));
        newVector.addElement(new Option("\tUse binary splits only.", "B", 0, "-B"));
        newVector.addElement(new Option("\tGenerate unpruned decision list.", "U", 0, "-U"));
        newVector.addElement(new Option("\tDo not use MDL correction for info gain on numeric attributes.", "J", 0, "-J"));
        newVector.addElement(new Option("\tSeed for random data shuffling (default 1).", "Q", 1, "-Q <seed>"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String numFoldsString;
        this.m_unpruned = Utils.getFlag('U', options);
        this.m_reducedErrorPruning = Utils.getFlag('R', options);
        this.m_binarySplits = Utils.getFlag('B', options);
        this.m_useMDLcorrection = !Utils.getFlag('J', options);
        String confidenceString = Utils.getOption('C', options);
        if (confidenceString.length() != 0) {
            if (this.m_reducedErrorPruning) {
                throw new Exception("Setting CF doesn't make sense for reduced error pruning.");
            }
            this.m_CF = new Float(confidenceString).floatValue();
            if (this.m_CF <= 0.0f || this.m_CF >= 1.0f) {
                throw new Exception("CF has to be greater than zero and smaller than one!");
            }
        } else {
            this.m_CF = 0.25f;
        }
        if ((numFoldsString = Utils.getOption('N', options)).length() != 0) {
            if (!this.m_reducedErrorPruning) {
                throw new Exception("Setting the number of folds does only make sense for reduced error pruning.");
            }
            this.m_numFolds = Integer.parseInt(numFoldsString);
        } else {
            this.m_numFolds = 3;
        }
        String minNumString = Utils.getOption('M', options);
        this.m_minNumObj = minNumString.length() != 0 ? Integer.parseInt(minNumString) : 2;
        String seedString = Utils.getOption('Q', options);
        this.m_Seed = seedString.length() != 0 ? Integer.parseInt(seedString) : 1;
    }

    @Override
    public String[] getOptions() {
        String[] options = new String[12];
        int current = 0;
        if (this.m_unpruned) {
            options[current++] = "-U";
        }
        if (this.m_reducedErrorPruning) {
            options[current++] = "-R";
        }
        if (this.m_binarySplits) {
            options[current++] = "-B";
        }
        options[current++] = "-M";
        options[current++] = "" + this.m_minNumObj;
        if (!this.m_reducedErrorPruning) {
            options[current++] = "-C";
            options[current++] = "" + this.m_CF;
        }
        if (this.m_reducedErrorPruning) {
            options[current++] = "-N";
            options[current++] = "" + this.m_numFolds;
        }
        options[current++] = "-Q";
        options[current++] = "" + this.m_Seed;
        if (!this.m_useMDLcorrection) {
            options[current++] = "-J";
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    public String toString() {
        if (this.m_root == null) {
            return "No classifier built";
        }
        return "PART decision list\n------------------\n\n" + this.m_root.toString();
    }

    @Override
    public String toSummaryString() {
        return "Number of rules: " + this.m_root.numRules() + "\n";
    }

    public double measureNumRules() {
        return this.m_root.numRules();
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(1);
        newVector.addElement("measureNumRules");
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumRules") == 0) {
            return this.measureNumRules();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (PART)");
    }

    public String confidenceFactorTipText() {
        return "The confidence factor used for pruning (smaller values incur more pruning).";
    }

    public float getConfidenceFactor() {
        return this.m_CF;
    }

    public void setConfidenceFactor(float v) {
        this.m_CF = v;
    }

    public String minNumObjTipText() {
        return "The minimum number of instances per rule.";
    }

    public int getMinNumObj() {
        return this.m_minNumObj;
    }

    public void setMinNumObj(int v) {
        this.m_minNumObj = v;
    }

    public String reducedErrorPruningTipText() {
        return "Whether reduced-error pruning is used instead of C.4.5 pruning.";
    }

    public boolean getReducedErrorPruning() {
        return this.m_reducedErrorPruning;
    }

    public void setReducedErrorPruning(boolean v) {
        this.m_reducedErrorPruning = v;
    }

    public String unprunedTipText() {
        return "Whether pruning is performed.";
    }

    public boolean getUnpruned() {
        return this.m_unpruned;
    }

    public void setUnpruned(boolean newunpruned) {
        this.m_unpruned = newunpruned;
    }

    public String useMDLcorrectionTipText() {
        return "Whether MDL correction is used when finding splits on numeric attributes.";
    }

    public boolean getUseMDLcorrection() {
        return this.m_useMDLcorrection;
    }

    public void setUseMDLcorrection(boolean newuseMDLcorrection) {
        this.m_useMDLcorrection = newuseMDLcorrection;
    }

    public String numFoldsTipText() {
        return "Determines the amount of data used for reduced-error pruning.  One fold is used for pruning, the rest for growing the rules.";
    }

    public int getNumFolds() {
        return this.m_numFolds;
    }

    public void setNumFolds(int v) {
        this.m_numFolds = v;
    }

    public String seedTipText() {
        return "The seed used for randomizing the data when reduced-error pruning is used.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int newSeed) {
        this.m_Seed = newSeed;
    }

    public String binarySplitsTipText() {
        return "Whether to use binary splits on nominal attributes when building the partial trees.";
    }

    public boolean getBinarySplits() {
        return this.m_binarySplits;
    }

    public void setBinarySplits(boolean v) {
        this.m_binarySplits = v;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6089 $");
    }

    public static void main(String[] argv) {
        PART.runClassifier(new PART(), argv);
    }
}

