/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import java.util.Enumeration;
import weka.classifiers.trees.j48.C45Split;
import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class C45ModelSelection
extends ModelSelection {
    private static final long serialVersionUID = 3372204862440821989L;
    private int m_minNoObj;
    private boolean m_useMDLcorrection;
    private Instances m_allData;

    public C45ModelSelection(int minNoObj, Instances allData, boolean useMDLcorrection) {
        this.m_minNoObj = minNoObj;
        this.m_allData = allData;
        this.m_useMDLcorrection = useMDLcorrection;
    }

    public void cleanup() {
        this.m_allData = null;
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances data) {
        ClassifierSplitModel bestModel = null;
        NoSplit noSplitModel = null;
        double averageInfoGain = 0.0;
        int validModels = 0;
        boolean multiVal = true;
        try {
            Distribution checkDistribution = new Distribution(data);
            noSplitModel = new NoSplit(checkDistribution);
            if (Utils.sm(checkDistribution.total(), 2 * this.m_minNoObj) || Utils.eq(checkDistribution.total(), checkDistribution.perClass(checkDistribution.maxClass()))) {
                return noSplitModel;
            }
            if (this.m_allData != null) {
                Enumeration enu = data.enumerateAttributes();
                while (enu.hasMoreElements()) {
                    Attribute attribute = (Attribute)enu.nextElement();
                    if (!attribute.isNumeric() && !Utils.sm(attribute.numValues(), 0.3 * (double)this.m_allData.numInstances())) continue;
                    multiVal = false;
                    break;
                }
            }
            C45Split[] currentModel = new C45Split[data.numAttributes()];
            double sumOfWeights = data.sumOfWeights();
            int i = 0;
            while (i < data.numAttributes()) {
                if (i != data.classIndex()) {
                    currentModel[i] = new C45Split(i, this.m_minNoObj, sumOfWeights, this.m_useMDLcorrection);
                    currentModel[i].buildClassifier(data);
                    if (currentModel[i].checkModel()) {
                        if (this.m_allData != null) {
                            if (data.attribute(i).isNumeric() || multiVal || Utils.sm(data.attribute(i).numValues(), 0.3 * (double)this.m_allData.numInstances())) {
                                averageInfoGain += currentModel[i].infoGain();
                                ++validModels;
                            }
                        } else {
                            averageInfoGain += currentModel[i].infoGain();
                            ++validModels;
                        }
                    }
                } else {
                    currentModel[i] = null;
                }
                ++i;
            }
            if (validModels == 0) {
                return noSplitModel;
            }
            averageInfoGain /= (double)validModels;
            double minResult = 0.0;
            i = 0;
            while (i < data.numAttributes()) {
                if (i != data.classIndex() && currentModel[i].checkModel() && currentModel[i].infoGain() >= averageInfoGain - 0.001 && Utils.gr(currentModel[i].gainRatio(), minResult)) {
                    bestModel = currentModel[i];
                    minResult = currentModel[i].gainRatio();
                }
                ++i;
            }
            if (Utils.eq(minResult, 0.0)) {
                return noSplitModel;
            }
            bestModel.distribution().addInstWithUnknown(data, ((C45Split)bestModel).attIndex());
            if (this.m_allData != null) {
                ((C45Split)bestModel).setSplitPoint(this.m_allData);
            }
            return bestModel;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public final ClassifierSplitModel selectModel(Instances train, Instances test) {
        return this.selectModel(train);
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6073 $");
    }
}

