/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees.j48;

import weka.classifiers.trees.j48.ClassifierSplitModel;
import weka.classifiers.trees.j48.ClassifierTree;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.classifiers.trees.j48.Stats;
import weka.core.Capabilities;
import weka.core.Instances;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class C45PruneableClassifierTree
extends ClassifierTree {
    static final long serialVersionUID = -4813820170260388194L;
    boolean m_pruneTheTree = false;
    boolean m_collapseTheTree = false;
    float m_CF = 0.25f;
    boolean m_subtreeRaising = true;
    boolean m_cleanup = true;

    public C45PruneableClassifierTree(ModelSelection toSelectLocModel, boolean pruneTree, float cf, boolean raiseTree, boolean cleanup, boolean collapseTree) throws Exception {
        super(toSelectLocModel);
        this.m_pruneTheTree = pruneTree;
        this.m_CF = cf;
        this.m_subtreeRaising = raiseTree;
        this.m_cleanup = cleanup;
        this.m_collapseTheTree = collapseTree;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.setMinimumNumberInstances(0);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        this.buildTree(data, this.m_subtreeRaising);
        if (this.m_collapseTheTree) {
            this.collapse();
        }
        if (this.m_pruneTheTree) {
            this.prune();
        }
        if (this.m_cleanup) {
            this.cleanup(new Instances(data, 0));
        }
    }

    public final void collapse() {
        if (!this.m_isLeaf) {
            double errorsOfTree;
            double errorsOfSubtree = this.getTrainingErrors();
            if (errorsOfSubtree >= (errorsOfTree = this.localModel().distribution().numIncorrect()) - 0.001) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
            } else {
                int i = 0;
                while (i < this.m_sons.length) {
                    this.son(i).collapse();
                    ++i;
                }
            }
        }
    }

    public void prune() throws Exception {
        if (!this.m_isLeaf) {
            double errorsTree;
            int i = 0;
            while (i < this.m_sons.length) {
                this.son(i).prune();
                ++i;
            }
            int indexOfLargestBranch = this.localModel().distribution().maxBag();
            double errorsLargestBranch = this.m_subtreeRaising ? this.son(indexOfLargestBranch).getEstimatedErrorsForBranch(this.m_train) : Double.MAX_VALUE;
            double errorsLeaf = this.getEstimatedErrorsForDistribution(this.localModel().distribution());
            if (Utils.smOrEq(errorsLeaf, (errorsTree = this.getEstimatedErrors()) + 0.1) && Utils.smOrEq(errorsLeaf, errorsLargestBranch + 0.1)) {
                this.m_sons = null;
                this.m_isLeaf = true;
                this.m_localModel = new NoSplit(this.localModel().distribution());
                return;
            }
            if (Utils.smOrEq(errorsLargestBranch, errorsTree + 0.1)) {
                C45PruneableClassifierTree largestBranch = this.son(indexOfLargestBranch);
                this.m_sons = largestBranch.m_sons;
                this.m_localModel = largestBranch.localModel();
                this.m_isLeaf = largestBranch.m_isLeaf;
                this.newDistribution(this.m_train);
                this.prune();
            }
        }
    }

    @Override
    protected ClassifierTree getNewTree(Instances data) throws Exception {
        C45PruneableClassifierTree newTree = new C45PruneableClassifierTree(this.m_toSelectModel, this.m_pruneTheTree, this.m_CF, this.m_subtreeRaising, this.m_cleanup, this.m_collapseTheTree);
        newTree.buildTree(data, this.m_subtreeRaising);
        return newTree;
    }

    private double getEstimatedErrors() {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(this.localModel().distribution());
        }
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.son(i).getEstimatedErrors();
            ++i;
        }
        return errors;
    }

    private double getEstimatedErrorsForBranch(Instances data) throws Exception {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.getEstimatedErrorsForDistribution(new Distribution(data));
        }
        Distribution savedDist = this.localModel().m_distribution;
        this.localModel().resetDistribution(data);
        Instances[] localInstances = this.localModel().split(data);
        this.localModel().m_distribution = savedDist;
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.son(i).getEstimatedErrorsForBranch(localInstances[i]);
            ++i;
        }
        return errors;
    }

    private double getEstimatedErrorsForDistribution(Distribution theDistribution) {
        if (Utils.eq(theDistribution.total(), 0.0)) {
            return 0.0;
        }
        return theDistribution.numIncorrect() + Stats.addErrs(theDistribution.total(), theDistribution.numIncorrect(), this.m_CF);
    }

    private double getTrainingErrors() {
        double errors = 0.0;
        if (this.m_isLeaf) {
            return this.localModel().distribution().numIncorrect();
        }
        int i = 0;
        while (i < this.m_sons.length) {
            errors += this.son(i).getTrainingErrors();
            ++i;
        }
        return errors;
    }

    private ClassifierSplitModel localModel() {
        return this.m_localModel;
    }

    private void newDistribution(Instances data) throws Exception {
        this.localModel().resetDistribution(data);
        this.m_train = data;
        if (!this.m_isLeaf) {
            Instances[] localInstances = this.localModel().split(data);
            int i = 0;
            while (i < this.m_sons.length) {
                this.son(i).newDistribution(localInstances[i]);
                ++i;
            }
        } else if (!Utils.eq(data.sumOfWeights(), 0.0)) {
            this.m_isEmpty = false;
        }
    }

    private C45PruneableClassifierTree son(int index) {
        return (C45PruneableClassifierTree)this.m_sons[index];
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 6073 $");
    }
}

