/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import weka.classifiers.CostMatrix;
import weka.classifiers.Evaluation;
import weka.core.FastVector;
import weka.core.Instances;

public class AggregateableEvaluation
extends Evaluation {
    private static final long serialVersionUID = 8734675926526110924L;

    public AggregateableEvaluation(Instances data) throws Exception {
        super(data);
    }

    public AggregateableEvaluation(Instances data, CostMatrix costMatrix) throws Exception {
        super(data, costMatrix);
    }

    public AggregateableEvaluation(Evaluation eval) throws Exception {
        super(eval.m_Header, eval.m_CostMatrix);
        this.m_NoPriors = eval.m_NoPriors;
        this.m_NumTrainClassVals = eval.m_NumTrainClassVals;
        this.m_TrainClassVals = eval.m_TrainClassVals;
        this.m_TrainClassWeights = eval.m_TrainClassWeights;
        this.m_PriorEstimator = eval.m_PriorEstimator;
        this.m_MinTarget = eval.m_MinTarget;
        this.m_MaxTarget = eval.m_MaxTarget;
        this.m_ClassPriorsSum = eval.m_ClassPriorsSum;
        this.m_ClassPriors = eval.m_ClassPriors;
    }

    public void aggregate(Evaluation evaluation) {
        double[] newClassPriors;
        int i;
        double[][] newMatrix;
        this.m_Incorrect += evaluation.incorrect();
        this.m_Correct += evaluation.correct();
        this.m_Unclassified += evaluation.unclassified();
        this.m_MissingClass += evaluation.m_MissingClass;
        this.m_WithClass += evaluation.m_WithClass;
        if (evaluation.m_ConfusionMatrix != null && (newMatrix = evaluation.confusionMatrix()) != null) {
            i = 0;
            while (i < this.m_ConfusionMatrix.length) {
                int j = 0;
                while (j < this.m_ConfusionMatrix[i].length) {
                    double[] dArray = this.m_ConfusionMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + newMatrix[i][j];
                    ++j;
                }
                ++i;
            }
        }
        if ((newClassPriors = evaluation.m_ClassPriors) != null) {
            i = 0;
            while (i < this.m_ClassPriors.length) {
                this.m_ClassPriors[i] = newClassPriors[i];
                ++i;
            }
        }
        this.m_ClassPriorsSum = evaluation.m_ClassPriorsSum;
        this.m_TotalCost += evaluation.totalCost();
        this.m_SumErr += evaluation.m_SumErr;
        this.m_SumAbsErr += evaluation.m_SumAbsErr;
        this.m_SumSqrErr += evaluation.m_SumSqrErr;
        this.m_SumClass += evaluation.m_SumClass;
        this.m_SumSqrClass += evaluation.m_SumSqrClass;
        this.m_SumPredicted += evaluation.m_SumPredicted;
        this.m_SumSqrPredicted += evaluation.m_SumSqrPredicted;
        this.m_SumClassPredicted += evaluation.m_SumClassPredicted;
        this.m_SumPriorAbsErr += evaluation.m_SumPriorAbsErr;
        this.m_SumPriorSqrErr += evaluation.m_SumPriorSqrErr;
        this.m_SumKBInfo += evaluation.m_SumKBInfo;
        double[] newMarginCounts = evaluation.m_MarginCounts;
        if (newMarginCounts != null) {
            int i2 = 0;
            while (i2 < this.m_MarginCounts.length) {
                int n = i2;
                this.m_MarginCounts[n] = this.m_MarginCounts[n] + newMarginCounts[i2];
                ++i2;
            }
        }
        this.m_SumPriorEntropy += evaluation.m_SumPriorEntropy;
        this.m_SumSchemeEntropy += evaluation.m_SumSchemeEntropy;
        this.m_TotalSizeOfRegions += evaluation.m_TotalSizeOfRegions;
        this.m_TotalCoverage += evaluation.m_TotalCoverage;
        FastVector predsToAdd = evaluation.m_Predictions;
        if (predsToAdd != null) {
            if (this.m_Predictions == null) {
                this.m_Predictions = new FastVector();
            }
            int i3 = 0;
            while (i3 < predsToAdd.size()) {
                this.m_Predictions.addElement(predsToAdd.elementAt(i3));
                ++i3;
            }
        }
    }
}

