/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.Random;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.ConditionalDensityEstimator;
import weka.classifiers.CostMatrix;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.Sourcable;
import weka.classifiers.UpdateableClassifier;
import weka.classifiers.evaluation.NominalPrediction;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.classifiers.evaluation.output.prediction.AbstractOutput;
import weka.classifiers.evaluation.output.prediction.PlainText;
import weka.classifiers.misc.InputMappedClassifier;
import weka.classifiers.pmml.consumer.PMMLClassifier;
import weka.classifiers.xml.XMLClassifier;
import weka.core.Drawable;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.core.Version;
import weka.core.converters.ConverterUtils;
import weka.core.pmml.PMMLFactory;
import weka.core.pmml.PMMLModel;
import weka.core.xml.KOML;
import weka.core.xml.XMLOptions;
import weka.estimators.UnivariateKernelEstimator;
import weka.experiment.Stats;

public class Evaluation
implements Summarizable,
RevisionHandler,
Serializable {
    private static final long serialVersionUID = -7010314486866816271L;
    protected int m_NumClasses;
    protected int m_NumFolds;
    protected double m_Incorrect;
    protected double m_Correct;
    protected double m_Unclassified;
    protected double m_MissingClass;
    protected double m_WithClass;
    protected double[][] m_ConfusionMatrix;
    protected String[] m_ClassNames;
    protected boolean m_ClassIsNominal;
    protected double[] m_ClassPriors;
    protected double m_ClassPriorsSum;
    protected CostMatrix m_CostMatrix;
    protected double m_TotalCost;
    protected double m_SumErr;
    protected double m_SumAbsErr;
    protected double m_SumSqrErr;
    protected double m_SumClass;
    protected double m_SumSqrClass;
    protected double m_SumPredicted;
    protected double m_SumSqrPredicted;
    protected double m_SumClassPredicted;
    protected double m_SumPriorAbsErr;
    protected double m_SumPriorSqrErr;
    protected double m_SumKBInfo;
    protected static int k_MarginResolution = 500;
    protected double[] m_MarginCounts;
    protected int m_NumTrainClassVals;
    protected double[] m_TrainClassVals;
    protected double[] m_TrainClassWeights;
    protected UnivariateKernelEstimator m_PriorEstimator;
    protected boolean m_ComplexityStatisticsAvailable = true;
    protected static final double MIN_SF_PROB = Double.MIN_VALUE;
    protected double m_SumPriorEntropy;
    protected double m_SumSchemeEntropy;
    protected boolean m_CoverageStatisticsAvailable = true;
    protected double m_ConfLevel = 0.95;
    protected double m_TotalSizeOfRegions;
    protected double m_TotalCoverage;
    protected double m_MinTarget;
    protected double m_MaxTarget;
    protected FastVector m_Predictions;
    protected boolean m_NoPriors = false;
    protected Instances m_Header;
    protected boolean m_DiscardPredictions;

    public Evaluation(Instances data) throws Exception {
        this(data, null);
    }

    public Evaluation(Instances data, CostMatrix costMatrix) throws Exception {
        this.m_Header = new Instances(data, 0);
        this.m_NumClasses = data.numClasses();
        this.m_NumFolds = 1;
        this.m_ClassIsNominal = data.classAttribute().isNominal();
        if (this.m_ClassIsNominal) {
            this.m_ConfusionMatrix = new double[this.m_NumClasses][this.m_NumClasses];
            this.m_ClassNames = new String[this.m_NumClasses];
            int i = 0;
            while (i < this.m_NumClasses) {
                this.m_ClassNames[i] = data.classAttribute().value(i);
                ++i;
            }
        }
        this.m_CostMatrix = costMatrix;
        if (this.m_CostMatrix != null) {
            if (!this.m_ClassIsNominal) {
                throw new Exception("Class has to be nominal if cost matrix given!");
            }
            if (this.m_CostMatrix.size() != this.m_NumClasses) {
                throw new Exception("Cost matrix not compatible with data!");
            }
        }
        this.m_ClassPriors = new double[this.m_NumClasses];
        this.setPriors(data);
        this.m_MarginCounts = new double[k_MarginResolution + 1];
    }

    public Instances getHeader() {
        return this.m_Header;
    }

    public void setDiscardPredictions(boolean value) {
        this.m_DiscardPredictions = value;
        if (this.m_DiscardPredictions) {
            this.m_Predictions = null;
        }
    }

    public boolean getDiscardPredictions() {
        return this.m_DiscardPredictions;
    }

    public double areaUnderROC(int classIndex) {
        if (this.m_Predictions == null) {
            return Utils.missingValue();
        }
        ThresholdCurve tc = new ThresholdCurve();
        Instances result = tc.getCurve(this.m_Predictions, classIndex);
        return ThresholdCurve.getROCArea(result);
    }

    public double weightedAreaUnderROC() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double aucTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.areaUnderROC(i2);
            if (!Utils.isMissingValue(temp)) {
                aucTotal += temp * classCounts[i2];
            }
            ++i2;
        }
        return aucTotal / classCountSum;
    }

    public double areaUnderPRC(int classIndex) {
        if (this.m_Predictions == null) {
            return Utils.missingValue();
        }
        ThresholdCurve tc = new ThresholdCurve();
        Instances result = tc.getCurve(this.m_Predictions, classIndex);
        return ThresholdCurve.getPRCArea(result);
    }

    public double weightedAreaUnderPRC() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double auprcTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.areaUnderPRC(i2);
            if (!Utils.isMissingValue(temp)) {
                auprcTotal += temp * classCounts[i2];
            }
            ++i2;
        }
        return auprcTotal / classCountSum;
    }

    public double[][] confusionMatrix() {
        double[][] newMatrix = new double[this.m_ConfusionMatrix.length][0];
        int i = 0;
        while (i < this.m_ConfusionMatrix.length) {
            newMatrix[i] = new double[this.m_ConfusionMatrix[i].length];
            System.arraycopy(this.m_ConfusionMatrix[i], 0, newMatrix[i], 0, this.m_ConfusionMatrix[i].length);
            ++i;
        }
        return newMatrix;
    }

    public void crossValidateModel(Classifier classifier, Instances data, int numFolds, Random random, Object ... forPredictionsPrinting) throws Exception {
        data = new Instances(data);
        data.randomize(random);
        if (data.classAttribute().isNominal()) {
            data.stratify(numFolds);
        }
        AbstractOutput classificationOutput = null;
        if (forPredictionsPrinting.length > 0) {
            classificationOutput = (AbstractOutput)forPredictionsPrinting[0];
            classificationOutput.setHeader(data);
            classificationOutput.printHeader();
        }
        int i = 0;
        while (i < numFolds) {
            Instances train = data.trainCV(numFolds, i, random);
            this.setPriors(train);
            Classifier copiedClassifier = AbstractClassifier.makeCopy(classifier);
            copiedClassifier.buildClassifier(train);
            Instances test = data.testCV(numFolds, i);
            this.evaluateModel(copiedClassifier, test, forPredictionsPrinting);
            ++i;
        }
        this.m_NumFolds = numFolds;
        if (classificationOutput != null) {
            classificationOutput.printFooter();
        }
    }

    public void crossValidateModel(String classifierString, Instances data, int numFolds, String[] options, Random random) throws Exception {
        this.crossValidateModel(AbstractClassifier.forName(classifierString, options), data, numFolds, random, new Object[0]);
    }

    public static String evaluateModel(String classifierString, String[] options) throws Exception {
        Classifier classifier;
        try {
            classifier = AbstractClassifier.forName(classifierString, null);
        }
        catch (Exception e) {
            throw new Exception("Can't find class with name " + classifierString + '.');
        }
        return Evaluation.evaluateModel(classifier, options);
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("The first argument must be the class name of a classifier");
            }
            String classifier = args[0];
            args[0] = "";
            System.out.println(Evaluation.evaluateModel(classifier, args));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }

    public static String evaluateModel(Classifier classifier, String[] options) throws Exception {
        Instance trainInst;
        String thresholdLabel;
        String thresholdFile;
        String sourceClass;
        String objectOutputFileName;
        String objectInputFileName;
        Instances train = null;
        Instances test = null;
        Instances template = null;
        int seed = 1;
        int folds = 10;
        int classIndex = -1;
        boolean noCrossValidation = false;
        boolean noOutput = false;
        boolean trainStatistics = true;
        boolean printMargins = false;
        boolean printComplexityStatistics = false;
        boolean printGraph = false;
        boolean classStatistics = false;
        boolean printSource = false;
        StringBuffer text = new StringBuffer();
        ConverterUtils.DataSource trainSource = null;
        ConverterUtils.DataSource testSource = null;
        ObjectInputStream objectInputStream = null;
        BufferedInputStream xmlInputStream = null;
        CostMatrix costMatrix = null;
        StringBuffer schemeOptionsText = null;
        long trainTimeStart = 0L;
        long trainTimeElapsed = 0L;
        long testTimeStart = 0L;
        long testTimeElapsed = 0L;
        String xml = "";
        String[] optionsTmp = null;
        Classifier classifierClassifications = null;
        int actualClassIndex = -1;
        String splitPercentageString = "";
        double splitPercentage = -1.0;
        boolean preserveOrder = false;
        boolean trainSetPresent = false;
        boolean testSetPresent = false;
        boolean discardPredictions = false;
        StringBuffer predsBuff = null;
        AbstractOutput classificationOutput = null;
        if (Utils.getFlag("h", options) || Utils.getFlag("help", options)) {
            boolean globalInfo = Utils.getFlag("synopsis", options) || Utils.getFlag("info", options);
            throw new Exception("\nHelp requested." + Evaluation.makeOptionString(classifier, globalInfo));
        }
        try {
            String seedString;
            xml = Utils.getOption("xml", options);
            if (!xml.equals("")) {
                options = new XMLOptions(xml).toArray();
            }
            optionsTmp = new String[options.length];
            int i = 0;
            while (i < options.length) {
                optionsTmp[i] = options[i];
                ++i;
            }
            String tmpO = Utils.getOption('l', optionsTmp);
            if (tmpO.endsWith(".xml")) {
                boolean success = false;
                try {
                    PMMLModel pmmlModel = PMMLFactory.getPMMLModel(tmpO);
                    if (pmmlModel instanceof PMMLClassifier) {
                        classifier = (PMMLClassifier)pmmlModel;
                        success = true;
                    }
                }
                catch (IllegalArgumentException ex) {
                    success = false;
                }
                if (!success) {
                    XMLClassifier xmlserial = new XMLClassifier();
                    OptionHandler cl = (OptionHandler)xmlserial.read(Utils.getOption('l', options));
                    optionsTmp = new String[options.length + cl.getOptions().length];
                    System.arraycopy(cl.getOptions(), 0, optionsTmp, 0, cl.getOptions().length);
                    System.arraycopy(options, 0, optionsTmp, cl.getOptions().length, options.length);
                    options = optionsTmp;
                }
            }
            noCrossValidation = Utils.getFlag("no-cv", options);
            String classIndexString = Utils.getOption('c', options);
            if (classIndexString.length() != 0) {
                classIndex = classIndexString.equals("first") ? 1 : (classIndexString.equals("last") ? -1 : Integer.parseInt(classIndexString));
            }
            String trainFileName = Utils.getOption('t', options);
            objectInputFileName = Utils.getOption('l', options);
            objectOutputFileName = Utils.getOption('d', options);
            String testFileName = Utils.getOption('T', options);
            String foldsString = Utils.getOption('x', options);
            if (foldsString.length() != 0) {
                folds = Integer.parseInt(foldsString);
            }
            if ((seedString = Utils.getOption('s', options)).length() != 0) {
                seed = Integer.parseInt(seedString);
            }
            if (trainFileName.length() == 0) {
                if (objectInputFileName.length() == 0) {
                    throw new Exception("No training file and no object input file given.");
                }
                if (testFileName.length() == 0) {
                    throw new Exception("No training file and no test file given.");
                }
            } else if (!(objectInputFileName.length() == 0 || classifier instanceof UpdateableClassifier && testFileName.length() != 0)) {
                throw new Exception("Classifier not incremental, or no test file provided: can't use both train and model file.");
            }
            try {
                if (trainFileName.length() != 0) {
                    trainSetPresent = true;
                    trainSource = new ConverterUtils.DataSource(trainFileName);
                }
                if (testFileName.length() != 0) {
                    testSetPresent = true;
                    testSource = new ConverterUtils.DataSource(testFileName);
                }
                if (objectInputFileName.length() != 0) {
                    if (objectInputFileName.endsWith(".xml")) {
                        objectInputStream = null;
                        xmlInputStream = null;
                    } else {
                        InputStream is = new FileInputStream(objectInputFileName);
                        if (objectInputFileName.endsWith(".gz")) {
                            is = new GZIPInputStream(is);
                        }
                        if (!objectInputFileName.endsWith(".koml") || !KOML.isPresent()) {
                            objectInputStream = new ObjectInputStream(is);
                            xmlInputStream = null;
                        } else {
                            objectInputStream = null;
                            xmlInputStream = new BufferedInputStream(is);
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + '.');
            }
            if (testSetPresent) {
                template = test = testSource.getStructure();
                if (classIndex != -1) {
                    test.setClassIndex(classIndex - 1);
                } else if (test.classIndex() == -1 || classIndexString.length() != 0) {
                    test.setClassIndex(test.numAttributes() - 1);
                }
                actualClassIndex = test.classIndex();
            } else {
                splitPercentageString = Utils.getOption("split-percentage", options);
                if (splitPercentageString.length() != 0) {
                    if (foldsString.length() != 0) {
                        throw new Exception("Percentage split cannot be used in conjunction with cross-validation ('-x').");
                    }
                    splitPercentage = Double.parseDouble(splitPercentageString);
                    if (splitPercentage <= 0.0 || splitPercentage >= 100.0) {
                        throw new Exception("Percentage split value needs be >0 and <100.");
                    }
                } else {
                    splitPercentage = -1.0;
                }
                if ((preserveOrder = Utils.getFlag("preserve-order", options)) && splitPercentage == -1.0) {
                    throw new Exception("Percentage split ('-percentage-split') is missing.");
                }
                if (splitPercentage > 0.0) {
                    testSetPresent = true;
                    Instances tmpInst = trainSource.getDataSet(actualClassIndex);
                    if (!preserveOrder) {
                        tmpInst.randomize(new Random(seed));
                    }
                    int trainSize = (int)Math.round((double)tmpInst.numInstances() * splitPercentage / 100.0);
                    int testSize = tmpInst.numInstances() - trainSize;
                    Instances trainInst2 = new Instances(tmpInst, 0, trainSize);
                    Instances testInst = new Instances(tmpInst, trainSize, testSize);
                    trainSource = new ConverterUtils.DataSource(trainInst2);
                    testSource = new ConverterUtils.DataSource(testInst);
                    template = test = testSource.getStructure();
                    if (classIndex != -1) {
                        test.setClassIndex(classIndex - 1);
                    } else if (test.classIndex() == -1 || classIndexString.length() != 0) {
                        test.setClassIndex(test.numAttributes() - 1);
                    }
                    actualClassIndex = test.classIndex();
                }
            }
            if (trainSetPresent) {
                template = train = trainSource.getStructure();
                if (classIndex != -1) {
                    train.setClassIndex(classIndex - 1);
                } else if (train.classIndex() == -1 || classIndexString.length() != 0) {
                    train.setClassIndex(train.numAttributes() - 1);
                }
                actualClassIndex = train.classIndex();
                if (!(classifier instanceof InputMappedClassifier) && testSetPresent && !test.equalHeaders(train)) {
                    throw new IllegalArgumentException("Train and test file not compatible!\n" + test.equalHeadersMsg(train));
                }
            }
            if (template == null) {
                throw new Exception("No actual dataset provided to use as template");
            }
            costMatrix = Evaluation.handleCostOption(Utils.getOption('m', options), template.numClasses());
            classStatistics = Utils.getFlag('i', options);
            noOutput = Utils.getFlag('o', options);
            trainStatistics = !Utils.getFlag('v', options);
            printComplexityStatistics = Utils.getFlag('k', options);
            printMargins = Utils.getFlag('r', options);
            printGraph = Utils.getFlag('g', options);
            sourceClass = Utils.getOption('z', options);
            printSource = sourceClass.length() != 0;
            thresholdFile = Utils.getOption("threshold-file", options);
            thresholdLabel = Utils.getOption("threshold-label", options);
            String classifications = Utils.getOption("classifications", options);
            String classificationsOld = Utils.getOption("p", options);
            if (classifications.length() > 0) {
                noOutput = true;
                classificationOutput = AbstractOutput.fromCommandline(classifications);
                if (classificationOutput == null) {
                    throw new Exception("Failed to instantiate class for classification output: " + classifications);
                }
                classificationOutput.setHeader(template);
            } else if (classificationsOld.length() > 0) {
                noOutput = true;
                classificationOutput = new PlainText();
                classificationOutput.setHeader(template);
                if (!classificationsOld.equals("0")) {
                    classificationOutput.setAttributes(classificationsOld);
                }
                classificationOutput.setOutputDistribution(Utils.getFlag("distribution", options));
            } else if (Utils.getFlag("distribution", options)) {
                throw new Exception("Cannot print distribution without '-p' option!");
            }
            discardPredictions = Utils.getFlag("no-predictions", options);
            if (discardPredictions && classificationOutput != null) {
                throw new Exception("Cannot discard predictions ('-no-predictions') and output predictions at the same time ('-classifications/-p')!");
            }
            if (!trainSetPresent && printComplexityStatistics) {
                throw new Exception("Cannot print complexity statistics ('-k') without training file ('-t')!");
            }
            if (objectInputFileName.length() != 0) {
                Utils.checkForRemainingOptions(options);
            } else if (classifier instanceof OptionHandler) {
                int i2 = 0;
                while (i2 < options.length) {
                    if (options[i2].length() != 0) {
                        if (schemeOptionsText == null) {
                            schemeOptionsText = new StringBuffer();
                        }
                        if (options[i2].indexOf(32) != -1) {
                            schemeOptionsText.append(String.valueOf('\"') + options[i2] + "\" ");
                        } else {
                            schemeOptionsText.append(String.valueOf(options[i2]) + " ");
                        }
                    }
                    ++i2;
                }
                ((OptionHandler)((Object)classifier)).setOptions(options);
            }
            Utils.checkForRemainingOptions(options);
        }
        catch (Exception e) {
            throw new Exception("\nWeka exception: " + e.getMessage() + Evaluation.makeOptionString(classifier, false));
        }
        if (objectInputFileName.length() != 0) {
            if (objectInputStream != null) {
                classifier = (Classifier)objectInputStream.readObject();
                Instances savedStructure = null;
                try {
                    savedStructure = (Instances)objectInputStream.readObject();
                }
                catch (Exception classifications) {
                    // empty catch block
                }
                if (savedStructure != null && !template.equalHeaders(savedStructure)) {
                    throw new Exception("training and test set are not compatible\n" + template.equalHeadersMsg(savedStructure));
                }
                objectInputStream.close();
            } else if (xmlInputStream != null) {
                classifier = (Classifier)KOML.read(xmlInputStream);
                xmlInputStream.close();
            }
        }
        Evaluation trainingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
        Evaluation testingEvaluation = new Evaluation(new Instances(template, 0), costMatrix);
        if (classifier instanceof InputMappedClassifier) {
            Instances mappedClassifierHeader = ((InputMappedClassifier)classifier).getModelHeader(new Instances(template, 0));
            trainingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
            testingEvaluation = new Evaluation(new Instances(mappedClassifierHeader, 0), costMatrix);
        }
        trainingEvaluation.setDiscardPredictions(discardPredictions);
        testingEvaluation.setDiscardPredictions(discardPredictions);
        if (!trainSetPresent) {
            testingEvaluation.useNoPriors();
        }
        Classifier classifierBackup = AbstractClassifier.makeCopy(classifier);
        if (classifier instanceof UpdateableClassifier && (testSetPresent || noCrossValidation) && costMatrix == null && trainSetPresent) {
            trainingEvaluation.setPriors(train);
            testingEvaluation.setPriors(train);
            trainTimeStart = System.currentTimeMillis();
            if (objectInputFileName.length() == 0) {
                classifier.buildClassifier(train);
            }
            while (trainSource.hasMoreElements(train)) {
                trainInst = trainSource.nextElement(train);
                trainingEvaluation.updatePriors(trainInst);
                testingEvaluation.updatePriors(trainInst);
                ((UpdateableClassifier)((Object)classifier)).updateClassifier(trainInst);
            }
            trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        } else if (objectInputFileName.length() == 0) {
            Instances tempTrain = trainSource.getDataSet(actualClassIndex);
            if (classifier instanceof InputMappedClassifier && !trainingEvaluation.getHeader().equalHeaders(tempTrain)) {
                Instances mappedClassifierDataset = ((InputMappedClassifier)classifier).getModelHeader(new Instances(template, 0));
                int zz = 0;
                while (zz < tempTrain.numInstances()) {
                    Instance mapped = ((InputMappedClassifier)classifier).constructMappedInstance(tempTrain.instance(zz));
                    mappedClassifierDataset.add(mapped);
                    ++zz;
                }
                tempTrain = mappedClassifierDataset;
            }
            trainingEvaluation.setPriors(tempTrain);
            testingEvaluation.setPriors(tempTrain);
            trainTimeStart = System.currentTimeMillis();
            classifier.buildClassifier(tempTrain);
            trainTimeElapsed = System.currentTimeMillis() - trainTimeStart;
        }
        if (classificationOutput != null) {
            classifierClassifications = AbstractClassifier.makeCopy(classifier);
            if (classifier instanceof InputMappedClassifier) {
                classificationOutput.setHeader(trainingEvaluation.getHeader());
            }
        }
        if (objectOutputFileName.length() != 0) {
            OutputStream os = new FileOutputStream(objectOutputFileName);
            if (!(objectOutputFileName.endsWith(".xml") || objectOutputFileName.endsWith(".koml") && KOML.isPresent())) {
                if (objectOutputFileName.endsWith(".gz")) {
                    os = new GZIPOutputStream(os);
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(os);
                objectOutputStream.writeObject(classifier);
                objectOutputStream.writeObject(template);
                objectOutputStream.flush();
                objectOutputStream.close();
            } else {
                BufferedOutputStream xmlOutputStream = new BufferedOutputStream(os);
                if (objectOutputFileName.endsWith(".xml")) {
                    XMLClassifier xmlSerial = new XMLClassifier();
                    xmlSerial.write(xmlOutputStream, (Object)classifier);
                } else if (objectOutputFileName.endsWith(".koml")) {
                    KOML.write(xmlOutputStream, (Object)classifier);
                }
                xmlOutputStream.close();
            }
        }
        if (classifier instanceof Drawable && printGraph) {
            return ((Drawable)((Object)classifier)).graph();
        }
        if (classifier instanceof Sourcable && printSource) {
            return Evaluation.wekaStaticWrapper((Sourcable)((Object)classifier), sourceClass);
        }
        if (!noOutput && !printMargins) {
            if (classifier instanceof OptionHandler && schemeOptionsText != null) {
                text.append("\nOptions: " + schemeOptionsText);
                text.append("\n");
            }
            text.append("\n" + classifier.toString() + "\n");
        }
        if (!printMargins && costMatrix != null) {
            text.append("\n=== Evaluation Cost Matrix ===\n\n");
            text.append(costMatrix.toString());
        }
        if (classificationOutput != null) {
            ConverterUtils.DataSource source = testSource;
            predsBuff = new StringBuffer();
            classificationOutput.setBuffer(predsBuff);
            if (source == null && noCrossValidation) {
                source = trainSource;
                predsBuff.append("\n=== Predictions on training data ===\n\n");
            } else {
                predsBuff.append("\n=== Predictions on test data ===\n\n");
            }
            if (source != null) {
                classificationOutput.print(classifierClassifications, source);
            }
        }
        if (trainStatistics && trainSetPresent) {
            if (classifier instanceof UpdateableClassifier && testSetPresent && costMatrix == null) {
                trainSource.reset();
                train = trainSource.getStructure(actualClassIndex);
                testTimeStart = System.currentTimeMillis();
                while (trainSource.hasMoreElements(train)) {
                    trainInst = trainSource.nextElement(train);
                    trainingEvaluation.evaluateModelOnce(classifier, trainInst);
                }
                testTimeElapsed = System.currentTimeMillis() - testTimeStart;
            } else {
                testTimeStart = System.currentTimeMillis();
                trainingEvaluation.evaluateModel(classifier, trainSource.getDataSet(actualClassIndex), new Object[0]);
                testTimeElapsed = System.currentTimeMillis() - testTimeStart;
            }
            if (printMargins) {
                return trainingEvaluation.toCumulativeMarginDistributionString();
            }
            if (classificationOutput == null) {
                text.append("\nTime taken to build model: " + Utils.doubleToString((double)trainTimeElapsed / 1000.0, 2) + " seconds");
                if (splitPercentage > 0.0) {
                    text.append("\nTime taken to test model on training split: ");
                } else {
                    text.append("\nTime taken to test model on training data: ");
                }
                text.append(String.valueOf(Utils.doubleToString((double)testTimeElapsed / 1000.0, 2)) + " seconds");
                if (splitPercentage > 0.0) {
                    text.append(trainingEvaluation.toSummaryString("\n\n=== Error on training split ===\n", printComplexityStatistics));
                } else {
                    text.append(trainingEvaluation.toSummaryString("\n\n=== Error on training data ===\n", printComplexityStatistics));
                }
                if (template.classAttribute().isNominal()) {
                    if (classStatistics) {
                        text.append("\n\n" + trainingEvaluation.toClassDetailsString());
                    }
                    if (!noCrossValidation) {
                        text.append("\n\n" + trainingEvaluation.toMatrixString());
                    }
                }
            }
        }
        if (testSource != null) {
            testSource.reset();
            test = testSource.getStructure(test.classIndex());
            while (testSource.hasMoreElements(test)) {
                Instance testInst = testSource.nextElement(test);
                testingEvaluation.evaluateModelOnceAndRecordPrediction(classifier, testInst);
            }
            if (splitPercentage > 0.0) {
                if (classificationOutput == null) {
                    text.append("\n\n" + testingEvaluation.toSummaryString("=== Error on test split ===\n", printComplexityStatistics));
                }
            } else if (classificationOutput == null) {
                text.append("\n\n" + testingEvaluation.toSummaryString("=== Error on test data ===\n", printComplexityStatistics));
            }
        } else if (trainSource != null && !noCrossValidation) {
            Random random = new Random(seed);
            classifier = AbstractClassifier.makeCopy(classifierBackup);
            if (classificationOutput == null) {
                testingEvaluation.crossValidateModel(classifier, trainSource.getDataSet(actualClassIndex), folds, random, new Object[0]);
                if (template.classAttribute().isNumeric()) {
                    text.append("\n\n\n" + testingEvaluation.toSummaryString("=== Cross-validation ===\n", printComplexityStatistics));
                } else {
                    text.append("\n\n\n" + testingEvaluation.toSummaryString("=== Stratified cross-validation ===\n", printComplexityStatistics));
                }
            } else {
                predsBuff = new StringBuffer();
                classificationOutput.setBuffer(predsBuff);
                predsBuff.append("\n=== Predictions under cross-validation ===\n\n");
                testingEvaluation.crossValidateModel(classifier, trainSource.getDataSet(actualClassIndex), folds, random, classificationOutput);
            }
        }
        if (template.classAttribute().isNominal()) {
            if (classStatistics && !noCrossValidation && classificationOutput == null) {
                text.append("\n\n" + testingEvaluation.toClassDetailsString());
            }
            if (!noCrossValidation && classificationOutput == null) {
                text.append("\n\n" + testingEvaluation.toMatrixString());
            }
        }
        if (predsBuff != null) {
            text.append("\n" + predsBuff);
        }
        if (thresholdFile.length() != 0 && template.classAttribute().isNominal()) {
            int labelIndex = 0;
            if (thresholdLabel.length() != 0) {
                labelIndex = template.classAttribute().indexOfValue(thresholdLabel);
            }
            if (labelIndex == -1) {
                throw new IllegalArgumentException("Class label '" + thresholdLabel + "' is unknown!");
            }
            ThresholdCurve tc = new ThresholdCurve();
            Instances result = tc.getCurve(testingEvaluation.predictions(), labelIndex);
            ConverterUtils.DataSink.write(thresholdFile, result);
        }
        return text.toString();
    }

    protected static CostMatrix handleCostOption(String costFileName, int numClasses) throws Exception {
        if (costFileName != null && costFileName.length() != 0) {
            System.out.println("NOTE: The behaviour of the -m option has changed between WEKA 3.0 and WEKA 3.1. -m now carries out cost-sensitive *evaluation* only. For cost-sensitive *prediction*, use one of the cost-sensitive metaschemes such as weka.classifiers.meta.CostSensitiveClassifier or weka.classifiers.meta.MetaCost");
            BufferedReader costReader = null;
            try {
                costReader = new BufferedReader(new FileReader(costFileName));
            }
            catch (Exception e) {
                throw new Exception("Can't open file " + e.getMessage() + '.');
            }
            try {
                return new CostMatrix(costReader);
            }
            catch (Exception ex) {
                try {
                    try {
                        ((Reader)costReader).close();
                        costReader = new BufferedReader(new FileReader(costFileName));
                    }
                    catch (Exception e) {
                        throw new Exception("Can't open file " + e.getMessage() + '.');
                    }
                    CostMatrix costMatrix = new CostMatrix(numClasses);
                    costMatrix.readOldFormat(costReader);
                    return costMatrix;
                }
                catch (Exception e2) {
                    throw ex;
                }
            }
        }
        return null;
    }

    public double[] evaluateModel(Classifier classifier, Instances data, Object ... forPredictionsPrinting) throws Exception {
        AbstractOutput classificationOutput = null;
        double[] predictions = new double[data.numInstances()];
        if (forPredictionsPrinting.length > 0) {
            classificationOutput = (AbstractOutput)forPredictionsPrinting[0];
        }
        int i = 0;
        while (i < data.numInstances()) {
            predictions[i] = this.evaluateModelOnceAndRecordPrediction(classifier, data.instance(i));
            if (classificationOutput != null) {
                classificationOutput.printClassification(classifier, data.instance(i), i);
            }
            ++i;
        }
        return predictions;
    }

    public double evaluationForSingleInstance(double[] dist, Instance instance, boolean storePredictions) throws Exception {
        double pred;
        if (this.m_ClassIsNominal) {
            pred = Utils.maxIndex(dist);
            if (dist[(int)pred] <= 0.0) {
                pred = Utils.missingValue();
            }
            this.updateStatsForClassifier(dist, instance);
            if (storePredictions && !this.m_DiscardPredictions) {
                if (this.m_Predictions == null) {
                    this.m_Predictions = new FastVector();
                }
                this.m_Predictions.addElement(new NominalPrediction(instance.classValue(), dist, instance.weight()));
            }
        } else {
            pred = dist[0];
            this.updateStatsForPredictor(pred, instance);
            if (storePredictions && !this.m_DiscardPredictions) {
                if (this.m_Predictions == null) {
                    this.m_Predictions = new FastVector();
                }
                this.m_Predictions.addElement(new NumericPrediction(instance.classValue(), pred, instance.weight()));
            }
        }
        return pred;
    }

    protected double evaluationForSingleInstance(Classifier classifier, Instance instance, boolean storePredictions) throws Exception {
        Instance classMissing = (Instance)instance.copy();
        classMissing.setDataset(instance.dataset());
        if (classifier instanceof InputMappedClassifier) {
            instance = (Instance)instance.copy();
            instance = ((InputMappedClassifier)classifier).constructMappedInstance(instance);
            int mappedClass = ((InputMappedClassifier)classifier).getMappedClassIndex();
            classMissing.setMissing(mappedClass);
        } else {
            classMissing.setClassMissing();
        }
        double pred = this.evaluationForSingleInstance(classifier.distributionForInstance(classMissing), instance, storePredictions);
        if (!(this.m_ClassIsNominal || instance.classIsMissing() || Utils.isMissingValue(pred))) {
            if (classifier instanceof IntervalEstimator) {
                this.updateStatsForIntervalEstimator((IntervalEstimator)((Object)classifier), classMissing, instance.classValue());
            } else {
                this.m_CoverageStatisticsAvailable = false;
            }
            if (classifier instanceof ConditionalDensityEstimator) {
                this.updateStatsForConditionalDensityEstimator((ConditionalDensityEstimator)((Object)classifier), classMissing, instance.classValue());
            } else {
                this.m_ComplexityStatisticsAvailable = false;
            }
        }
        return pred;
    }

    public double evaluateModelOnceAndRecordPrediction(Classifier classifier, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(classifier, instance, true);
    }

    public double evaluateModelOnce(Classifier classifier, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(classifier, instance, false);
    }

    public double evaluateModelOnce(double[] dist, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(dist, instance, false);
    }

    public double evaluateModelOnceAndRecordPrediction(double[] dist, Instance instance) throws Exception {
        return this.evaluationForSingleInstance(dist, instance, true);
    }

    public void evaluateModelOnce(double prediction, Instance instance) throws Exception {
        this.evaluateModelOnce(this.makeDistribution(prediction), instance);
    }

    public FastVector predictions() {
        if (this.m_DiscardPredictions) {
            return null;
        }
        return this.m_Predictions;
    }

    public static String wekaStaticWrapper(Sourcable classifier, String className) throws Exception {
        StringBuffer result = new StringBuffer();
        String staticClassifier = classifier.toSource(className);
        result.append("// Generated with Weka " + Version.VERSION + "\n");
        result.append("//\n");
        result.append("// This code is public domain and comes with no warranty.\n");
        result.append("//\n");
        result.append("// Timestamp: " + new Date() + "\n");
        result.append("\n");
        result.append("package weka.classifiers;\n");
        result.append("\n");
        result.append("import weka.core.Attribute;\n");
        result.append("import weka.core.Capabilities;\n");
        result.append("import weka.core.Capabilities.Capability;\n");
        result.append("import weka.core.Instance;\n");
        result.append("import weka.core.Instances;\n");
        result.append("import weka.core.RevisionUtils;\n");
        result.append("import weka.classifiers.Classifier;\nimport weka.classifiers.AbstractClassifier;\n");
        result.append("\n");
        result.append("public class WekaWrapper\n");
        result.append("  extends AbstractClassifier {\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns only the toString() method.\n");
        result.append("   *\n");
        result.append("   * @return a string describing the classifier\n");
        result.append("   */\n");
        result.append("  public String globalInfo() {\n");
        result.append("    return toString();\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns the capabilities of this classifier.\n");
        result.append("   *\n");
        result.append("   * @return the capabilities\n");
        result.append("   */\n");
        result.append("  public Capabilities getCapabilities() {\n");
        result.append(((Classifier)((Object)classifier)).getCapabilities().toSource("result", 4));
        result.append("    return result;\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * only checks the data against its capabilities.\n");
        result.append("   *\n");
        result.append("   * @param i the training data\n");
        result.append("   */\n");
        result.append("  public void buildClassifier(Instances i) throws Exception {\n");
        result.append("    // can classifier handle the data?\n");
        result.append("    getCapabilities().testWithFail(i);\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Classifies the given instance.\n");
        result.append("   *\n");
        result.append("   * @param i the instance to classify\n");
        result.append("   * @return the classification result\n");
        result.append("   */\n");
        result.append("  public double classifyInstance(Instance i) throws Exception {\n");
        result.append("    Object[] s = new Object[i.numAttributes()];\n");
        result.append("    \n");
        result.append("    for (int j = 0; j < s.length; j++) {\n");
        result.append("      if (!i.isMissing(j)) {\n");
        result.append("        if (i.attribute(j).isNominal())\n");
        result.append("          s[j] = new String(i.stringValue(j));\n");
        result.append("        else if (i.attribute(j).isNumeric())\n");
        result.append("          s[j] = new Double(i.value(j));\n");
        result.append("      }\n");
        result.append("    }\n");
        result.append("    \n");
        result.append("    // set class value to missing\n");
        result.append("    s[i.classIndex()] = null;\n");
        result.append("    \n");
        result.append("    return " + className + ".classify(s);\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns the revision string.\n");
        result.append("   * \n");
        result.append("   * @return        the revision\n");
        result.append("   */\n");
        result.append("  public String getRevision() {\n");
        result.append("    return RevisionUtils.extract(\"1.0\");\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Returns only the classnames and what classifier it is based on.\n");
        result.append("   *\n");
        result.append("   * @return a short description\n");
        result.append("   */\n");
        result.append("  public String toString() {\n");
        result.append("    return \"Auto-generated classifier wrapper, based on " + classifier.getClass().getName() + " (generated with Weka " + Version.VERSION + ").\\n" + "\" + this.getClass().getName() + \"/" + className + "\";\n");
        result.append("  }\n");
        result.append("\n");
        result.append("  /**\n");
        result.append("   * Runs the classfier from commandline.\n");
        result.append("   *\n");
        result.append("   * @param args the commandline arguments\n");
        result.append("   */\n");
        result.append("  public static void main(String args[]) {\n");
        result.append("    runClassifier(new WekaWrapper(), args);\n");
        result.append("  }\n");
        result.append("}\n");
        result.append("\n");
        result.append(staticClassifier);
        return result.toString();
    }

    public final double numInstances() {
        return this.m_WithClass;
    }

    public final double coverageOfTestCasesByPredictedRegions() {
        if (!this.m_CoverageStatisticsAvailable) {
            return Double.NaN;
        }
        return 100.0 * this.m_TotalCoverage / this.m_WithClass;
    }

    public final double sizeOfPredictedRegions() {
        if (this.m_NoPriors || !this.m_CoverageStatisticsAvailable) {
            return Double.NaN;
        }
        return 100.0 * this.m_TotalSizeOfRegions / this.m_WithClass;
    }

    public final double incorrect() {
        return this.m_Incorrect;
    }

    public final double pctIncorrect() {
        return 100.0 * this.m_Incorrect / this.m_WithClass;
    }

    public final double totalCost() {
        return this.m_TotalCost;
    }

    public final double avgCost() {
        return this.m_TotalCost / this.m_WithClass;
    }

    public final double correct() {
        return this.m_Correct;
    }

    public final double pctCorrect() {
        return 100.0 * this.m_Correct / this.m_WithClass;
    }

    public final double unclassified() {
        return this.m_Unclassified;
    }

    public final double pctUnclassified() {
        return 100.0 * this.m_Unclassified / this.m_WithClass;
    }

    public final double errorRate() {
        if (!this.m_ClassIsNominal) {
            return Math.sqrt(this.m_SumSqrErr / (this.m_WithClass - this.m_Unclassified));
        }
        if (this.m_CostMatrix == null) {
            return this.m_Incorrect / this.m_WithClass;
        }
        return this.avgCost();
    }

    public final double kappa() {
        double[] sumRows = new double[this.m_ConfusionMatrix.length];
        double[] sumColumns = new double[this.m_ConfusionMatrix.length];
        double sumOfWeights = 0.0;
        int i = 0;
        while (i < this.m_ConfusionMatrix.length) {
            int j = 0;
            while (j < this.m_ConfusionMatrix.length) {
                int n = i;
                sumRows[n] = sumRows[n] + this.m_ConfusionMatrix[i][j];
                int n2 = j;
                sumColumns[n2] = sumColumns[n2] + this.m_ConfusionMatrix[i][j];
                sumOfWeights += this.m_ConfusionMatrix[i][j];
                ++j;
            }
            ++i;
        }
        double correct = 0.0;
        double chanceAgreement = 0.0;
        int i2 = 0;
        while (i2 < this.m_ConfusionMatrix.length) {
            chanceAgreement += sumRows[i2] * sumColumns[i2];
            correct += this.m_ConfusionMatrix[i2][i2];
            ++i2;
        }
        chanceAgreement /= sumOfWeights * sumOfWeights;
        correct /= sumOfWeights;
        if (chanceAgreement < 1.0) {
            return (correct - chanceAgreement) / (1.0 - chanceAgreement);
        }
        return 1.0;
    }

    public final double correlationCoefficient() throws Exception {
        if (this.m_ClassIsNominal) {
            throw new Exception("Can't compute correlation coefficient: class is nominal!");
        }
        double correlation = 0.0;
        double varActual = this.m_SumSqrClass - this.m_SumClass * this.m_SumClass / (this.m_WithClass - this.m_Unclassified);
        double varPredicted = this.m_SumSqrPredicted - this.m_SumPredicted * this.m_SumPredicted / (this.m_WithClass - this.m_Unclassified);
        double varProd = this.m_SumClassPredicted - this.m_SumClass * this.m_SumPredicted / (this.m_WithClass - this.m_Unclassified);
        correlation = varActual * varPredicted <= 0.0 ? 0.0 : varProd / Math.sqrt(varActual * varPredicted);
        return correlation;
    }

    public final double meanAbsoluteError() {
        return this.m_SumAbsErr / (this.m_WithClass - this.m_Unclassified);
    }

    public final double meanPriorAbsoluteError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumPriorAbsErr / this.m_WithClass;
    }

    public final double relativeAbsoluteError() throws Exception {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.meanAbsoluteError() / this.meanPriorAbsoluteError();
    }

    public final double rootMeanSquaredError() {
        return Math.sqrt(this.m_SumSqrErr / (this.m_WithClass - this.m_Unclassified));
    }

    public final double rootMeanPriorSquaredError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return Math.sqrt(this.m_SumPriorSqrErr / this.m_WithClass);
    }

    public final double rootRelativeSquaredError() {
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.rootMeanSquaredError() / this.rootMeanPriorSquaredError();
    }

    public final double priorEntropy() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute entropy of class prior: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        double entropy = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            entropy -= this.m_ClassPriors[i] / this.m_ClassPriorsSum * Utils.log2(this.m_ClassPriors[i] / this.m_ClassPriorsSum);
            ++i;
        }
        return entropy;
    }

    public final double KBInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumKBInfo;
    }

    public final double KBMeanInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return this.m_SumKBInfo / (this.m_WithClass - this.m_Unclassified);
    }

    public final double KBRelativeInformation() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Can't compute K&B Info score: class numeric!");
        }
        if (this.m_NoPriors) {
            return Double.NaN;
        }
        return 100.0 * this.KBInformation() / this.priorEntropy();
    }

    public final double SFPriorEntropy() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy;
    }

    public final double SFMeanPriorEntropy() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy / this.m_WithClass;
    }

    public final double SFSchemeEntropy() {
        if (!this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumSchemeEntropy;
    }

    public final double SFMeanSchemeEntropy() {
        if (!this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumSchemeEntropy / (this.m_WithClass - this.m_Unclassified);
    }

    public final double SFEntropyGain() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return this.m_SumPriorEntropy - this.m_SumSchemeEntropy;
    }

    public final double SFMeanEntropyGain() {
        if (this.m_NoPriors || !this.m_ComplexityStatisticsAvailable) {
            return Double.NaN;
        }
        return (this.m_SumPriorEntropy - this.m_SumSchemeEntropy) / (this.m_WithClass - this.m_Unclassified);
    }

    public String toCumulativeMarginDistributionString() throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Class must be nominal for margin distributions");
        }
        String result = "";
        double cumulativeCount = 0.0;
        int i = 0;
        while (i <= k_MarginResolution) {
            if (this.m_MarginCounts[i] != 0.0) {
                double margin = (double)i * 2.0 / (double)k_MarginResolution - 1.0;
                result = String.valueOf(result) + Utils.doubleToString(margin, 7, 3) + ' ' + Utils.doubleToString((cumulativeCount += this.m_MarginCounts[i]) * 100.0 / this.m_WithClass, 7, 3) + '\n';
            } else if (i == 0) {
                result = String.valueOf(Utils.doubleToString(-1.0, 7, 3)) + ' ' + Utils.doubleToString(0.0, 7, 3) + '\n';
            }
            ++i;
        }
        return result;
    }

    @Override
    public String toSummaryString() {
        return this.toSummaryString("", false);
    }

    public String toSummaryString(boolean printComplexityStatistics) {
        return this.toSummaryString("=== Summary ===\n", printComplexityStatistics);
    }

    public String toSummaryString(String title, boolean printComplexityStatistics) {
        StringBuffer text = new StringBuffer();
        if (printComplexityStatistics && this.m_NoPriors) {
            printComplexityStatistics = false;
            System.err.println("Priors disabled, cannot print complexity statistics!");
        }
        text.append(String.valueOf(title) + "\n");
        try {
            if (this.m_WithClass > 0.0) {
                if (this.m_ClassIsNominal) {
                    text.append("Correctly Classified Instances     ");
                    text.append(String.valueOf(Utils.doubleToString(this.correct(), 12, 4)) + "     " + Utils.doubleToString(this.pctCorrect(), 12, 4) + " %\n");
                    text.append("Incorrectly Classified Instances   ");
                    text.append(String.valueOf(Utils.doubleToString(this.incorrect(), 12, 4)) + "     " + Utils.doubleToString(this.pctIncorrect(), 12, 4) + " %\n");
                    text.append("Kappa statistic                    ");
                    text.append(String.valueOf(Utils.doubleToString(this.kappa(), 12, 4)) + "\n");
                    if (this.m_CostMatrix != null) {
                        text.append("Total Cost                         ");
                        text.append(String.valueOf(Utils.doubleToString(this.totalCost(), 12, 4)) + "\n");
                        text.append("Average Cost                       ");
                        text.append(String.valueOf(Utils.doubleToString(this.avgCost(), 12, 4)) + "\n");
                    }
                    if (printComplexityStatistics) {
                        text.append("K&B Relative Info Score            ");
                        text.append(String.valueOf(Utils.doubleToString(this.KBRelativeInformation(), 12, 4)) + " %\n");
                        text.append("K&B Information Score              ");
                        text.append(String.valueOf(Utils.doubleToString(this.KBInformation(), 12, 4)) + " bits");
                        text.append(String.valueOf(Utils.doubleToString(this.KBMeanInformation(), 12, 4)) + " bits/instance\n");
                    }
                } else {
                    text.append("Correlation coefficient            ");
                    text.append(String.valueOf(Utils.doubleToString(this.correlationCoefficient(), 12, 4)) + "\n");
                }
                if (printComplexityStatistics && this.m_ComplexityStatisticsAvailable) {
                    text.append("Class complexity | order 0         ");
                    text.append(String.valueOf(Utils.doubleToString(this.SFPriorEntropy(), 12, 4)) + " bits");
                    text.append(String.valueOf(Utils.doubleToString(this.SFMeanPriorEntropy(), 12, 4)) + " bits/instance\n");
                    text.append("Class complexity | scheme          ");
                    text.append(String.valueOf(Utils.doubleToString(this.SFSchemeEntropy(), 12, 4)) + " bits");
                    text.append(String.valueOf(Utils.doubleToString(this.SFMeanSchemeEntropy(), 12, 4)) + " bits/instance\n");
                    text.append("Complexity improvement     (Sf)    ");
                    text.append(String.valueOf(Utils.doubleToString(this.SFEntropyGain(), 12, 4)) + " bits");
                    text.append(String.valueOf(Utils.doubleToString(this.SFMeanEntropyGain(), 12, 4)) + " bits/instance\n");
                }
                text.append("Mean absolute error                ");
                text.append(String.valueOf(Utils.doubleToString(this.meanAbsoluteError(), 12, 4)) + "\n");
                text.append("Root mean squared error            ");
                text.append(String.valueOf(Utils.doubleToString(this.rootMeanSquaredError(), 12, 4)) + "\n");
                if (!this.m_NoPriors) {
                    text.append("Relative absolute error            ");
                    text.append(String.valueOf(Utils.doubleToString(this.relativeAbsoluteError(), 12, 4)) + " %\n");
                    text.append("Root relative squared error        ");
                    text.append(String.valueOf(Utils.doubleToString(this.rootRelativeSquaredError(), 12, 4)) + " %\n");
                }
                if (this.m_CoverageStatisticsAvailable) {
                    text.append("Coverage of cases (" + Utils.doubleToString(this.m_ConfLevel, 4, 2) + " level)     ");
                    text.append(String.valueOf(Utils.doubleToString(this.coverageOfTestCasesByPredictedRegions(), 12, 4)) + " %\n");
                    if (!this.m_NoPriors) {
                        text.append("Mean rel. region size (" + Utils.doubleToString(this.m_ConfLevel, 4, 2) + " level) ");
                        text.append(String.valueOf(Utils.doubleToString(this.sizeOfPredictedRegions(), 12, 4)) + " %\n");
                    }
                }
            }
            if (Utils.gr(this.unclassified(), 0.0)) {
                text.append("UnClassified Instances             ");
                text.append(String.valueOf(Utils.doubleToString(this.unclassified(), 12, 4)) + "     " + Utils.doubleToString(this.pctUnclassified(), 12, 4) + " %\n");
            }
            text.append("Total Number of Instances          ");
            text.append(String.valueOf(Utils.doubleToString(this.m_WithClass, 12, 4)) + "\n");
            if (this.m_MissingClass > 0.0) {
                text.append("Ignored Class Unknown Instances            ");
                text.append(String.valueOf(Utils.doubleToString(this.m_MissingClass, 12, 4)) + "\n");
            }
        }
        catch (Exception ex) {
            System.err.println("Arggh - Must be a bug in Evaluation class");
        }
        return text.toString();
    }

    public String toMatrixString() throws Exception {
        return this.toMatrixString("=== Confusion Matrix ===\n");
    }

    public String toMatrixString(String title) throws Exception {
        int j;
        StringBuffer text = new StringBuffer();
        char[] IDChars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        boolean fractional = false;
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No confusion matrix possible!");
        }
        double maxval = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            j = 0;
            while (j < this.m_NumClasses) {
                double current = this.m_ConfusionMatrix[i][j];
                if (current < 0.0) {
                    current *= -10.0;
                }
                if (current > maxval) {
                    maxval = current;
                }
                double fract = current - Math.rint(current);
                if (!fractional && Math.log(fract) / Math.log(10.0) >= -2.0) {
                    fractional = true;
                }
                ++j;
            }
            ++i;
        }
        int IDWidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0) + (double)(fractional ? 3 : 0)), (int)(Math.log(this.m_NumClasses) / Math.log(IDChars.length)));
        text.append(title).append("\n");
        i = 0;
        while (i < this.m_NumClasses) {
            if (fractional) {
                text.append(" ").append(this.num2ShortID(i, IDChars, IDWidth - 3)).append("   ");
            } else {
                text.append(" ").append(this.num2ShortID(i, IDChars, IDWidth));
            }
            ++i;
        }
        text.append("   <-- classified as\n");
        i = 0;
        while (i < this.m_NumClasses) {
            j = 0;
            while (j < this.m_NumClasses) {
                text.append(" ").append(Utils.doubleToString(this.m_ConfusionMatrix[i][j], IDWidth, fractional ? 2 : 0));
                ++j;
            }
            text.append(" | ").append(this.num2ShortID(i, IDChars, IDWidth)).append(" = ").append(this.m_ClassNames[i]).append("\n");
            ++i;
        }
        return text.toString();
    }

    public String toClassDetailsString() throws Exception {
        return this.toClassDetailsString("=== Detailed Accuracy By Class ===\n");
    }

    public String toClassDetailsString(String title) throws Exception {
        if (!this.m_ClassIsNominal) {
            throw new Exception("Evaluation: No per class statistics possible!");
        }
        StringBuffer text = new StringBuffer(String.valueOf(title) + "\n               TP Rate   FP Rate" + "   Precision   Recall" + "  F-Measure   ROC Area   PRC Area  Class\n");
        int i = 0;
        while (i < this.m_NumClasses) {
            text.append("               " + Utils.doubleToString(this.truePositiveRate(i), 7, 3)).append("   ");
            text.append(Utils.doubleToString(this.falsePositiveRate(i), 7, 3)).append("    ");
            text.append(Utils.doubleToString(this.precision(i), 7, 3)).append("   ");
            text.append(Utils.doubleToString(this.recall(i), 7, 3)).append("   ");
            text.append(Utils.doubleToString(this.fMeasure(i), 7, 3)).append("    ");
            double rocVal = this.areaUnderROC(i);
            if (Utils.isMissingValue(rocVal)) {
                text.append("  ?    ").append("    ");
            } else {
                text.append(Utils.doubleToString(rocVal, 7, 3)).append("    ");
            }
            double prcVal = this.areaUnderPRC(i);
            if (Utils.isMissingValue(prcVal)) {
                text.append("  ?    ").append("    ");
            } else {
                text.append(Utils.doubleToString(prcVal, 7, 3)).append("    ");
            }
            text.append(this.m_ClassNames[i]).append('\n');
            ++i;
        }
        text.append("Weighted Avg.  " + Utils.doubleToString(this.weightedTruePositiveRate(), 7, 3));
        text.append("   " + Utils.doubleToString(this.weightedFalsePositiveRate(), 7, 3));
        text.append("    " + Utils.doubleToString(this.weightedPrecision(), 7, 3));
        text.append("   " + Utils.doubleToString(this.weightedRecall(), 7, 3));
        text.append("   " + Utils.doubleToString(this.weightedFMeasure(), 7, 3));
        text.append("    " + Utils.doubleToString(this.weightedAreaUnderROC(), 7, 3));
        text.append("    " + Utils.doubleToString(this.weightedAreaUnderPRC(), 7, 3));
        text.append("\n");
        return text.toString();
    }

    public double numTruePositives(int classIndex) {
        double correct = 0.0;
        int j = 0;
        while (j < this.m_NumClasses) {
            if (j == classIndex) {
                correct += this.m_ConfusionMatrix[classIndex][j];
            }
            ++j;
        }
        return correct;
    }

    public double truePositiveRate(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        int j = 0;
        while (j < this.m_NumClasses) {
            if (j == classIndex) {
                correct += this.m_ConfusionMatrix[classIndex][j];
            }
            total += this.m_ConfusionMatrix[classIndex][j];
            ++j;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public double weightedTruePositiveRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double truePosTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.truePositiveRate(i2);
            truePosTotal += temp * classCounts[i2];
            ++i2;
        }
        return truePosTotal / classCountSum;
    }

    public double numTrueNegatives(int classIndex) {
        double correct = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i != classIndex) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (j != classIndex) {
                        correct += this.m_ConfusionMatrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return correct;
    }

    public double trueNegativeRate(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i != classIndex) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (j != classIndex) {
                        correct += this.m_ConfusionMatrix[i][j];
                    }
                    total += this.m_ConfusionMatrix[i][j];
                    ++j;
                }
            }
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public double weightedTrueNegativeRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double trueNegTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.trueNegativeRate(i2);
            trueNegTotal += temp * classCounts[i2];
            ++i2;
        }
        return trueNegTotal / classCountSum;
    }

    public double numFalsePositives(int classIndex) {
        double incorrect = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i != classIndex) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (j == classIndex) {
                        incorrect += this.m_ConfusionMatrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return incorrect;
    }

    public double falsePositiveRate(int classIndex) {
        double incorrect = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i != classIndex) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (j == classIndex) {
                        incorrect += this.m_ConfusionMatrix[i][j];
                    }
                    total += this.m_ConfusionMatrix[i][j];
                    ++j;
                }
            }
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return incorrect / total;
    }

    public double weightedFalsePositiveRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double falsePosTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.falsePositiveRate(i2);
            falsePosTotal += temp * classCounts[i2];
            ++i2;
        }
        return falsePosTotal / classCountSum;
    }

    public double numFalseNegatives(int classIndex) {
        double incorrect = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i == classIndex) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (j != classIndex) {
                        incorrect += this.m_ConfusionMatrix[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return incorrect;
    }

    public double falseNegativeRate(int classIndex) {
        double incorrect = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i == classIndex) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (j != classIndex) {
                        incorrect += this.m_ConfusionMatrix[i][j];
                    }
                    total += this.m_ConfusionMatrix[i][j];
                    ++j;
                }
            }
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return incorrect / total;
    }

    public double weightedFalseNegativeRate() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double falseNegTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.falseNegativeRate(i2);
            falseNegTotal += temp * classCounts[i2];
            ++i2;
        }
        return falseNegTotal / classCountSum;
    }

    public double recall(int classIndex) {
        return this.truePositiveRate(classIndex);
    }

    public double weightedRecall() {
        return this.weightedTruePositiveRate();
    }

    public double precision(int classIndex) {
        double correct = 0.0;
        double total = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i == classIndex) {
                correct += this.m_ConfusionMatrix[i][classIndex];
            }
            total += this.m_ConfusionMatrix[i][classIndex];
            ++i;
        }
        if (total == 0.0) {
            return 0.0;
        }
        return correct / total;
    }

    public double weightedPrecision() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double precisionTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.precision(i2);
            precisionTotal += temp * classCounts[i2];
            ++i2;
        }
        return precisionTotal / classCountSum;
    }

    public double fMeasure(int classIndex) {
        double recall;
        double precision = this.precision(classIndex);
        if (precision + (recall = this.recall(classIndex)) == 0.0) {
            return 0.0;
        }
        return 2.0 * precision * recall / (precision + recall);
    }

    public double weightedFMeasure() {
        double[] classCounts = new double[this.m_NumClasses];
        double classCountSum = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            int j = 0;
            while (j < this.m_NumClasses) {
                int n = i;
                classCounts[n] = classCounts[n] + this.m_ConfusionMatrix[i][j];
                ++j;
            }
            classCountSum += classCounts[i];
            ++i;
        }
        double fMeasureTotal = 0.0;
        int i2 = 0;
        while (i2 < this.m_NumClasses) {
            double temp = this.fMeasure(i2);
            fMeasureTotal += temp * classCounts[i2];
            ++i2;
        }
        return fMeasureTotal / classCountSum;
    }

    public double unweightedMacroFmeasure() {
        Stats rr = new Stats();
        int c = 0;
        while (c < this.m_NumClasses) {
            if (this.numTruePositives(c) + this.numFalseNegatives(c) > 0.0) {
                rr.add(this.fMeasure(c));
            }
            ++c;
        }
        rr.calculateDerived();
        return rr.mean;
    }

    public double unweightedMicroFmeasure() {
        double tp = 0.0;
        double fn = 0.0;
        double fp = 0.0;
        int c = 0;
        while (c < this.m_NumClasses) {
            tp += this.numTruePositives(c);
            fn += this.numFalseNegatives(c);
            fp += this.numFalsePositives(c);
            ++c;
        }
        return 2.0 * tp / (2.0 * tp + fn + fp);
    }

    public void setPriors(Instances train) throws Exception {
        this.m_NoPriors = false;
        if (!this.m_ClassIsNominal) {
            this.m_NumTrainClassVals = 0;
            this.m_TrainClassVals = null;
            this.m_TrainClassWeights = null;
            this.m_PriorEstimator = null;
            this.m_MinTarget = Double.MAX_VALUE;
            this.m_MaxTarget = -1.7976931348623157E308;
            int i = 0;
            while (i < train.numInstances()) {
                Instance currentInst = train.instance(i);
                if (!currentInst.classIsMissing()) {
                    this.addNumericTrainClass(currentInst.classValue(), currentInst.weight());
                }
                ++i;
            }
            this.m_ClassPriorsSum = 0.0;
            this.m_ClassPriors[0] = 0.0;
            i = 0;
            while (i < train.numInstances()) {
                if (!train.instance(i).classIsMissing()) {
                    this.m_ClassPriors[0] = this.m_ClassPriors[0] + train.instance(i).classValue() * train.instance(i).weight();
                    this.m_ClassPriorsSum += train.instance(i).weight();
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.m_NumClasses) {
                this.m_ClassPriors[i] = 1.0;
                ++i;
            }
            this.m_ClassPriorsSum = this.m_NumClasses;
            i = 0;
            while (i < train.numInstances()) {
                if (!train.instance(i).classIsMissing()) {
                    int n = (int)train.instance(i).classValue();
                    this.m_ClassPriors[n] = this.m_ClassPriors[n] + train.instance(i).weight();
                    this.m_ClassPriorsSum += train.instance(i).weight();
                }
                ++i;
            }
            this.m_MaxTarget = this.m_NumClasses;
            this.m_MinTarget = 0.0;
        }
    }

    public double[] getClassPriors() {
        return this.m_ClassPriors;
    }

    public void updatePriors(Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            if (!this.m_ClassIsNominal) {
                this.addNumericTrainClass(instance.classValue(), instance.weight());
                this.m_ClassPriors[0] = this.m_ClassPriors[0] + instance.classValue() * instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            } else {
                int n = (int)instance.classValue();
                this.m_ClassPriors[n] = this.m_ClassPriors[n] + instance.weight();
                this.m_ClassPriorsSum += instance.weight();
            }
        }
    }

    public void useNoPriors() {
        this.m_NoPriors = true;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        Evaluation cmp = (Evaluation)obj;
        if (this.m_ClassIsNominal != cmp.m_ClassIsNominal) {
            return false;
        }
        if (this.m_NumClasses != cmp.m_NumClasses) {
            return false;
        }
        if (this.m_Incorrect != cmp.m_Incorrect) {
            return false;
        }
        if (this.m_Correct != cmp.m_Correct) {
            return false;
        }
        if (this.m_Unclassified != cmp.m_Unclassified) {
            return false;
        }
        if (this.m_MissingClass != cmp.m_MissingClass) {
            return false;
        }
        if (this.m_WithClass != cmp.m_WithClass) {
            return false;
        }
        if (this.m_SumErr != cmp.m_SumErr) {
            return false;
        }
        if (this.m_SumAbsErr != cmp.m_SumAbsErr) {
            return false;
        }
        if (this.m_SumSqrErr != cmp.m_SumSqrErr) {
            return false;
        }
        if (this.m_SumClass != cmp.m_SumClass) {
            return false;
        }
        if (this.m_SumSqrClass != cmp.m_SumSqrClass) {
            return false;
        }
        if (this.m_SumPredicted != cmp.m_SumPredicted) {
            return false;
        }
        if (this.m_SumSqrPredicted != cmp.m_SumSqrPredicted) {
            return false;
        }
        if (this.m_SumClassPredicted != cmp.m_SumClassPredicted) {
            return false;
        }
        if (this.m_ClassIsNominal) {
            int i = 0;
            while (i < this.m_NumClasses) {
                int j = 0;
                while (j < this.m_NumClasses) {
                    if (this.m_ConfusionMatrix[i][j] != cmp.m_ConfusionMatrix[i][j]) {
                        return false;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return true;
    }

    protected static String makeOptionString(Classifier classifier, boolean globalInfo) {
        StringBuffer optionsText = new StringBuffer("");
        optionsText.append("\n\nGeneral options:\n\n");
        optionsText.append("-h or -help\n");
        optionsText.append("\tOutput help information.\n");
        optionsText.append("-synopsis or -info\n");
        optionsText.append("\tOutput synopsis for classifier (use in conjunction  with -h)\n");
        optionsText.append("-t <name of training file>\n");
        optionsText.append("\tSets training file.\n");
        optionsText.append("-T <name of test file>\n");
        optionsText.append("\tSets test file. If missing, a cross-validation will be performed\n");
        optionsText.append("\ton the training data.\n");
        optionsText.append("-c <class index>\n");
        optionsText.append("\tSets index of class attribute (default: last).\n");
        optionsText.append("-x <number of folds>\n");
        optionsText.append("\tSets number of folds for cross-validation (default: 10).\n");
        optionsText.append("-no-cv\n");
        optionsText.append("\tDo not perform any cross validation.\n");
        optionsText.append("-split-percentage <percentage>\n");
        optionsText.append("\tSets the percentage for the train/test set split, e.g., 66.\n");
        optionsText.append("-preserve-order\n");
        optionsText.append("\tPreserves the order in the percentage split.\n");
        optionsText.append("-s <random number seed>\n");
        optionsText.append("\tSets random number seed for cross-validation or percentage split\n");
        optionsText.append("\t(default: 1).\n");
        optionsText.append("-m <name of file with cost matrix>\n");
        optionsText.append("\tSets file with cost matrix.\n");
        optionsText.append("-l <name of input file>\n");
        optionsText.append("\tSets model input file. In case the filename ends with '.xml',\n");
        optionsText.append("\ta PMML file is loaded or, if that fails, options are loaded\n");
        optionsText.append("\tfrom the XML file.\n");
        optionsText.append("-d <name of output file>\n");
        optionsText.append("\tSets model output file. In case the filename ends with '.xml',\n");
        optionsText.append("\tonly the options are saved to the XML file, not the model.\n");
        optionsText.append("-v\n");
        optionsText.append("\tOutputs no statistics for training data.\n");
        optionsText.append("-o\n");
        optionsText.append("\tOutputs statistics only, not the classifier.\n");
        optionsText.append("-i\n");
        optionsText.append("\tOutputs detailed information-retrieval");
        optionsText.append(" statistics for each class.\n");
        optionsText.append("-k\n");
        optionsText.append("\tOutputs information-theoretic statistics.\n");
        optionsText.append("-classifications \"weka.classifiers.evaluation.output.prediction.AbstractOutput + options\"\n");
        optionsText.append("\tUses the specified class for generating the classification output.\n");
        optionsText.append("\tE.g.: " + PlainText.class.getName() + "\n");
        optionsText.append("-p range\n");
        optionsText.append("\tOutputs predictions for test instances (or the train instances if\n");
        optionsText.append("\tno test instances provided and -no-cv is used), along with the \n");
        optionsText.append("\tattributes in the specified range (and nothing else). \n");
        optionsText.append("\tUse '-p 0' if no attributes are desired.\n");
        optionsText.append("\tDeprecated: use \"-classifications ...\" instead.\n");
        optionsText.append("-distribution\n");
        optionsText.append("\tOutputs the distribution instead of only the prediction\n");
        optionsText.append("\tin conjunction with the '-p' option (only nominal classes).\n");
        optionsText.append("\tDeprecated: use \"-classifications ...\" instead.\n");
        optionsText.append("-r\n");
        optionsText.append("\tOnly outputs cumulative margin distribution.\n");
        if (classifier instanceof Sourcable) {
            optionsText.append("-z <class name>\n");
            optionsText.append("\tOnly outputs the source representation of the classifier,\n\tgiving it the supplied name.\n");
        }
        if (classifier instanceof Drawable) {
            optionsText.append("-g\n");
            optionsText.append("\tOnly outputs the graph representation of the classifier.\n");
        }
        optionsText.append("-xml filename | xml-string\n");
        optionsText.append("\tRetrieves the options from the XML-data instead of the command line.\n");
        optionsText.append("-threshold-file <file>\n");
        optionsText.append("\tThe file to save the threshold data to.\n\tThe format is determined by the extensions, e.g., '.arff' for ARFF \n\tformat or '.csv' for CSV.\n");
        optionsText.append("-threshold-label <label>\n");
        optionsText.append("\tThe class label to determine the threshold data for\n\t(default is the first label)\n");
        if (classifier instanceof OptionHandler) {
            optionsText.append("\nOptions specific to " + classifier.getClass().getName() + ":\n\n");
            Enumeration enu = ((OptionHandler)((Object)classifier)).listOptions();
            while (enu.hasMoreElements()) {
                Option option = (Option)enu.nextElement();
                optionsText.append(String.valueOf(option.synopsis()) + '\n');
                optionsText.append(String.valueOf(option.description()) + "\n");
            }
        }
        if (globalInfo) {
            try {
                String gi = Evaluation.getGlobalInfo(classifier);
                optionsText.append(gi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return optionsText.toString();
    }

    protected static String getGlobalInfo(Classifier classifier) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(classifier.getClass());
        MethodDescriptor[] methods = bi.getMethodDescriptors();
        Object[] args = new Object[]{};
        String result = "\nSynopsis for " + classifier.getClass().getName() + ":\n\n";
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getDisplayName();
            Method meth = methods[i].getMethod();
            if (name.equals("globalInfo")) {
                String globalInfo = (String)meth.invoke((Object)classifier, args);
                result = String.valueOf(result) + globalInfo;
                break;
            }
            ++i;
        }
        return result;
    }

    protected String num2ShortID(int num, char[] IDChars, int IDWidth) {
        char[] ID = new char[IDWidth];
        int i = IDWidth - 1;
        while (i >= 0) {
            ID[i] = IDChars[num % IDChars.length];
            if ((num = num / IDChars.length - 1) < 0) break;
            --i;
        }
        --i;
        while (i >= 0) {
            ID[i] = 32;
            --i;
        }
        return new String(ID);
    }

    protected double[] makeDistribution(double predictedClass) {
        double[] result = new double[this.m_NumClasses];
        if (Utils.isMissingValue(predictedClass)) {
            return result;
        }
        if (this.m_ClassIsNominal) {
            result[(int)predictedClass] = 1.0;
        } else {
            result[0] = predictedClass;
        }
        return result;
    }

    protected void updateStatsForClassifier(double[] predictedDistribution, Instance instance) throws Exception {
        int actualClass = (int)instance.classValue();
        if (!instance.classIsMissing()) {
            double priorProb;
            this.updateMargins(predictedDistribution, actualClass, instance.weight());
            int predictedClass = -1;
            double bestProb = 0.0;
            int i = 0;
            while (i < this.m_NumClasses) {
                if (predictedDistribution[i] > bestProb) {
                    predictedClass = i;
                    bestProb = predictedDistribution[i];
                }
                ++i;
            }
            this.m_WithClass += instance.weight();
            if (this.m_CostMatrix != null) {
                this.m_TotalCost = predictedClass < 0 ? (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getMaxCost(actualClass, instance)) : (this.m_TotalCost += instance.weight() * this.m_CostMatrix.getElement(actualClass, predictedClass, instance));
            }
            if (predictedClass < 0) {
                this.m_Unclassified += instance.weight();
                return;
            }
            double predictedProb = Math.max(Double.MIN_VALUE, predictedDistribution[actualClass]);
            this.m_SumKBInfo = predictedProb >= (priorProb = Math.max(Double.MIN_VALUE, this.m_ClassPriors[actualClass] / this.m_ClassPriorsSum)) ? (this.m_SumKBInfo += (Utils.log2(predictedProb) - Utils.log2(priorProb)) * instance.weight()) : (this.m_SumKBInfo -= (Utils.log2(1.0 - predictedProb) - Utils.log2(1.0 - priorProb)) * instance.weight());
            this.m_SumSchemeEntropy -= Utils.log2(predictedProb) * instance.weight();
            this.m_SumPriorEntropy -= Utils.log2(priorProb) * instance.weight();
            this.updateNumericScores(predictedDistribution, this.makeDistribution(instance.classValue()), instance.weight());
            int[] indices = Utils.sort(predictedDistribution);
            double sum = 0.0;
            double sizeOfRegions = 0.0;
            int i2 = predictedDistribution.length - 1;
            while (i2 >= 0) {
                if (sum >= this.m_ConfLevel) break;
                sum += predictedDistribution[indices[i2]];
                sizeOfRegions += 1.0;
                if (actualClass == indices[i2]) {
                    this.m_TotalCoverage += instance.weight();
                }
                --i2;
            }
            this.m_TotalSizeOfRegions += sizeOfRegions / (this.m_MaxTarget - this.m_MinTarget);
            double[] dArray = this.m_ConfusionMatrix[actualClass];
            int n = predictedClass;
            dArray[n] = dArray[n] + instance.weight();
            if (predictedClass != actualClass) {
                this.m_Incorrect += instance.weight();
            } else {
                this.m_Correct += instance.weight();
            }
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    protected void updateStatsForIntervalEstimator(IntervalEstimator classifier, Instance classMissing, double classValue) throws Exception {
        double[][] preds = classifier.predictIntervals(classMissing, this.m_ConfLevel);
        if (this.m_Predictions != null) {
            ((NumericPrediction)this.m_Predictions.lastElement()).setPredictionIntervals(preds);
        }
        int i = 0;
        while (i < preds.length) {
            this.m_TotalSizeOfRegions += (preds[i][1] - preds[i][0]) / (this.m_MaxTarget - this.m_MinTarget);
            ++i;
        }
        i = 0;
        while (i < preds.length) {
            if (preds[i][1] >= classValue && preds[i][0] <= classValue) {
                this.m_TotalCoverage += classMissing.weight();
                break;
            }
            ++i;
        }
    }

    protected void updateStatsForConditionalDensityEstimator(ConditionalDensityEstimator classifier, Instance classMissing, double classValue) throws Exception {
        if (this.m_PriorEstimator == null) {
            this.setNumericPriorsFromBuffer();
        }
        this.m_SumSchemeEntropy -= classifier.logDensity(classMissing, classValue) * classMissing.weight() / Utils.log2;
        this.m_SumPriorEntropy -= this.m_PriorEstimator.logDensity(classValue) * classMissing.weight() / Utils.log2;
    }

    protected void updateStatsForPredictor(double predictedValue, Instance instance) throws Exception {
        if (!instance.classIsMissing()) {
            this.m_WithClass += instance.weight();
            if (Utils.isMissingValue(predictedValue)) {
                this.m_Unclassified += instance.weight();
                return;
            }
            this.m_SumClass += instance.weight() * instance.classValue();
            this.m_SumSqrClass += instance.weight() * instance.classValue() * instance.classValue();
            this.m_SumClassPredicted += instance.weight() * instance.classValue() * predictedValue;
            this.m_SumPredicted += instance.weight() * predictedValue;
            this.m_SumSqrPredicted += instance.weight() * predictedValue * predictedValue;
            this.updateNumericScores(this.makeDistribution(predictedValue), this.makeDistribution(instance.classValue()), instance.weight());
        } else {
            this.m_MissingClass += instance.weight();
        }
    }

    protected void updateMargins(double[] predictedDistribution, int actualClass, double weight) {
        int bin;
        double probActual = predictedDistribution[actualClass];
        double probNext = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            if (i != actualClass && predictedDistribution[i] > probNext) {
                probNext = predictedDistribution[i];
            }
            ++i;
        }
        double margin = probActual - probNext;
        int n = bin = (int)((margin + 1.0) / 2.0 * (double)k_MarginResolution);
        this.m_MarginCounts[n] = this.m_MarginCounts[n] + weight;
    }

    protected void updateNumericScores(double[] predicted, double[] actual, double weight) {
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumSqrErr = 0.0;
        double sumPriorAbsErr = 0.0;
        double sumPriorSqrErr = 0.0;
        int i = 0;
        while (i < this.m_NumClasses) {
            double diff = predicted[i] - actual[i];
            sumErr += diff;
            sumAbsErr += Math.abs(diff);
            sumSqrErr += diff * diff;
            diff = this.m_ClassPriors[i] / this.m_ClassPriorsSum - actual[i];
            sumPriorAbsErr += Math.abs(diff);
            sumPriorSqrErr += diff * diff;
            ++i;
        }
        this.m_SumErr += weight * sumErr / (double)this.m_NumClasses;
        this.m_SumAbsErr += weight * sumAbsErr / (double)this.m_NumClasses;
        this.m_SumSqrErr += weight * sumSqrErr / (double)this.m_NumClasses;
        this.m_SumPriorAbsErr += weight * sumPriorAbsErr / (double)this.m_NumClasses;
        this.m_SumPriorSqrErr += weight * sumPriorSqrErr / (double)this.m_NumClasses;
    }

    protected void addNumericTrainClass(double classValue, double weight) {
        if (classValue > this.m_MaxTarget) {
            this.m_MaxTarget = classValue;
        }
        if (classValue < this.m_MinTarget) {
            this.m_MinTarget = classValue;
        }
        if (this.m_TrainClassVals == null) {
            this.m_TrainClassVals = new double[100];
            this.m_TrainClassWeights = new double[100];
        }
        if (this.m_NumTrainClassVals == this.m_TrainClassVals.length) {
            double[] temp = new double[this.m_TrainClassVals.length * 2];
            System.arraycopy(this.m_TrainClassVals, 0, temp, 0, this.m_TrainClassVals.length);
            this.m_TrainClassVals = temp;
            temp = new double[this.m_TrainClassWeights.length * 2];
            System.arraycopy(this.m_TrainClassWeights, 0, temp, 0, this.m_TrainClassWeights.length);
            this.m_TrainClassWeights = temp;
        }
        this.m_TrainClassVals[this.m_NumTrainClassVals] = classValue;
        this.m_TrainClassWeights[this.m_NumTrainClassVals] = weight;
        ++this.m_NumTrainClassVals;
    }

    protected void setNumericPriorsFromBuffer() {
        this.m_PriorEstimator = new UnivariateKernelEstimator();
        int i = 0;
        while (i < this.m_NumTrainClassVals) {
            this.m_PriorEstimator.addValue(this.m_TrainClassVals[i], this.m_TrainClassWeights[i]);
            ++i;
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7897 $");
    }
}

