/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.BestFirst;
import weka.attributeSelection.CfsSubsetEval;
import weka.classifiers.SingleClassifierEnhancer;
import weka.classifiers.trees.J48;
import weka.core.AdditionalMeasureProducer;
import weka.core.Capabilities;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class AttributeSelectedClassifier
extends SingleClassifierEnhancer
implements OptionHandler,
Drawable,
AdditionalMeasureProducer,
WeightedInstancesHandler {
    static final long serialVersionUID = -5951805453487947577L;
    protected AttributeSelection m_AttributeSelection = null;
    protected ASEvaluation m_Evaluator = new CfsSubsetEval();
    protected ASSearch m_Search = new BestFirst();
    protected Instances m_ReducedHeader;
    protected int m_numClasses;
    protected double m_numAttributesSelected;
    protected double m_selectionTime;
    protected double m_totalTime;

    @Override
    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public AttributeSelectedClassifier() {
        this.m_Classifier = new J48();
    }

    public String globalInfo() {
        return "Dimensionality of training and test data is reduced by attribute selection before being passed on to a classifier.";
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(3);
        newVector.addElement(new Option("\tFull class name of attribute evaluator, followed\n\tby its options.\n\teg: \"weka.attributeSelection.CfsSubsetEval -L\"\n\t(default weka.attributeSelection.CfsSubsetEval)", "E", 1, "-E <attribute evaluator specification>"));
        newVector.addElement(new Option("\tFull class name of search method, followed\n\tby its options.\n\teg: \"weka.attributeSelection.BestFirst -D 1\"\n\t(default weka.attributeSelection.BestFirst)", "S", 1, "-S <search method specification>"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String[] searchSpec;
        String[] evaluatorSpec;
        String evaluatorString = Utils.getOption('E', options);
        if (evaluatorString.length() == 0) {
            evaluatorString = CfsSubsetEval.class.getName();
        }
        if ((evaluatorSpec = Utils.splitOptions(evaluatorString)).length == 0) {
            throw new Exception("Invalid attribute evaluator specification string");
        }
        String evaluatorName = evaluatorSpec[0];
        evaluatorSpec[0] = "";
        this.setEvaluator(ASEvaluation.forName(evaluatorName, evaluatorSpec));
        String searchString = Utils.getOption('S', options);
        if (searchString.length() == 0) {
            searchString = BestFirst.class.getName();
        }
        if ((searchSpec = Utils.splitOptions(searchString)).length == 0) {
            throw new Exception("Invalid search specification string");
        }
        String searchName = searchSpec[0];
        searchSpec[0] = "";
        this.setSearch(ASSearch.forName(searchName, searchSpec));
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[superOptions.length + 4];
        int current = 0;
        options[current++] = "-E";
        options[current++] = this.getEvaluatorSpec();
        options[current++] = "-S";
        options[current++] = this.getSearchSpec();
        System.arraycopy(superOptions, 0, options, current, superOptions.length);
        return options;
    }

    public String evaluatorTipText() {
        return "Set the attribute evaluator to use. This evaluator is used during the attribute selection phase before the classifier is invoked.";
    }

    public void setEvaluator(ASEvaluation evaluator) {
        this.m_Evaluator = evaluator;
    }

    public ASEvaluation getEvaluator() {
        return this.m_Evaluator;
    }

    protected String getEvaluatorSpec() {
        ASEvaluation e = this.getEvaluator();
        if (e instanceof OptionHandler) {
            return String.valueOf(e.getClass().getName()) + " " + Utils.joinOptions(((OptionHandler)((Object)e)).getOptions());
        }
        return e.getClass().getName();
    }

    public String searchTipText() {
        return "Set the search method. This search method is used during the attribute selection phase before the classifier is invoked.";
    }

    public void setSearch(ASSearch search) {
        this.m_Search = search;
    }

    public ASSearch getSearch() {
        return this.m_Search;
    }

    protected String getSearchSpec() {
        ASSearch s = this.getSearch();
        if (s instanceof OptionHandler) {
            return String.valueOf(s.getClass().getName()) + " " + Utils.joinOptions(((OptionHandler)((Object)s)).getOptions());
        }
        return s.getClass().getName();
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = this.getEvaluator() == null ? super.getCapabilities() : this.getEvaluator().getCapabilities();
        Capabilities.Capability[] capabilityArray = Capabilities.Capability.values();
        int n = capabilityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Capabilities.Capability cap = capabilityArray[n2];
            result.enableDependency(cap);
            ++n2;
        }
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        if (this.m_Classifier == null) {
            throw new Exception("No base classifier has been set!");
        }
        if (this.m_Evaluator == null) {
            throw new Exception("No attribute evaluator has been set!");
        }
        if (this.m_Search == null) {
            throw new Exception("No search method has been set!");
        }
        this.getCapabilities().testWithFail(data);
        Instances newData = new Instances(data);
        newData.deleteWithMissingClass();
        if (newData.numInstances() == 0) {
            this.m_Classifier.buildClassifier(newData);
            return;
        }
        this.m_numClasses = newData.classAttribute().isNominal() ? newData.classAttribute().numValues() : 1;
        Instances resampledData = null;
        double weight = newData.instance(0).weight();
        boolean ok = false;
        int i = 1;
        while (i < newData.numInstances()) {
            if (newData.instance(i).weight() != weight) {
                ok = true;
                break;
            }
            ++i;
        }
        if (ok) {
            if (!(this.m_Evaluator instanceof WeightedInstancesHandler) || !(this.m_Classifier instanceof WeightedInstancesHandler)) {
                Random r = new Random(1L);
                int i2 = 0;
                while (i2 < 10) {
                    r.nextDouble();
                    ++i2;
                }
                resampledData = newData.resampleWithWeights(r);
            }
        } else {
            resampledData = newData;
        }
        this.m_AttributeSelection = new AttributeSelection();
        this.m_AttributeSelection.setEvaluator(this.m_Evaluator);
        this.m_AttributeSelection.setSearch(this.m_Search);
        long start = System.currentTimeMillis();
        this.m_AttributeSelection.SelectAttributes(this.m_Evaluator instanceof WeightedInstancesHandler ? newData : resampledData);
        long end = System.currentTimeMillis();
        if (this.m_Classifier instanceof WeightedInstancesHandler) {
            newData = this.m_AttributeSelection.reduceDimensionality(newData);
            this.m_Classifier.buildClassifier(newData);
        } else {
            resampledData = this.m_AttributeSelection.reduceDimensionality(resampledData);
            this.m_Classifier.buildClassifier(resampledData);
        }
        long end2 = System.currentTimeMillis();
        this.m_numAttributesSelected = this.m_AttributeSelection.numberAttributesSelected();
        this.m_ReducedHeader = new Instances(this.m_Classifier instanceof WeightedInstancesHandler ? newData : resampledData, 0);
        this.m_selectionTime = end - start;
        this.m_totalTime = end2 - start;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        Instance newInstance = this.m_AttributeSelection == null ? instance : this.m_AttributeSelection.reduceDimensionality(instance);
        return this.m_Classifier.distributionForInstance(newInstance);
    }

    @Override
    public int graphType() {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graphType();
        }
        return 0;
    }

    @Override
    public String graph() throws Exception {
        if (this.m_Classifier instanceof Drawable) {
            return ((Drawable)((Object)this.m_Classifier)).graph();
        }
        throw new Exception("Classifier: " + this.getClassifierSpec() + " cannot be graphed");
    }

    public String toString() {
        if (this.m_AttributeSelection == null) {
            return "AttributeSelectedClassifier: No attribute selection possible.\n\n" + this.m_Classifier.toString();
        }
        StringBuffer result = new StringBuffer();
        result.append("AttributeSelectedClassifier:\n\n");
        result.append(this.m_AttributeSelection.toResultsString());
        result.append("\n\nHeader of reduced data:\n" + this.m_ReducedHeader.toString());
        result.append("\n\nClassifier Model\n" + this.m_Classifier.toString());
        return result.toString();
    }

    public double measureNumAttributesSelected() {
        return this.m_numAttributesSelected;
    }

    public double measureSelectionTime() {
        return this.m_selectionTime;
    }

    public double measureTime() {
        return this.m_totalTime;
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>(3);
        newVector.addElement("measureNumAttributesSelected");
        newVector.addElement("measureSelectionTime");
        newVector.addElement("measureTime");
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            Enumeration en = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).enumerateMeasures();
            while (en.hasMoreElements()) {
                String mname = (String)en.nextElement();
                newVector.addElement(mname);
            }
        }
        return newVector.elements();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureNumAttributesSelected") == 0) {
            return this.measureNumAttributesSelected();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureSelectionTime") == 0) {
            return this.measureSelectionTime();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTime") == 0) {
            return this.measureTime();
        }
        if (this.m_Classifier instanceof AdditionalMeasureProducer) {
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(additionalMeasureName);
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (AttributeSelectedClassifier)");
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.26 $");
    }

    public static void main(String[] argv) {
        AttributeSelectedClassifier.runClassifier(new AttributeSelectedClassifier(), argv);
    }
}

