/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.AbstractClusterer;
import weka.clusterers.Clusterer;
import weka.clusterers.DensityBasedClusterer;
import weka.clusterers.SimpleKMeans;
import weka.clusterers.UpdateableClusterer;
import weka.core.Drawable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Range;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.converters.ConverterUtils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class ClusterEvaluation
implements Serializable,
RevisionHandler {
    static final long serialVersionUID = -830188327319128005L;
    private Clusterer m_Clusterer;
    private StringBuffer m_clusteringResults;
    private int m_numClusters;
    private double[] m_clusterAssignments;
    private double m_logL;
    private int[] m_classToCluster = null;

    public void setClusterer(Clusterer clusterer) {
        this.m_Clusterer = clusterer;
    }

    public String clusterResultsToString() {
        return this.m_clusteringResults.toString();
    }

    public int getNumClusters() {
        return this.m_numClusters;
    }

    public double[] getClusterAssignments() {
        return this.m_clusterAssignments;
    }

    public int[] getClassesToClusters() {
        return this.m_classToCluster;
    }

    public double getLogLikelihood() {
        return this.m_logL;
    }

    public ClusterEvaluation() {
        this.setClusterer(new SimpleKMeans());
        this.m_clusteringResults = new StringBuffer();
        this.m_clusterAssignments = null;
    }

    public void evaluateClusterer(Instances test) throws Exception {
        this.evaluateClusterer(test, "");
    }

    public void evaluateClusterer(Instances test, String testFileName) throws Exception {
        this.evaluateClusterer(test, testFileName, true);
    }

    public void evaluateClusterer(Instances test, String testFileName, boolean outputModel) throws Exception {
        int cc;
        int i = 0;
        double loglk = 0.0;
        this.m_numClusters = cc = this.m_Clusterer.numberOfClusters();
        double[] instanceStats = new double[cc];
        Instances testRaw = null;
        boolean hasClass = test.classIndex() >= 0;
        int unclusteredInstances = 0;
        Vector<Double> clusterAssignments = new Vector<Double>();
        Remove filter = null;
        ConverterUtils.DataSource source = null;
        if (testFileName == null) {
            testFileName = "";
        }
        source = testFileName.length() != 0 ? new ConverterUtils.DataSource(testFileName) : new ConverterUtils.DataSource(test);
        testRaw = source.getStructure(test.classIndex());
        if (hasClass) {
            if (testRaw.classAttribute().isNumeric()) {
                throw new Exception("ClusterEvaluation: Class must be nominal!");
            }
            filter = new Remove();
            filter.setAttributeIndices("" + (testRaw.classIndex() + 1));
            filter.setInvertSelection(false);
            ((Filter)filter).setInputFormat(testRaw);
        }
        i = 0;
        while (source.hasMoreElements(testRaw)) {
            Instance inst = source.nextElement(testRaw);
            if (filter != null) {
                ((Filter)filter).input(inst);
                filter.batchFinished();
                inst = filter.output();
            }
            int cnum = -1;
            try {
                if (this.m_Clusterer instanceof DensityBasedClusterer) {
                    loglk += ((DensityBasedClusterer)this.m_Clusterer).logDensityForInstance(inst);
                    cnum = this.m_Clusterer.clusterInstance(inst);
                    clusterAssignments.add(Double.valueOf(cnum));
                } else {
                    cnum = this.m_Clusterer.clusterInstance(inst);
                    clusterAssignments.add(Double.valueOf(cnum));
                }
            }
            catch (Exception e) {
                clusterAssignments.add(-1.0);
                ++unclusteredInstances;
            }
            if (cnum == -1) continue;
            int n = cnum;
            instanceStats[n] = instanceStats[n] + 1.0;
        }
        double sum = Utils.sum(instanceStats);
        this.m_logL = loglk /= sum;
        this.m_clusterAssignments = new double[clusterAssignments.size()];
        i = 0;
        while (i < clusterAssignments.size()) {
            this.m_clusterAssignments[i] = (Double)clusterAssignments.get(i);
            ++i;
        }
        int numInstFieldWidth = (int)(Math.log(clusterAssignments.size()) / Math.log(10.0) + 1.0);
        if (outputModel) {
            this.m_clusteringResults.append(this.m_Clusterer.toString());
        }
        this.m_clusteringResults.append("Clustered Instances\n\n");
        int clustFieldWidth = (int)(Math.log(cc) / Math.log(10.0) + 1.0);
        i = 0;
        while (i < cc) {
            if (instanceStats[i] > 0.0) {
                this.m_clusteringResults.append(String.valueOf(Utils.doubleToString(i, clustFieldWidth, 0)) + "      " + Utils.doubleToString(instanceStats[i], numInstFieldWidth, 0) + " (" + Utils.doubleToString(instanceStats[i] / sum * 100.0, 3, 0) + "%)\n");
            }
            ++i;
        }
        if (unclusteredInstances > 0) {
            this.m_clusteringResults.append("\nUnclustered instances : " + unclusteredInstances);
        }
        if (this.m_Clusterer instanceof DensityBasedClusterer) {
            this.m_clusteringResults.append("\n\nLog likelihood: " + Utils.doubleToString(loglk, 1, 5) + "\n");
        }
        if (hasClass) {
            this.evaluateClustersWithRespectToClass(test, testFileName);
        }
    }

    private void evaluateClustersWithRespectToClass(Instances inst, String fileName) throws Exception {
        int numClasses = inst.classAttribute().numValues();
        int[][] counts = new int[this.m_numClusters][numClasses];
        int[] clusterTotals = new int[this.m_numClusters];
        double[] best = new double[this.m_numClusters + 1];
        double[] current = new double[this.m_numClusters + 1];
        ConverterUtils.DataSource source = null;
        Instances instances = null;
        Instance instance = null;
        if (fileName == null) {
            fileName = "";
        }
        source = fileName.length() != 0 ? new ConverterUtils.DataSource(fileName) : new ConverterUtils.DataSource(inst);
        instances = source.getStructure(inst.classIndex());
        int i = 0;
        while (source.hasMoreElements(instances)) {
            instance = source.nextElement(instances);
            if (this.m_clusterAssignments[i] >= 0.0) {
                int[] nArray = counts[(int)this.m_clusterAssignments[i]];
                int n = (int)instance.classValue();
                nArray[n] = nArray[n] + 1;
                int n2 = (int)this.m_clusterAssignments[i];
                clusterTotals[n2] = clusterTotals[n2] + 1;
            }
            ++i;
        }
        int numInstances = i;
        best[this.m_numClusters] = Double.MAX_VALUE;
        ClusterEvaluation.mapClasses(this.m_numClusters, 0, counts, clusterTotals, current, best, 0);
        this.m_clusteringResults.append("\n\nClass attribute: " + inst.classAttribute().name() + "\n");
        this.m_clusteringResults.append("Classes to Clusters:\n");
        String matrixString = this.toMatrixString(counts, clusterTotals, new Instances(inst, 0));
        this.m_clusteringResults.append(matrixString).append("\n");
        int Cwidth = 1 + (int)(Math.log(this.m_numClusters) / Math.log(10.0));
        i = 0;
        while (i < this.m_numClusters) {
            if (clusterTotals[i] > 0) {
                this.m_clusteringResults.append("Cluster " + Utils.doubleToString(i, Cwidth, 0));
                this.m_clusteringResults.append(" <-- ");
                if (best[i] < 0.0) {
                    this.m_clusteringResults.append("No class\n");
                } else {
                    this.m_clusteringResults.append(inst.classAttribute().value((int)best[i])).append("\n");
                }
            }
            ++i;
        }
        this.m_clusteringResults.append("\nIncorrectly clustered instances :\t" + best[this.m_numClusters] + "\t" + Utils.doubleToString(best[this.m_numClusters] / (double)numInstances * 100.0, 8, 4) + " %\n");
        this.m_classToCluster = new int[this.m_numClusters];
        i = 0;
        while (i < this.m_numClusters) {
            this.m_classToCluster[i] = (int)best[i];
            ++i;
        }
    }

    private String toMatrixString(int[][] counts, int[] clusterTotals, Instances inst) throws Exception {
        StringBuffer ms = new StringBuffer();
        int maxval = 0;
        int i = 0;
        while (i < this.m_numClusters) {
            int j = 0;
            while (j < counts[i].length) {
                if (counts[i][j] > maxval) {
                    maxval = counts[i][j];
                }
                ++j;
            }
            ++i;
        }
        int Cwidth = 1 + Math.max((int)(Math.log(maxval) / Math.log(10.0)), (int)(Math.log(this.m_numClusters) / Math.log(10.0)));
        ms.append("\n");
        int i2 = 0;
        while (i2 < this.m_numClusters) {
            if (clusterTotals[i2] > 0) {
                ms.append(" ").append(Utils.doubleToString(i2, Cwidth, 0));
            }
            ++i2;
        }
        ms.append("  <-- assigned to cluster\n");
        i2 = 0;
        while (i2 < counts[0].length) {
            int j = 0;
            while (j < this.m_numClusters) {
                if (clusterTotals[j] > 0) {
                    ms.append(" ").append(Utils.doubleToString(counts[j][i2], Cwidth, 0));
                }
                ++j;
            }
            ms.append(" | ").append(inst.classAttribute().value(i2)).append("\n");
            ++i2;
        }
        return ms.toString();
    }

    public static void mapClasses(int numClusters, int lev, int[][] counts, int[] clusterTotals, double[] current, double[] best, int error) {
        block9: {
            block8: {
                if (lev != numClusters) break block8;
                if (!((double)error < best[numClusters])) break block9;
                best[numClusters] = error;
                int i = 0;
                while (i < numClusters) {
                    best[i] = current[i];
                    ++i;
                }
                break block9;
            }
            if (clusterTotals[lev] == 0) {
                current[lev] = -1.0;
                ClusterEvaluation.mapClasses(numClusters, lev + 1, counts, clusterTotals, current, best, error);
            } else {
                current[lev] = -1.0;
                ClusterEvaluation.mapClasses(numClusters, lev + 1, counts, clusterTotals, current, best, error + clusterTotals[lev]);
                int i = 0;
                while (i < counts[0].length) {
                    if (counts[lev][i] > 0) {
                        boolean ok = true;
                        int j = 0;
                        while (j < lev) {
                            if ((int)current[j] == i) {
                                ok = false;
                                break;
                            }
                            ++j;
                        }
                        if (ok) {
                            current[lev] = i;
                            ClusterEvaluation.mapClasses(numClusters, lev + 1, counts, clusterTotals, current, best, error + (clusterTotals[lev] - counts[lev][i]));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static String evaluateClusterer(Clusterer clusterer, String[] options) throws Exception {
        String graphFileName;
        String testFileName;
        String trainFileName;
        String objectOutputFileName;
        String objectInputFileName;
        int seed = 1;
        int folds = 10;
        boolean doXval = false;
        Instances train = null;
        String[] savedOptions = null;
        boolean printClusterAssignments = false;
        Range attributesToOutput = null;
        StringBuffer text = new StringBuffer();
        int theClass = -1;
        boolean updateable = clusterer instanceof UpdateableClusterer;
        ConverterUtils.DataSource source = null;
        if (Utils.getFlag('h', options) || Utils.getFlag("help", options)) {
            boolean globalInfo = Utils.getFlag("synopsis", options) || Utils.getFlag("info", options);
            throw new Exception("Help requested." + ClusterEvaluation.makeOptionString(clusterer, globalInfo));
        }
        try {
            String foldsString;
            String seedString;
            String attributeRangeString;
            objectInputFileName = Utils.getOption('l', options);
            objectOutputFileName = Utils.getOption('d', options);
            trainFileName = Utils.getOption('t', options);
            testFileName = Utils.getOption('T', options);
            graphFileName = Utils.getOption('g', options);
            try {
                attributeRangeString = Utils.getOption('p', options);
            }
            catch (Exception e) {
                throw new Exception(String.valueOf(e.getMessage()) + "\nNOTE: the -p option has changed. " + "It now expects a parameter specifying a range of attributes " + "to list with the predictions. Use '-p 0' for none.");
            }
            if (attributeRangeString.length() != 0) {
                printClusterAssignments = true;
                if (!attributeRangeString.equals("0")) {
                    attributesToOutput = new Range(attributeRangeString);
                }
            }
            if (trainFileName.length() == 0) {
                if (objectInputFileName.length() == 0) {
                    throw new Exception("No training file and no object input file given.");
                }
                if (testFileName.length() == 0) {
                    throw new Exception("No training file and no test file given.");
                }
            } else if (objectInputFileName.length() != 0 && !printClusterAssignments) {
                throw new Exception("Can't use both train and model file unless -p specified.");
            }
            if ((seedString = Utils.getOption('s', options)).length() != 0) {
                seed = Integer.parseInt(seedString);
            }
            if ((foldsString = Utils.getOption('x', options)).length() != 0) {
                folds = Integer.parseInt(foldsString);
                doXval = true;
            }
        }
        catch (Exception e) {
            throw new Exception(String.valueOf('\n') + e.getMessage() + ClusterEvaluation.makeOptionString(clusterer, false));
        }
        try {
            if (trainFileName.length() != 0) {
                source = new ConverterUtils.DataSource(trainFileName);
                train = source.getStructure();
                String classString = Utils.getOption('c', options);
                if (classString.length() != 0) {
                    theClass = classString.compareTo("last") == 0 ? train.numAttributes() : (classString.compareTo("first") == 0 ? 1 : Integer.parseInt(classString));
                    if (theClass != -1) {
                        if (doXval || testFileName.length() != 0) {
                            throw new Exception("Can only do class based evaluation on the training data");
                        }
                        if (objectInputFileName.length() != 0) {
                            throw new Exception("Can't load a clusterer and do class based evaluation");
                        }
                        if (objectOutputFileName.length() != 0) {
                            throw new Exception("Can't do class based evaluation and save clusterer");
                        }
                    }
                } else if (train.classIndex() != -1) {
                    theClass = train.classIndex() + 1;
                    System.err.println("Note: using class attribute from dataset, i.e., attribute #" + theClass);
                }
                if (theClass != -1) {
                    if (theClass < 1 || theClass > train.numAttributes()) {
                        throw new Exception("Class is out of range!");
                    }
                    if (!train.attribute(theClass - 1).isNominal()) {
                        throw new Exception("Class must be nominal!");
                    }
                    train.setClassIndex(theClass - 1);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("ClusterEvaluation: " + e.getMessage() + '.');
        }
        if (options != null) {
            savedOptions = new String[options.length];
            System.arraycopy(options, 0, savedOptions, 0, options.length);
        }
        if (objectInputFileName.length() != 0) {
            Utils.checkForRemainingOptions(options);
        }
        if (clusterer instanceof OptionHandler) {
            ((OptionHandler)((Object)clusterer)).setOptions(options);
        }
        Utils.checkForRemainingOptions(options);
        Instances trainHeader = train;
        if (objectInputFileName.length() != 0) {
            ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(objectInputFileName)));
            clusterer = (Clusterer)ois.readObject();
            try {
                trainHeader = (Instances)ois.readObject();
            }
            catch (Exception exception) {}
        } else if (theClass == -1) {
            if (updateable) {
                clusterer.buildClusterer(source.getStructure());
                while (source.hasMoreElements(train)) {
                    Instance inst = source.nextElement(train);
                    ((UpdateableClusterer)((Object)clusterer)).updateClusterer(inst);
                }
                ((UpdateableClusterer)((Object)clusterer)).updateFinished();
            } else {
                clusterer.buildClusterer(source.getDataSet());
            }
        } else {
            Instances clusterTrain;
            Remove removeClass = new Remove();
            removeClass.setAttributeIndices("" + theClass);
            removeClass.setInvertSelection(false);
            removeClass.setInputFormat(train);
            if (updateable) {
                clusterTrain = Filter.useFilter(train, removeClass);
                clusterer.buildClusterer(clusterTrain);
                trainHeader = clusterTrain;
                while (source.hasMoreElements(train)) {
                    Instance inst = source.nextElement(train);
                    removeClass.input(inst);
                    removeClass.batchFinished();
                    Instance clusterTrainInst = removeClass.output();
                    ((UpdateableClusterer)((Object)clusterer)).updateClusterer(clusterTrainInst);
                }
                ((UpdateableClusterer)((Object)clusterer)).updateFinished();
            } else {
                clusterTrain = Filter.useFilter(source.getDataSet(), removeClass);
                clusterer.buildClusterer(clusterTrain);
                trainHeader = clusterTrain;
            }
            ClusterEvaluation ce = new ClusterEvaluation();
            ce.setClusterer(clusterer);
            ce.evaluateClusterer(train, trainFileName);
            return "\n\n=== Clustering stats for training data ===\n\n" + ce.clusterResultsToString();
        }
        if (printClusterAssignments) {
            return ClusterEvaluation.printClusterings(clusterer, trainFileName, testFileName, attributesToOutput);
        }
        text.append(clusterer.toString());
        text.append("\n\n=== Clustering stats for training data ===\n\n" + ClusterEvaluation.printClusterStats(clusterer, trainFileName));
        if (testFileName.length() != 0) {
            ConverterUtils.DataSource test = new ConverterUtils.DataSource(testFileName);
            Instances testStructure = test.getStructure();
            if (!trainHeader.equalHeaders(testStructure)) {
                throw new Exception("Training and testing data are not compatible\n" + trainHeader.equalHeadersMsg(testStructure));
            }
            text.append("\n\n=== Clustering stats for testing data ===\n\n" + ClusterEvaluation.printClusterStats(clusterer, testFileName));
        }
        if (clusterer instanceof DensityBasedClusterer && doXval && testFileName.length() == 0 && objectInputFileName.length() == 0) {
            Random random = new Random(seed);
            random.setSeed(seed);
            train = source.getDataSet();
            train.randomize(random);
            text.append(ClusterEvaluation.crossValidateModel(clusterer.getClass().getName(), train, folds, savedOptions, random));
        }
        if (objectOutputFileName.length() != 0) {
            ClusterEvaluation.saveClusterer(objectOutputFileName, clusterer, trainHeader);
        }
        if (clusterer instanceof Drawable && graphFileName.length() != 0) {
            BufferedWriter writer = new BufferedWriter(new FileWriter(graphFileName));
            writer.write(((Drawable)((Object)clusterer)).graph());
            writer.newLine();
            writer.flush();
            writer.close();
        }
        return text.toString();
    }

    private static void saveClusterer(String fileName, Clusterer clusterer, Instances header) throws Exception {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
        oos.writeObject(clusterer);
        if (header != null) {
            oos.writeObject(header);
        }
        oos.flush();
        oos.close();
    }

    public static double crossValidateModel(DensityBasedClusterer clusterer, Instances data, int numFolds, Random random) throws Exception {
        double foldAv = 0.0;
        data = new Instances(data);
        data.randomize(random);
        int i = 0;
        while (i < numFolds) {
            Instances train = data.trainCV(numFolds, i, random);
            clusterer.buildClusterer(train);
            Instances test = data.testCV(numFolds, i);
            int j = 0;
            while (j < test.numInstances()) {
                try {
                    foldAv += clusterer.logDensityForInstance(test.instance(j));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++j;
            }
            ++i;
        }
        return foldAv / (double)data.numInstances();
    }

    public static String crossValidateModel(String clustererString, Instances data, int numFolds, String[] options, Random random) throws Exception {
        Clusterer clusterer = null;
        String[] savedOptions = null;
        double CvAv = 0.0;
        StringBuffer CvString = new StringBuffer();
        if (options != null) {
            savedOptions = new String[options.length];
        }
        data = new Instances(data);
        try {
            clusterer = (Clusterer)Class.forName(clustererString).newInstance();
        }
        catch (Exception e) {
            throw new Exception("Can't find class with name " + clustererString + '.');
        }
        if (!(clusterer instanceof DensityBasedClusterer)) {
            throw new Exception(String.valueOf(clustererString) + " must be a distrinbution " + "clusterer.");
        }
        if (options != null) {
            System.arraycopy(options, 0, savedOptions, 0, options.length);
        }
        if (clusterer instanceof OptionHandler) {
            try {
                ((OptionHandler)((Object)clusterer)).setOptions(savedOptions);
                Utils.checkForRemainingOptions(savedOptions);
            }
            catch (Exception e) {
                throw new Exception("Can't parse given options in cross-validation!");
            }
        }
        CvAv = ClusterEvaluation.crossValidateModel((DensityBasedClusterer)clusterer, data, numFolds, random);
        CvString.append("\n" + numFolds + " fold CV Log Likelihood: " + Utils.doubleToString(CvAv, 6, 4) + "\n");
        return CvString.toString();
    }

    private static String printClusterStats(Clusterer clusterer, String fileName) throws Exception {
        StringBuffer text = new StringBuffer();
        int i = 0;
        double loglk = 0.0;
        int cc = clusterer.numberOfClusters();
        double[] instanceStats = new double[cc];
        int unclusteredInstances = 0;
        if (fileName.length() != 0) {
            ConverterUtils.DataSource source = new ConverterUtils.DataSource(fileName);
            Instances structure = source.getStructure();
            while (source.hasMoreElements(structure)) {
                Instance inst = source.nextElement(structure);
                try {
                    int cnum = clusterer.clusterInstance(inst);
                    if (clusterer instanceof DensityBasedClusterer) {
                        loglk += ((DensityBasedClusterer)clusterer).logDensityForInstance(inst);
                    }
                    int n = cnum;
                    instanceStats[n] = instanceStats[n] + 1.0;
                }
                catch (Exception e) {
                    ++unclusteredInstances;
                }
                ++i;
            }
            int clustFieldWidth = (int)(Math.log(cc) / Math.log(10.0) + 1.0);
            int numInstFieldWidth = (int)(Math.log(i) / Math.log(10.0) + 1.0);
            double sum = Utils.sum(instanceStats);
            loglk /= sum;
            text.append("Clustered Instances\n");
            i = 0;
            while (i < cc) {
                if (instanceStats[i] > 0.0) {
                    text.append(String.valueOf(Utils.doubleToString(i, clustFieldWidth, 0)) + "      " + Utils.doubleToString(instanceStats[i], numInstFieldWidth, 0) + " (" + Utils.doubleToString(instanceStats[i] / sum * 100.0, 3, 0) + "%)\n");
                }
                ++i;
            }
            if (unclusteredInstances > 0) {
                text.append("\nUnclustered Instances : " + unclusteredInstances);
            }
            if (clusterer instanceof DensityBasedClusterer) {
                text.append("\n\nLog likelihood: " + Utils.doubleToString(loglk, 1, 5) + "\n");
            }
        }
        return text.toString();
    }

    private static String printClusterings(Clusterer clusterer, String trainFileName, String testFileName, Range attributesToOutput) throws Exception {
        StringBuffer text = new StringBuffer();
        int i = 0;
        ConverterUtils.DataSource source = null;
        source = testFileName.length() != 0 ? new ConverterUtils.DataSource(testFileName) : new ConverterUtils.DataSource(trainFileName);
        Instances structure = source.getStructure();
        while (source.hasMoreElements(structure)) {
            Instance inst = source.nextElement(structure);
            try {
                int cnum = clusterer.clusterInstance(inst);
                text.append(String.valueOf(i) + " " + cnum + " " + ClusterEvaluation.attributeValuesString(inst, attributesToOutput) + "\n");
            }
            catch (Exception e) {
                text.append(String.valueOf(i) + " Unclustered " + ClusterEvaluation.attributeValuesString(inst, attributesToOutput) + "\n");
            }
            ++i;
        }
        return text.toString();
    }

    private static String attributeValuesString(Instance instance, Range attRange) {
        StringBuffer text = new StringBuffer();
        if (attRange != null) {
            boolean firstOutput = true;
            attRange.setUpper(instance.numAttributes() - 1);
            int i = 0;
            while (i < instance.numAttributes()) {
                if (attRange.isInRange(i)) {
                    if (firstOutput) {
                        text.append("(");
                    } else {
                        text.append(",");
                    }
                    text.append(instance.toString(i));
                    firstOutput = false;
                }
                ++i;
            }
            if (!firstOutput) {
                text.append(")");
            }
        }
        return text.toString();
    }

    private static String makeOptionString(Clusterer clusterer, boolean globalInfo) {
        StringBuffer optionsText = new StringBuffer("");
        optionsText.append("\n\nGeneral options:\n\n");
        optionsText.append("-h or -help\n");
        optionsText.append("\tOutput help information.\n");
        optionsText.append("-synopsis or -info\n");
        optionsText.append("\tOutput synopsis for clusterer (use in conjunction  with -h)\n");
        optionsText.append("-t <name of training file>\n");
        optionsText.append("\tSets training file.\n");
        optionsText.append("-T <name of test file>\n");
        optionsText.append("\tSets test file.\n");
        optionsText.append("-l <name of input file>\n");
        optionsText.append("\tSets model input file.\n");
        optionsText.append("-d <name of output file>\n");
        optionsText.append("\tSets model output file.\n");
        optionsText.append("-p <attribute range>\n");
        optionsText.append("\tOutput predictions. Predictions are for training file\n\tif only training file is specified,\n\totherwise predictions are for the test file.\n\tThe range specifies attribute values to be output\n\twith the predictions. Use '-p 0' for none.\n");
        optionsText.append("-x <number of folds>\n");
        optionsText.append("\tOnly Distribution Clusterers can be cross validated.\n");
        optionsText.append("-s <random number seed>\n");
        optionsText.append("\tSets the seed for randomizing the data in cross-validation\n");
        optionsText.append("-c <class index>\n");
        optionsText.append("\tSet class attribute. If supplied, class is ignored");
        optionsText.append("\n\tduring clustering but is used in a classes to");
        optionsText.append("\n\tclusters evaluation.\n");
        if (clusterer instanceof Drawable) {
            optionsText.append("-g <name of graph file>\n");
            optionsText.append("\tOutputs the graph representation of the clusterer to the file.\n");
        }
        if (clusterer instanceof OptionHandler) {
            optionsText.append("\nOptions specific to " + clusterer.getClass().getName() + ":\n\n");
            Enumeration enu = ((OptionHandler)((Object)clusterer)).listOptions();
            while (enu.hasMoreElements()) {
                Option option = (Option)enu.nextElement();
                optionsText.append(String.valueOf(option.synopsis()) + '\n');
                optionsText.append(String.valueOf(option.description()) + "\n");
            }
        }
        if (globalInfo) {
            try {
                String gi = ClusterEvaluation.getGlobalInfo(clusterer);
                optionsText.append(gi);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return optionsText.toString();
    }

    protected static String getGlobalInfo(Clusterer clusterer) throws Exception {
        BeanInfo bi = Introspector.getBeanInfo(clusterer.getClass());
        MethodDescriptor[] methods = bi.getMethodDescriptors();
        Object[] args = new Object[]{};
        String result = "\nSynopsis for " + clusterer.getClass().getName() + ":\n\n";
        int i = 0;
        while (i < methods.length) {
            String name = methods[i].getDisplayName();
            Method meth = methods[i].getMethod();
            if (name.equals("globalInfo")) {
                String globalInfo = (String)meth.invoke((Object)clusterer, args);
                result = String.valueOf(result) + globalInfo;
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        String clusteringResults2;
        int i;
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ClusterEvaluation cmp = (ClusterEvaluation)obj;
        if (this.m_classToCluster != null != (cmp.m_classToCluster != null)) {
            return false;
        }
        if (this.m_classToCluster != null) {
            i = 0;
            while (i < this.m_classToCluster.length) {
                if (this.m_classToCluster[i] != cmp.m_classToCluster[i]) {
                    return false;
                }
                ++i;
            }
        }
        if (this.m_clusterAssignments != null != (cmp.m_clusterAssignments != null)) {
            return false;
        }
        if (this.m_clusterAssignments != null) {
            i = 0;
            while (i < this.m_clusterAssignments.length) {
                if (this.m_clusterAssignments[i] != cmp.m_clusterAssignments[i]) {
                    return false;
                }
                ++i;
            }
        }
        if (Double.isNaN(this.m_logL) != Double.isNaN(cmp.m_logL)) {
            return false;
        }
        if (!Double.isNaN(this.m_logL) && this.m_logL != cmp.m_logL) {
            return false;
        }
        if (this.m_numClusters != cmp.m_numClusters) {
            return false;
        }
        String clusteringResults1 = this.m_clusteringResults.toString().replaceAll("Elapsed time.*", "");
        return clusteringResults1.equals(clusteringResults2 = cmp.m_clusteringResults.toString().replaceAll("Elapsed time.*", ""));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7756 $");
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                throw new Exception("The first argument must be the name of a clusterer");
            }
            String ClustererString = args[0];
            args[0] = "";
            Clusterer newClusterer = AbstractClusterer.forName(ClustererString, null);
            System.out.println(ClusterEvaluation.evaluateClusterer(newClusterer, args));
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

