/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import weka.core.Copyable;
import weka.core.Instances;
import weka.core.ProtectedProperties;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.core.WekaEnumeration;

public class Attribute
implements Copyable,
Serializable,
RevisionHandler {
    static final long serialVersionUID = -742180568732916383L;
    public static final int NUMERIC = 0;
    public static final int NOMINAL = 1;
    public static final int STRING = 2;
    public static final int DATE = 3;
    public static final int RELATIONAL = 4;
    public static final int ORDERING_SYMBOLIC = 0;
    public static final int ORDERING_ORDERED = 1;
    public static final int ORDERING_MODULO = 2;
    public static final String ARFF_ATTRIBUTE = "@attribute";
    public static final String ARFF_ATTRIBUTE_INTEGER = "integer";
    public static final String ARFF_ATTRIBUTE_REAL = "real";
    public static final String ARFF_ATTRIBUTE_NUMERIC = "numeric";
    public static final String ARFF_ATTRIBUTE_STRING = "string";
    public static final String ARFF_ATTRIBUTE_DATE = "date";
    public static final String ARFF_ATTRIBUTE_RELATIONAL = "relational";
    public static final String ARFF_END_SUBRELATION = "@end";
    private static final int STRING_COMPRESS_THRESHOLD = 200;
    private String m_Name;
    private int m_Type;
    private ArrayList<Object> m_Values;
    private Hashtable<Object, Integer> m_Hashtable;
    private Instances m_Header;
    private SimpleDateFormat m_DateFormat;
    private int m_Index;
    private ProtectedProperties m_Metadata;
    private int m_Ordering;
    private boolean m_IsRegular;
    private boolean m_IsAveragable;
    private boolean m_HasZeropoint;
    private double m_Weight;
    private double m_LowerBound;
    private boolean m_LowerBoundIsOpen;
    private double m_UpperBound;
    private boolean m_UpperBoundIsOpen;

    public Attribute(String attributeName) {
        this(attributeName, new ProtectedProperties(new Properties()));
    }

    public Attribute(String attributeName, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        this.m_Index = -1;
        this.m_Values = null;
        this.m_Hashtable = null;
        this.m_Header = null;
        this.m_Type = 0;
        this.setMetadata(metadata);
    }

    public Attribute(String attributeName, String dateFormat) {
        this(attributeName, dateFormat, new ProtectedProperties(new Properties()));
    }

    public Attribute(String attributeName, String dateFormat, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        this.m_Index = -1;
        this.m_Values = null;
        this.m_Hashtable = null;
        this.m_Header = null;
        this.m_Type = 3;
        this.m_DateFormat = dateFormat != null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        this.m_DateFormat.setLenient(false);
        this.setMetadata(metadata);
    }

    public Attribute(String attributeName, List<String> attributeValues) {
        this(attributeName, attributeValues, new ProtectedProperties(new Properties()));
    }

    public Attribute(String attributeName, List<String> attributeValues, ProtectedProperties metadata) {
        this.m_Name = attributeName;
        this.m_Index = -1;
        if (attributeValues == null) {
            this.m_Values = new ArrayList();
            this.m_Hashtable = new Hashtable();
            this.m_Header = null;
            this.m_Type = 2;
        } else {
            this.m_Values = new ArrayList(attributeValues.size());
            this.m_Hashtable = new Hashtable(attributeValues.size());
            this.m_Header = null;
            int i = 0;
            while (i < attributeValues.size()) {
                Object store = attributeValues.get(i);
                if (((String)store).length() > 200) {
                    try {
                        store = new SerializedObject(attributeValues.get(i), true);
                    }
                    catch (Exception ex) {
                        System.err.println("Couldn't compress nominal attribute value - storing uncompressed.");
                    }
                }
                if (this.m_Hashtable.containsKey(store)) {
                    throw new IllegalArgumentException("A nominal attribute (" + attributeName + ") cannot" + " have duplicate labels (" + store + ").");
                }
                this.m_Values.add(store);
                this.m_Hashtable.put(store, new Integer(i));
                ++i;
            }
            this.m_Type = 1;
        }
        this.setMetadata(metadata);
    }

    public Attribute(String attributeName, Instances header) {
        this(attributeName, header, new ProtectedProperties(new Properties()));
    }

    public Attribute(String attributeName, Instances header, ProtectedProperties metadata) {
        if (header.numInstances() > 0) {
            throw new IllegalArgumentException("Header for relation-valued attribute should not contain any instances");
        }
        this.m_Name = attributeName;
        this.m_Index = -1;
        this.m_Values = new ArrayList();
        this.m_Hashtable = new Hashtable();
        this.m_Header = header;
        this.m_Type = 4;
        this.setMetadata(metadata);
    }

    @Override
    public Object copy() {
        Attribute copy = new Attribute(this.m_Name);
        copy.m_Index = this.m_Index;
        copy.m_Type = this.m_Type;
        copy.m_Values = this.m_Values;
        copy.m_Hashtable = this.m_Hashtable;
        copy.m_DateFormat = this.m_DateFormat;
        copy.m_Header = this.m_Header;
        copy.setMetadata(this.m_Metadata);
        return copy;
    }

    public final Enumeration enumerateValues() {
        if (this.isNominal() || this.isString()) {
            final WekaEnumeration ee = new WekaEnumeration(this.m_Values);
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return ee.hasMoreElements();
                }

                public Object nextElement() {
                    Object oo = ee.nextElement();
                    if (oo instanceof SerializedObject) {
                        return ((SerializedObject)oo).getObject();
                    }
                    return oo;
                }
            };
        }
        return null;
    }

    public final boolean equals(Object other) {
        return this.equalsMsg(other) == null;
    }

    public final String equalsMsg(Object other) {
        if (other == null) {
            return "Comparing with null object";
        }
        if (!other.getClass().equals(this.getClass())) {
            return "Object has wrong class";
        }
        Attribute att = (Attribute)other;
        if (!this.m_Name.equals(att.m_Name)) {
            return "Names differ: " + this.m_Name + " != " + att.m_Name;
        }
        if (this.isNominal() && att.isNominal()) {
            if (this.m_Values.size() != att.m_Values.size()) {
                return "Different number of labels: " + this.m_Values.size() + " != " + att.m_Values.size();
            }
            int i = 0;
            while (i < this.m_Values.size()) {
                if (!this.m_Values.get(i).equals(att.m_Values.get(i))) {
                    return "Labels differ at position " + (i + 1) + ": " + this.m_Values.get(i) + " != " + att.m_Values.get(i);
                }
                ++i;
            }
            return null;
        }
        if (this.isRelationValued() && att.isRelationValued()) {
            return this.m_Header.equalHeadersMsg(att.m_Header);
        }
        if (this.type() != att.type()) {
            return "Types differ: " + Attribute.typeToString(this) + " != " + Attribute.typeToString(att);
        }
        return null;
    }

    public static String typeToString(Attribute att) {
        return Attribute.typeToString(att.type());
    }

    public static String typeToString(int type) {
        String result;
        switch (type) {
            case 0: {
                result = ARFF_ATTRIBUTE_NUMERIC;
                break;
            }
            case 1: {
                result = "nominal";
                break;
            }
            case 2: {
                result = ARFF_ATTRIBUTE_STRING;
                break;
            }
            case 3: {
                result = ARFF_ATTRIBUTE_DATE;
                break;
            }
            case 4: {
                result = ARFF_ATTRIBUTE_RELATIONAL;
                break;
            }
            default: {
                result = "unknown(" + type + ")";
            }
        }
        return result;
    }

    public static String typeToStringShort(Attribute att) {
        return Attribute.typeToStringShort(att.type());
    }

    public static String typeToStringShort(int type) {
        String result;
        switch (type) {
            case 0: {
                result = "Num";
                break;
            }
            case 1: {
                result = "Nom";
                break;
            }
            case 2: {
                result = "Str";
                break;
            }
            case 3: {
                result = "Dat";
                break;
            }
            case 4: {
                result = "Rel";
                break;
            }
            default: {
                result = "???";
            }
        }
        return result;
    }

    public final int index() {
        return this.m_Index;
    }

    public final int indexOfValue(String value) {
        Integer val;
        if (!this.isNominal() && !this.isString()) {
            return -1;
        }
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - searching uncompressed.");
            }
        }
        if ((val = this.m_Hashtable.get(store)) == null) {
            return -1;
        }
        return val;
    }

    public final boolean isNominal() {
        return this.m_Type == 1;
    }

    public final boolean isNumeric() {
        return this.m_Type == 0 || this.m_Type == 3;
    }

    public final boolean isRelationValued() {
        return this.m_Type == 4;
    }

    public final boolean isString() {
        return this.m_Type == 2;
    }

    public final boolean isDate() {
        return this.m_Type == 3;
    }

    public final String name() {
        return this.m_Name;
    }

    public final int numValues() {
        if (!(this.isNominal() || this.isString() || this.isRelationValued())) {
            return 0;
        }
        return this.m_Values.size();
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append(ARFF_ATTRIBUTE).append(" ").append(Utils.quote(this.m_Name)).append(" ");
        switch (this.m_Type) {
            case 1: {
                text.append('{');
                Enumeration enu = this.enumerateValues();
                while (enu.hasMoreElements()) {
                    text.append(Utils.quote((String)enu.nextElement()));
                    if (!enu.hasMoreElements()) continue;
                    text.append(',');
                }
                text.append('}');
                break;
            }
            case 0: {
                text.append(ARFF_ATTRIBUTE_NUMERIC);
                break;
            }
            case 2: {
                text.append(ARFF_ATTRIBUTE_STRING);
                break;
            }
            case 3: {
                text.append(ARFF_ATTRIBUTE_DATE).append(" ").append(Utils.quote(this.m_DateFormat.toPattern()));
                break;
            }
            case 4: {
                text.append(ARFF_ATTRIBUTE_RELATIONAL).append("\n");
                Enumeration enm = this.m_Header.enumerateAttributes();
                while (enm.hasMoreElements()) {
                    text.append(enm.nextElement()).append("\n");
                }
                text.append(ARFF_END_SUBRELATION).append(" ").append(Utils.quote(this.m_Name));
                break;
            }
            default: {
                text.append("UNKNOWN");
            }
        }
        return text.toString();
    }

    public final int type() {
        return this.m_Type;
    }

    public final String getDateFormat() {
        if (this.isDate()) {
            return this.m_DateFormat.toPattern();
        }
        return "";
    }

    public final String value(int valIndex) {
        if (!this.isNominal() && !this.isString()) {
            return "";
        }
        Object val = this.m_Values.get(valIndex);
        if (val instanceof SerializedObject) {
            val = ((SerializedObject)val).getObject();
        }
        return (String)val;
    }

    public final Instances relation() {
        if (!this.isRelationValued()) {
            return null;
        }
        return this.m_Header;
    }

    public final Instances relation(int valIndex) {
        if (!this.isRelationValued()) {
            return null;
        }
        return (Instances)this.m_Values.get(valIndex);
    }

    public Attribute(String attributeName, int index) {
        this(attributeName);
        this.m_Index = index;
    }

    public Attribute(String attributeName, String dateFormat, int index) {
        this(attributeName, dateFormat);
        this.m_Index = index;
    }

    public Attribute(String attributeName, List<String> attributeValues, int index) {
        this(attributeName, attributeValues);
        this.m_Index = index;
    }

    public Attribute(String attributeName, Instances header, int index) {
        this(attributeName, header);
        this.m_Index = index;
    }

    public int addStringValue(String value) {
        Integer index;
        if (!this.isString()) {
            return -1;
        }
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        if ((index = this.m_Hashtable.get(store)) != null) {
            return index;
        }
        int intIndex = this.m_Values.size();
        this.m_Values.add(store);
        this.m_Hashtable.put(store, new Integer(intIndex));
        return intIndex;
    }

    public void setStringValue(String value) {
        if (!this.isString()) {
            return;
        }
        this.m_Hashtable.clear();
        this.m_Values.clear();
        this.addStringValue(value);
    }

    public int addStringValue(Attribute src, int index) {
        if (!this.isString()) {
            return -1;
        }
        Object store = src.m_Values.get(index);
        Integer oldIndex = this.m_Hashtable.get(store);
        if (oldIndex != null) {
            return oldIndex;
        }
        int intIndex = this.m_Values.size();
        this.m_Values.add(store);
        this.m_Hashtable.put(store, new Integer(intIndex));
        return intIndex;
    }

    public int addRelation(Instances value) {
        if (!this.isRelationValued()) {
            return -1;
        }
        if (!this.m_Header.equalHeaders(value)) {
            throw new IllegalArgumentException("Incompatible value for relation-valued attribute.\n" + this.m_Header.equalHeadersMsg(value));
        }
        Integer index = this.m_Hashtable.get(value);
        if (index != null) {
            return index;
        }
        int intIndex = this.m_Values.size();
        this.m_Values.add(value);
        this.m_Hashtable.put(value, new Integer(intIndex));
        return intIndex;
    }

    final void addValue(String value) {
        this.m_Values = (ArrayList)Utils.cast(this.m_Values.clone());
        this.m_Hashtable = (Hashtable)Utils.cast(this.m_Hashtable.clone());
        this.forceAddValue(value);
    }

    public final Attribute copy(String newName) {
        Attribute copy = new Attribute(newName);
        copy.m_Index = this.m_Index;
        copy.m_DateFormat = this.m_DateFormat;
        copy.m_Type = this.m_Type;
        copy.m_Values = this.m_Values;
        copy.m_Hashtable = this.m_Hashtable;
        copy.m_Header = this.m_Header;
        copy.setMetadata(this.m_Metadata);
        return copy;
    }

    final void delete(int index) {
        if (!(this.isNominal() || this.isString() || this.isRelationValued())) {
            throw new IllegalArgumentException("Can only remove value of nominal, string or relation- valued attribute!");
        }
        this.m_Values = (ArrayList)Utils.cast(this.m_Values.clone());
        this.m_Values.remove(index);
        if (!this.isRelationValued()) {
            Hashtable<Object, Integer> hash = new Hashtable<Object, Integer>(this.m_Hashtable.size());
            Enumeration<Object> enu = this.m_Hashtable.keys();
            while (enu.hasMoreElements()) {
                Object string = enu.nextElement();
                Integer valIndexObject = this.m_Hashtable.get(string);
                int valIndex = valIndexObject;
                if (valIndex > index) {
                    hash.put(string, new Integer(valIndex - 1));
                    continue;
                }
                if (valIndex >= index) continue;
                hash.put(string, valIndexObject);
            }
            this.m_Hashtable = hash;
        }
    }

    final void forceAddValue(String value) {
        Object store = value;
        if (value.length() > 200) {
            try {
                store = new SerializedObject(value, true);
            }
            catch (Exception ex) {
                System.err.println("Couldn't compress string attribute value - storing uncompressed.");
            }
        }
        this.m_Values.add(store);
        this.m_Hashtable.put(store, new Integer(this.m_Values.size() - 1));
    }

    final void setIndex(int index) {
        this.m_Index = index;
    }

    final void setValue(int index, String string) {
        switch (this.m_Type) {
            case 1: 
            case 2: {
                this.m_Values = (ArrayList)Utils.cast(this.m_Values.clone());
                this.m_Hashtable = (Hashtable)Utils.cast(this.m_Hashtable.clone());
                Object store = string;
                if (string.length() > 200) {
                    try {
                        store = new SerializedObject(string, true);
                    }
                    catch (Exception ex) {
                        System.err.println("Couldn't compress string attribute value - storing uncompressed.");
                    }
                }
                this.m_Hashtable.remove(this.m_Values.get(index));
                this.m_Values.set(index, store);
                this.m_Hashtable.put(store, new Integer(index));
                break;
            }
            default: {
                throw new IllegalArgumentException("Can only set values for nominal or string attributes!");
            }
        }
    }

    final void setValue(int index, Instances data) {
        if (this.isRelationValued()) {
            if (!data.equalHeaders(this.m_Header)) {
                throw new IllegalArgumentException("Can't set relational value. Headers not compatible.\n" + data.equalHeadersMsg(this.m_Header));
            }
        } else {
            throw new IllegalArgumentException("Can only set value for relation-valued attributes!");
        }
        this.m_Values = (ArrayList)Utils.cast(this.m_Values.clone());
        this.m_Values.set(index, data);
    }

    public String formatDate(double date) {
        switch (this.m_Type) {
            case 3: {
                return this.m_DateFormat.format(new Date((long)date));
            }
        }
        throw new IllegalArgumentException("Can only format date values for date attributes!");
    }

    public double parseDate(String string) throws ParseException {
        switch (this.m_Type) {
            case 3: {
                long time = this.m_DateFormat.parse(string).getTime();
                return time;
            }
        }
        throw new IllegalArgumentException("Can only parse date values for date attributes!");
    }

    public final ProtectedProperties getMetadata() {
        return this.m_Metadata;
    }

    public final int ordering() {
        return this.m_Ordering;
    }

    public final boolean isRegular() {
        return this.m_IsRegular;
    }

    public final boolean isAveragable() {
        return this.m_IsAveragable;
    }

    public final boolean hasZeropoint() {
        return this.m_HasZeropoint;
    }

    public final double weight() {
        return this.m_Weight;
    }

    public void setWeight(double value) {
        this.m_Weight = value;
        Properties props = new Properties();
        Enumeration<?> names = this.m_Metadata.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (name.equals("weight")) continue;
            props.setProperty(name, this.m_Metadata.getProperty(name));
        }
        props.setProperty("weight", "" + this.m_Weight);
        this.m_Metadata = new ProtectedProperties(props);
    }

    public final double getLowerNumericBound() {
        return this.m_LowerBound;
    }

    public final boolean lowerNumericBoundIsOpen() {
        return this.m_LowerBoundIsOpen;
    }

    public final double getUpperNumericBound() {
        return this.m_UpperBound;
    }

    public final boolean upperNumericBoundIsOpen() {
        return this.m_UpperBoundIsOpen;
    }

    public final boolean isInRange(double value) {
        if (this.m_Type == 3 || Utils.isMissingValue(value)) {
            return true;
        }
        if (this.m_Type != 0) {
            int intVal = (int)value;
            if (intVal < 0 || intVal >= this.m_Hashtable.size()) {
                return false;
            }
        } else {
            if (this.m_LowerBoundIsOpen ? value <= this.m_LowerBound : value < this.m_LowerBound) {
                return false;
            }
            if (this.m_UpperBoundIsOpen ? value >= this.m_UpperBound : value > this.m_UpperBound) {
                return false;
            }
        }
        return true;
    }

    private void setMetadata(ProtectedProperties metadata) {
        this.m_Metadata = metadata;
        if (this.m_Type == 3) {
            this.m_Ordering = 1;
            this.m_IsRegular = true;
            this.m_IsAveragable = false;
            this.m_HasZeropoint = false;
        } else {
            String orderString = this.m_Metadata.getProperty("ordering", "");
            String def = this.m_Type == 0 && orderString.compareTo("modulo") != 0 && orderString.compareTo("symbolic") != 0 ? "true" : "false";
            this.m_IsAveragable = this.m_Metadata.getProperty("averageable", def).compareTo("true") == 0;
            boolean bl = this.m_HasZeropoint = this.m_Metadata.getProperty("zeropoint", def).compareTo("true") == 0;
            if (this.m_IsAveragable || this.m_HasZeropoint) {
                def = "true";
            }
            boolean bl2 = this.m_IsRegular = this.m_Metadata.getProperty("regular", def).compareTo("true") == 0;
            this.m_Ordering = orderString.compareTo("symbolic") == 0 ? 0 : (orderString.compareTo("ordered") == 0 ? 1 : (orderString.compareTo("modulo") == 0 ? 2 : (this.m_Type == 0 || this.m_IsAveragable || this.m_HasZeropoint ? 1 : 0)));
        }
        if (this.m_IsAveragable && !this.m_IsRegular) {
            throw new IllegalArgumentException("An averagable attribute must be regular");
        }
        if (this.m_HasZeropoint && !this.m_IsRegular) {
            throw new IllegalArgumentException("A zeropoint attribute must be regular");
        }
        if (this.m_IsRegular && this.m_Ordering == 0) {
            throw new IllegalArgumentException("A symbolic attribute cannot be regular");
        }
        if (this.m_IsAveragable && this.m_Ordering != 1) {
            throw new IllegalArgumentException("An averagable attribute must be ordered");
        }
        if (this.m_HasZeropoint && this.m_Ordering != 1) {
            throw new IllegalArgumentException("A zeropoint attribute must be ordered");
        }
        this.m_Weight = 1.0;
        String weightString = this.m_Metadata.getProperty("weight");
        if (weightString != null) {
            try {
                this.m_Weight = Double.valueOf(weightString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Not a valid attribute weight: '" + weightString + "'");
            }
        }
        if (this.m_Type == 0) {
            this.setNumericRange(this.m_Metadata.getProperty("range"));
        }
    }

    private void setNumericRange(String rangeString) {
        this.m_LowerBound = Double.NEGATIVE_INFINITY;
        this.m_LowerBoundIsOpen = false;
        this.m_UpperBound = Double.POSITIVE_INFINITY;
        this.m_UpperBoundIsOpen = false;
        if (rangeString == null) {
            return;
        }
        StreamTokenizer tokenizer = new StreamTokenizer(new StringReader(rangeString));
        tokenizer.resetSyntax();
        tokenizer.whitespaceChars(0, 32);
        tokenizer.wordChars(33, 255);
        tokenizer.ordinaryChar(91);
        tokenizer.ordinaryChar(40);
        tokenizer.ordinaryChar(44);
        tokenizer.ordinaryChar(93);
        tokenizer.ordinaryChar(41);
        try {
            tokenizer.nextToken();
            if (tokenizer.ttype == 91) {
                this.m_LowerBoundIsOpen = false;
            } else if (tokenizer.ttype == 40) {
                this.m_LowerBoundIsOpen = true;
            } else {
                throw new IllegalArgumentException("Expected opening brace on range, found: " + tokenizer.toString());
            }
            tokenizer.nextToken();
            if (tokenizer.ttype != -3) {
                throw new IllegalArgumentException("Expected lower bound in range, found: " + tokenizer.toString());
            }
            if (tokenizer.sval.compareToIgnoreCase("-inf") == 0) {
                this.m_LowerBound = Double.NEGATIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("+inf") == 0) {
                this.m_LowerBound = Double.POSITIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("inf") == 0) {
                this.m_LowerBound = Double.NEGATIVE_INFINITY;
            } else {
                try {
                    this.m_LowerBound = Double.valueOf(tokenizer.sval);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Expected lower bound in range, found: '" + tokenizer.sval + "'");
                }
            }
            if (tokenizer.nextToken() != 44) {
                throw new IllegalArgumentException("Expected comma in range, found: " + tokenizer.toString());
            }
            tokenizer.nextToken();
            if (tokenizer.ttype != -3) {
                throw new IllegalArgumentException("Expected upper bound in range, found: " + tokenizer.toString());
            }
            if (tokenizer.sval.compareToIgnoreCase("-inf") == 0) {
                this.m_UpperBound = Double.NEGATIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("+inf") == 0) {
                this.m_UpperBound = Double.POSITIVE_INFINITY;
            } else if (tokenizer.sval.compareToIgnoreCase("inf") == 0) {
                this.m_UpperBound = Double.POSITIVE_INFINITY;
            } else {
                try {
                    this.m_UpperBound = Double.valueOf(tokenizer.sval);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Expected upper bound in range, found: '" + tokenizer.sval + "'");
                }
            }
            tokenizer.nextToken();
            if (tokenizer.ttype == 93) {
                this.m_UpperBoundIsOpen = false;
            } else if (tokenizer.ttype == 41) {
                this.m_UpperBoundIsOpen = true;
            } else {
                throw new IllegalArgumentException("Expected closing brace on range, found: " + tokenizer.toString());
            }
            if (tokenizer.nextToken() != -1) {
                throw new IllegalArgumentException("Expected end of range string, found: " + tokenizer.toString());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException reading attribute range string: " + e.getMessage());
        }
        if (this.m_UpperBound < this.m_LowerBound) {
            throw new IllegalArgumentException("Upper bound (" + this.m_UpperBound + ") on numeric range is" + " less than lower bound (" + this.m_LowerBound + ")!");
        }
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 7782 $");
    }

    public static void main(String[] ops) {
        try {
            Attribute length = new Attribute("length");
            Attribute weight = new Attribute("weight");
            Attribute date = new Attribute(ARFF_ATTRIBUTE_DATE, "yyyy-MM-dd HH:mm:ss");
            System.out.println(date);
            double dd = date.parseDate("2001-04-04 14:13:55");
            System.out.println("Test date = " + dd);
            System.out.println(date.formatDate(dd));
            dd = new Date().getTime();
            System.out.println("Date now = " + dd);
            System.out.println(date.formatDate(dd));
            ArrayList<String> my_nominal_values = new ArrayList<String>(3);
            my_nominal_values.add("first");
            my_nominal_values.add("second");
            my_nominal_values.add("third");
            Attribute position = new Attribute("position", my_nominal_values);
            System.out.println("Name of \"position\": " + position.name());
            Enumeration attValues = position.enumerateValues();
            while (attValues.hasMoreElements()) {
                String string = (String)attValues.nextElement();
                System.out.println("Value of \"position\": " + string);
            }
            Attribute copy = (Attribute)position.copy();
            System.out.println("Copy is the same as original: " + copy.equals(position));
            System.out.println("Index of attribute \"weight\" (should be -1): " + weight.index());
            System.out.println("Index of value \"first\" of \"position\" (should be 0): " + position.indexOfValue("first"));
            System.out.println("\"position\" is numeric: " + position.isNumeric());
            System.out.println("\"position\" is nominal: " + position.isNominal());
            System.out.println("\"position\" is string: " + position.isString());
            System.out.println("Name of \"position\": " + position.name());
            System.out.println("Number of values for \"position\": " + position.numValues());
            int i = 0;
            while (i < position.numValues()) {
                System.out.println("Value " + i + ": " + position.value(i));
                ++i;
            }
            System.out.println(position);
            switch (position.type()) {
                case 0: {
                    System.out.println("\"position\" is numeric");
                    break;
                }
                case 1: {
                    System.out.println("\"position\" is nominal");
                    break;
                }
                case 2: {
                    System.out.println("\"position\" is string");
                    break;
                }
                case 3: {
                    System.out.println("\"position\" is date");
                    break;
                }
                case 4: {
                    System.out.println("\"position\" is relation-valued");
                    break;
                }
                default: {
                    System.out.println("\"position\" has unknown type");
                }
            }
            ArrayList<Attribute> atts = new ArrayList<Attribute>(1);
            atts.add(position);
            Instances relation = new Instances("Test", atts, 0);
            Attribute relationValuedAtt = new Attribute("test", relation);
            System.out.println(relationValuedAtt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

