/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Enumeration;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import weka.core.Check;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TestInstances;
import weka.core.Utils;

public abstract class CheckScheme
extends Check {
    protected int m_NumInstances = 20;
    protected int m_NumNominal = 2;
    protected int m_NumNumeric = 1;
    protected int m_NumString = 1;
    protected int m_NumDate = 1;
    protected int m_NumRelational = 1;
    protected int m_NumInstancesRelational = 10;
    protected String[] m_Words = TestInstances.DEFAULT_WORDS;
    protected String m_WordSeparators = " ";
    protected PostProcessor m_PostProcessor = null;
    protected boolean m_ClasspathProblems = false;

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement((Option)en.nextElement());
        }
        result.addElement(new Option("\tThe number of instances in the datasets (default 20).", "N", 1, "-N <num>"));
        result.addElement(new Option("\tThe number of nominal attributes (default 2).", "nominal", 1, "-nominal <num>"));
        result.addElement(new Option("\tThe number of values for nominal attributes (default 1).", "nominal-values", 1, "-nominal-values <num>"));
        result.addElement(new Option("\tThe number of numeric attributes (default 1).", "numeric", 1, "-numeric <num>"));
        result.addElement(new Option("\tThe number of string attributes (default 1).", "string", 1, "-string <num>"));
        result.addElement(new Option("\tThe number of date attributes (default 1).", "date", 1, "-date <num>"));
        result.addElement(new Option("\tThe number of relational attributes (default 1).", "relational", 1, "-relational <num>"));
        result.addElement(new Option("\tThe number of instances in relational/bag attributes (default 10).", "num-instances-relational", 1, "-num-instances-relational <num>"));
        result.addElement(new Option("\tThe words to use in string attributes.", "words", 1, "-words <comma-separated-list>"));
        result.addElement(new Option("\tThe word separators to use in string attributes.", "word-separators", 1, "-word-separators <chars>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumInstances(Integer.parseInt(tmpStr));
        } else {
            this.setNumInstances(20);
        }
        tmpStr = Utils.getOption("nominal", options);
        if (tmpStr.length() != 0) {
            this.setNumNominal(Integer.parseInt(tmpStr));
        } else {
            this.setNumNominal(2);
        }
        tmpStr = Utils.getOption("numeric", options);
        if (tmpStr.length() != 0) {
            this.setNumNumeric(Integer.parseInt(tmpStr));
        } else {
            this.setNumNumeric(1);
        }
        tmpStr = Utils.getOption("string", options);
        if (tmpStr.length() != 0) {
            this.setNumString(Integer.parseInt(tmpStr));
        } else {
            this.setNumString(1);
        }
        tmpStr = Utils.getOption("date", options);
        if (tmpStr.length() != 0) {
            this.setNumDate(Integer.parseInt(tmpStr));
        } else {
            this.setNumDate(1);
        }
        tmpStr = Utils.getOption("relational", options);
        if (tmpStr.length() != 0) {
            this.setNumRelational(Integer.parseInt(tmpStr));
        } else {
            this.setNumRelational(1);
        }
        tmpStr = Utils.getOption("num-instances-relational", options);
        if (tmpStr.length() != 0) {
            this.setNumInstancesRelational(Integer.parseInt(tmpStr));
        } else {
            this.setNumInstancesRelational(10);
        }
        tmpStr = Utils.getOption("words", options);
        if (tmpStr.length() != 0) {
            this.setWords(tmpStr);
        } else {
            this.setWords(new TestInstances().getWords());
        }
        if (Utils.getOptionPos("word-separators", options) > -1) {
            tmpStr = Utils.getOption("word-separators", options);
            this.setWordSeparators(tmpStr);
        } else {
            this.setWordSeparators(" ");
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-N");
        result.add("" + this.getNumInstances());
        result.add("-nominal");
        result.add("" + this.getNumNominal());
        result.add("-numeric");
        result.add("" + this.getNumNumeric());
        result.add("-string");
        result.add("" + this.getNumString());
        result.add("-date");
        result.add("" + this.getNumDate());
        result.add("-relational");
        result.add("" + this.getNumRelational());
        result.add("-words");
        result.add(this.getWords());
        result.add("-word-separators");
        result.add(this.getWordSeparators());
        return result.toArray(new String[result.size()]);
    }

    public void setPostProcessor(PostProcessor value) {
        this.m_PostProcessor = value;
    }

    public PostProcessor getPostProcessor() {
        return this.m_PostProcessor;
    }

    public boolean hasClasspathProblems() {
        return this.m_ClasspathProblems;
    }

    @Override
    public abstract void doTests();

    public void setNumInstances(int value) {
        this.m_NumInstances = value;
    }

    public int getNumInstances() {
        return this.m_NumInstances;
    }

    public void setNumNominal(int value) {
        this.m_NumNominal = value;
    }

    public int getNumNominal() {
        return this.m_NumNominal;
    }

    public void setNumNumeric(int value) {
        this.m_NumNumeric = value;
    }

    public int getNumNumeric() {
        return this.m_NumNumeric;
    }

    public void setNumString(int value) {
        this.m_NumString = value;
    }

    public int getNumString() {
        return this.m_NumString;
    }

    public void setNumDate(int value) {
        this.m_NumDate = value;
    }

    public int getNumDate() {
        return this.m_NumDate;
    }

    public void setNumRelational(int value) {
        this.m_NumRelational = value;
    }

    public int getNumRelational() {
        return this.m_NumRelational;
    }

    public void setNumInstancesRelational(int value) {
        this.m_NumInstancesRelational = value;
    }

    public int getNumInstancesRelational() {
        return this.m_NumInstancesRelational;
    }

    protected static String[] listToArray(String value) {
        Vector<String> list = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(value, ",");
        while (tok.hasMoreTokens()) {
            list.add(tok.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String arrayToList(String[] value) {
        String result = "";
        int i = 0;
        while (i < value.length) {
            if (i > 0) {
                result = String.valueOf(result) + ",";
            }
            result = String.valueOf(result) + value[i];
            ++i;
        }
        return result;
    }

    public static String attributeTypeToString(int type) {
        String result;
        switch (type) {
            case 0: {
                result = "numeric";
                break;
            }
            case 1: {
                result = "nominal";
                break;
            }
            case 2: {
                result = "string";
                break;
            }
            case 3: {
                result = "date";
                break;
            }
            case 4: {
                result = "relational";
                break;
            }
            default: {
                result = "???";
            }
        }
        return result;
    }

    public void setWords(String value) {
        if (CheckScheme.listToArray(value).length < 2) {
            throw new IllegalArgumentException("At least 2 words must be provided!");
        }
        this.m_Words = CheckScheme.listToArray(value);
    }

    public String getWords() {
        return CheckScheme.arrayToList(this.m_Words);
    }

    public void setWordSeparators(String value) {
        this.m_WordSeparators = value;
    }

    public String getWordSeparators() {
        return this.m_WordSeparators;
    }

    protected void compareDatasets(Instances data1, Instances data2) throws Exception {
        if (!data2.equalHeaders(data1)) {
            throw new Exception("header has been modified\n" + data2.equalHeadersMsg(data1));
        }
        if (data2.numInstances() != data1.numInstances()) {
            throw new Exception("number of instances has changed");
        }
        int i = 0;
        while (i < data2.numInstances()) {
            Instance orig = data1.instance(i);
            Instance copy = data2.instance(i);
            int j = 0;
            while (j < orig.numAttributes()) {
                if (orig.isMissing(j) ? !copy.isMissing(j) : orig.value(j) != copy.value(j)) {
                    throw new Exception("instances have changed");
                }
                if (orig.weight() != copy.weight()) {
                    throw new Exception("instance weights have changed");
                }
                ++j;
            }
            ++i;
        }
    }

    protected void addMissing(Instances data, int level, boolean predictorMissing, boolean classMissing) {
        int classIndex = data.classIndex();
        Random random = new Random(1L);
        int i = 0;
        while (i < data.numInstances()) {
            Instance current = data.instance(i);
            int j = 0;
            while (j < data.numAttributes()) {
                if ((j == classIndex && classMissing || j != classIndex && predictorMissing) && Math.abs(random.nextInt()) % 100 < level) {
                    current.setMissing(j);
                }
                ++j;
            }
            ++i;
        }
    }

    protected Instances process(Instances data) {
        if (this.getPostProcessor() == null) {
            return data;
        }
        return this.getPostProcessor().process(data);
    }

    public static class PostProcessor
    implements RevisionHandler {
        public Instances process(Instances data) {
            return data;
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5953 $");
        }
    }
}

