/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Statistics;
import weka.core.Utils;

public final class SpecialFunctions
implements RevisionHandler {
    private static double log2 = Math.log(2.0);

    public static double lnFactorial(double x) {
        return Statistics.lnGamma(x + 1.0);
    }

    public static double log2Binomial(double a, double b) {
        if (Utils.gr(b, a)) {
            throw new ArithmeticException("Can't compute binomial coefficient.");
        }
        return (SpecialFunctions.lnFactorial(a) - SpecialFunctions.lnFactorial(b) - SpecialFunctions.lnFactorial(a - b)) / log2;
    }

    public static double log2Multinomial(double a, double[] bs) {
        double sum = 0.0;
        int i = 0;
        while (i < bs.length) {
            if (Utils.gr(bs[i], a)) {
                throw new ArithmeticException("Can't compute multinomial coefficient.");
            }
            sum += SpecialFunctions.lnFactorial(bs[i]);
            ++i;
        }
        return (SpecialFunctions.lnFactorial(a) - sum) / log2;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }

    public static void main(String[] ops) {
        double[] doubles = new double[]{1.0, 2.0, 3.0};
        System.out.println("6!: " + Math.exp(SpecialFunctions.lnFactorial(6.0)));
        System.out.println("Binomial 6 over 2: " + Math.pow(2.0, SpecialFunctions.log2Binomial(6.0, 2.0)));
        System.out.println("Multinomial 6 over 1, 2, 3: " + Math.pow(2.0, SpecialFunctions.log2Multinomial(6.0, doubles)));
    }
}

