/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch.balltrees;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.neighboursearch.balltrees.BallNode;
import weka.core.neighboursearch.balltrees.BallSplitter;

public class MedianDistanceFromArbitraryPoint
extends BallSplitter
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 5617378551363700558L;
    protected int m_RandSeed = 17;
    protected Random m_Rand;

    public MedianDistanceFromArbitraryPoint() {
    }

    public MedianDistanceFromArbitraryPoint(int[] instList, Instances insts, EuclideanDistance e) {
        super(instList, insts, e);
    }

    public String globalInfo() {
        return "Class that splits a BallNode of a ball tree using Uhlmann's described method.\n\nFor information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Jeffrey K. Uhlmann");
        result.setValue(TechnicalInformation.Field.TITLE, "Satisfying general proximity/similarity queries with metric trees");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Information Processing Letters");
        result.setValue(TechnicalInformation.Field.MONTH, "November");
        result.setValue(TechnicalInformation.Field.YEAR, "1991");
        result.setValue(TechnicalInformation.Field.NUMBER, "4");
        result.setValue(TechnicalInformation.Field.VOLUME, "40");
        result.setValue(TechnicalInformation.Field.PAGES, "175-179");
        TechnicalInformation additional = result.add(TechnicalInformation.Type.MASTERSTHESIS);
        additional.setValue(TechnicalInformation.Field.AUTHOR, "Ashraf Masood Kibriya");
        additional.setValue(TechnicalInformation.Field.TITLE, "Fast Algorithms for Nearest Neighbour Search");
        additional.setValue(TechnicalInformation.Field.YEAR, "2007");
        additional.setValue(TechnicalInformation.Field.SCHOOL, "Department of Computer Science, School of Computing and Mathematical Sciences, University of Waikato");
        additional.setValue(TechnicalInformation.Field.ADDRESS, "Hamilton, New Zealand");
        return result;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> result = new Vector<Option>();
        Enumeration enm = super.listOptions();
        while (enm.hasMoreElements()) {
            result.addElement((Option)enm.nextElement());
        }
        result.addElement(new Option("\tThe seed value for the random number generator.\n\t(default: 17)", "S", 1, "-S <num>"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('S', options);
        if (tmpStr.length() > 0) {
            this.setRandomSeed(Integer.parseInt(tmpStr));
        } else {
            this.setRandomSeed(17);
        }
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-S");
        result.add("" + this.getRandomSeed());
        return result.toArray(new String[result.size()]);
    }

    public void setRandomSeed(int seed) {
        this.m_RandSeed = seed;
    }

    public int getRandomSeed() {
        return this.m_RandSeed;
    }

    public String randomSeedTipText() {
        return "The seed value for the random number generator.";
    }

    @Override
    public void splitNode(BallNode node, int numNodesCreated) throws Exception {
        this.correctlyInitialized();
        this.m_Rand = new Random(this.m_RandSeed);
        int ridx = node.m_Start + this.m_Rand.nextInt(node.m_NumInstances);
        Instance randomInst = (Instance)this.m_Instances.instance(this.m_Instlist[ridx]).copy();
        double[] distList = new double[node.m_NumInstances - 1];
        int i = node.m_Start;
        int j = 0;
        while (i < node.m_End) {
            Instance temp = this.m_Instances.instance(this.m_Instlist[i]);
            distList[j] = this.m_DistanceFunction.distance(randomInst, temp, Double.POSITIVE_INFINITY);
            ++i;
            ++j;
        }
        int medianIdx = this.select(distList, this.m_Instlist, 0, distList.length - 1, node.m_Start, (node.m_End - node.m_Start) / 2 + 1) + node.m_Start;
        Instance pivot = BallNode.calcCentroidPivot(node.m_Start, medianIdx, this.m_Instlist, this.m_Instances);
        node.m_Left = new BallNode(node.m_Start, medianIdx, numNodesCreated + 1, pivot, BallNode.calcRadius(node.m_Start, medianIdx, this.m_Instlist, this.m_Instances, pivot, this.m_DistanceFunction));
        pivot = BallNode.calcCentroidPivot(medianIdx + 1, node.m_End, this.m_Instlist, this.m_Instances);
        node.m_Right = new BallNode(medianIdx + 1, node.m_End, numNodesCreated + 2, pivot, BallNode.calcRadius(medianIdx + 1, node.m_End, this.m_Instlist, this.m_Instances, pivot, this.m_DistanceFunction));
    }

    /*
     * Unable to fully structure code
     */
    protected int partition(double[] array, int[] index, int l, int r, int indexStart) {
        pivot = array[(l + r) / 2];
        ** GOTO lbl15
        {
            ++l;
            do {
                if (array[l] < pivot && l < r) continue block0;
                while (array[r] > pivot && l < r) {
                    --r;
                }
                if (l >= r) continue;
                help = index[indexStart + l];
                index[indexStart + l] = index[indexStart + r];
                index[indexStart + r] = help;
                ++l;
                --r;
lbl15:
                // 3 sources

            } while (l < r);
        }
        if (l == r && array[r] > pivot) {
            --r;
        }
        return r;
    }

    protected int select(double[] array, int[] indices, int left, int right, int indexStart, int k) {
        if (left == right) {
            return left;
        }
        int middle = this.partition(array, indices, left, right, indexStart);
        if (middle - left + 1 >= k) {
            return this.select(array, indices, left, middle, indexStart, k);
        }
        return this.select(array, indices, middle + 1, right, indexStart, k - (middle - left + 1));
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5953 $");
    }
}

