/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.beans.PropertyVetoException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.MultiInstanceCapabilitiesHandler;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyDialog;
import weka.gui.PropertyPanel;
import weka.gui.PropertyText;
import weka.gui.PropertyValueSelector;
import weka.gui.beans.GOECustomizer;

public class PropertySheetPanel
extends JPanel
implements PropertyChangeListener,
EnvironmentHandler {
    private static final long serialVersionUID = -8939835593429918345L;
    private Object m_Target;
    private GOECustomizer m_Customizer;
    private PropertyDescriptor[] m_Properties;
    private MethodDescriptor[] m_Methods;
    private PropertyEditor[] m_Editors;
    private Object[] m_Values;
    private JComponent[] m_Views;
    private JLabel[] m_Labels;
    private String[] m_TipTexts;
    private StringBuffer m_HelpText;
    private JDialog m_HelpDialog;
    private CapabilitiesHelpDialog m_CapabilitiesDialog;
    private JButton m_HelpBut;
    private JButton m_CapabilitiesBut;
    private JTextArea m_CapabilitiesText;
    private int m_NumEditable = 0;
    private JPanel m_aboutPanel;
    private transient Environment m_env;
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    public PropertySheetPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.m_env = Environment.getSystemWide();
    }

    public JPanel getAboutPanel() {
        return this.m_aboutPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.wasModified(evt);
        this.support.firePropertyChange("", null, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public synchronized void setTarget(Object targ) {
        String name;
        if (this.m_env == null) {
            this.m_env = Environment.getSystemWide();
        }
        int componentOffset = 0;
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel scrollablePanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane(scrollablePanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)scrollPane, "Center");
        GridBagLayout gbLayout = new GridBagLayout();
        scrollablePanel.setLayout(gbLayout);
        this.setVisible(false);
        this.m_NumEditable = 0;
        this.m_Target = targ;
        Class<?> custClass = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(this.m_Target.getClass());
            this.m_Properties = bi.getPropertyDescriptors();
            this.m_Methods = bi.getMethodDescriptors();
            custClass = Introspector.getBeanInfo(this.m_Target.getClass()).getBeanDescriptor().getCustomizerClass();
        }
        catch (IntrospectionException ex) {
            System.err.println("PropertySheet: Couldn't introspect");
            return;
        }
        JTextArea jt = new JTextArea();
        this.m_HelpText = null;
        Object[] args = new Object[]{};
        boolean firstTip = true;
        StringBuffer optionsBuff = new StringBuffer();
        int i = 0;
        while (i < this.m_Methods.length) {
            name = this.m_Methods[i].getDisplayName();
            Method meth = this.m_Methods[i].getMethod();
            if (name.endsWith("TipText") && meth.getReturnType().equals(String.class)) {
                try {
                    String tempTip = (String)meth.invoke(this.m_Target, args);
                    if (firstTip) {
                        optionsBuff.append("OPTIONS\n");
                        firstTip = false;
                    }
                    tempTip = tempTip.replace("<html>", "").replace("</html>", "").replace("<br>", "\n").replace("<p>", "\n\n");
                    optionsBuff.append(name.replace("TipText", "")).append(" -- ");
                    optionsBuff.append(tempTip).append("\n\n");
                }
                catch (Exception tempTip) {
                    // empty catch block
                }
            }
            if (name.equals("globalInfo") && meth.getReturnType().equals(String.class)) {
                try {
                    String globalInfo;
                    String summary = globalInfo = (String)meth.invoke(this.m_Target, args);
                    int ci = globalInfo.indexOf(46);
                    if (ci != -1) {
                        summary = globalInfo.substring(0, ci + 1);
                    }
                    String className = targ.getClass().getName();
                    this.m_HelpText = new StringBuffer("NAME\n");
                    this.m_HelpText.append(className).append("\n\n");
                    this.m_HelpText.append("SYNOPSIS\n").append(globalInfo).append("\n\n");
                    this.m_HelpBut = new JButton("More");
                    this.m_HelpBut.setToolTipText("More information about " + className);
                    this.m_HelpBut.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent a) {
                            PropertySheetPanel.this.openHelpFrame();
                            PropertySheetPanel.this.m_HelpBut.setEnabled(false);
                        }
                    });
                    if (this.m_Target instanceof CapabilitiesHandler) {
                        this.m_CapabilitiesBut = new JButton("Capabilities");
                        this.m_CapabilitiesBut.setToolTipText("The capabilities of " + className);
                        this.m_CapabilitiesBut.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent a) {
                                PropertySheetPanel.this.openCapabilitiesHelpDialog();
                                PropertySheetPanel.this.m_CapabilitiesBut.setEnabled(false);
                            }
                        });
                    } else {
                        this.m_CapabilitiesBut = null;
                    }
                    jt.setColumns(30);
                    jt.setFont(new Font("SansSerif", 0, 12));
                    jt.setEditable(false);
                    jt.setLineWrap(true);
                    jt.setWrapStyleWord(true);
                    jt.setText(summary);
                    jt.setBackground(this.getBackground());
                    JPanel jp = new JPanel();
                    jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("About"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
                    jp.setLayout(new BorderLayout());
                    jp.add((Component)jt, "Center");
                    JPanel p2 = new JPanel();
                    p2.setLayout(new BorderLayout());
                    p2.add((Component)this.m_HelpBut, "North");
                    if (this.m_CapabilitiesBut != null) {
                        JPanel p3 = new JPanel();
                        p3.setLayout(new BorderLayout());
                        p3.add((Component)this.m_CapabilitiesBut, "North");
                        p2.add((Component)p3, "Center");
                    }
                    jp.add((Component)p2, "East");
                    GridBagConstraints gbConstraints = new GridBagConstraints();
                    gbConstraints.fill = 1;
                    gbConstraints.gridwidth = 2;
                    gbConstraints.insets = new Insets(0, 5, 0, 5);
                    gbLayout.setConstraints(jp, gbConstraints);
                    this.m_aboutPanel = jp;
                    scrollablePanel.add(this.m_aboutPanel);
                    componentOffset = 1;
                }
                catch (Exception globalInfo) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (this.m_HelpText != null) {
            this.m_HelpText.append(optionsBuff.toString());
        }
        if (custClass != null) {
            try {
                Object customizer = custClass.newInstance();
                if (customizer instanceof JComponent && customizer instanceof GOECustomizer) {
                    this.m_Customizer = (GOECustomizer)customizer;
                    this.m_Customizer.dontShowOKCancelButtons();
                    this.m_Customizer.setObject(this.m_Target);
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.fill = 1;
                    gbc.gridwidth = 2;
                    gbc.gridy = componentOffset;
                    gbc.gridx = 0;
                    gbc.insets = new Insets(0, 5, 0, 5);
                    gbLayout.setConstraints((JComponent)((Object)this.m_Customizer), gbc);
                    scrollablePanel.add((JComponent)((Object)this.m_Customizer));
                    this.validate();
                    Dimension dim = scrollablePanel.getPreferredSize();
                    dim.height += 20;
                    dim.width += 20;
                    scrollPane.setPreferredSize(dim);
                    this.validate();
                    this.setVisible(true);
                    return;
                }
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        this.m_Editors = new PropertyEditor[this.m_Properties.length];
        this.m_Values = new Object[this.m_Properties.length];
        this.m_Views = new JComponent[this.m_Properties.length];
        this.m_Labels = new JLabel[this.m_Properties.length];
        this.m_TipTexts = new String[this.m_Properties.length];
        i = 0;
        while (i < this.m_Properties.length) {
            block49: {
                if (!this.m_Properties[i].isHidden() && !this.m_Properties[i].isExpert()) {
                    name = this.m_Properties[i].getDisplayName();
                    Class<?> type = this.m_Properties[i].getPropertyType();
                    Method getter = this.m_Properties[i].getReadMethod();
                    Method setter = this.m_Properties[i].getWriteMethod();
                    if (getter != null && setter != null) {
                        JComponent view = null;
                        try {
                            String getterClass;
                            Object value;
                            this.m_Values[i] = value = getter.invoke(this.m_Target, args);
                            PropertyEditor editor = null;
                            Class<?> pec = this.m_Properties[i].getPropertyEditorClass();
                            if (pec != null) {
                                try {
                                    editor = (PropertyEditor)pec.newInstance();
                                }
                                catch (Exception gbConstraints) {
                                    // empty catch block
                                }
                            }
                            if (editor == null) {
                                editor = PropertyEditorManager.findEditor(type);
                            }
                            this.m_Editors[i] = editor;
                            if (editor == null) {
                                getterClass = this.m_Properties[i].getReadMethod().getDeclaringClass().getName();
                                break block49;
                            }
                            if (editor instanceof GenericObjectEditor) {
                                ((GenericObjectEditor)editor).setClassType(type);
                            }
                            if (editor instanceof EnvironmentHandler) {
                                ((EnvironmentHandler)((Object)editor)).setEnvironment(this.m_env);
                            }
                            if (value == null) {
                                getterClass = this.m_Properties[i].getReadMethod().getDeclaringClass().getName();
                                break block49;
                            }
                            editor.setValue(value);
                            String tipName = String.valueOf(name) + "TipText";
                            int j = 0;
                            while (j < this.m_Methods.length) {
                                String mname = this.m_Methods[j].getDisplayName();
                                Method meth = this.m_Methods[j].getMethod();
                                if (mname.equals(tipName) && meth.getReturnType().equals(String.class)) {
                                    try {
                                        String tempTip = (String)meth.invoke(this.m_Target, args);
                                        int ci = tempTip.indexOf(46);
                                        if (ci < 0) {
                                            this.m_TipTexts[i] = tempTip;
                                            break;
                                        }
                                        this.m_TipTexts[i] = tempTip.substring(0, ci);
                                    }
                                    catch (Exception exception) {}
                                    break;
                                }
                                ++j;
                            }
                            if (editor.isPaintable() && editor.supportsCustomEditor()) {
                                view = new PropertyPanel(editor);
                            } else if (editor.supportsCustomEditor() && editor.getCustomEditor() instanceof JComponent) {
                                view = (JComponent)editor.getCustomEditor();
                            } else if (editor.getTags() != null) {
                                view = new PropertyValueSelector(editor);
                            } else {
                                if (editor.getAsText() == null) {
                                    System.err.println("Warning: Property \"" + name + "\" has non-displayabale editor.  Skipping.");
                                    break block49;
                                }
                                view = new PropertyText(editor);
                            }
                            editor.addPropertyChangeListener(this);
                        }
                        catch (InvocationTargetException ex) {
                            System.err.println("Skipping property " + name + " ; exception on target: " + ex.getTargetException());
                            ex.getTargetException().printStackTrace();
                            break block49;
                        }
                        catch (Exception ex) {
                            System.err.println("Skipping property " + name + " ; exception: " + ex);
                            ex.printStackTrace();
                            break block49;
                        }
                        this.m_Labels[i] = new JLabel(name, 4);
                        this.m_Labels[i].setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 5));
                        this.m_Views[i] = view;
                        GridBagConstraints gbConstraints = new GridBagConstraints();
                        gbConstraints.anchor = 13;
                        gbConstraints.fill = 2;
                        gbConstraints.gridy = i + componentOffset;
                        gbConstraints.gridx = 0;
                        gbLayout.setConstraints(this.m_Labels[i], gbConstraints);
                        scrollablePanel.add(this.m_Labels[i]);
                        JPanel newPanel = new JPanel();
                        if (this.m_TipTexts[i] != null) {
                            this.m_Views[i].setToolTipText(this.m_TipTexts[i]);
                        }
                        newPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
                        newPanel.setLayout(new BorderLayout());
                        newPanel.add((Component)this.m_Views[i], "Center");
                        gbConstraints = new GridBagConstraints();
                        gbConstraints.anchor = 17;
                        gbConstraints.fill = 1;
                        gbConstraints.gridy = i + componentOffset;
                        gbConstraints.gridx = 1;
                        gbConstraints.weightx = 100.0;
                        gbLayout.setConstraints(newPanel, gbConstraints);
                        scrollablePanel.add(newPanel);
                        ++this.m_NumEditable;
                    }
                }
            }
            ++i;
        }
        if (this.m_NumEditable == 0) {
            JLabel empty = new JLabel("No editable properties", 0);
            Dimension d = empty.getPreferredSize();
            empty.setPreferredSize(new Dimension(d.width * 2, d.height * 2));
            empty.setBorder(BorderFactory.createEmptyBorder(10, 5, 0, 10));
            GridBagConstraints gbConstraints = new GridBagConstraints();
            gbConstraints.anchor = 10;
            gbConstraints.fill = 2;
            gbConstraints.gridy = componentOffset;
            gbConstraints.gridx = 0;
            gbLayout.setConstraints(empty, gbConstraints);
            scrollablePanel.add(empty);
        }
        this.validate();
        Dimension dim = scrollablePanel.getPreferredSize();
        dim.height += 20;
        dim.width += 20;
        scrollPane.setPreferredSize(dim);
        this.validate();
        this.setVisible(true);
    }

    protected void openHelpFrame() {
        JTextArea ta = new JTextArea();
        ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        ta.setEditable(false);
        ta.setText(this.m_HelpText.toString());
        ta.setCaretPosition(0);
        JDialog jdtmp = PropertyDialog.getParentDialog(this) != null ? new JDialog(PropertyDialog.getParentDialog(this), "Information") : (PropertyDialog.getParentFrame(this) != null ? new JDialog(PropertyDialog.getParentFrame(this), "Information") : new JDialog(PropertyDialog.getParentDialog(this.m_aboutPanel), "Information"));
        final JDialog jd = jdtmp;
        jd.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                jd.dispose();
                if (PropertySheetPanel.this.m_HelpDialog == jd) {
                    PropertySheetPanel.this.m_HelpBut.setEnabled(true);
                }
            }
        });
        jd.getContentPane().setLayout(new BorderLayout());
        jd.getContentPane().add((Component)new JScrollPane(ta), "Center");
        jd.pack();
        jd.setSize(400, 350);
        jd.setLocation(this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().x + this.m_aboutPanel.getTopLevelAncestor().getSize().width, this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().y);
        jd.setVisible(true);
        this.m_HelpDialog = jd;
    }

    protected void openCapabilitiesHelpDialog() {
        this.m_CapabilitiesDialog = PropertyDialog.getParentDialog(this) != null ? new CapabilitiesHelpDialog(PropertyDialog.getParentDialog(this)) : new CapabilitiesHelpDialog(PropertyDialog.getParentFrame(this));
        this.m_CapabilitiesDialog.setSize(400, 350);
        this.m_CapabilitiesDialog.setLocation(this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().x + this.m_aboutPanel.getTopLevelAncestor().getSize().width, this.m_aboutPanel.getTopLevelAncestor().getLocationOnScreen().y);
        this.m_CapabilitiesDialog.setVisible(true);
        this.addPropertyChangeListener(this.m_CapabilitiesDialog);
    }

    public int editableProperties() {
        return this.m_NumEditable;
    }

    synchronized void wasModified(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof PropertyEditor) {
            PropertyEditor editor = (PropertyEditor)evt.getSource();
            int i = 0;
            while (i < this.m_Editors.length) {
                if (this.m_Editors[i] == editor) {
                    Object value;
                    PropertyDescriptor property = this.m_Properties[i];
                    this.m_Values[i] = value = editor.getValue();
                    Method setter = property.getWriteMethod();
                    try {
                        Object[] args = new Object[]{value};
                        args[0] = value;
                        setter.invoke(this.m_Target, args);
                    }
                    catch (InvocationTargetException ex) {
                        if (ex.getTargetException() instanceof PropertyVetoException) {
                            String message = "WARNING: Vetoed; reason is: " + ex.getTargetException().getMessage();
                            System.err.println(message);
                            Container jf = evt.getSource() instanceof JPanel ? ((JPanel)evt.getSource()).getParent() : new JFrame();
                            JOptionPane.showMessageDialog(jf, message, "error", 2);
                            if (jf instanceof JFrame) {
                                ((Window)jf).dispose();
                            }
                        } else {
                            System.err.println(String.valueOf(ex.getTargetException().getClass().getName()) + " while updating " + property.getName() + ": " + ex.getTargetException().getMessage());
                            Container jf = evt.getSource() instanceof JPanel ? ((JPanel)evt.getSource()).getParent() : new JFrame();
                            JOptionPane.showMessageDialog(jf, String.valueOf(ex.getTargetException().getClass().getName()) + " while updating " + property.getName() + ":\n" + ex.getTargetException().getMessage(), "error", 2);
                            if (jf instanceof JFrame) {
                                ((Window)jf).dispose();
                            }
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("Unexpected exception while updating " + property.getName());
                    }
                    if (this.m_Views[i] == null || !(this.m_Views[i] instanceof PropertyPanel)) break;
                    this.m_Views[i].repaint();
                    this.revalidate();
                    break;
                }
                ++i;
            }
        }
        int i = 0;
        while (i < this.m_Properties.length) {
            block17: {
                Object o;
                try {
                    Method getter = this.m_Properties[i].getReadMethod();
                    Method setter = this.m_Properties[i].getWriteMethod();
                    if (getter == null || setter == null) break block17;
                    Object[] args = new Object[]{};
                    o = getter.invoke(this.m_Target, args);
                }
                catch (Exception ex) {
                    o = null;
                }
                if (!(o == this.m_Values[i] || o != null && o.equals(this.m_Values[i]))) {
                    this.m_Values[i] = o;
                    if (this.m_Editors[i] != null) {
                        this.m_Editors[i].removePropertyChangeListener(this);
                        this.m_Editors[i].setValue(o);
                        this.m_Editors[i].addPropertyChangeListener(this);
                        if (this.m_Views[i] != null) {
                            this.m_Views[i].repaint();
                        }
                    }
                }
            }
            ++i;
        }
        if (Beans.isInstanceOf(this.m_Target, Component.class)) {
            ((Component)Beans.getInstanceOf(this.m_Target, Component.class)).repaint();
        }
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public void closingOK() {
        if (this.m_Customizer != null) {
            this.m_Customizer.closingOK();
        }
    }

    public void closingCancel() {
        if (this.m_Customizer != null) {
            this.m_Customizer.closingCancel();
        }
    }

    protected class CapabilitiesHelpDialog
    extends JDialog
    implements PropertyChangeListener {
        private static final long serialVersionUID = -1404770987103289858L;
        private CapabilitiesHelpDialog m_Self;

        public CapabilitiesHelpDialog(Frame owner) {
            super(owner);
            this.initialize();
        }

        public CapabilitiesHelpDialog(Dialog owner) {
            super(owner);
            this.initialize();
        }

        protected void initialize() {
            this.setTitle("Information about Capabilities");
            this.m_Self = this;
            PropertySheetPanel.this.m_CapabilitiesText = new JTextArea();
            PropertySheetPanel.this.m_CapabilitiesText.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            PropertySheetPanel.this.m_CapabilitiesText.setLineWrap(true);
            PropertySheetPanel.this.m_CapabilitiesText.setWrapStyleWord(true);
            PropertySheetPanel.this.m_CapabilitiesText.setEditable(false);
            this.updateText();
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    CapabilitiesHelpDialog.this.m_Self.dispose();
                    if (PropertySheetPanel.this.m_CapabilitiesDialog == CapabilitiesHelpDialog.this.m_Self) {
                        PropertySheetPanel.this.m_CapabilitiesBut.setEnabled(true);
                    }
                }
            });
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)new JScrollPane(PropertySheetPanel.this.m_CapabilitiesText), "Center");
            this.pack();
        }

        protected String listCapabilities(Capabilities c) {
            String result = "";
            Iterator iter = c.capabilities();
            while (iter.hasNext()) {
                if (result.length() != 0) {
                    result = String.valueOf(result) + ", ";
                }
                result = String.valueOf(result) + iter.next().toString();
            }
            return result;
        }

        protected String addCapabilities(String title, Capabilities c) {
            String result = String.valueOf(title) + "\n";
            String caps = this.listCapabilities(c.getClassCapabilities());
            if (caps.length() != 0) {
                result = String.valueOf(result) + "Class -- ";
                result = String.valueOf(result) + caps;
                result = String.valueOf(result) + "\n\n";
            }
            if ((caps = this.listCapabilities(c.getAttributeCapabilities())).length() != 0) {
                result = String.valueOf(result) + "Attributes -- ";
                result = String.valueOf(result) + caps;
                result = String.valueOf(result) + "\n\n";
            }
            if ((caps = this.listCapabilities(c.getOtherCapabilities())).length() != 0) {
                result = String.valueOf(result) + "Other -- ";
                result = String.valueOf(result) + caps;
                result = String.valueOf(result) + "\n\n";
            }
            result = String.valueOf(result) + "Additional\n";
            result = String.valueOf(result) + "min # of instances: " + c.getMinimumNumberInstances() + "\n";
            result = String.valueOf(result) + "\n";
            return result;
        }

        protected void updateText() {
            StringBuffer helpText = new StringBuffer();
            if (PropertySheetPanel.this.m_Target instanceof CapabilitiesHandler) {
                helpText.append(this.addCapabilities("CAPABILITIES", ((CapabilitiesHandler)PropertySheetPanel.this.m_Target).getCapabilities()));
            }
            if (PropertySheetPanel.this.m_Target instanceof MultiInstanceCapabilitiesHandler) {
                helpText.append(this.addCapabilities("MI CAPABILITIES", ((MultiInstanceCapabilitiesHandler)PropertySheetPanel.this.m_Target).getMultiInstanceCapabilities()));
            }
            PropertySheetPanel.this.m_CapabilitiesText.setText(helpText.toString());
            PropertySheetPanel.this.m_CapabilitiesText.setCaretPosition(0);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.updateText();
        }
    }
}

