/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BeanVisual
extends JPanel {
    private static final long serialVersionUID = -6677473561687129614L;
    public static final String ICON_PATH = "weka/gui/beans/icons/";
    public static final int NORTH_CONNECTOR = 0;
    public static final int SOUTH_CONNECTOR = 1;
    public static final int EAST_CONNECTOR = 2;
    public static final int WEST_CONNECTOR = 3;
    protected String m_iconPath;
    protected String m_animatedIconPath;
    protected transient ImageIcon m_icon;
    protected transient ImageIcon m_animatedIcon;
    protected String m_visualName;
    protected JLabel m_visualLabel;
    private boolean m_stationary = true;
    private PropertyChangeSupport m_pcs = new PropertyChangeSupport(this);
    private boolean m_displayConnectors = false;
    private Color m_connectorColor = Color.blue;

    public BeanVisual(String visualName, String iconPath, String animatedIconPath) {
        this.loadIcons(iconPath, animatedIconPath);
        this.m_visualName = visualName;
        this.m_visualLabel = new JLabel(this.m_icon);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visualLabel, "Center");
        Dimension d = this.m_visualLabel.getPreferredSize();
        Dimension d2 = new Dimension((int)d.getWidth() + 10, (int)d.getHeight() + 10);
        this.setMinimumSize(d2);
        this.setPreferredSize(d2);
        this.setMaximumSize(d2);
    }

    public void scale(int factor) {
        if (this.m_icon != null) {
            this.removeAll();
            Image pic = this.m_icon.getImage();
            int width = this.m_icon.getIconWidth();
            int height = this.m_icon.getIconHeight();
            int reduction = width / factor;
            pic = pic.getScaledInstance(width -= reduction, height -= reduction, 4);
            this.m_icon = new ImageIcon(pic);
            this.m_visualLabel = new JLabel(this.m_icon);
            this.add((Component)this.m_visualLabel, "Center");
            Dimension d = this.m_visualLabel.getPreferredSize();
            Dimension d2 = new Dimension((int)d.getWidth() + 10, (int)d.getHeight() + 10);
            this.setMinimumSize(d2);
            this.setPreferredSize(d2);
            this.setMaximumSize(d2);
        }
    }

    public Image scale(double percent) {
        if (this.m_icon != null) {
            Image pic = this.m_icon.getImage();
            double width = this.m_icon.getIconWidth();
            double height = this.m_icon.getIconHeight();
            pic = pic.getScaledInstance((int)(width *= percent), (int)(height *= percent), 4);
            return pic;
        }
        return null;
    }

    public boolean loadIcons(String iconPath, String animatedIconPath) {
        boolean success = true;
        URL imageURL = this.getClass().getClassLoader().getResource(iconPath);
        if (imageURL != null) {
            Image pic = Toolkit.getDefaultToolkit().getImage(imageURL);
            this.m_icon = new ImageIcon(pic);
            if (this.m_visualLabel != null) {
                this.m_visualLabel.setIcon(this.m_icon);
            }
        }
        if ((imageURL = this.getClass().getClassLoader().getResource(animatedIconPath)) == null) {
            success = false;
        } else {
            Image pic2 = Toolkit.getDefaultToolkit().getImage(imageURL);
            this.m_animatedIcon = new ImageIcon(pic2);
        }
        this.m_iconPath = iconPath;
        this.m_animatedIconPath = animatedIconPath;
        return success;
    }

    public void setText(String text) {
        this.m_visualName = text;
        this.m_pcs.firePropertyChange("label", null, null);
    }

    public String getText() {
        return this.m_visualName;
    }

    public void setStatic() {
        this.setDisplayConnectors(false);
    }

    public void setAnimated() {
        this.setDisplayConnectors(true);
    }

    public Point getClosestConnectorPoint(Point pt) {
        int cx;
        int sourceX = this.getParent().getX();
        int sourceY = this.getParent().getY();
        int sourceWidth = this.getWidth();
        int sourceHeight = this.getHeight();
        int sourceMidX = sourceX + sourceWidth / 2;
        int sourceMidY = sourceY + sourceHeight / 2;
        int x = (int)pt.getX();
        int y = (int)pt.getY();
        Point closest = new Point();
        int n = Math.abs(x - sourceMidX) < Math.abs(y - sourceMidY) ? sourceMidX : (cx = x < sourceMidX ? sourceX : sourceX + sourceWidth);
        int cy = Math.abs(y - sourceMidY) < Math.abs(x - sourceMidX) ? sourceMidY : (y < sourceMidY ? sourceY : sourceY + sourceHeight);
        closest.setLocation(cx, cy);
        return closest;
    }

    public Point getConnectorPoint(int compassPoint) {
        int sourceX = this.getParent().getX();
        int sourceY = this.getParent().getY();
        int sourceWidth = this.getWidth();
        int sourceHeight = this.getHeight();
        int sourceMidX = sourceX + sourceWidth / 2;
        int sourceMidY = sourceY + sourceHeight / 2;
        switch (compassPoint) {
            case 0: {
                return new Point(sourceMidX, sourceY);
            }
            case 1: {
                return new Point(sourceMidX, sourceY + sourceHeight);
            }
            case 3: {
                return new Point(sourceX, sourceMidY);
            }
            case 2: {
                return new Point(sourceX + sourceWidth, sourceMidY);
            }
        }
        System.err.println("Unrecognised connectorPoint (BeanVisual)");
        return new Point(sourceX, sourceY);
    }

    public ImageIcon getStaticIcon() {
        return this.m_icon;
    }

    public ImageIcon getAnimatedIcon() {
        return this.m_animatedIcon;
    }

    public String getIconPath() {
        return this.m_iconPath;
    }

    public String getAnimatedIconPath() {
        return this.m_animatedIconPath;
    }

    public void setDisplayConnectors(boolean dc) {
        this.m_displayConnectors = dc;
        this.m_connectorColor = Color.blue;
        this.repaint();
    }

    public void setDisplayConnectors(boolean dc, Color c) {
        this.setDisplayConnectors(dc);
        this.m_connectorColor = c;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcs.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcs.removePropertyChangeListener(pcl);
    }

    @Override
    public void paintComponent(Graphics gx) {
        ((Graphics2D)gx).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(gx);
        if (this.m_displayConnectors) {
            gx.setColor(this.m_connectorColor);
            int midx = (int)((double)this.getWidth() / 2.0);
            int midy = (int)((double)this.getHeight() / 2.0);
            gx.fillOval(midx - 2, 0, 5, 5);
            gx.fillOval(midx - 2, this.getHeight() - 5, 5, 5);
            gx.fillOval(0, midy - 2, 5, 5);
            gx.fillOval(this.getWidth() - 5, midy - 2, 5, 5);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        try {
            ois.defaultReadObject();
            this.remove(this.m_visualLabel);
            this.m_visualLabel = new JLabel(this.m_icon);
            this.loadIcons(this.m_iconPath, this.m_animatedIconPath);
            this.add((Component)this.m_visualLabel, "Center");
            Dimension d = this.m_visualLabel.getPreferredSize();
            Dimension d2 = new Dimension((int)d.getWidth() + 10, (int)d.getHeight() + 10);
            this.setMinimumSize(d2);
            this.setPreferredSize(d2);
            this.setMaximumSize(d2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

