/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import weka.classifiers.UpdateableClassifier;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertySheetPanel;
import weka.gui.beans.BeanCustomizer;
import weka.gui.beans.Classifier;
import weka.gui.beans.CustomizerCloseRequester;
import weka.gui.beans.CustomizerClosingListener;

public class ClassifierCustomizer
extends JPanel
implements BeanCustomizer,
CustomizerClosingListener,
CustomizerCloseRequester,
EnvironmentHandler {
    private static final long serialVersionUID = -6688000820160821429L;
    private PropertyChangeSupport m_pcSupport = new PropertyChangeSupport(this);
    private Classifier m_dsClassifier;
    private PropertySheetPanel m_ClassifierEditor = new PropertySheetPanel();
    private JPanel m_incrementalPanel = new JPanel();
    private JCheckBox m_updateIncrementalClassifier = new JCheckBox("Update classifier on incoming instance stream");
    private boolean m_panelVisible = false;
    private JPanel m_holderPanel = new JPanel();
    private JTextField m_executionSlotsText = new JTextField();
    private JCheckBox m_blockOnLastFold = new JCheckBox("Block on last fold of last run");
    private Window m_parentWindow;
    protected weka.classifiers.Classifier m_backup;
    private Environment m_env = Environment.getSystemWide();
    private BeanCustomizer.ModifyListener m_modifyListener;

    static {
        GenericObjectEditor.registerEditors();
    }

    public ClassifierCustomizer() {
        this.m_ClassifierEditor.setBorder(BorderFactory.createTitledBorder("Classifier options"));
        this.m_updateIncrementalClassifier.setToolTipText("Train the classifier on each individual incoming streamed instance.");
        this.m_updateIncrementalClassifier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setUpdateIncrementalClassifier(ClassifierCustomizer.this.m_updateIncrementalClassifier.isSelected());
                }
            }
        });
        this.m_incrementalPanel.add(this.m_updateIncrementalClassifier);
        this.m_executionSlotsText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int newSlots = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(newSlots);
                }
            }
        });
        this.m_executionSlotsText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null && ClassifierCustomizer.this.m_executionSlotsText.getText().length() > 0) {
                    int newSlots = Integer.parseInt(ClassifierCustomizer.this.m_executionSlotsText.getText());
                    ClassifierCustomizer.this.m_dsClassifier.setExecutionSlots(newSlots);
                }
            }
        });
        this.m_blockOnLastFold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_dsClassifier != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setBlockOnLastFold(ClassifierCustomizer.this.m_blockOnLastFold.isSelected());
                }
            }
        });
        JPanel executionSlotsPanel = new JPanel();
        executionSlotsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JLabel executionSlotsLabel = new JLabel("Execution slots");
        executionSlotsPanel.setLayout(new BorderLayout());
        executionSlotsPanel.add((Component)executionSlotsLabel, "West");
        executionSlotsPanel.add((Component)this.m_executionSlotsText, "Center");
        this.m_holderPanel.setBorder(BorderFactory.createTitledBorder("More options"));
        this.m_holderPanel.setLayout(new BorderLayout());
        this.m_holderPanel.add((Component)executionSlotsPanel, "North");
        this.m_holderPanel.add((Component)this.m_blockOnLastFold, "South");
        JPanel holder2 = new JPanel();
        holder2.setLayout(new BorderLayout());
        holder2.add((Component)this.m_holderPanel, "North");
        JButton OKBut = new JButton("OK");
        JButton CancelBut = new JButton("Cancel");
        OKBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClassifierCustomizer.this.m_dsClassifier.setClassifierTemplate(ClassifierCustomizer.this.m_dsClassifier.getClassifierTemplate());
                if (ClassifierCustomizer.this.m_modifyListener != null) {
                    ClassifierCustomizer.this.m_modifyListener.setModifiedStatus(ClassifierCustomizer.this, true);
                }
                ClassifierCustomizer.this.m_parentWindow.dispose();
            }
        });
        CancelBut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ClassifierCustomizer.this.m_backup != null) {
                    ClassifierCustomizer.this.m_dsClassifier.setClassifierTemplate(ClassifierCustomizer.this.m_backup);
                }
                if (ClassifierCustomizer.this.m_modifyListener != null) {
                    ClassifierCustomizer.this.m_modifyListener.setModifiedStatus(ClassifierCustomizer.this, false);
                }
                ClassifierCustomizer.this.m_parentWindow.dispose();
            }
        });
        JPanel butHolder = new JPanel();
        butHolder.setLayout(new GridLayout(1, 2));
        butHolder.add(OKBut);
        butHolder.add(CancelBut);
        holder2.add((Component)butHolder, "South");
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_ClassifierEditor, "Center");
        this.add((Component)holder2, "South");
    }

    private void checkOnClassifierType() {
        weka.classifiers.Classifier editedC = this.m_dsClassifier.getClassifierTemplate();
        if (editedC instanceof UpdateableClassifier && this.m_dsClassifier.hasIncomingStreamInstances()) {
            if (!this.m_panelVisible) {
                this.m_holderPanel.add((Component)this.m_incrementalPanel, "South");
                this.m_panelVisible = true;
                this.m_executionSlotsText.setEnabled(false);
            }
        } else if (this.m_panelVisible) {
            this.m_holderPanel.remove(this.m_incrementalPanel);
            this.m_executionSlotsText.setEnabled(true);
            this.m_panelVisible = false;
        }
    }

    @Override
    public void setObject(Object object) {
        this.m_dsClassifier = (Classifier)object;
        try {
            this.m_backup = (weka.classifiers.Classifier)GenericObjectEditor.makeCopy(this.m_dsClassifier.getClassifierTemplate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_ClassifierEditor.setEnvironment(this.m_env);
        this.m_ClassifierEditor.setTarget(this.m_dsClassifier.getClassifierTemplate());
        this.m_updateIncrementalClassifier.setSelected(this.m_dsClassifier.getUpdateIncrementalClassifier());
        this.m_executionSlotsText.setText("" + this.m_dsClassifier.getExecutionSlots());
        this.m_blockOnLastFold.setSelected(this.m_dsClassifier.getBlockOnLastFold());
        this.checkOnClassifierType();
    }

    @Override
    public void customizerClosing() {
        if (this.m_executionSlotsText.getText().length() > 0) {
            int newSlots = Integer.parseInt(this.m_executionSlotsText.getText());
            this.m_dsClassifier.setExecutionSlots(newSlots);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.addPropertyChangeListener(pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.m_pcSupport.removePropertyChangeListener(pcl);
    }

    @Override
    public void setParentWindow(Window parent) {
        this.m_parentWindow = parent;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    @Override
    public void setModifiedListener(BeanCustomizer.ModifyListener l) {
        this.m_modifyListener = l;
    }
}

