/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import weka.core.Memory;
import weka.core.logging.Logger;
import weka.experiment.Experiment;
import weka.gui.GenericObjectEditor;
import weka.gui.LookAndFeel;
import weka.gui.experiment.ResultsPanel;
import weka.gui.experiment.RunPanel;
import weka.gui.experiment.SetupModePanel;

public class Experimenter
extends JPanel {
    private static final long serialVersionUID = -5751617505738193788L;
    protected SetupModePanel m_SetupPanel;
    protected RunPanel m_RunPanel;
    protected ResultsPanel m_ResultsPanel;
    protected JTabbedPane m_TabbedPane = new JTabbedPane();
    protected boolean m_ClassFirst = false;
    private static Experimenter m_experimenter;
    private static Memory m_Memory;

    static {
        m_Memory = new Memory(true);
    }

    public Experimenter(boolean classFirst) {
        this.m_SetupPanel = new SetupModePanel();
        this.m_ResultsPanel = new ResultsPanel();
        this.m_RunPanel = new RunPanel();
        this.m_RunPanel.setResultsPanel(this.m_ResultsPanel);
        this.m_ClassFirst = classFirst;
        this.m_TabbedPane.addTab("Setup", null, this.m_SetupPanel, "Set up the experiment");
        this.m_TabbedPane.addTab("Run", null, this.m_RunPanel, "Run the experiment");
        this.m_TabbedPane.addTab("Analyse", null, this.m_ResultsPanel, "Analyse experiment results");
        this.m_TabbedPane.setSelectedIndex(0);
        this.m_TabbedPane.setEnabledAt(1, false);
        this.m_SetupPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Experiment exp = Experimenter.this.m_SetupPanel.getExperiment();
                exp.classFirst(Experimenter.this.m_ClassFirst);
                Experimenter.this.m_RunPanel.setExperiment(exp);
                Experimenter.this.m_TabbedPane.setEnabledAt(1, true);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_TabbedPane, "Center");
    }

    public static void main(String[] args) {
        Logger.log(Logger.Level.INFO, "Logging started");
        GenericObjectEditor.determineClasses();
        LookAndFeel.setLookAndFeel();
        try {
            boolean classFirst = false;
            if (args.length > 0) {
                classFirst = args[0].equals("CLASS_FIRST");
            }
            m_experimenter = new Experimenter(classFirst);
            final JFrame jf = new JFrame("Weka Experiment Environment");
            jf.getContentPane().setLayout(new BorderLayout());
            jf.getContentPane().add((Component)m_experimenter, "Center");
            jf.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    jf.dispose();
                    System.exit(0);
                }
            });
            jf.pack();
            jf.setSize(800, 600);
            jf.setVisible(true);
            Image icon = Toolkit.getDefaultToolkit().getImage(m_experimenter.getClass().getClassLoader().getResource("weka/gui/weka_icon_new_48.png"));
            jf.setIconImage(icon);
            Thread memMonitor = new Thread(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                3.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                jf.dispose();
                                m_experimenter = null;
                                System.gc();
                                m_Memory.stopThreads();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            memMonitor.setPriority(5);
            memMonitor.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

