/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.experiment;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;
import weka.gui.GenericObjectEditor;
import weka.gui.PropertyPanel;
import weka.gui.experiment.ExperimenterDefaults;

public class OutputFormatDialog
extends JDialog {
    private static final long serialVersionUID = 2169792738187807378L;
    public static final int APPROVE_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected int m_Result;
    protected static Vector<Class> m_OutputFormatClasses;
    protected static Vector<String> m_OutputFormatNames;
    protected GenericObjectEditor m_ResultMatrixEditor;
    protected PropertyPanel m_ResultMatrixPanel;
    protected JLabel m_ResultMatrixLabel;
    protected ResultMatrix m_ResultMatrix;
    protected JComboBox m_OutputFormatComboBox;
    protected JLabel m_OutputFormatLabel;
    protected JSpinner m_MeanPrecSpinner;
    protected JLabel m_MeanPrecLabel;
    protected JSpinner m_StdDevPrecSpinner;
    protected JLabel m_StdDevPrecLabel;
    protected JCheckBox m_ShowAverageCheckBox;
    protected JLabel m_ShowAverageLabel;
    protected JCheckBox m_RemoveFilterNameCheckBox;
    protected JLabel m_RemoveFilterNameLabel;
    protected JButton m_OkButton;
    protected JButton m_CancelButton;
    protected boolean m_IgnoreChanges = true;

    public OutputFormatDialog(Frame parent) {
        super((Window)parent, "Output Format...", Dialog.ModalityType.DOCUMENT_MODAL);
        this.initialize();
        this.initGUI();
        this.m_IgnoreChanges = false;
    }

    protected void initialize() {
        this.m_Result = 1;
        if (m_OutputFormatClasses == null) {
            Vector<String> classes = GenericObjectEditor.getClassnames(ResultMatrix.class.getName());
            m_OutputFormatClasses = new Vector();
            m_OutputFormatNames = new Vector();
            int i = 0;
            while (i < classes.size()) {
                try {
                    Class<?> cls = Class.forName(classes.get(i).toString());
                    ResultMatrix matrix = (ResultMatrix)cls.newInstance();
                    m_OutputFormatClasses.add(cls);
                    m_OutputFormatNames.add(matrix.getDisplayName());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel(new GridLayout(6, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)panel, "Center");
        this.m_MeanPrecSpinner = new JSpinner();
        this.m_MeanPrecSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OutputFormatDialog.this.getData();
            }
        });
        SpinnerNumberModel model = (SpinnerNumberModel)this.m_MeanPrecSpinner.getModel();
        model.setMaximum(new Integer(20));
        model.setMinimum(new Integer(0));
        this.m_MeanPrecLabel = new JLabel("Mean Precision");
        this.m_MeanPrecLabel.setDisplayedMnemonic('M');
        this.m_MeanPrecLabel.setLabelFor(this.m_MeanPrecSpinner);
        JPanel panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.m_MeanPrecLabel);
        panel2.add(this.m_MeanPrecSpinner);
        panel.add(panel2);
        this.m_StdDevPrecSpinner = new JSpinner();
        this.m_StdDevPrecSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OutputFormatDialog.this.getData();
            }
        });
        model = (SpinnerNumberModel)this.m_StdDevPrecSpinner.getModel();
        model.setMaximum(new Integer(20));
        model.setMinimum(new Integer(0));
        this.m_StdDevPrecLabel = new JLabel("StdDev. Precision");
        this.m_StdDevPrecLabel.setDisplayedMnemonic('S');
        this.m_StdDevPrecLabel.setLabelFor(this.m_StdDevPrecSpinner);
        panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.m_StdDevPrecLabel);
        panel2.add(this.m_StdDevPrecSpinner);
        panel.add(panel2);
        this.m_OutputFormatComboBox = new JComboBox<String>(m_OutputFormatNames);
        this.m_OutputFormatComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.getData();
            }
        });
        this.m_OutputFormatLabel = new JLabel("Output Format");
        this.m_OutputFormatLabel.setDisplayedMnemonic('F');
        this.m_OutputFormatLabel.setLabelFor(this.m_OutputFormatComboBox);
        panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.m_OutputFormatLabel);
        panel2.add(this.m_OutputFormatComboBox);
        panel.add(panel2);
        this.m_ShowAverageCheckBox = new JCheckBox("");
        this.m_ShowAverageCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OutputFormatDialog.this.getData();
            }
        });
        this.m_ShowAverageLabel = new JLabel("Show Average");
        this.m_ShowAverageLabel.setDisplayedMnemonic('A');
        this.m_ShowAverageLabel.setLabelFor(this.m_ShowAverageCheckBox);
        panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.m_ShowAverageLabel);
        panel2.add(this.m_ShowAverageCheckBox);
        panel.add(panel2);
        this.m_RemoveFilterNameCheckBox = new JCheckBox("");
        this.m_RemoveFilterNameCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                OutputFormatDialog.this.getData();
            }
        });
        this.m_RemoveFilterNameLabel = new JLabel("Remove filter classnames");
        this.m_RemoveFilterNameLabel.setDisplayedMnemonic('R');
        this.m_RemoveFilterNameLabel.setLabelFor(this.m_RemoveFilterNameCheckBox);
        panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.m_RemoveFilterNameLabel);
        panel2.add(this.m_RemoveFilterNameCheckBox);
        panel.add(panel2);
        this.m_ResultMatrix = ExperimenterDefaults.getOutputFormat();
        this.m_ResultMatrixEditor = new GenericObjectEditor(true);
        this.m_ResultMatrixEditor.setClassType(ResultMatrix.class);
        this.m_ResultMatrixEditor.setValue(this.m_ResultMatrix);
        this.m_ResultMatrixEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (!OutputFormatDialog.this.m_ResultMatrix.getClass().equals(OutputFormatDialog.this.m_ResultMatrixEditor.getValue().getClass())) {
                    if (OutputFormatDialog.this.m_ResultMatrixEditor.getValue().getClass().equals(ExperimenterDefaults.getOutputFormat().getClass())) {
                        OutputFormatDialog.this.m_ResultMatrix = ExperimenterDefaults.getOutputFormat();
                        OutputFormatDialog.this.m_ResultMatrixEditor.setValue(ExperimenterDefaults.getOutputFormat());
                    } else {
                        OutputFormatDialog.this.m_ResultMatrix = (ResultMatrix)OutputFormatDialog.this.m_ResultMatrixEditor.getValue();
                    }
                    OutputFormatDialog.this.setData();
                }
                OutputFormatDialog.this.repaint();
            }
        });
        ((GenericObjectEditor.GOEPanel)this.m_ResultMatrixEditor.getCustomEditor()).addOkListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.m_ResultMatrix = (ResultMatrix)OutputFormatDialog.this.m_ResultMatrixEditor.getValue();
                OutputFormatDialog.this.setData();
            }
        });
        this.m_ResultMatrixPanel = new PropertyPanel(this.m_ResultMatrixEditor, false);
        this.m_ResultMatrixLabel = new JLabel("Advanced setup");
        panel2 = new JPanel(new FlowLayout(0));
        panel2.add(this.m_ResultMatrixLabel);
        panel2.add(this.m_ResultMatrixPanel);
        panel.add(panel2);
        panel = new JPanel(new FlowLayout(2));
        this.getContentPane().add((Component)panel, "South");
        this.m_CancelButton = new JButton("Cancel");
        this.m_CancelButton.setMnemonic('C');
        this.m_CancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.m_Result = 1;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        this.m_OkButton = new JButton("OK");
        this.m_OkButton.setMnemonic('O');
        this.m_OkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputFormatDialog.this.getData();
                OutputFormatDialog.this.m_Result = 0;
                OutputFormatDialog.this.setVisible(false);
            }
        });
        panel.add(this.m_OkButton);
        panel.add(this.m_CancelButton);
        this.getRootPane().setDefaultButton(this.m_OkButton);
        this.pack();
        this.m_MeanPrecLabel.setPreferredSize(new Dimension(this.m_RemoveFilterNameLabel.getWidth(), this.m_MeanPrecLabel.getHeight()));
        this.m_MeanPrecSpinner.setPreferredSize(new Dimension(this.m_MeanPrecSpinner.getWidth() * 3, this.m_MeanPrecSpinner.getHeight()));
        this.m_StdDevPrecLabel.setPreferredSize(new Dimension(this.m_RemoveFilterNameLabel.getWidth(), this.m_StdDevPrecLabel.getHeight()));
        this.m_StdDevPrecSpinner.setPreferredSize(new Dimension(this.m_StdDevPrecSpinner.getWidth() * 3, this.m_StdDevPrecSpinner.getHeight()));
        this.m_OutputFormatLabel.setPreferredSize(new Dimension(this.m_RemoveFilterNameLabel.getWidth(), this.m_OutputFormatLabel.getHeight()));
        this.m_ShowAverageLabel.setPreferredSize(new Dimension(this.m_RemoveFilterNameLabel.getWidth(), this.m_ShowAverageLabel.getHeight()));
        this.m_ResultMatrixLabel.setPreferredSize(new Dimension(this.m_RemoveFilterNameLabel.getWidth(), this.m_ResultMatrixLabel.getHeight()));
        this.m_ResultMatrixPanel.setPreferredSize(new Dimension((int)((double)this.m_ResultMatrixPanel.getWidth() * 1.5), this.m_ResultMatrixPanel.getHeight()));
        this.pack();
    }

    private void setData() {
        this.m_IgnoreChanges = true;
        this.m_MeanPrecSpinner.setValue(this.m_ResultMatrix.getMeanPrec());
        this.m_StdDevPrecSpinner.setValue(this.m_ResultMatrix.getStdDevPrec());
        int i = 0;
        while (i < m_OutputFormatClasses.size()) {
            if (m_OutputFormatClasses.get(i).equals(this.m_ResultMatrix.getClass())) {
                this.m_OutputFormatComboBox.setSelectedItem(m_OutputFormatNames.get(i));
                break;
            }
            ++i;
        }
        this.m_ShowAverageCheckBox.setSelected(this.m_ResultMatrix.getShowAverage());
        this.m_RemoveFilterNameCheckBox.setSelected(this.m_ResultMatrix.getRemoveFilterName());
        this.m_ResultMatrixEditor.setValue(this.m_ResultMatrix);
        this.m_IgnoreChanges = false;
    }

    private void getData() {
        if (this.m_IgnoreChanges) {
            return;
        }
        try {
            if (!this.m_ResultMatrix.getClass().equals(m_OutputFormatClasses.get(this.m_OutputFormatComboBox.getSelectedIndex()))) {
                this.m_ResultMatrix = m_OutputFormatClasses.get(this.m_OutputFormatComboBox.getSelectedIndex()).equals(ExperimenterDefaults.getOutputFormat().getClass()) ? ExperimenterDefaults.getOutputFormat() : (ResultMatrix)m_OutputFormatClasses.get(this.m_OutputFormatComboBox.getSelectedIndex()).newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.m_ResultMatrix = new ResultMatrixPlainText();
        }
        this.m_ResultMatrix.setMeanPrec(Integer.parseInt(this.m_MeanPrecSpinner.getValue().toString()));
        this.m_ResultMatrix.setStdDevPrec(Integer.parseInt(this.m_StdDevPrecSpinner.getValue().toString()));
        this.m_ResultMatrix.setShowAverage(this.m_ShowAverageCheckBox.isSelected());
        this.m_ResultMatrix.setRemoveFilterName(this.m_RemoveFilterNameCheckBox.isSelected());
        this.m_ResultMatrixEditor.setValue(this.m_ResultMatrix);
    }

    public void setResultMatrix(ResultMatrix matrix) {
        this.m_ResultMatrix = matrix;
        this.setData();
    }

    public ResultMatrix getResultMatrix() {
        return this.m_ResultMatrix;
    }

    protected void setFormat() {
        int i = 0;
        while (i < m_OutputFormatClasses.size()) {
            if (m_OutputFormatNames.get(i).equals(this.m_OutputFormatComboBox.getItemAt(i).toString())) {
                this.m_OutputFormatComboBox.setSelectedIndex(i);
                break;
            }
            ++i;
        }
    }

    public int getResult() {
        return this.m_Result;
    }

    public int showDialog() {
        this.m_Result = 1;
        this.setData();
        this.setVisible(true);
        return this.m_Result;
    }

    public static void main(String[] args) {
        OutputFormatDialog dialog = new OutputFormatDialog(null);
        if (dialog.showDialog() == 0) {
            System.out.println("Accepted");
        } else {
            System.out.println("Aborted");
        }
    }
}

