/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.IntervalEstimator;
import weka.classifiers.evaluation.NumericPrediction;
import weka.classifiers.misc.InputMappedClassifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.explorer.AbstractPlotInstances;
import weka.gui.explorer.ExplorerDefaults;
import weka.gui.visualize.PlotData2D;

public class ClassifierErrorsPlotInstances
extends AbstractPlotInstances {
    private static final long serialVersionUID = -3941976365792013279L;
    protected int m_MinimumPlotSizeNumeric;
    protected int m_MaximumPlotSizeNumeric;
    protected boolean m_SaveForVisualization;
    protected FastVector m_PlotShapes;
    protected FastVector m_PlotSizes;
    protected Classifier m_Classifier;
    protected int m_ClassIndex;
    protected Evaluation m_Evaluation;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotShapes = new FastVector();
        this.m_PlotSizes = new FastVector();
        this.m_Classifier = null;
        this.m_ClassIndex = -1;
        this.m_Evaluation = null;
        this.m_SaveForVisualization = true;
        this.m_MinimumPlotSizeNumeric = ExplorerDefaults.getClassifierErrorsMinimumPlotSizeNumeric();
        this.m_MaximumPlotSizeNumeric = ExplorerDefaults.getClassifierErrorsMaximumPlotSizeNumeric();
    }

    public FastVector getPlotShapes() {
        return this.m_PlotShapes;
    }

    public FastVector getPlotSizes() {
        return this.m_PlotSizes;
    }

    public void setClassifier(Classifier value) {
        this.m_Classifier = value;
    }

    public Classifier getClassifier() {
        return this.m_Classifier;
    }

    public void setClassIndex(int index) {
        this.m_ClassIndex = index;
    }

    public int getClassIndex() {
        return this.m_ClassIndex;
    }

    public void setEvaluation(Evaluation value) {
        this.m_Evaluation = value;
    }

    public Evaluation getEvaluation() {
        return this.m_Evaluation;
    }

    public void setSaveForVisualization(boolean value) {
        this.m_SaveForVisualization = value;
    }

    public boolean getSaveForVisualization() {
        return this.m_SaveForVisualization;
    }

    @Override
    protected void check() {
        super.check();
        if (this.m_Classifier == null) {
            throw new IllegalStateException("No classifier set!");
        }
        if (this.m_ClassIndex == -1) {
            throw new IllegalStateException("No class index set!");
        }
        if (this.m_Evaluation == null) {
            throw new IllegalStateException("No evaluation set");
        }
    }

    @Override
    protected void determineFormat() {
        Attribute predictedClass;
        int i;
        if (!this.m_SaveForVisualization) {
            this.m_PlotInstances = null;
            return;
        }
        FastVector<Attribute> hv = new FastVector<Attribute>();
        Attribute classAt = this.m_Instances.attribute(this.m_ClassIndex);
        if (classAt.isNominal()) {
            FastVector<String> attVals = new FastVector<String>();
            i = 0;
            while (i < classAt.numValues()) {
                attVals.addElement(classAt.value(i));
                ++i;
            }
            predictedClass = new Attribute("predicted" + classAt.name(), attVals);
        } else {
            predictedClass = new Attribute("predicted" + classAt.name());
        }
        i = 0;
        while (i < this.m_Instances.numAttributes()) {
            if (i == this.m_Instances.classIndex()) {
                hv.addElement(predictedClass);
            }
            hv.addElement((Attribute)this.m_Instances.attribute(i).copy());
            ++i;
        }
        this.m_PlotInstances = new Instances(String.valueOf(this.m_Instances.relationName()) + "_predicted", hv, this.m_Instances.numInstances());
        this.m_PlotInstances.setClassIndex(this.m_ClassIndex + 1);
    }

    public void process(Instance toPredict, Classifier classifier, Evaluation eval) {
        try {
            double pred = eval.evaluateModelOnceAndRecordPrediction(classifier, toPredict);
            if (classifier instanceof InputMappedClassifier) {
                toPredict = ((InputMappedClassifier)classifier).constructMappedInstance(toPredict);
            }
            if (!this.m_SaveForVisualization) {
                return;
            }
            if (this.m_PlotInstances != null) {
                double[] values = new double[this.m_PlotInstances.numAttributes()];
                int i = 0;
                while (i < this.m_PlotInstances.numAttributes()) {
                    if (i < toPredict.classIndex()) {
                        values[i] = toPredict.value(i);
                    } else if (i == toPredict.classIndex()) {
                        values[i] = pred;
                        values[i + 1] = toPredict.value(i);
                        ++i;
                    } else {
                        values[i] = toPredict.value(i - 1);
                    }
                    ++i;
                }
                this.m_PlotInstances.add(new DenseInstance(1.0, values));
                if (toPredict.classAttribute().isNominal()) {
                    if (toPredict.isMissing(toPredict.classIndex()) || Utils.isMissingValue(pred)) {
                        this.m_PlotShapes.addElement(new Integer(2000));
                    } else if (pred != toPredict.classValue()) {
                        this.m_PlotShapes.addElement(new Integer(1000));
                    } else {
                        this.m_PlotShapes.addElement(new Integer(-1));
                    }
                    this.m_PlotSizes.addElement(new Integer(2));
                } else {
                    Double errd = null;
                    if (!toPredict.isMissing(toPredict.classIndex()) && !Utils.isMissingValue(pred)) {
                        errd = new Double(pred - toPredict.classValue());
                        this.m_PlotShapes.addElement(new Integer(-1));
                    } else {
                        this.m_PlotShapes.addElement(new Integer(2000));
                    }
                    this.m_PlotSizes.addElement(errd);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected void scaleNumericPredictions() {
        double err;
        Double errd;
        double maxErr = Double.NEGATIVE_INFINITY;
        double minErr = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < this.m_PlotSizes.size()) {
            errd = (Double)this.m_PlotSizes.elementAt(i);
            if (errd != null) {
                err = Math.abs(errd);
                if (err < minErr) {
                    minErr = err;
                }
                if (err > maxErr) {
                    maxErr = err;
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.m_PlotSizes.size()) {
            errd = (Double)this.m_PlotSizes.elementAt(i);
            if (errd != null) {
                err = Math.abs(errd);
                if (maxErr - minErr > 0.0) {
                    double temp = (err - minErr) / (maxErr - minErr) * (double)(this.m_MaximumPlotSizeNumeric - this.m_MinimumPlotSizeNumeric + 1);
                    this.m_PlotSizes.setElementAt(new Integer((int)temp) + this.m_MinimumPlotSizeNumeric, i);
                } else {
                    this.m_PlotSizes.setElementAt(new Integer(this.m_MinimumPlotSizeNumeric), i);
                }
            } else {
                this.m_PlotSizes.setElementAt(new Integer(this.m_MinimumPlotSizeNumeric), i);
            }
            ++i;
        }
    }

    protected void addPredictionIntervals() {
        int maxNum = 0;
        FastVector preds = this.m_Evaluation.predictions();
        int i = 0;
        while (i < preds.size()) {
            int num = ((NumericPrediction)preds.elementAt(i)).predictionIntervals().length;
            if (num > maxNum) {
                maxNum = num;
            }
            ++i;
        }
        FastVector<Attribute> atts = new FastVector<Attribute>();
        i = 0;
        while (i < this.m_PlotInstances.numAttributes()) {
            atts.addElement(this.m_PlotInstances.attribute(i));
            ++i;
        }
        i = 0;
        while (i < maxNum) {
            atts.addElement(new Attribute("predictionInterval_" + (i + 1) + "-lowerBoundary"));
            atts.addElement(new Attribute("predictionInterval_" + (i + 1) + "-upperBoundary"));
            atts.addElement(new Attribute("predictionInterval_" + (i + 1) + "-width"));
            ++i;
        }
        Instances data = new Instances(this.m_PlotInstances.relationName(), atts, this.m_PlotInstances.numInstances());
        data.setClassIndex(this.m_PlotInstances.classIndex());
        i = 0;
        while (i < this.m_PlotInstances.numInstances()) {
            Instance inst = this.m_PlotInstances.instance(i);
            double[] values = new double[data.numAttributes()];
            System.arraycopy(inst.toDoubleArray(), 0, values, 0, inst.numAttributes());
            double[][] predInt = ((NumericPrediction)preds.elementAt(i)).predictionIntervals();
            int n = 0;
            while (n < maxNum) {
                if (n < predInt.length) {
                    values[this.m_PlotInstances.numAttributes() + n * 3 + 0] = predInt[n][0];
                    values[this.m_PlotInstances.numAttributes() + n * 3 + 1] = predInt[n][1];
                    values[this.m_PlotInstances.numAttributes() + n * 3 + 2] = predInt[n][1] - predInt[n][0];
                } else {
                    values[this.m_PlotInstances.numAttributes() + n * 3 + 0] = Utils.missingValue();
                    values[this.m_PlotInstances.numAttributes() + n * 3 + 1] = Utils.missingValue();
                    values[this.m_PlotInstances.numAttributes() + n * 3 + 2] = Utils.missingValue();
                }
                ++n;
            }
            DenseInstance newInst = new DenseInstance(inst.weight(), values);
            data.add(newInst);
            ++i;
        }
        this.m_PlotInstances = data;
    }

    @Override
    protected void finishUp() {
        super.finishUp();
        if (!this.m_SaveForVisualization) {
            return;
        }
        if (this.m_Instances.attribute(this.m_ClassIndex).isNumeric()) {
            this.scaleNumericPredictions();
            if (this.m_Classifier instanceof IntervalEstimator) {
                this.addPredictionIntervals();
            }
        }
    }

    @Override
    protected PlotData2D createPlotData(String name) throws Exception {
        if (!this.m_SaveForVisualization) {
            return null;
        }
        PlotData2D result = new PlotData2D(this.m_PlotInstances);
        result.setShapeSize(this.m_PlotSizes);
        result.setShapeType(this.m_PlotShapes);
        result.setPlotName(String.valueOf(name) + " (" + this.m_Instances.relationName() + ")");
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Classifier = null;
        this.m_PlotShapes = null;
        this.m_PlotSizes = null;
        this.m_Evaluation = null;
    }
}

