/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.global;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.search.global.HillClimber;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;

public class TabuSearch
extends HillClimber
implements TechnicalInformationHandler {
    static final long serialVersionUID = 1176705618756672292L;
    int m_nRuns = 10;
    int m_nTabuList = 5;
    HillClimber.Operation[] m_oTabuList = null;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.PHDTHESIS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "R.R. Bouckaert");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        result.setValue(TechnicalInformation.Field.TITLE, "Bayesian Belief Networks: from Construction to Inference");
        result.setValue(TechnicalInformation.Field.INSTITUTION, "University of Utrecht");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Utrecht, Netherlands");
        return result;
    }

    @Override
    protected void search(BayesNet bayesNet, Instances instances) throws Exception {
        double fCurrentScore;
        this.m_oTabuList = new HillClimber.Operation[this.m_nTabuList];
        int iCurrentTabuList = 0;
        double fBestScore = fCurrentScore = this.calcScore(bayesNet);
        BayesNet bestBayesNet = new BayesNet();
        bestBayesNet.m_Instances = instances;
        bestBayesNet.initStructure();
        this.copyParentSets(bestBayesNet, bayesNet);
        for (int iRun = 0; iRun < this.m_nRuns; ++iRun) {
            HillClimber.Operation oOperation = this.getOptimalOperation(bayesNet, instances);
            this.performOperation(bayesNet, instances, oOperation);
            if (oOperation == null) {
                throw new Exception("Panic: could not find any step to make. Tabu list too long?");
            }
            this.m_oTabuList[iCurrentTabuList] = oOperation;
            iCurrentTabuList = (iCurrentTabuList + 1) % this.m_nTabuList;
            if ((fCurrentScore += oOperation.m_fScore) > fBestScore) {
                fBestScore = fCurrentScore;
                this.copyParentSets(bestBayesNet, bayesNet);
            }
            if (!bayesNet.getDebug()) continue;
            this.printTabuList();
        }
        this.copyParentSets(bayesNet, bestBayesNet);
        bestBayesNet = null;
    }

    void copyParentSets(BayesNet dest, BayesNet source) {
        int nNodes = source.getNrOfNodes();
        for (int iNode = 0; iNode < nNodes; ++iNode) {
            dest.getParentSet(iNode).copy(source.getParentSet(iNode));
        }
    }

    @Override
    boolean isNotTabu(HillClimber.Operation oOperation) {
        for (int iTabu = 0; iTabu < this.m_nTabuList; ++iTabu) {
            if (!oOperation.equals(this.m_oTabuList[iTabu])) continue;
            return false;
        }
        return true;
    }

    void printTabuList() {
        for (int i = 0; i < this.m_nTabuList; ++i) {
            HillClimber.Operation o = this.m_oTabuList[i];
            if (o == null) continue;
            if (o.m_nOperation == 0) {
                System.out.print(" +(");
            } else {
                System.out.print(" -(");
            }
            System.out.print(o.m_nTail + "->" + o.m_nHead + ")");
        }
        System.out.println();
    }

    public int getRuns() {
        return this.m_nRuns;
    }

    public void setRuns(int nRuns) {
        this.m_nRuns = nRuns;
    }

    public int getTabuList() {
        return this.m_nTabuList;
    }

    public void setTabuList(int nTabuList) {
        this.m_nTabuList = nTabuList;
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>(4);
        newVector.addElement(new Option("\tTabu list length", "L", 1, "-L <integer>"));
        newVector.addElement(new Option("\tNumber of runs", "U", 1, "-U <integer>"));
        newVector.addElement(new Option("\tMaximum number of parents", "P", 1, "-P <nr of parents>"));
        newVector.addElement(new Option("\tUse arc reversal operation.\n\t(default false)", "R", 0, "-R"));
        Enumeration enu = super.listOptions();
        while (enu.hasMoreElements()) {
            newVector.addElement((Option)enu.nextElement());
        }
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String sRuns;
        String sTabuList = Utils.getOption('L', options);
        if (sTabuList.length() != 0) {
            this.setTabuList(Integer.parseInt(sTabuList));
        }
        if ((sRuns = Utils.getOption('U', options)).length() != 0) {
            this.setRuns(Integer.parseInt(sRuns));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        String[] superOptions = super.getOptions();
        String[] options = new String[7 + superOptions.length];
        int current = 0;
        options[current++] = "-L";
        options[current++] = "" + this.getTabuList();
        options[current++] = "-U";
        options[current++] = "" + this.getRuns();
        for (int iOption = 0; iOption < superOptions.length; ++iOption) {
            options[current++] = superOptions[iOption];
        }
        while (current < options.length) {
            options[current++] = "";
        }
        return options;
    }

    @Override
    public String globalInfo() {
        return "This Bayes Network learning algorithm uses tabu search for finding a well scoring Bayes network structure. Tabu search is hill climbing till an optimum is reached. The following step is the least worst possible step. The last X steps are kept in a list and none of the steps in this so called tabu list is considered in taking the next step. The best network found in this traversal is returned.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    public String runsTipText() {
        return "Sets the number of steps to be performed.";
    }

    public String tabuListTipText() {
        return "Sets the length of the tabu list.";
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }
}

