/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import weka.core.Memory;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.Version;
import weka.gui.LookAndFeel;

public class SystemInfo
implements RevisionHandler {
    private Hashtable<String, String> m_Info = new Hashtable();

    public SystemInfo() {
        this.readProperties();
    }

    private void readProperties() {
        this.m_Info.clear();
        Properties props = System.getProperties();
        Enumeration<?> enm = props.propertyNames();
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            this.m_Info.put(name, (String)props.get(name));
        }
        this.m_Info.put("weka.version", Version.VERSION);
        String[] laf = LookAndFeel.getInstalledLookAndFeels();
        String tmpStr = "";
        for (int i = 0; i < laf.length; ++i) {
            if (i > 0) {
                tmpStr = tmpStr + ",";
            }
            tmpStr = tmpStr + laf[i];
        }
        this.m_Info.put("ui.installedLookAndFeels", tmpStr);
        this.m_Info.put("ui.currentLookAndFeel", LookAndFeel.getSystemLookAndFeel());
        Memory mem = new Memory();
        this.m_Info.put("memory.initial", "" + Utils.doubleToString(Memory.toMegaByte(mem.getInitial()), 1) + "MB" + " (" + mem.getInitial() + ")");
        this.m_Info.put("memory.max", "" + Utils.doubleToString(Memory.toMegaByte(mem.getMax()), 1) + "MB" + " (" + mem.getMax() + ")");
    }

    public Hashtable getSystemInfo() {
        return (Hashtable)this.m_Info.clone();
    }

    public String toString() {
        String result = "";
        Vector<String> keys = new Vector<String>();
        Enumeration<String> enm = this.m_Info.keys();
        while (enm.hasMoreElements()) {
            keys.add(enm.nextElement());
        }
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = ((String)keys.get(i)).toString();
            String value = this.m_Info.get(key).toString();
            if (key.equals("line.separator")) {
                value = Utils.backQuoteChars(value);
            }
            result = result + key + ": " + value + "\n";
        }
        return result;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 8034 $");
    }

    public static void main(String[] args) {
        System.out.println(new SystemInfo());
    }
}

