/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.EventSetDescriptor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JPanel;
import weka.classifiers.misc.InputMappedClassifier;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instances;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.xml.KOML;
import weka.core.xml.XStream;
import weka.gui.Logger;
import weka.gui.beans.BatchClassifierEvent;
import weka.gui.beans.BatchClassifierListener;
import weka.gui.beans.BatchClustererEvent;
import weka.gui.beans.BatchClustererListener;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanVisual;
import weka.gui.beans.IncrementalClassifierEvent;
import weka.gui.beans.IncrementalClassifierListener;
import weka.gui.beans.Visible;

public class SerializedModelSaver
extends JPanel
implements BeanCommon,
Visible,
BatchClassifierListener,
IncrementalClassifierListener,
BatchClustererListener,
EnvironmentHandler,
Serializable {
    private static final long serialVersionUID = 3956528599473814287L;
    protected BeanVisual m_visual = new BeanVisual("AbstractDataSink", "weka/gui/beans/icons/SerializedModelSaver.gif", "weka/gui/beans/icons/SerializedModelSaver_animated.gif");
    protected Object m_listenee = null;
    protected transient Logger m_logger = null;
    private String m_filenamePrefix = "";
    private File m_directory = new File(System.getProperty("user.dir"));
    private Tag m_fileFormat;
    public static final int BINARY = 0;
    public static final int KOMLV = 1;
    public static final int XSTREAM = 2;
    public static final String FILE_EXTENSION = "model";
    private boolean m_useRelativePath = false;
    private boolean m_includeRelationName = false;
    public static ArrayList<Tag> s_fileFormatsAvailable = new ArrayList();
    protected transient Environment m_env;

    public SerializedModelSaver() {
        this.useDefaultVisual();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_visual, "Center");
        this.m_fileFormat = s_fileFormatsAvailable.get(0);
        this.m_env = Environment.getSystemWide();
    }

    @Override
    public void setCustomName(String name) {
        this.m_visual.setText(name);
    }

    @Override
    public String getCustomName() {
        return this.m_visual.getText();
    }

    @Override
    public void useDefaultVisual() {
        this.m_visual.loadIcons("weka/gui/beans/icons/SerializedModelSaver.gif", "weka/gui/beans/icons/SerializedModelSaver_animated.gif");
        this.m_visual.setText("SerializedModelSaver");
    }

    @Override
    public void setVisual(BeanVisual newVisual) {
        this.m_visual = newVisual;
    }

    @Override
    public BeanVisual getVisual() {
        return this.m_visual;
    }

    @Override
    public boolean connectionAllowed(EventSetDescriptor esd) {
        return this.connectionAllowed(esd.getName());
    }

    @Override
    public boolean connectionAllowed(String eventName) {
        return this.m_listenee == null;
    }

    @Override
    public synchronized void connectionNotification(String eventName, Object source) {
        if (this.connectionAllowed(eventName)) {
            this.m_listenee = source;
        }
    }

    @Override
    public synchronized void disconnectionNotification(String eventName, Object source) {
        if (this.m_listenee == source) {
            this.m_listenee = null;
        }
    }

    @Override
    public void setLog(Logger logger) {
        this.m_logger = logger;
    }

    @Override
    public void stop() {
        if (this.m_listenee instanceof BeanCommon) {
            ((BeanCommon)this.m_listenee).stop();
        }
    }

    @Override
    public boolean isBusy() {
        return false;
    }

    protected String sanitizeFilename(String filename) {
        return filename.replaceAll("\\\\", "_").replaceAll(":", "_").replaceAll("/", "_");
    }

    @Override
    public void acceptClusterer(BatchClustererEvent ce) {
        if (ce.getTestSet() == null || ce.getTestOrTrain() == BatchClustererEvent.TEST || ce.getTestSet().isStructureOnly()) {
            return;
        }
        Instances trainHeader = new Instances(ce.getTestSet().getDataSet(), 0);
        String titleString = ce.getClusterer().getClass().getName();
        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
        String prefix = "";
        String relationName = this.m_includeRelationName ? trainHeader.relationName() : "";
        try {
            prefix = this.m_env.substitute(this.m_filenamePrefix);
        }
        catch (Exception ex) {
            this.stop();
            String message = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + ex.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(message);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(message);
            }
            return;
        }
        String fileName = "" + prefix + relationName + titleString + "_" + ce.getSetNumber() + "_" + ce.getMaxSetNumber();
        fileName = this.sanitizeFilename(fileName);
        String dirName = this.m_directory.getPath();
        try {
            dirName = this.m_env.substitute(dirName);
        }
        catch (Exception ex) {
            this.stop();
            String message = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + ex.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(message);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(message);
            }
            return;
        }
        File tempFile = new File(dirName);
        fileName = tempFile.getAbsolutePath() + File.separator + fileName;
        this.saveModel(fileName, trainHeader, ce.getClusterer());
    }

    @Override
    public void acceptClassifier(IncrementalClassifierEvent ce) {
        if (ce.getStatus() == 2) {
            Instances header = ce.getStructure();
            String titleString = ce.getClassifier().getClass().getName();
            titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
            String prefix = "";
            String relationName = this.m_includeRelationName ? header.relationName() : "";
            try {
                prefix = this.m_env.substitute(this.m_filenamePrefix);
            }
            catch (Exception ex) {
                this.stop();
                String message = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + ex.getMessage();
                if (this.m_logger != null) {
                    this.m_logger.logMessage(message);
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                } else {
                    System.err.println(message);
                }
                return;
            }
            String fileName = "" + prefix + relationName + titleString;
            fileName = this.sanitizeFilename(fileName);
            String dirName = this.m_directory.getPath();
            try {
                dirName = this.m_env.substitute(dirName);
            }
            catch (Exception ex) {
                this.stop();
                String message = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + ex.getMessage();
                if (this.m_logger != null) {
                    this.m_logger.logMessage(message);
                    this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
                } else {
                    System.err.println(message);
                }
                return;
            }
            File tempFile = new File(dirName);
            fileName = tempFile.getAbsolutePath() + File.separator + fileName;
            this.saveModel(fileName, header, ce.getClassifier());
        }
    }

    @Override
    public void acceptClassifier(BatchClassifierEvent ce) {
        if (ce.getTrainSet() == null || ce.getTrainSet().isStructureOnly()) {
            return;
        }
        Instances trainHeader = ce.getTrainSet().getDataSet().stringFreeStructure();
        if (ce.getClassifier() instanceof InputMappedClassifier) {
            try {
                trainHeader = ((InputMappedClassifier)ce.getClassifier()).getModelHeader(trainHeader);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        String titleString = ce.getClassifier().getClass().getName();
        titleString = titleString.substring(titleString.lastIndexOf(46) + 1, titleString.length());
        String prefix = "";
        String relationName = this.m_includeRelationName ? trainHeader.relationName() : "";
        try {
            prefix = this.m_env.substitute(this.m_filenamePrefix);
        }
        catch (Exception ex) {
            this.stop();
            String message = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + ex.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(message);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(message);
            }
            return;
        }
        String fileName = "" + prefix + relationName + titleString + "_" + ce.getSetNumber() + "_" + ce.getMaxSetNumber();
        fileName = this.sanitizeFilename(fileName);
        String dirName = this.m_directory.getPath();
        try {
            dirName = this.m_env.substitute(dirName);
        }
        catch (Exception ex) {
            this.stop();
            String message = "[SerializedModelSaver] " + this.statusMessagePrefix() + " Can't save model. Reason: " + ex.getMessage();
            if (this.m_logger != null) {
                this.m_logger.logMessage(message);
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            } else {
                System.err.println(message);
            }
            return;
        }
        File tempFile = new File(dirName);
        fileName = tempFile.getAbsolutePath() + File.separator + fileName;
        this.saveModel(fileName, trainHeader, ce.getClassifier());
    }

    private void saveModel(String fileName, Instances trainHeader, Object model) {
        block7: {
            this.m_fileFormat = this.validateFileFormat(this.m_fileFormat);
            if (this.m_fileFormat == null) {
                this.m_fileFormat = s_fileFormatsAvailable.get(0);
            }
            try {
                switch (this.m_fileFormat.getID()) {
                    case 1: {
                        fileName = fileName + ".koml" + FILE_EXTENSION;
                        SerializedModelSaver.saveKOML(new File(fileName), model, trainHeader);
                        break;
                    }
                    case 2: {
                        fileName = fileName + ".xstream" + FILE_EXTENSION;
                        SerializedModelSaver.saveXStream(new File(fileName), model, trainHeader);
                        break;
                    }
                    default: {
                        fileName = fileName + "." + FILE_EXTENSION;
                        SerializedModelSaver.saveBinary(new File(fileName), model, trainHeader);
                        break;
                    }
                }
            }
            catch (Exception ex) {
                this.stop();
                System.err.println("[SerializedModelSaver] Problem saving model");
                if (this.m_logger == null) break block7;
                this.m_logger.logMessage("[SerializedModelSaver] " + this.statusMessagePrefix() + " Problem saving model");
                this.m_logger.statusMessage(this.statusMessagePrefix() + "ERROR (See log for details)");
            }
        }
    }

    public static void saveBinary(File saveTo, Object model, Instances header) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(saveTo)));
        os.writeObject(model);
        if (header != null) {
            os.writeObject(header);
        }
        os.close();
    }

    public static void saveKOML(File saveTo, Object model, Instances header) throws Exception {
        Vector<Object> v = new Vector<Object>();
        v.add(model);
        if (header != null) {
            v.add(header);
        }
        v.trimToSize();
        KOML.write(saveTo.getAbsolutePath(), v);
    }

    public static void saveXStream(File saveTo, Object model, Instances header) throws Exception {
        Vector<Object> v = new Vector<Object>();
        v.add(model);
        if (header != null) {
            v.add(header);
        }
        v.trimToSize();
        XStream.write(saveTo.getAbsolutePath(), v);
    }

    public File getDirectory() {
        return this.m_directory;
    }

    public void setDirectory(File d) {
        this.m_directory = d;
        if (this.m_useRelativePath) {
            try {
                this.m_directory = Utils.convertToRelativePath(this.m_directory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setUseRelativePath(boolean rp) {
        this.m_useRelativePath = rp;
    }

    public boolean getUseRelativePath() {
        return this.m_useRelativePath;
    }

    public void setIncludeRelationName(boolean rn) {
        this.m_includeRelationName = rn;
    }

    public boolean getIncludeRelationName() {
        return this.m_includeRelationName;
    }

    public String getPrefix() {
        return this.m_filenamePrefix;
    }

    public void setPrefix(String p) {
        this.m_filenamePrefix = p;
    }

    public String globalInfo() {
        return "Save trained models to serialized object files.";
    }

    public void setFileFormat(Tag ff) {
        this.m_fileFormat = ff;
    }

    public Tag getFileFormat() {
        return this.m_fileFormat;
    }

    public Tag validateFileFormat(Tag ff) {
        Tag r = ff;
        if (ff.getID() == 0) {
            return ff;
        }
        if (ff.getID() == 1 && !KOML.isPresent()) {
            r = null;
        }
        if (ff.getID() == 2 && !XStream.isPresent()) {
            r = null;
        }
        return r;
    }

    private String statusMessagePrefix() {
        return this.getCustomName() + "$" + this.hashCode() + "|";
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    private void readObject(ObjectInputStream aStream) throws IOException, ClassNotFoundException {
        aStream.defaultReadObject();
        this.m_env = Environment.getSystemWide();
    }

    static {
        s_fileFormatsAvailable.add(new Tag(0, "Binary serialized model file (*model)", "", false));
        if (KOML.isPresent()) {
            s_fileFormatsAvailable.add(new Tag(1, "XML serialized model file (*.komlmodel)", "", false));
        }
        if (XStream.isPresent()) {
            s_fileFormatsAvailable.add(new Tag(2, "XML serialized model file (*.xstreammodel)", "", false));
        }
    }
}

