/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import weka.gui.ComponentHelper;
import weka.gui.sql.InfoPanelCellRenderer;
import weka.gui.sql.Messages;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = -7701133696481997973L;
    protected JFrame m_Parent;
    protected JList m_Info;
    protected DefaultListModel m_Model;
    protected JButton m_ButtonClear;
    protected JButton m_ButtonCopy;

    public InfoPanel(JFrame parent) {
        this.m_Parent = parent;
        this.createPanel();
    }

    protected void createPanel() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(0, 80));
        this.m_Model = new DefaultListModel();
        this.m_Info = new JList(this.m_Model);
        this.m_Info.setCellRenderer(new InfoPanelCellRenderer());
        this.m_Info.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                InfoPanel.this.setButtons(e);
            }
        });
        this.add((Component)new JScrollPane(this.m_Info), "Center");
        JPanel panel = new JPanel(new BorderLayout());
        this.add((Component)panel, "East");
        Messages.getInstance();
        this.m_ButtonClear = new JButton(Messages.getString("InfoPanel_CreatePanel_ButtonClear_JButton_Text"));
        this.m_ButtonClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoPanel.this.clear();
            }
        });
        panel.add((Component)this.m_ButtonClear, "North");
        JPanel panel2 = new JPanel(new BorderLayout());
        panel.add((Component)panel2, "Center");
        Messages.getInstance();
        this.m_ButtonCopy = new JButton(Messages.getString("InfoPanel_CreatePanel_ButtonCopy_JButton_Text"));
        this.m_ButtonCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoPanel.this.copyToClipboard();
            }
        });
        panel2.add((Component)this.m_ButtonCopy, "North");
    }

    protected void setButtons(ListSelectionEvent e) {
        if (e == null || e.getSource() == this.m_Info) {
            this.m_ButtonClear.setEnabled(this.m_Model.getSize() > 0);
            this.m_ButtonCopy.setEnabled(this.m_Info.getSelectedIndices().length == 1);
        }
    }

    public void setFocus() {
        this.m_Info.requestFocus();
    }

    public void clear() {
        this.m_Model.clear();
        this.setButtons(null);
    }

    public boolean copyToClipboard() {
        if (this.m_Info.getSelectedIndices().length != 1) {
            return false;
        }
        StringSelection selection = new StringSelection(((JLabel)this.m_Info.getSelectedValue()).getText());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(selection, selection);
        return true;
    }

    public void append(String msg, String icon) {
        this.append(new JLabel(msg, ComponentHelper.getImageIcon(icon), 2));
    }

    public void append(Object msg) {
        if (msg instanceof String) {
            this.append(msg.toString(), "empty_small.gif");
            return;
        }
        this.m_Model.addElement(msg);
        this.m_Info.setSelectedIndex(this.m_Model.getSize() - 1);
        this.m_Info.ensureIndexIsVisible(this.m_Info.getSelectedIndex());
        this.setButtons(null);
    }
}

